@extends('frontend::page')

@section('content')

@if(empty($link_query->image))
@php $link_query->image='no_image.png'; @endphp
@endif

<!-- Container -->
<div class="container mt-3">

    <!-- Grid row -->
    <div class="row" id="redirect" data-redirect-base="{{$settings['redirect_base']}}" data-app-id="{{ $link_query->id }}" data-redirection-delay="{{$settings['time_before_redirect']*1000}}">

        @if (!empty($ad[6]))
        <div class="col-md-3 mb-3 text-center text-md-start order-md-1 @if($settings['redirection_page_link_details_mobile'] == '1') order-2 @else order-1 @endif">
            {!! $ad[6] !!}
        </div>
        @endif

        @if (!empty($ad[7]))<div class="col-md-3 mb-3 text-center text-md-start order-md-2 order-3">
            {!! $ad[7] !!}
        </div>
        @endif

        <div class="col-md-6 my-auto order-md-3 @if($settings['redirection_page_link_details_mobile'] == '1') order-1 @else order-2 @endif">

            <div class="d-flex flex-row mb-3">
                <div><img src="{{ asset('images/links') }}/{{ $link_query->image }}" class="redirect-icon" alt="{{ $link_query->title }}"></div>
                <div class="my-auto ms-3">
                    <span class="title">{{ $link_query->title }}</span>
                    <span class="site-url mb-2">
                        @if(empty($link_query->visible_url))
                        {{ $link_query->url }}
                        @else
                        {{ $link_query->visible_url }}
                        @endif
                    </span>
                    <span class="message">@lang('general.redirecting_message') <i id="countdown" class="fst-normal">({{$settings['time_before_redirect']}})</i></span>
                </div>
            </div>

        </div>

    </div>
    <!-- /Grid row -->

</div>
<!-- /Container -->

@endsection