@extends('rtl-frontend::page')

@section('content')

<!-- Container -->
<main class="container mt-3">

    <!-- Grid Row -->
    <div class="row">

        <!-- Grid Column -->
        <div class="col-md-9">

            @if(!empty($ad[4]))<div class="mb-3 text-center">{!! $ad[4] !!}</div>@endif

            <!-- Search Box -->
            @include('rtl-frontend::inc.partials', ['type' => '1'])
            <!-- /Search Box -->

            @if ($settings['breadcrumbs'] == '1')
            <!-- Breadcrumbs -->
            <div class="breadcrumbs mb-3">
                <a href="{{ asset($language_prefix) }}">@lang('general.homepage')</a> <span class="sep">›</span> <a href="{{url()->current()}}">@lang('general.articles')</a>
                <a href="{{ asset($language_prefix.'article-rss') }}" target="_blank"><i class="icon-rss rss-icon float-start"></i></a>
            </div>

            @if ($settings['schema_breadcrumbs'] == '1')
            {!! $breadcrumb_schema_data->toScript() !!}
            @endif
            <!-- /Breadcrumbs -->
            @endif

            @if($all_articles->isEmpty())
            <div class="col-12">
                <h6 class="alert alert-warning">@lang('general.no_articles_added')</h6>
            </div>
            @endif

            <!-- Page Content -->
            <div class="articles-list row">

                @foreach ($all_articles as $article)
                <div class="col-md-4 col-12 mb-3">
                    <div class="shadow-sm bg-white rounded h-100">
                        <a href="{{ asset($language_prefix.$settings['article_base']) }}/{{ $article->slug }}">
                            <img src="{{ asset('images/pixel.png') }}" data-src="{{ asset('images') }}/articles/{{ $article->image}}" alt="{{ $article->title }}" class="img-fluid rounded-top lazy">
                            <div class="p-2">
                                <h2 class="title mx-1">{{ $article->title}}</h2>
                                <h3 class="description mx-1">{{ $article->description}}</h3>
                            </div>
                        </a>
                    </div>
                </div>
                @endforeach

            </div>
            <!-- /Page Content -->

            <div class="d-flex">
                <div class="mx-auto">
                    {{ $all_articles->onEachSide(1)->links() }}
                </div>
            </div>

            @if(!empty($ad[3]))<div class="mb-3 text-center">{!! $ad[3] !!}</div>@endif

        </div>
        <!-- /Grid Column -->

        <!-- Grid Column -->
        <div class="col-md-3 text-center mb-3">
            @if ($settings['sticky_ads_right_column'] == '1')<div class="sticky-top sticky-top-15">@endif
                @if(!empty($ad[5]))<div class="mb-3">{!! $ad[5] !!}</div>@endif
                @if ($settings['sticky_ads_right_column'] == '1')</div>@endif
        </div>
        <!-- /Grid Column -->

    </div>
    <!-- /Grid row -->

</main>
<!-- /Container -->

@endsection