@extends('rtl-frontend::page')

@section('content')

<!-- Container -->
<main class="container">

    <!-- Grid Row -->
    <div class="row member-area mt-3">

        <div class="col-md-3 menu">

            <div class="bg-white shadow-sm rounded p-2 pb-0">
                <!-- Left Column -->
                @include('rtl-frontend::inc.partials', ['type' => '3'])
                <!-- /Left Column -->
            </div>

        </div>

        <div class="col-md-9 mb-3">

            <div class="bg-white shadow-sm rounded p-2">

                <div class="m-1 text-center payment-methods py-2">
                    <h6 class="mb-1 fw-bold">@lang('general.choose_payment_method')</h6>
                    <span class="d-block mb-3">Amount to be Paid: <b>{{$settings['payment_currency_symbol']}}{{$link_query->price}}</b></span>

                    @foreach($payment_methods as $payment)
                    @if($payment->subscription == '0' && ($payment->id != '3' || $link_query->price >= '0.5'))
                    <a href="{{ asset($language_prefix.'member-area/renew/'.request()->id.'/'.$payment->id) }}" class="d-block mx-auto">@lang('general.'.$payment->title)</a>
                    @endif
                    @endforeach

                </div>

            </div>

        </div>

    </div>
    <!-- /Grid row -->

</main>
<!-- /Container -->

@endsection