<?php

namespace App\Http\Controllers;

use App;
use App\Models\Comment;
use App\Models\Translation;
use DB;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\View;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Mail;
use App\Mail\Packagerenewed;
use App\Mail\Sendemail;

class BankpaymentController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');

        // Site Settings
        $site_settings = DB::table('settings')->get();

        foreach ($site_settings as $setting) {
            $setting_name = $setting->name;
            $this->$setting_name = $setting->value;
            if ($setting->language == null) {
                $this->settings[$setting->name] = $setting->value;
            } else {
                $this->settings[$setting->name . '-' . $setting->language] = $setting->value;
            }
        }

        // List of languages
        $translations = Translation::orderBy('sort', 'ASC')->get();

        // Language prefixes
        foreach ($translations as $language) {
            if ($language->code == $this->settings['site_language']) {
                $this->site_language_id = $language->id;
            }
            if ($this->settings['root_language'] == '1' && $language->code == $this->settings['site_language']) {
                $this->language_prefix[$language->id] = '/';
            } else {
                $this->language_prefix[$language->id] = $language->code . '/';
            }
        }

        $this->mail_site_title = $this->settings['site_title' . '-' . $this->site_language_id];
        $this->mail_from = $_ENV['MAIL_FROM_ADDRESS'];

        // Pass data to views
        View::share(['settings' => $this->settings]);
    }

    /** Index */
    public function index()
    {
        // List of bank payments
        $bank_payments = DB::table('payment_notifications')
            ->leftJoin('orders', 'payment_notifications.order_id', '=', 'orders.id')
            ->select('orders.price AS price', 'orders.currency_symbol AS currency_symbol', 'orders.id AS order_id', 'payment_notifications.id AS id', 'payment_notifications.checked AS checked', 'payment_notifications.sender_name AS sender_name', 'payment_notifications.created_at AS created_at')
            ->where('orders.payment_method', '2')
            ->where('orders.is_renewal', '1')
            ->orderBy('payment_notifications.id', 'desc')
            ->paginate(15);

        // Return view
        return view('adminlte::payment_notifications.index', compact('bank_payments'));
    }
    
    
    /** Bank Payment Approval */
    public function bank_payment(Request $request, $id)
    {
        // Retrieve payment notification
        $payment_notification = DB::table('payment_notifications')
            ->leftJoin('bank_accounts', 'payment_notifications.bank_account', '=', 'bank_accounts.id')
            ->leftJoin('links', 'payment_notifications.link_id', '=', 'links.id')
            ->leftJoin('users', 'links.owner', '=', 'users.id')
            ->leftJoin('packages', 'links.package', '=', 'packages.id')
            ->select('bank_accounts.bank_name AS bank_name', 'users.email AS link_email', 'links.owner AS user', 'links.expire_at AS expire_at', 'packages.duration AS duration', 'packages.price AS price', 'users.email AS user_email', 'links.url AS url', 'links.title AS title', 'links.package AS package', 'payment_notifications.*')
            ->where('payment_notifications.id', $id)
            ->where('payment_notifications.checked', 0)
            ->first();

        // Return 404 page if payment notification is not found
        if ($payment_notification == null) {
            abort(404);
        }

        $now = Carbon::now();

        if ($request->has('bank_payment')) {
            $bank_payment_status = request()->bank_payment;

            if ($bank_payment_status == '1') {

                if ($now > $payment_notification->expire_at) {
                    $new_expire_time = expire_time($payment_notification->duration, $now);
                    DB::table('links')->where('id', $payment_notification->link_id)->update(['enabled' => '1']);
                } else {
                    $new_expire_time = expire_time($payment_notification->duration, $payment_notification->expire_at);
                }

                DB::table('orders')->where('id', $payment_notification->order_id)->update(['payment_status' => '1', 'status' => '2']);
                DB::table('links')->where('id', $payment_notification->link_id)->update(['expire_at' => $new_expire_time, 'status' => '2']);

        // Package Durations
        $durations = submission_durations();
        
        // Package Details
        $package = DB::table('packages')->where('id', $payment_notification->package)->first();
        
        // Notify link owner by email
        \Mail::to($payment_notification->link_email)->send(new Packagerenewed($durations[$payment_notification->duration], $this->settings['payment_currency_symbol'] . $payment_notification->price, $package->title, $payment_notification->url, $this->mail_site_title, $this->mail_from));

            DB::table('payment_notifications')->where('id', $id)->update(['checked' => '1']);

                return redirect()->route('payment_notifications.index')->with('success', __('admin.package_renewed'));
            }

            if ($bank_payment_status == '2') {
                Mail::to($payment_notification->user_email)->send(new Sendemail(__('admin.about_your_payment'), __('admin.payment_not_received_mail'), $this->mail_site_title, $this->mail_from));

                DB::table('orders')->where('id', $payment_notification->order_id)->update(['payment_status' => '0', 'status' => '0']);

            DB::table('payment_notifications')->where('id', $id)->update(['checked' => '2']);

                return redirect()->route('payment_notifications.index')->with('success', __('admin.payment_not_received_notification'));
            }

        }

        // Return view
        return view('adminlte::payment_notifications.bank_payment')->with('payment_notification', $payment_notification);
    }

}
