<?php

namespace App\Http\Controllers;

use App\Models\Comment;
use App\Models\Translation;
use DB;
use Illuminate\Support\Facades\View;

class CommentController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');

        // Site Settings
        $site_settings = DB::table('settings')->get();

        foreach ($site_settings as $setting) {
            $setting_name = $setting->name;
            $this->$setting_name = $setting->value;
            if ($setting->language == null) {
                $settings[$setting->name] = $setting->value;
            } else {
                $settings[$setting->name . '-' . $setting->language] = $setting->value;
            }
        }

        // List of languages
        $translations = Translation::orderBy('id', 'ASC')->get();

        foreach ($translations as $language) {
            if ($settings['root_language'] == '1' && $language->code == $settings['site_language']) {
                $language_prefix[$language->id] = '/';
            } else {
                $language_prefix[$language->id] = $language->code . '/';
            }
        }

        // Pass data to views
        View::share(['settings' => $settings, 'language_prefix' => $language_prefix]);
    }

    /** Index */
    public function index()
    {
        $link_comments = Comment::leftJoin('links', 'comments.content_id', '=', 'links.id')
            ->select('comments.*', 'links.title as app_title', 'links.slug as slug', 'links.language as language')
            ->where('comments.type', '1');

        $news_comments = Comment::leftJoin('articles', 'comments.content_id', '=', 'articles.id')
            ->select('comments.*', 'articles.title as app_title', 'articles.slug as slug', 'articles.language as language')
            ->where('comments.type', '2');
        
        // Merge Queries
        $comments = $link_comments->union($news_comments)->orderBy('created_at', 'desc')->paginate(15);

        // Return view
        return view('adminlte::comments.index', compact('comments'));
    }

    /** Edit */
    public function edit($id)
    {

        $status = request()->get('approve');

        $comment = Comment::find($id);
        $user_rating = $comment->rating;
        $content_id = $comment->content_id;

        if ( $comment->approval == 1 ) {
            $comment->update(['approval' => 0]);
        } else {
            $comment->update(['approval' => 1]);
        }

        if ($comment->approval == '1' && $comment->type == '1') {

            // Get average rating
            $rating_query = DB::table('links')->where('id', $content_id)->first();
            $votes = $rating_query->votes;

            $total_votes = $rating_query->total_votes;

            $new_average = ($votes * $total_votes + $user_rating) / ($total_votes + 1);

            // Update total votes and votes count
            DB::table('links')->where('id', $content_id)->update(array('votes' => $new_average));
            DB::table('links')->where('id', $content_id)->increment('total_votes');
        }

        if ($comment->approval == '0' && $comment->type == '1') {

            // Get average rating
            $rating_query = DB::table('links')->where('id', $content_id)->first();
            $votes = $rating_query->votes;

            $total_votes = $rating_query->total_votes;

            if ($total_votes == '1') {
                $new_average = '0';
            } else {
                $new_average = ((($votes * $total_votes) - $user_rating) / ($total_votes - 1));
            }

            // Update total votes and votes count
            DB::table('links')->where('id', $content_id)->update(array('votes' => $new_average));
            DB::table('links')->where('id', $content_id)->decrement('total_votes');
        }

        // Return view
        return redirect()->route('comments.index')->with('success', __('admin.data_updated'));
    }

    /** Destroy */
    public function destroy($id)
    {
        // Retrieve comment details
        $comment = Comment::find($id);
        $user_rating = $comment->rating;
        $content_id = $comment->content_id;
        $comment_status = $comment->approval;

        if ($comment_status == '1' && $comment->type == '1') {

            // Get average rating
            $rating_query = DB::table('links')->where('id', $content_id)->first();
            $votes = $rating_query->votes;

            $total_votes = $rating_query->total_votes;

            if ($total_votes == '1') {
                $new_average = '0';
            } else {
                $new_average = ((($votes * $total_votes) - $user_rating) / ($total_votes - 1));
            }

            // Update total votes and votes count
            DB::table('links')->where('id', $content_id)->update(array('votes' => $new_average));
            DB::table('links')->where('id', $content_id)->decrement('total_votes');
        }

        $comment->delete();

        // Redirect to list of comments
        return redirect()->route('comments.index')->with('success', __('admin.data_deleted'));
    }
}
