<?php

namespace App\Http\Controllers;

use App;
use App\Mail\Report;
use DB;
use GuzzleHttp\Client;
use Illuminate\Http\Request;
use Mail;
use Response;
use Validator;

class LinkReportController extends Controller
{
    public function __construct()
    {
        // Site Settings
        $site_settings = DB::table('settings')->get();

        foreach ($site_settings as $setting) {
            $setting_name = $setting->name;
            $this->$setting_name = $setting->value;
            if ($setting->language == null) {
                $settings[$setting->name] = $setting->value;
            } else {
                $settings[$setting->name . '-' . $setting->language] = $setting->value;
            }
        }

        // List of languages
        $languages = DB::table('translations')->OrderBy('sort', 'ASC')->get();
        
        foreach ($languages as $language) {
        if ($language->code == $settings['site_language']) {
            $site_language_id = $language->id;
        }
        }

        $this->mail_site_title = $settings['site_title' . '-' . $site_language_id];
        $this->mail_from = $_ENV['MAIL_FROM_ADDRESS'];

    }

    /** Store */
    public function store(Request $request)
    {
        $rules = array(
            'name' => 'required',
            'email' => 'required|email',
            'reason' => 'required',
        );

        $validator = Validator::make($request->all(), $rules);

        // Return error response if form validation fails
        if ($validator->fails()) {
            return Response::json(array(
                'success' => false,
                'errors' => $validator->getMessageBag()->toArray(),
            ), 400);

        } else {

            $process = 1;

            if ($this->enable_google_recaptcha == '1') {

                // Google reCAPTCHA validation
                $secret = $this->google_recaptcha_secret_key;
                $recaptcha_data = request()->recaptcha;

                $client = new \GuzzleHttp\Client();
                $response = $client->request('POST', 'https://www.google.com/recaptcha/api/siteverify', [
                    'form_params' => [
                        'secret' => $secret,
                        'response' => $recaptcha_data,
                    ],
                ]);

                $response = $response->getBody();

                $responseData = json_decode($response, true);

                if ($responseData['success'] == false) {

                    $process = 0;

                    // If Google reCAPTCHA validation fails, return error response
                    return Response::json(array(
                        'success' => false,
                        'errors' => $responseData['error-codes'],
                    ), 400);
                }
            }

            if ($process == '1') {

                $name = $request->get('name');
                $email = $request->get('email');
                $reason = $request->get('reason');
                $ip_address = $request->ip();
                $admin_email = $this->admin_email;
                $link = request()->headers->get('referer');

                // Notify site admin by email
                Mail::to($admin_email)->send(new Report($name, $email, $link, $reason, $ip_address, $this->mail_site_title, $this->mail_from));

                // Return success message
                return '<div class="alert alert-success mt-3 show" role="alert">' . __('general.report_submission_thanks') . '</div>';
            }

        }
    }
}
