<?php
namespace App\Http\Controllers;

use App\Models\Article;
use App\Models\Category;
use App\Models\Location;
use App\Models\Link;
use App\Models\Page;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\View;

class SitemapController extends Controller
{

    public function __construct()
    {
        // Site Settings
        $site_settings = DB::table('settings')->get();

        foreach ($site_settings as $setting) {
            $setting_name = $setting->name;
            $this->$setting_name = $setting->value;
            $settings[$setting->name] = $setting->value;
        }
        
        $translations = DB::table('translations')->OrderBy('sort', 'ASC')->get();
        
        foreach ($translations as $language) {
            if ( $settings['root_language'] == '1' && $language->code == $settings['site_language'] ) {
            $language_prefix[$language->id] = '/';
            } else {
            $language_prefix[$language->id] = $language->code.'/';
            }
        }

        // List of categories
        $this->category_list = Category::orderBy('title', 'ASC')->get();
        
        // List of locations
        $this->locations_list = Location::orderBy('title', 'ASC')->get();

        // Pass data to views
        View::share(['settings' => $settings, 'category_list' => $this->category_list, 'locations_list' => $this->locations_list, 'language_prefix' => $language_prefix]);
    }

    /** Index */
    public function index()
    {
        // Return view
        return response()->view('frontend::sitemap.index')->header('Content-Type', 'text/xml');
    }

    /** Sitemaps */
    public function sitemap()
    {
        // List of Sitemaps
        $sitemaps = array('links', 'categories', 'locations', 'pages', 'articles');
        $slug = request()->slug;

        if (!in_array($slug, $sitemaps)) {
            abort(404);
        }

        switch ($slug) {

            /** Links Sitemap */
            case "links":

                // List of links
                $links = Link::where('bypass_details', '0')->where('enabled', '1')->latest()->get();

                // Return view
                return response()->view('frontend::sitemap.links', ['links' => $links])->header('Content-Type', 'text/xml');

                break;

            /** Categories Sitemap */
            case "categories":

                // List of categories
                if ($this->show_links_under_subcategories == '1') {
                    $categories = $this->category_list;
                } else {
                    $categories = DB::select(DB::raw("SELECT c.parent_id, c.slug, c.language, (select count(*) from links where category = c.id and enabled='1') as item_count FROM categories c"));
                }

                // Return view
                return response()->view('frontend::sitemap.categories', ['categories' => $categories, 'links_per_page' => $this->links_per_page])->header('Content-Type', 'text/xml');

                break;

            /** Locations Sitemap */
            case "locations":

                // List of locations
                    $locations = $this->locations_list;

                // Return view
                return response()->view('frontend::sitemap.locations', ['locations' => $locations, 'links_per_page' => $this->links_per_page])->header('Content-Type', 'text/xml');

                break;

            /** Articles Sitemap */
            case "articles":

                // List of articles
                $articles = Article::latest()->get();

                // Return view
                return response()->view('frontend::sitemap.articles', ['articles' => $articles])->header('Content-Type', 'text/xml');

                break;

            /** Pages Sitemap */
            case "pages":

                // List of custom pages
                $pages = Page::latest()->get();

                // Return view
                return response()->view('frontend::sitemap.pages', ['pages' => $pages])->header('Content-Type', 'text/xml');

                break;
        }
    }

}
