<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class Submissionreceived extends Mailable
{
    use Queueable, SerializesModels;

    public $mail_from;
    public $site_title;
    public $name;
    public $email;
    public $url;
    public $title;
    public $description;
    public $category_title;
    public $ip_address;
    public $link_package;
    
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($name, $email, $link_package, $site_title, $url, $title, $description, $ip_address, $mail_from)
    {
        $this->name = $name;
        $this->email = $email;
        $this->link_package = $link_package;
        $this->site_title = $site_title;
        $this->url = $url;
        $this->title = $title;
        $this->description = $description;
        $this->ip_address = $ip_address;
        $this->mail_from = $mail_from;
        }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from($this->mail_from)->markdown('vendor.frontend.mail.submission_received')->subject(__('general.submission_received'));
    }
}
