@extends('adminlte::master')

@section('adminlte_css')
<link rel="stylesheet" href="{{ asset('vendor/adminlte/vendor/icheck-bootstrap/icheck-bootstrap.min.css') }}">
@yield('css')
@stop

@section('body_class', 'login-page')

@section('body')
<div class="login-box">
    <div class="login-logo">
        <a href="{{ url(config('adminlte.dashboard_url', 'admin')) }}">{!! config('adminlte.logo', '<b>Admin</b>LTE') !!}</a>
    </div>

    @if(count($errors) > 0)
    <div class="alert alert-danger">
        @foreach($errors->all() as $error)
        <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
        @endforeach
    </div>
    @endif

    <!-- /.login-logo -->
    <div class="login-box-body">
        <p class="login-box-msg">{{ trans('adminlte::adminlte.login_message') }}</p>
        <form action="{{ asset(env('ADMIN_LOGIN_URL')) }}" method="post">
            {{ csrf_field() }}

            <div class="form-group has-feedback {{ $errors->has('email') ? 'has-error' : '' }}">
                <input type="email" name="email" class="form-control" value="{{ old('email') }}" placeholder="{{ trans('adminlte::adminlte.email') }}">
                <span class="glyphicon glyphicon-envelope form-control-feedback"></span>
                @if ($errors->has('email'))
                <span class="help-block">
                    <strong>{{ $errors->first('email') }}</strong>
                </span>
                @endif
            </div>
            <div class="form-group has-feedback {{ $errors->has('password') ? 'has-error' : '' }}">
                <input type="password" name="password" class="form-control" placeholder="{{ trans('adminlte::adminlte.password') }}">
                <span class="glyphicon glyphicon-lock form-control-feedback"></span>
                @if ($errors->has('password'))
                <span class="help-block">
                    <strong>{{ $errors->first('password') }}</strong>
                </span>
                @endif
            </div>

            <div class="form-group">
                @if ($settings['enable_google_recaptcha'] == '1')
                <div class="g-recaptcha mt-3" data-sitekey="{{ $settings['google_recaptcha_site_key'] }}"></div>
                @endif
            </div>
            
            <div class="row">
                <div class="col-xs-8">
                    <div class="icheck-primary">
                        <input type="checkbox" name="remember" id="remember">
                        <label for="remember">{{ trans('adminlte::adminlte.remember_me') }}</label>
                    </div>
                </div>
                <!-- /.col -->
                <div class="col-xs-4">
                    <button type="submit" class="btn btn-primary btn-block btn-flat">
                        {{ trans('adminlte::adminlte.sign_in') }}
                    </button>
                </div>
                <!-- /.col -->
            </div>

        </form>
        <br>
        <p>
            <a href="{{ url(config('adminlte.password_reset_url', 'password/reset')) }}" class="text-center">
                {{ trans('adminlte::adminlte.i_forgot_my_password') }}
            </a>
        </p>
        @if (config('adminlte.register_url', 'register'))
        <p>
            <a href="{{ url(config('adminlte.register_url', 'register')) }}" class="text-center">
                {{ trans('adminlte::adminlte.register_a_new_membership') }}
            </a>
        </p>
        @endif
    </div>
    <!-- /.login-box-body -->
</div><!-- /.login-box -->
@stop

@section('adminlte_js')
@yield('js')
@stop