@extends('adminlte::page')

@section('content')

@if($main_category == '0')
@section('content_header', __('admin.subcategories'))
@endif
@if($main_category == '1')
@section('content_header', __('admin.categories'))
@endif
@if($main_category == '2')
@section('content_header', __('admin.languages'))
@endif

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            @if($main_category == '2')

            <div class="table-responsive">
                <table class="table table-striped" id="table" data-delete-prompt="@lang('admin.delete_prompt')" data-yes="@lang('admin.yes')" data-cancel="@lang('admin.cancel')">
                    <thead>
                        <tr>
                            <th class="col-md-1">ID</th>
                            <th class="col-md-10">@lang('admin.language')</th>
                            <th class="col-md-1">@lang('admin.categories')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($translations as $row)
                        <tr>
                            <td>{{$row->id}}</td>
                            <td><span class="fi fi-{{$array_data['language_code'][$row->id]}}"></span> {{$row->language}}</td>
                            <td><a href="{{ asset(env('ADMIN_URL').'/main_categories/'.$row->id) }}" class="btn btn-link btn-sm bg-purple"><i class="fas fa-edit"></i>
                                    @lang('admin.view')
                                </a>

                            </td>

                        </tr>

                        @endforeach
                    </tbody>
                </table>
            </div>

            @endif

            <!-- box-body -->
            <div class="box-body no-padding">

                @if($main_category == '0' || $main_category == '1')

                @if($main_category == '1')
                <a href="{{ asset(env('ADMIN_URL').'/categories/create') }}?language={{request()->id}}" class="btn bg-purple btn-flat margin">
                    @else
                    <a href="{{ asset(env('ADMIN_URL').'/categories/create?sub_category='.request()->id.'') }}&language={{$data_to_pass['category_language']}}" class="btn bg-purple btn-flat margin">
                        @endif
                        <i class="fas fa-plus-square"></i> @if($main_category == '1') @lang('admin.create_category') @else @lang('admin.create_subcategory') @endif </a>
                        
                        @if($main_category == '1')
                        <a href="{{ asset(env('ADMIN_URL').'/categories/create_categories_bulk') }}?language={{request()->id}}" class="btn bg-olive btn-flat">
                            @else
                        <a href="{{ asset(env('ADMIN_URL').'/categories/create_categories_bulk?sub_category='.request()->id.'') }}&language={{$data_to_pass['category_language']}}" class="btn bg-olive btn-flat">
                            @endif
                            
                        <i class="fas fa-plus-square"></i> @if($main_category == '1') @lang('admin.create_categories_in_bulk') @else @lang('admin.create_subcategories_in_bulk') @endif
                        </a>
                        
                    <div class="table-responsive">
                        <table class="table table-striped" id="table" data-delete-prompt="@lang('admin.delete_prompt')" data-yes="@lang('admin.yes')" data-cancel="@lang('admin.cancel')">
                            <thead>
                                <tr>
                                    <th class="col-md-1">ID</th>
                                    <th class="@if($main_category == '1')col-md-6 @else col-md-7 @endif">@lang('admin.title')</th>
                                    @if($main_category == '1')
                                    <th class="col-md-1">@lang('admin.subcategories')</th>
                                    @endif
                                    <th class="col-md-1">@lang('admin.date')</th>
                                    <th class="col-md-1">@lang('admin.language')</th>
                                    <th class="col-md-1">@lang('admin.edit')</th>
                                    <th class="col-md-1">@lang('admin.delete')</th>
                                </tr>
                            </thead>
                            <tbody class="sortable-posts" id="categories">
                                @foreach($categories as $row)
                                <tr id="{{ $row->id }}">
                                    <td>{{$row->id}}</td>
                                    @if($main_category == '1')
                                    <td><a href="{{ asset($array_data['language_prefix'][$row->language].$settings['category_base'.'-'.$row->language]) }}/{{ $row->slug }}" class="text-black" target="_blank">{{$row->title}}</a></td>
                                    @else
                                    <td><a href="{{ asset($array_data['language_prefix'][$row->language].$settings['category_base'.'-'.$row->language]) }}/{{ $data_to_pass['parent_category_slug'] }}/{{ $row->slug }}" class="text-black" target="_blank">{{$row->title}}</a></td>
                                    @endif
                                    @if($main_category == '1')
                                    <td><a href="{{ asset(env('ADMIN_URL').'/sub_categories/'.$row->id) }}" class="text-black"><u>{{ count($row->children) }}</u></a></td>
                                    @endif
                                    <td>{{\Carbon\Carbon::parse($row->created_at)->translatedFormat('M d, Y')}}</td>
                                    <td><span class="fi fi-{{$array_data['language_code'][$row->language]}}"></span></td>
                                    <td><a href="{{action('App\Http\Controllers\CategoryController@edit', $row->id)}}" class="btn btn-link btn-sm bg-purple"><i class="fas fa-edit"></i>
                                            @lang('admin.edit')
                                        </a></td>
                                    <td>
                                        <form id="delete_from_{{$row->id}}" method="POST" action="{{action('App\Http\Controllers\CategoryController@destroy', $row['id'])}}">
                                            {{ csrf_field() }}
                                            {{ method_field('DELETE') }}
                                            <a href="javascript:void(0);" data-id="{{$row->id}}" class="_delete_data">
                                                <span class="btn btn-sm bg-red"><i class="fas fa-ban"></i>
                                                    @lang('admin.delete')</span>
                                            </a>
                                        </form>
                                    </td>
                                </tr>

                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    @endif

            </div>
            <!-- /.box-body -->

        </div>
        <!-- /.general form elements -->

        @if($main_category != '2' && $categories->isEmpty())
        <h6 class="alert alert-danger">@lang('admin.no_record').</h6>
        @endif

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

@endsection