@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.view_order'))

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            <!-- form -->

            <!-- box-body -->
            <div class="box-body">

                <div class="table-responsive">
                    <table class="table table-hover">
                        <tbody>
                            <tr>
                                <th>@lang('admin.order_id')</th>
                                <td>#{{$order->order_id}}</td>
                            </tr>
                            <tr>
                                <th>@lang('admin.status')</th>
                                <td>
                                    @if($order->price == '0.00')
                                    -
                                    @else
                                    @if($order->payment_status=='0')<span class="badge not-paid">@lang('general.not_paid')</span>@endif
                                    @if($order->payment_status=='1')<span class="badge paid">@lang('general.paid')</span>@endif
                                    @if($order->payment_status=='3')<span class="badge processing">@lang('general.processing')</span>@endif
                                    @if($order->payment_status=='4')<span class="badge expired">@lang('general.expired')</span>@endif
                                    @endif
                                </td>
                            </tr>
                            <tr>
                                <th>@lang('admin.package')</th>
                                <td>{{$array_data['package_name'][$order->package]}}</td>
                            </tr>
                            <tr>
                                <th>@lang('admin.price')</th>
                                <td>@if($order->price=='0.00')@lang('general.free') @else{{$order->currency_symbol}}{{$order->price}}@endif</td>
                            </tr>
                            @if($order->price!='0.00')
                            <tr>
                                <th>@lang('admin.payment_method')</th>
                                <td>{{$array_data['payment_method_name'][$order->payment_method]}}</td>
                            </tr>
                            @endif
                            <tr>
                                <th>@lang('admin.title')</th>
                                <td>{{$order->title}}</td>
                            </tr>
                            <tr>
                                <th>@lang('admin.url')</th>
                                <td><a href="{{$order->url}}" target="_blank">{{$order->url}}</a>
                            </tr>
                            @if($order->reciprocal_link != null)
                            <th>@lang('admin.reciprocal_link')</th>
                            <td><a href="{{$order->reciprocal_link}}" target="_blank">{{$order->reciprocal_link}}</a>
                                @endif
                                @if($order->visible_url != null)
                                <tr>
                                    <th>@lang('admin.visible_url')</th>
                                    <td>{{$order->visible_url}}</td>
                                </tr>
                                @endif
                                @if($order->bypass_redirect == 1)
                                <tr>
                                    <th>@lang('admin.bypass_redirection_page')</th>
                                    <td><i class="fas fa-check"></i></td>
                                </tr>
                                @endif
                                @if($order->bypass_details == 1)
                                <tr>
                                    <th>@lang('admin.bypass_details_page')</th>
                                    <td><i class="fas fa-check"></i></td>
                                </tr>
                                @endif
                                @if($order->featured_home == 1)
                                <tr>
                                    <th>@lang('admin.featured_home')</th>
                                    <td><i class="fas fa-check"></i></td>
                                </tr>
                                @endif
                                @if($order->featured_category == 1)
                                <tr>
                                    <th>@lang('admin.featured_category')</th>
                                    <td><i class="fas fa-check"></i></td>
                                </tr>
                                @endif

                                <tr>
                                    <th>@lang('admin.category')</th>
                                    <td>@foreach($categories as $category)

                                        @php if(in_array($category->id, $order_categories)) { echo $category->title.'<br />'; } @endphp

                                        @foreach($category->children as $submenu)
                                        @php if(in_array($submenu->id, $order_categories)) { echo $category->title.'<br />'; } @endphp

                                        @endforeach

                                        @endforeach</td>
                                </tr>

                                @if (!empty($deep_link_data['link_1']['url'] && $deep_link_data['link_1']['title']) || !empty($deep_link_data['link_2']['url'] && $deep_link_data['link_2']['title']) || !empty($deep_link_data['link_3']['url'] && $deep_link_data['link_3']['title']))
                                <tr>
                                    <th>@lang('admin.deep_links')</th>
                                    <td>
                                        @foreach($deep_link_data as $title)
                                        @if ($title['url'] != null && $title['title'] != null)
                                        <a href="{{$title['url']}}" target="_blank" class="site-url">{{$title['title']}}</a><br />
                                        @endif
                                        @endforeach
                                    </td>
                                </tr>

                                @endif

                                @if ($other_contacts['facebook_url']['url'] != null || $other_contacts['twitter_url']['url'] != null || $other_contacts['instagram_url']['url'] != null || $other_contacts['linkedin_url']['url'] != null || $other_contacts['telegram_url']['url'] != null || $other_contacts['whatsapp_number']['number'] != null)
                                <tr>
                                    <th>@lang('admin.other_contacts')</th>
                                    <td>
                                        @if ($other_contacts['facebook_url']['url'] != null)<a href="{{$other_contacts['facebook_url']['url']}}" target="_blank">@lang('admin.facebook_url')</a><br />@endif
                                        @if ($other_contacts['twitter_url']['url'] != null)<a href="{{$other_contacts['twitter_url']['url']}}" target="_blank">@lang('admin.twitter_url')</a><br />@endif
                                        @if ($other_contacts['instagram_url']['url'] != null)<a href="{{$other_contacts['instagram_url']['url']}}" target="_blank">@lang('admin.instagram_url')</a><br />@endif
                                        @if ($other_contacts['linkedin_url']['url'] != null)<a href="{{$other_contacts['linkedin_url']['url']}}" target="_blank">@lang('admin.linkedin_url')</a><br />@endif
                                        @if ($other_contacts['whatsapp_number']['number'] != null)<a href="https://wa.me/{{$other_contacts['whatsapp_number']['number']}}" target="_blank">@lang('admin.whatsapp_number')</a><br />@endif
                                        @if ($other_contacts['telegram_url']['url'] != null)<a href="{{$other_contacts['telegram_url']['url']}}" target="_blank">@lang('admin.telegram_url')</a><br />@endif
                                    </td>
                                </tr>

                                @endif

                                @if($order->phone_number != null)
                                <tr>
                                    <th>@lang('admin.phone_number')</th>
                                    <td>{{$order->phone_number}}</td>
                                </tr>
                                @endif
                                @if($order->email != null)
                                <tr>
                                    <th>@lang('admin.email')</th>
                                    <td>{{$order->email}}</td>
                                </tr>
                                @endif
                                @if($order->address != null)
                                <tr>
                                    <th>@lang('admin.address')</th>
                                    <td>{{$order->address}}</td>
                                </tr>
                                @endif
                                <tr>
                                    <th>@lang('admin.date')</th>
                                    <td>{{\Carbon\Carbon::parse($order->created_at)->translatedFormat('F d, Y H:i:s')}}</td>
                                </tr>
                                <tr>
                                    <th>@lang('admin.ip_address')</th>
                                    <td>{{$order->ip}}</td>
                                </tr>

                        </tbody>
                    </table>
                </div>
            </div>
            <!-- /.box-body -->

        </div>
        <!-- /.general form elements -->

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

@endsection