<form action="{{ asset(env('ADMIN_URL').'/search') }}" method="GET" class="sidebar-form">
    <div class="input-group">
        <input type="text" name="term" class="form-control" placeholder="
            @lang('admin.search_links')
            ">
        <span class="input-group-btn">
            <button type="submit" id="search-btn" class="btn btn-flat">
                <i class="fas fa-search"></i>
            </button>
        </span>
    </div>
</form>

<li class="header">@lang('admin.administration')</li>

<li class="treeview{{ Request::is(env('ADMIN_URL').'/links*', env('ADMIN_URL'), env('ADMIN_URL').'/search')  ? ' active' : '' }}">
    <a href="#">
        <i class="fas fa-link"></i>
        <span class="ml-5">
            @lang('admin.links')
        </span>
        <span class="pull-right-container">
            <i class="fas fa-angle-left pull-right"></i>
        </span>
    </a>
    <ul class="treeview-menu">
        <li class="{{ Request::is(env('ADMIN_URL').'/links', env('ADMIN_URL'), env('ADMIN_URL').'/links/*/edit', env('ADMIN_URL').'/search') ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/links') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.links')
                </span>
            </a>
        </li>
        <li class="{{ Request::is(env('ADMIN_URL').'/links/create') ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/links/create') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.create_link')
                </span>
            </a>
        </li>     
    </ul>
</li>

<li class="treeview{{ Request::is(env('ADMIN_URL').'/packages*')  ? ' active' : '' }}">
    <a href="#">
        <i class="fas fa-box-open"></i>
        <span class="ml-5">
            @lang('admin.packages')
        </span>
        <span class="pull-right-container">
            <i class="fas fa-angle-left pull-right"></i>
        </span>
    </a>
    <ul class="treeview-menu">
        <li class="{{ Request::is(env('ADMIN_URL').'/packages', env('ADMIN_URL').'/packages/*/edit') ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/packages') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.packages')
                </span>
            </a>
        </li>
        <li class="{{ Request::is(env('ADMIN_URL').'/packages/create') ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/packages/create') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.create_package')
                </span>
            </a>
        </li>
    </ul>
</li>

<li class="treeview{{ Request::is(env('ADMIN_URL').'/orders*', env('ADMIN_URL').'/payment_notifications*')  ? ' active' : '' }}">
    <a href="#">
        <i class="fas fa-dollar-sign"></i>
        <span class="ml-5">
            @lang('admin.orders')
        </span>
        <span class="pull-right-container">
            <i class="fas fa-angle-left pull-right"></i>
        </span>
    </a>
    <ul class="treeview-menu">
        <li class="{{ Request::is(env('ADMIN_URL').'/orders') ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/orders') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.orders')
                </span>
            </a>
        </li>
        <li class="{{ Request::is(env('ADMIN_URL').'/payment_notifications') ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/payment_notifications') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.payment_notifications')
                </span>
            </a>
        </li>
    </ul>
</li>

<li class="treeview{{ Request::is(env('ADMIN_URL').'/members*')  ? ' active' : '' }}">
    <a href="#">
        <i class="fas fa-user"></i>
        <span class="ml-5">
            @lang('admin.members')
        </span>
        <span class="pull-right-container">
            <i class="fas fa-angle-left pull-right"></i>
        </span>
    </a>
    <ul class="treeview-menu">
        <li class="{{ Request::is(env('ADMIN_URL').'/members', env('ADMIN_URL').'/members/*/edit', env('ADMIN_URL').'/members/send_email*') ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/members') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.members')
                </span>
            </a>
        </li>
        <li class="{{ Request::is(env('ADMIN_URL').'/members/create') ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/members/create') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.create_member')
                </span>
            </a>
        </li>
    </ul>
</li>

<li class="treeview{{ Request::is(env('ADMIN_URL').'/categories*', env('ADMIN_URL').'/sub_categories/*', env('ADMIN_URL').'/main_categories/*', env('ADMIN_URL').'/categories/create_categories_bulk*') ? ' active' : '' }}">
    <a href="#">
        <i class="fas fa-bookmark"></i>
        <span class="ml-5">
            @lang('admin.categories')
        </span>
        <span class="pull-right-container">
            <i class="fas fa-angle-left pull-right"></i>
        </span>
    </a>
    <ul class="treeview-menu">
        <li class="{{ Request::is(env('ADMIN_URL').'/categories', env('ADMIN_URL').'/categories/*/edit', env('ADMIN_URL').'/sub_categories/*', env('ADMIN_URL').'/main_categories/*', env('ADMIN_URL').'/categories/create_categories_bulk*') ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/categories') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.categories')
                </span>
            </a>
        </li>
        <li class="{{ Request::is(env('ADMIN_URL').'/categories/create') ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/categories/create') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.create_category')
                </span>
            </a>
        </li>    
    </ul>
</li>

<li class="treeview{{ Request::is(env('ADMIN_URL').'/locations*', env('ADMIN_URL').'/countries/*', env('ADMIN_URL').'/cities/*') ? ' active' : '' }}">
    <a href="#">
        <i class="fas fa-map-marker-alt"></i>
        <span class="ml-5">
            @lang('admin.locations')
        </span>
        <span class="pull-right-container">
            <i class="fas fa-angle-left pull-right"></i>
        </span>
    </a>
    <ul class="treeview-menu">
        <li class="{{ Request::is(env('ADMIN_URL').'/locations', env('ADMIN_URL').'/locations/*/edit', env('ADMIN_URL').'/countries/*', env('ADMIN_URL').'/cities/*') ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/locations') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.locations')
                </span>
            </a>
        </li>
        <li class="{{ Request::is(env('ADMIN_URL').'/locations/create') ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/locations/create') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.create_location')
                </span>
            </a>
        </li>    
    </ul>
</li>

<li class="treeview{{ Request::is(env('ADMIN_URL').'/articles*')  ? ' active' : '' }}">
    <a href="#">
        <i class="fas fa-font"></i>
        <span class="ml-5">
            @lang('admin.articles')
        </span>
        <span class="pull-right-container">
            <i class="fas fa-angle-left pull-right"></i>
        </span>
    </a>
    <ul class="treeview-menu">
        <li class="{{ Request::is(env('ADMIN_URL').'/articles', env('ADMIN_URL').'/articles/*/edit') ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/articles') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.articles')
                </span>
            </a>
        </li>
        <li class="{{ Request::is(env('ADMIN_URL').'/articles/create') ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/articles/create') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.create_article')
                </span>
            </a>
        </li>
    </ul>
</li>

<li class="treeview{{ Request::is(env('ADMIN_URL').'/pages*', env('ADMIN_URL').'/page_list*') ? ' active' : '' }}">
    <a href="#">
        <i class="fas fa-file"></i>
        <span class="ml-5">
            @lang('admin.pages')
        </span>
        <span class="pull-right-container">
            <i class="fas fa-angle-left pull-right"></i>
        </span>
    </a>
    <ul class="treeview-menu">
        <li class="{{ Request::is(env('ADMIN_URL').'/pages', env('ADMIN_URL').'/pages/*/edit', env('ADMIN_URL').'/page_list*') ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/pages') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.pages')
                </span>
            </a>
        </li>
        <li class="{{ Request::is(env('ADMIN_URL').'/pages/create') ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/pages/create') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.create_page')
                </span>
            </a>
        </li>
    </ul>
</li>

<li class="treeview{{ Request::is(env('ADMIN_URL').'/partners*', env('ADMIN_URL').'/partner_list*')  ? ' active' : '' }}">
    <a href="#">
        <i class="fas fa-briefcase"></i>
        <span class="ml-5">
            @lang('admin.partners')
        </span>
        <span class="pull-right-container">
            <i class="fas fa-angle-left pull-right"></i>
        </span>
    </a>
    <ul class="treeview-menu">
        <li class="{{ Request::is(env('ADMIN_URL').'/partners', env('ADMIN_URL').'/partners/*/edit', env('ADMIN_URL').'/partner_list*') ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/partners') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.partners')
                </span>
            </a>
        </li>
        <li class="{{ Request::is(env('ADMIN_URL').'/partners/create') ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/partners/create') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.create_partner')
                </span>
            </a>
        </li>
    </ul>
</li>

<li class="treeview{{ Request::is(env('ADMIN_URL').'/settings*', env('ADMIN_URL').'/seo_settings*', env('ADMIN_URL').'/payment_listing_settings*', env('ADMIN_URL').'/account_settings*', env('ADMIN_URL').'/translations*', env('ADMIN_URL').'/bank_accounts*', env('ADMIN_URL').'/mail_settings*', env('ADMIN_URL').'/pwa_settings*')  ? ' active' : '' }}">
    <a href="#">
        <i class="fas fa-cog"></i>
        <span class="ml-5">
            @lang('admin.settings')
        </span>
        <span class="pull-right-container">
            <i class="fas fa-angle-left pull-right"></i>
        </span>
    </a>
    <ul class="treeview-menu">
        <li class="{{ Request::is(env('ADMIN_URL').'/settings*')  ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/settings') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.settings')
                </span>
            </a>
        </li>
        <li class="{{ Request::is(env('ADMIN_URL').'/bank_accounts*') ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/bank_accounts') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.bank_accounts')
                </span>
            </a>
        </li>
        <li class="{{ Request::is(env('ADMIN_URL').'/payment_listing_settings*')  ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/payment_listing_settings') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.payment_listing_settings')
                </span>
            </a>
        </li>
        <li class="{{ Request::is(env('ADMIN_URL').'/seo_settings*')  ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/seo_settings') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.seo_settings')
                </span>
            </a>
        </li>
        <li class="{{ Request::is(env('ADMIN_URL').'/mail_settings*')  ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/mail_settings') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.mail_settings')
                </span>
            </a>
        </li>
        <li class="{{ Request::is(env('ADMIN_URL').'/pwa_settings*')  ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/pwa_settings') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.pwa_settings')
                </span>
            </a>
        </li>        
        <li class="{{ Request::is(env('ADMIN_URL').'/translations*')  ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/translations') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.translations')
                </span>
            </a>
        </li>
        <li class="{{ Request::is(env('ADMIN_URL').'/account_settings*')  ? 'active' : '' }}">
            <a href="{{ asset(env('ADMIN_URL').'/account_settings') }}">
                <i class="fas fa-angle-right"></i>
                <span class="ml-5">
                    @lang('admin.account_settings')
                </span>
            </a>
        </li>
    </ul>
</li>

<li class="{{ Request::is(env('ADMIN_URL').'/ads*')  ? 'active' : '' }}">
    <a href="{{ asset(env('ADMIN_URL').'/ads') }}">
        <i class="fas fa-flag"></i>
        <span class="ml-5">
            @lang('admin.ads')
        </span>
    </a>
</li>

<li class="{{ Request::is(env('ADMIN_URL').'/submissions*')  ? 'active' : '' }}">
    <a href="{{ asset(env('ADMIN_URL').'/submissions') }}">
        <i class="fas fa-file-import"></i>
        <span class="ml-5">
            @lang('admin.submissions')
        </span>
    </a>
</li>

<li class="">
    <a href="https://codecanyon.net/item/link-directory-pro/34390503/support" target="blank">
        <i class="fas fa-paper-plane"></i>
        <span class="ml-5">
            @lang('admin.suggest_feature')
        </span>
    </a>
</li>

<li>
    <a href="https://members.foxart.co/documentation/link-directory-pro/" target="_blank">
        <i class="fa fa-book"></i>
        <span>
            @lang('admin.documentation')
        </span>
    </a>
</li>

<li>
    <a href="javascript:void(0);" class="v_control" id="v_control" onclick="executeExample('dynamicQueue')" data-version-control="@lang('admin.version_control')" data-version-info="@lang('admin.version_check_info')" data-latest-version="@lang('admin.check_latest_version')" data-version-control-fail="@lang('admin.version_control_fail')">
        <i class="fa fa-code-branch"></i>
        <span>
            Link Directory Pro {{env('APP_VERSION')}}
        </span>
    </a>
</li>