@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.create_partner'))

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            <!-- form -->
            <form method="POST" enctype="multipart/form-data" action="{{url(env('ADMIN_URL').'/partners')}}">
                @csrf @method('POST')

                <!-- box-body -->
                <div class="box-body">

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.language') <span class="text-danger">*</span></label>
                                <select title="@lang('admin.select_language')" name="language" class="form-control selectpicker" data-live-search="true">
                                    @foreach($translations as $translation)
                                    <option value="{{ $translation->id }}" data-content="<span class='fi fi-{{$translation['icon']}}'></span> {{$translation['language']}}" {{ old('language', $array_data['site_language_id']) == $translation['id'] ? 'selected' : '' }}></option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <div class="form-group">
                        <label>@lang('admin.title') <span class="text-danger">*</span></label>
                        <input type="text" name="title" class="form-control" value="{{old('title')}}" placeholder="@lang('admin.title')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.url') <span class="text-danger">*</span></label>
                        <input type="text" name="url" class="form-control" value="{{old('url')}}" placeholder="@lang('admin.url')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.link_type')</label>
                        <select title="@lang('admin.link_type')" name="link_type" class="form-control selectpicker" data-live-search="true">
                            @foreach($link_types as $link_id => $link_type)
                            <option value="{{ $link_id }}" {{ old('link_type') == $link_id ? 'selected' : '' }}>
                                {{ $link_type }}
                            </option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.show_on_header')</label><br />
                        <input type="checkbox" name="navbar" {{ old('navbar') == "on" ? 'checked' : '' }}>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.show_on_footer')</label><br />
                        <input type="checkbox" name="footer"  @if(!old() || old('footer')=='on' ) checked="checked" @endif>
                    </div>

                </div>
                <!-- /.box-body -->

                <div class="box-footer">
                    <button type="submit" class="btn btn-primary">@lang('admin.submit')</button>
                </div>

            </form>
            <!-- /.form -->

        </div>
        <!-- /.general form elements -->

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

@endsection