@extends('adminlte::page')

@section('content')

@if($language_menu == '0')
@section('content_header', __('admin.seo_settings'))
@endif
@if($language_menu == '1')
@section('content_header', __('admin.languages'))
@endif

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            @if($language_menu == '1')

            <div class="table-responsive">
                <table class="table table-striped" id="table" data-delete-prompt="@lang('admin.delete_prompt')" data-yes="@lang('admin.yes')" data-cancel="@lang('admin.cancel')">
                    <thead>
                        <tr>
                            <th class="col-md-1">ID</th>
                            <th class="col-md-10">@lang('admin.language')</th>
                            <th class="col-md-1">@lang('admin.pages')</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($translations as $row)
                        <tr>
                            <td>{{$row->id}}</td>
                            <td><span class="fi fi-{{$language_code[$row->id]}}"></span> {{$row->language}}</td>
                            <td><a href="{{ asset(env('ADMIN_URL').'/seo_settings/'.$row->id) }}" class="btn btn-link btn-sm bg-purple"><i class="fas fa-edit"></i>
                                    @lang('admin.view')
                                </a>
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            @else

            <!-- form -->
            <form method="POST" enctype="multipart/form-data" action="{{url(env('ADMIN_URL').'/seo_settings/'.request()->route('id'))}}">
                @csrf @method('POST')

                <!-- box-body -->
                <div class="box-body">


                    <!-- row -->
                    <div class="row">
                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.general_settings')</label>
                        </div>
                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-12">
                            <div class="form-group">
                                <label>@lang('admin.site_title') <span class="text-danger">*</span></label>
                                <input type="text" name="site_title" class="form-control" value="{{$seo_settings['site_title']}}" placeholder="@lang('admin.site_title')" />
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label>@lang('admin.site_description') <span class="text-danger">*</span></label>
                                <textarea class="form-control" name="site_description" rows="3" placeholder="@lang('admin.site_description')">{{$seo_settings['site_description']}}</textarea>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">
                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.permalinks')</label>
                        </div>
                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.detail_base') <span class="text-danger">*</span></label>
                                <input type="text" name="detail_base" class="form-control" value="{{$seo_settings['detail_base']}}" placeholder="@lang('admin.detail_base')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.category_base') <span class="text-danger">*</span></label>
                                <input type="text" name="category_base" class="form-control" value="{{$seo_settings['category_base']}}" placeholder="@lang('admin.category_base')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.article_base') <span class="text-danger">*</span></label>
                                <input type="text" name="article_base" class="form-control" value="{{$seo_settings['article_base']}}" placeholder="@lang('admin.article_base')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.page_base') <span class="text-danger">*</span></label>
                                <input type="text" name="page_base" class="form-control" value="{{$seo_settings['page_base']}}" placeholder="@lang('admin.page_base')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.redirect_base') <span class="text-danger">*</span></label>
                                <input type="text" name="redirect_base" class="form-control" value="{{$seo_settings['redirect_base']}}" placeholder="@lang('admin.redirect_base')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.contact_slug') <span class="text-danger">*</span></label>
                                <input type="text" name="contact_slug" class="form-control" value="{{$seo_settings['contact_slug']}}" placeholder="@lang('admin.contact_slug')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.latest_links_slug') <span class="text-danger">*</span></label>
                                <input type="text" name="latest_links_slug" class="form-control" value="{{$seo_settings['latest_links_slug']}}" placeholder="@lang('admin.latest_links_slug')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.popular_links_slug') <span class="text-danger">*</span></label>
                                <input type="text" name="popular_links_slug" class="form-control" value="{{$seo_settings['popular_links_slug']}}" placeholder="@lang('admin.popular_links_slug')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.all_articles_slug') <span class="text-danger">*</span></label>
                                <input type="text" name="all_articles_slug" class="form-control" value="{{$seo_settings['all_articles_slug']}}" placeholder="@lang('admin.all_articles_slug')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.favorites_slug') <span class="text-danger">*</span></label>
                                <input type="text" name="favorites_slug" class="form-control" value="{{$seo_settings['favorites_slug']}}" placeholder="@lang('admin.favorites_slug')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.history_slug') <span class="text-danger">*</span></label>
                                <input type="text" name="history_slug" class="form-control" value="{{$seo_settings['history_slug']}}" placeholder="@lang('admin.history_slug')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.location_base') <span class="text-danger">*</span></label>
                                <input type="text" name="location_base" class="form-control" value="{{$seo_settings['location_base']}}" placeholder="@lang('admin.location_base')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.tag_base') <span class="text-danger">*</span></label>
                                <input type="text" name="tag_base" class="form-control" value="{{$seo_settings['tag_base']}}" placeholder="@lang('admin.tag_base')" />
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row mt-10">
                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.page_titles')</label>
                        </div>
                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.home_page_title_format')</label>
                                <input type="text" name="home_page_title_format" class="form-control" value="{{$seo_settings['home_page_title_format']}}" placeholder="@lang('admin.home_page_title_format')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.link_title_format')</label>
                                <input type="text" name="link_title_format" class="form-control" value="{{$seo_settings['link_title_format']}}" placeholder="@lang('admin.link_title_format')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.redirection_title_format')</label>
                                <input type="text" name="redirection_title_format" class="form-control" value="{{$seo_settings['redirection_title_format']}}" placeholder="@lang('admin.redirection_title_format')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.category_title_format')</label>
                                <input type="text" name="category_title_format" class="form-control" value="{{$seo_settings['category_title_format']}}" placeholder="@lang('admin.category_title_format')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.custom_page_title_format')</label>
                                <input type="text" name="custom_page_title_format" class="form-control" value="{{$seo_settings['custom_page_title_format']}}" placeholder="@lang('admin.custom_page_title_format')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.custom_article_title_format')</label>
                                <input type="text" name="custom_article_title_format" class="form-control" value="{{$seo_settings['custom_article_title_format']}}" placeholder="@lang('admin.custom_article_title_format')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.articles_page_title_format')</label>
                                <input type="text" name="articles_page_title_format" class="form-control" value="{{$seo_settings['articles_page_title_format']}}" placeholder="@lang('admin.articles_page_title_format')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.contact_page_title_format')</label>
                                <input type="text" name="contact_page_title_format" class="form-control" value="{{$seo_settings['contact_page_title_format']}}" placeholder="@lang('admin.contact_page_title_format')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.latest_links_page_title_format')</label>
                                <input type="text" name="latest_links_page_title_format" class="form-control" value="{{$seo_settings['latest_links_page_title_format']}}" placeholder="@lang('admin.latest_links_page_title_format')" />
                            </div>
                        </div>

                        <div class="col-md-4">

                            <div class="form-group">
                                <label>@lang('admin.popular_links_page_title_format')</label>
                                <input type="text" name="popular_links_page_title_format" class="form-control" value="{{$seo_settings['popular_links_page_title_format']}}" placeholder="@lang('admin.popular_links_page_title_format')" />
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row mt-10">
                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.page_descriptions')</label>
                        </div>
                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>@lang('admin.articles_page_description')</label>
                                <textarea class="form-control" name="articles_page_description" rows="3" placeholder="@lang('admin.articles_page_description')">{{$seo_settings['articles_page_description']}}</textarea>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>@lang('admin.contact_page_description')</label>
                                <textarea class="form-control" name="contact_page_description" rows="3" placeholder="@lang('admin.contact_page_description')">{{$seo_settings['contact_page_description']}}</textarea>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>@lang('admin.latest_links_page_description')</label>
                                <textarea class="form-control" name="latest_links_page_description" rows="3" placeholder="@lang('admin.latest_links_page_description')">{{$seo_settings['latest_links_page_description']}}</textarea>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>@lang('admin.popular_links_page_description')</label>
                                <textarea class="form-control" name="popular_links_page_description" rows="3" placeholder="@lang('admin.popular_links_page_description')">{{$seo_settings['popular_links_page_description']}}</textarea>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                </div>
                <!-- /.box-body -->

                <div class="box-footer">
                    <button type="submit" class="btn btn-primary">@lang('admin.submit')</button>
                </div>

            </form>
            <!-- /.form -->

            @endif

        </div>
        <!-- /.general form elements -->

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

@endsection