@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.settings'))

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            <!-- form -->
            <form method="POST" enctype="multipart/form-data" action="{{url(env('ADMIN_URL').'/settings')}}">
                @csrf @method('POST')

                <!-- box-body -->
                <div class="box-body">

                    <!-- row -->
                    <div class="row">
                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.general_settings')</label>
                        </div>
                    </div>
                    <!-- /.row -->

                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.site_language')</label>
                                <select title="@lang('admin.site_language')" name="site_language" class="form-control selectpicker" data-live-search="true">
                                    @foreach($language_translation as $lang => $language)
                                    <option value="{{ $lang }}" {{ $settings['site_language'] == $lang ? ' selected' : '' }}>{{ $language }}
                                    </option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                    </div>

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row mt-10">
                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.logo_image_settings')</label>
                        </div>
                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>@lang('admin.site_logo')<br /><span class="label bg-dark">1100x220</span></label>
                                <div class="logo-box mt-5">
                                    <img src="{{ asset('/images/logo.png') }}?r={{Str::random(40)}}" class="img-responsive icon-preview">
                                </div>
                                <label class="btn btn-outline btn-sm" id="browse-color-image">@lang('admin.browse')<input type="file" name="site_logo" id="import-file-select" class="hidden"></label>
                            </div>
                        </div>

                        <div class="col-md-2">
                            <div class="form-group">
                                <label>@lang('admin.favicon')<br /><span class="label bg-dark">192x192</span></label>
                                <div class="logo-box mt-5">
                                    <img src="{{ asset('/images/favicon.png') }}?r={{Str::random(40)}}" class="img-responsive icon-preview">
                                </div>
                                <label class="btn btn-outline btn-sm" id="browse-color-image">@lang('admin.browse')<input type="file" name="favicon" id="import-file-select" class="hidden"></label>
                            </div>
                        </div>

                        <div class="col-md-2">
                            <div class="form-group">
                                <label>@lang('admin.default_link_image')<br /><span class="label bg-dark">200x200</span></label>
                                <div class="logo-box mt-5">
                                    <img src="{{ asset('/images/links/no_image.png') }}?r={{Str::random(40)}}" class="img-responsive icon-preview">
                                </div>
                                <label class="btn btn-outline btn-sm" id="browse-color-image">@lang('admin.browse')<input type="file" name="default_link_image" id="import-file-select" class="hidden"></label>
                            </div>
                        </div>

                        <div class="col-md-2">
                            <div class="form-group">
                                <label>@lang('admin.default_category_image')<br /><span class="label bg-dark">200x200</span></label>
                                <div class="logo-box mt-5">
                                    <img src="{{ asset('/images/categories/no_image.png') }}?r={{Str::random(40)}}" class="img-responsive icon-preview">
                                </div>
                                <label class="btn btn-outline btn-sm" id="browse-color-image">@lang('admin.browse')<input type="file" name="default_category_image" id="import-file-select" class="hidden"></label>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <hr class="divider" />

                    <div class="form-group">
                        <label>@lang('admin.use_text_logo') </label><br />
                        <input type="checkbox" name="use_text_logo" {{ $settings['use_text_logo'] == 1 ? 'checked' : '' }}>
                    </div>

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>@lang('admin.default_share_image')<br /><span class="label bg-dark">600x315</span></label>
                                <div class="logo-box mt-5">
                                    <img src="{{ asset('/images/default_share_image.png') }}?r={{Str::random(40)}}" class="img-responsive">
                                </div>
                                <label class="btn btn-outline btn-sm" id="browse-color-image">@lang('admin.browse')<input type="file" name="default_share_image" id="import-file-select" class="hidden"></label>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row mt-10">
                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.social_media')</label>
                        </div>
                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.facebook_page_url')</label>
                                <input type="text" name="facebook_page" class="form-control" value="{{$settings['facebook_page']}}" placeholder="@lang('admin.facebook_page_url')" />
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.twitter_account_url')</label>
                                <input type="text" name="twitter_account" class="form-control" value="{{$settings['twitter_account']}}" placeholder="@lang('admin.twitter_account_url')" />
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.telegram_page_url')</label>
                                <input type="text" name="telegram_page" class="form-control" value="{{$settings['telegram_page']}}" placeholder="@lang('admin.telegram_page_url')" />
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row mt-10">
                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.google_recaptcha')</label>
                        </div>
                    </div>
                    <!-- /.row -->

                    <div class="form-group">
                        <label>@lang('admin.enable_google_recaptcha') </label><br />
                        <input type="checkbox" name="enable_google_recaptcha" {{ $settings['enable_google_recaptcha'] == 1 ? 'checked' : '' }}>
                    </div>

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>@lang('admin.google_recaptcha_site_key')</label>
                                <input type="text" name="google_recaptcha_site_key" class="form-control" value="{{$settings['google_recaptcha_site_key']}}" placeholder="@lang('admin.google_recaptcha_site_key')" />
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>@lang('admin.google_recaptcha_secret_key')</label>
                                <input type="text" name="google_recaptcha_secret_key" class="form-control" value="{{$settings['google_recaptcha_secret_key']}}" placeholder="@lang('admin.google_recaptcha_secret_key')" />
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row mt-10">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.redirection_page')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <div class="form-group">
                        <label>@lang('admin.time_before_redirect')</label>
                        <input type="text" name="time_before_redirect" class="form-control" value="{{$settings['time_before_redirect']}}" placeholder="@lang('admin.time_before_redirect')" />
                    </div>

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row mt-10">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.html_codes')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>@lang('admin.html_code_before_head')</label>
                                <textarea class="form-control" name="before_head_tag" rows="5">{{$settings['before_head_tag']}}</textarea>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>@lang('admin.html_code_after_body')</label>
                                <textarea class="form-control" name="after_head_tag" rows="5">{{$settings['after_head_tag']}}</textarea>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>@lang('admin.html_code_before_body_end')</label>
                                <textarea class="form-control" name="before_body_end_tag" rows="5">{{$settings['before_body_end_tag']}}</textarea>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row mt-10">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.item_listing_details')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <div class="form-group">
                        <label>@lang('admin.links_per_page')</label>
                        <input type="text" name="links_per_page" class="form-control" value="{{$settings['links_per_page']}}" placeholder="@lang('admin.links_per_page')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.search_page_links_per_page')</label>
                        <input type="text" name="search_page_links_per_page" class="form-control" value="{{$settings['search_page_links_per_page']}}" placeholder="@lang('admin.search_page_links_per_page')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.articles_per_page')</label>
                        <input type="text" name="articles_per_page" class="form-control" value="{{$settings['articles_per_page']}}" placeholder="@lang('admin.articles_per_page')" />
                    </div>

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row mt-10">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.screenshot_settings')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <div class="form-group">
                        <label>@lang('admin.save_screenshot_as_icon') </label><br />
                        <input type="checkbox" name="save_screenshot_as_icon" {{ $settings['save_screenshot_as_icon'] == 1 ? 'checked' : '' }}>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.thum_io_id')</label>
                        <input type="text" name="thum_io_id" class="form-control" value="{{$settings['thum_io_id']}}" placeholder="@lang('admin.thum_io_id')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.thum_io_url_key')</label>
                        <input type="text" name="thum_io_url_key" class="form-control" value="{{$settings['thum_io_url_key']}}" placeholder="@lang('admin.thum_io_url_key')" />
                    </div>

                    <hr class="divider" />

                    <!-- row -->
                    <div class="row mt-10">

                        <div class="col-md-12">
                            <label class="section-head">@lang('admin.other_settings')</label>
                        </div>

                    </div>
                    <!-- /.row -->

                    <div class="form-group">
                        <label>@lang('admin.image_quality')</label>
                        <input type="text" name="image_quality" class="form-control" value="{{$settings['image_quality']}}" placeholder="@lang('admin.image_quality')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.save_as_webp') </label><br />
                        <input type="checkbox" name="save_as_webp" {{ $settings['save_as_webp'] == 1 ? 'checked' : '' }}>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.ga_tracking_id')</label>
                        <input type="text" name="ga_tracking_id" class="form-control" value="{{$settings['ga_tracking_id']}}" placeholder="@lang('admin.ga_tracking_id')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.ga_publisher_id')</label>
                        <input type="text" name="ga_publisher_id" class="form-control" value="{{$settings['ga_publisher_id']}}" placeholder="@lang('admin.ga_publisher_id')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.admin_email')</label>
                        <input type="text" name="admin_email" class="form-control" value="{{$settings['admin_email']}}" placeholder="@lang('admin.admin_email')" />
                    </div>

                                        <!-- row -->
                                        <div class="row">

                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label>@lang('admin.meta_theme_color')</label>
                                                    <input type="text" name="meta_theme_color" class="form-control my-colorpicker" value="{{$settings['meta_theme_color']}}" placeholder="@lang('admin.meta_theme_color')" />
                                                </div>
                                            </div>

                                            <div class="col-md-3">
                                                <div class="form-group">
                                                    <label>@lang('admin.header_bg_color')</label>
                                                    <input type="text" name="header_bg_color" class="form-control my-colorpicker" value="{{$settings['header_bg_color']}}" placeholder="@lang('admin.header_bg_color')" />
                                                </div>
                                            </div>
                                                        
                <div class="col-md-3">
                    <div class="form-group">
                        <label>@lang('admin.footer_bg_color')</label>
                        <input type="text" name="footer_bg_color" class="form-control my-colorpicker" value="{{$settings['footer_bg_color']}}" placeholder="@lang('admin.footer_bg_color')" />
                    </div>
                </div>

                    <div class="col-md-3">
                        <div class="form-group">
                        <label>@lang('admin.copyright_bg_color')</label>
                        <input type="text" name="copyright_bg_color" class="form-control my-colorpicker" value="{{$settings['copyright_bg_color']}}" placeholder="@lang('admin.copyright_bg_color')" />
                    </div>
                </div>

            </div>

                    <div class="form-group">
                        <label>@lang('admin.redirection_page_link_details_mobile')</label>
                        <select title="@lang('admin.redirection_page_link_details_mobile')" name="redirection_page_link_details_mobile" class="form-control selectpicker" data-live-search="true">
                            <option value="1" {{ $settings['redirection_page_link_details_mobile'] == '1' ? ' selected' : '' }}>@lang('admin.on_mobile_first')</option>
                            <option value="2" {{ $settings['redirection_page_link_details_mobile'] == '2' ? ' selected' : '' }}>@lang('admin.on_mobile_second')</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.navbar_type')</label>
                        <select title="@lang('admin.navbar_type')" name="navbar_type" class="form-control selectpicker" data-live-search="true">
                            <option value="1" {{ $settings['navbar_type'] == '1' ? ' selected' : '' }}>@lang('admin.scrollable_navbar')</option>
                            <option value="2" {{ $settings['navbar_type'] == '2' ? ' selected' : '' }}>@lang('admin.collapsible_navbar')</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.article_boxes_on_home_page')</label>
                        <select title="@lang('admin.article_boxes_on_home_page')" name="article_boxes_on_home_page" class="form-control selectpicker" data-live-search="true">
                            <option value="0" {{ $settings['article_boxes_on_home_page'] == '0' ? ' selected' : '' }}>@lang('admin.dont_show')</option>
                            <option value="1" {{ $settings['article_boxes_on_home_page'] == '1' ? ' selected' : '' }}>@lang('admin.above_left_column')</option>
                            <option value="2" {{ $settings['article_boxes_on_home_page'] == '2' ? ' selected' : '' }}>@lang('admin.below_left_column')</option>
                        </select>
                    </div>

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.page_view_once')</label><br />
                                <input type="checkbox" name="page_view_once" {{ $settings['page_view_once'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.show_phone_number_country_code')</label><br />
                                <input type="checkbox" name="show_phone_number_country_code" {{ $settings['show_phone_number_country_code'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.ping_google')</label><br />
                                <input type="checkbox" name="ping_google" {{ $settings['ping_google'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.show_cookie_bar')</label><br />
                                <input type="checkbox" name="show_cookie_bar" {{ $settings['show_cookie_bar'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.enable_registration') </label><br />
                                <input type="checkbox" name="enable_registration" {{ $settings['enable_registration'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.enable_submission_form')</label><br />
                                <input type="checkbox" name="enable_submission_form" {{ $settings['enable_submission_form'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.rss_link')</label><br />
                                <input type="checkbox" name="show_rss_feed" {{ $settings['show_rss_feed'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.show_random_link') </label><br />
                                <input type="checkbox" name="show_random_link" {{ $settings['show_random_link'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.breadcrumbs') </label><br />
                                <input type="checkbox" name="breadcrumbs" {{ $settings['breadcrumbs'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.show_qr_code') </label><br />
                                <input type="checkbox" name="show_qr_code" {{ $settings['show_qr_code'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.enable_report_form') </label><br />
                                <input type="checkbox" name="enable_report_form" {{ $settings['enable_report_form'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.show_page_views') </label><br />
                                <input type="checkbox" name="show_page_views" {{ $settings['show_page_views'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.show_clicks') </label><br />
                                <input type="checkbox" name="show_clicks" {{ $settings['show_clicks'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.count_home') </label><br />
                                <input type="checkbox" name="count_home" {{ $settings['count_home'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.sub_count_home') </label><br />
                                <input type="checkbox" name="sub_count_home" {{ $settings['sub_count_home'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.sub_count_category') </label><br />
                                <input type="checkbox" name="sub_count_category" {{ $settings['sub_count_category'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.sticky_ads_right_column') </label><br />
                                <input type="checkbox" name="sticky_ads_right_column" {{ $settings['sticky_ads_right_column'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.show_featured_text') </label><br />
                                <input type="checkbox" name="show_featured_text" {{ $settings['show_featured_text'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.show_featured_links_randomly') </label><br />
                                <input type="checkbox" name="show_featured_links_randomly" {{ $settings['show_featured_links_randomly'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.show_articles_in_header') </label><br />
                                <input type="checkbox" name="show_articles_in_header" {{ $settings['show_articles_in_header'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.search_categories') </label><br />
                                <input type="checkbox" name="search_categories" {{ $settings['search_categories'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.show_links_under_subcategories') </label><br />
                                <input type="checkbox" name="show_links_under_subcategories" {{ $settings['show_links_under_subcategories'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.infinite_scroll') </label><br />
                                <input type="checkbox" name="infinite_scroll" {{ $settings['infinite_scroll'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.scrollable_articles_home_page') </label><br />
                                <input type="checkbox" name="scrollable_articles_home_page" {{ $settings['scrollable_articles_home_page'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.optional_submission_icon') </label><br />
                                <input type="checkbox" name="optional_submission_icon" {{ $settings['optional_submission_icon'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.root_language') </label><br />
                                <input type="checkbox" name="root_language" {{ $settings['root_language'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.allow_widget_embed') </label><br />
                                <input type="checkbox" name="allow_widget_embed" {{ $settings['allow_widget_embed'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.redirection_page_noindex')</label><br />
                                <input type="checkbox" name="redirection_page_noindex" {{ $settings['redirection_page_noindex']==1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.enable_live_ajax_search')</label><br />
                                <input type="checkbox" name="enable_live_ajax_search" {{ $settings['enable_live_ajax_search']==1 ? 'checked' : '' }}>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.enable_user_ratings')</label><br />
                                <input type="checkbox" name="enable_user_ratings" {{ $settings['enable_user_ratings']==1 ? 'checked' : '' }}>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.enable_user_reviews')</label><br />
                                <input type="checkbox" name="enable_user_reviews" {{ $settings['enable_user_reviews']==1 ? 'checked' : '' }}>
                            </div>
                        </div>
                        
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.hide_language_selector')</label><br />
                                <input type="checkbox" name="hide_language_selector" {{ $settings['hide_language_selector']==1 ? 'checked' : '' }}>
                            </div>
                        </div>
                                         
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.allow_user_history')</label><br />
                                <input type="checkbox" name="allow_user_history" {{ $settings['allow_user_history']==1 ? 'checked' : '' }}>
                            </div>
                        </div>
                                         
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.allow_user_favorites')</label><br />
                                <input type="checkbox" name="allow_user_favorites" {{ $settings['allow_user_favorites']==1 ? 'checked' : '' }}>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                </div>
                <!-- /.box-body -->

                <div class="box-footer">
                    <button type="submit" class="btn btn-primary">@lang('admin.submit')</button>
                </div>

            </form>
            <!-- /.form -->

        </div>
        <!-- /.general form elements -->

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

@endsection