@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.submissions'))

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            <!-- box-body -->
            <div class="box-body no-padding">

                <div class="table-responsive">
                    <table class="table table-striped" id="table" data-delete-prompt="@lang('admin.delete_prompt')" data-yes="@lang('admin.yes')" data-cancel="@lang('admin.cancel')" data-reason="@lang('admin.rejection_reason')">
                        <tr>
                            <th class="col-md-1">ID</th>
                            <th class="col-md-4">@lang('admin.title')</th>
                            <th class="col-md-2">@lang('admin.package')</th>
                            <th class="col-md-2">@lang('admin.payment_method')</th>
                            <th class="col-md-2">@lang('admin.date')</th>
                            <th class="col-md-1">@lang('admin.review')</th>
                        </tr>
                        @foreach($submissions as $row)
                        <tr>
                            <td>{{$row->id}}</td>
                            <td>{{$row->url}}</td>
                            <td>{{$array_data['package_name'][$row->package]}}</td>
                            <td>{{$array_data['payment_method_name'][$row->payment_method] ?? '-'}}</td>
                            <td>{{\Carbon\Carbon::parse($row->created_at)->translatedFormat('F d, Y')}}</td>
                            <td><a href="{{action('App\Http\Controllers\SubmissionController@show', $row->id)}}" class="btn btn-sm bg-purple"><i class="fas fa-search"></i> @lang('admin.review')</a>
                            </td>
                        </tr>
                        @endforeach
                    </table>
                </div>

            </div>
            <!-- /.box-body -->

        </div>
        <!-- /.general form elements -->

        @if($submissions->isEmpty())
        <h6 class="alert alert-danger">@lang('admin.no_record').</h6>
        @endif

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

{{ $submissions->onEachSide(1)->links() }}

@endsection