@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.create_translation'))

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            <!-- form -->
            <form method="POST" enctype="multipart/form-data" action="{{url(env('ADMIN_URL').'/translations')}}">
                @csrf @method('POST')

                <!-- box-body -->
                <div class="box-body">

                    <div class="form-group">
                        <label>@lang('admin.language') <span class="text-danger">*</span></label>
                        <input type="text" name="language" class="form-control" placeholder="@lang('admin.language')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.language_code') <span class="text-danger">*</span></label>
                        <input type="text" name="code" class="form-control" placeholder="@lang('admin.language_code')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.og_locale_tag') <span class="text-danger">*</span></label>
                        <input type="text" name="locale_code" class="form-control" placeholder="@lang('admin.og_locale_tag')" />
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.country_flag') <span class="text-danger">*</span></label>
                        <select title="@lang('admin.select_flag')" name="icon" class="form-control selectpicker" data-live-search="true">
                            @foreach($countries as $country)
                            <option value="{{$country['code']}}" data-content="<span class='fi fi-{{$country['code']}}'></span> {{$country['name']}}" {{ old('icon', 'xx') == $country['code'] ? 'selected' : '' }}></option>
                            @endforeach
                        </select>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.text_direction') <span class="text-danger">*</span></label><br />
                        <select title="@lang('admin.navbar_type')" name="text_direction" class="form-control selectpicker" data-live-search="true">
                            <option value="1" selected>@lang('admin.ltr')</option>
                            <option value="2">@lang('admin.rtl')</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.hidden_on_header')</label><br />
                        <input type="checkbox" name="hidden">
                    </div>

                </div>
                <!-- /.box-body -->

                <div class="box-footer">
                    <button type="submit" class="btn btn-primary">@lang('admin.submit')</button>
                </div>

            </form>
            <!-- /.form -->

        </div>
        <!-- /.general form elements -->

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

@endsection