@extends('frontend::page')

@section('content')

{!! $schema_comments->toScript() !!}

<!-- Container -->
<main class="container links mt-3" id="details">

    <!-- Grid Row -->
    <div class="row">

        <!-- Grid Column -->
        <div class="col-md-9">

            @if(!empty($ad[4]))<div class="mb-3 text-center">{!! $ad[4] !!}</div>@endif

            <!-- Search Box -->
            @include('frontend::inc.partials', ['type' => '1'])
            <!-- /Search Box -->

            @if ($settings['breadcrumbs'] == '1')
            <!-- Breadcrumbs -->
            <div class="breadcrumbs mb-3">
                <a href="{{ asset($language_prefix) }}">@lang('general.homepage')</a> <span class="sep">›</span>

                @if(count($link_query->categories) > 1)
                @foreach ($link_query->categories as $category)
                @if ($loop->first)
                @if(isset($category_name[$category->id]))
                <button class="btn dropdown-toggle dropdown-toggle-categories p-0" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">{{$category_name[$category->id]}}</button>
                @endif
                <div class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                    @if(isset($category_name[$category->id]))
                    @if($category->parent_id == 0)
                    <a class="dropdown-item" href="{{ asset($language_prefix.$settings['category_base']) }}/{{ $category_slug[$category->id] }}" class="site-url d-inline-block">
                        {{$category->title}}
                    </a>
                    @else
                    <a class="dropdown-item" href="{{ asset($language_prefix.$settings['category_base']) }}/{{ $category_slug[$category->parent_id] }}/{{ $category_slug[$category->id] }}" class="site-url d-inline-block">
                        {{$category->title}}
                    </a>
                    @endif
                    @endif
                    @else
                    @if(isset($category_name[$category->id]))
                    @if($category->parent_id == 0)
                    <a class="dropdown-item" href="{{ asset($language_prefix.$settings['category_base']) }}/{{ $category_slug[$category->id] }}" class="site-url d-inline-block">
                        {{$category->title}}
                    </a>
                    @else
                    <a class="dropdown-item" href="{{ asset($language_prefix.$settings['category_base']) }}/{{ $category_slug[$category->parent_id] }}/{{ $category_slug[$category->id] }}" class="site-url d-inline-block">
                        {{$category->title}}
                    </a>
                    @endif
                    @endif
                    @endif
                    @endforeach
                </div>
                @else
                @foreach ($link_query->categories as $category)
                @if(isset($category_name[$category->id]))
                @if($category->parent_id == 0)
                <a href="{{ asset($language_prefix.$settings['category_base']) }}/{{ $category_slug[$category->id] }}" class="site-url d-inline-block">
                    {{$category->title}}
                </a>
                @else
                <a href="{{ asset($language_prefix.$settings['category_base']) }}/{{ $category_slug[$category->parent_id] }}/{{ $category_slug[$category->id] }}" class="site-url d-inline-block">
                    {{$category->title}}
                </a>
                @endif
                @endif
                @endforeach
                @endif

                <span class="sep">›</span>

                <a href="{{url()->current()}}">{{$link_query->title}}</a>
            </div>

            @if ($settings['schema_breadcrumbs'] == '1')
            {!! $breadcrumb_schema_data->toScript() !!}
            @endif
            <!-- /Breadcrumbs -->
            @endif

            <div class="shadow-sm p-2 bg-white rounded mb-3">

                <div class="p-1">

                    <div class="row">
                        <div class="col-md-3 d-none d-lg-inline-block"><b>@lang('general.title')</b></div>
                        <div class="col-md-9"><span class="link-title-detail">{{ $link_query->title }}@if($link_query->featured_category == '1' OR $link_query->featured_home == '1')@endif @if($link_query->badge == '1')<i class="icon-check-circle title-badge" data-bs-toggle="tooltip" data-bs-placement="top" title="@lang('general.badge_title')"></i>@endif</span>

                            @auth @if (auth()->user()->user_type == '1') <a href="{{ asset(env('ADMIN_URL').'/links/'.$link_query->id.'/edit') }}" target="_blank"><sup class="edit">[@lang('general.edit')]</sup></a> @endif @endauth

                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-md-3"><b>@lang('general.url')</b></div>
                        <div class="col-md-9"><a href="@if ($link_query->bypass_redirect == '0'){{ asset($language_prefix.$settings['redirect_base']) }}/{{ $link_query->slug }}@else{{ $link_query->url }}@endif" target="_blank" class="site-url" @if ($link_query->bypass_redirect == '1'){!! $link_types[$link_query->bypass_type] !!}@endif>
                                @if(empty($link_query->visible_url))
                                {{ $link_query->url }}
                                @else
                                {{ $link_query->visible_url }}
                                @endif
                            </a></div>
                    </div>

                    @if ($settings['allow_user_favorites'] == '1')

                    <div class="row mt-3">
                        <div class="col-md-3 my-auto"><b>@lang('general.favorites')</b></div>
                        <div class="col-md-9 mt-1 mt-md-0"><a href="{{ $favorite_check >= 1 ? "?remove" : "?add" }}" class="badge bg-favorites mt-1" data-bs-toggle="tooltip" data-bs-placement="right" title="{{ $favorite_check >= 1 ? __('general.remove_from_favorites') : __('general.add_to_favorites') }}">{{ $favorite_check >= 1 ? __('general.remove_from_favorites') : __('general.add_to_favorites') }}</a></div>
                    </div>

                    @endif

                    <div class="row mt-3">
                        <div class="col-md-3"><b>@lang('general.description')</b></div>
                        <div class="col-md-9">{{ $link_query->description }}</div>
                    </div>

                    @if ($link_query->gallery != "")

                    <div class="row mt-3">
                        <div class="col-md-3"><b>@lang('general.gallery')</b></div>
                        <div class="col-md-9 mt-1 mt-md-0" id="gallery">
                            @foreach($gallery_data as $image_name)
                            <a href="{{ asset('images/uploads') }}/{{$image_name}}"><img src="/images/pixel.png" data-src="{{ asset('images/uploads') }}/{{$image_name}}" class="lazy me-2 mb-2" alt=""></a>
                            @endforeach
                        </div>
                    </div>

                    @endif

                    <div class="row mt-2">
                        <div class="col-md-3 my-auto"><b>@lang('general.site_icon')</b></div>
                        <div class="col-md-9 mt-1 mt-md-0"><img src="{{ asset('images/links') }}/{{ $link_query->image ?? 'no_image.png' }}" class="img-fluid rounded detail-icon" alt="{{ $link_query->title }}"></div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-md-3"><b>@lang('general.categories')</b></div>
                        <div class="col-md-9">

                            @foreach ($link_query->categories as $category)

                            @if($category->parent_id == 0)
                            <a href="{{ asset($language_prefix.$settings['category_base']) }}/{{ $category_slug[$category->id] }}">
                                {{$category->title}}</a>
                            @else
                            <a href="{{ asset($language_prefix.$settings['category_base']) }}/{{ $category_slug[$category->parent_id] }}">
                                {{$category_name[$category->parent_id]}}
                            </a>
                            <span class="sep">›</span>

                            <a href="{{ asset($language_prefix.$settings['category_base']) }}/{{ $category_slug[$category->parent_id] }}/{{ $category_slug[$category->id] }}">
                                {{$category->title}}
                            </a>
                            @endif

                            <br />

                            @endforeach

                        </div>
                    </div>

                    @if ($settings['enable_user_ratings'] == '1')

                    <div class="row mt-3">
                        <div class="col-md-3 my-auto"><b>@lang('general.rate_the_link')</b></div>
                        <div class="col-md-9 mt-1 mt-md-0">
                            <span class="vote_info"></span>
                            <div class="ratings" id="rating" data-rating-id="{{$link_query->id}}">
                                @for ($i = 1; $i <= 5; $i++) @if($i<=round($link_query->votes))
                                    <input type="radio" name="vote" class="rating" value="{{$i}}" checked="checked" />
                                    @else
                                    <input type="radio" name="vote" class="rating" value="{{$i}}" />
                                    @endif
                                    @endfor
                            </div>
                        </div>
                    </div>

                    @endif

                    @if (isset($link_query->tags))
                    @if (count($link_query->tags) > 0)
                    <div class="row mt-3">
                        <div class="col-md-3 my-auto"><b>Tags</b></div>
                        <div class="col-md-9 tags">

                            <ul>
                                @foreach ($link_query->tags as $tag)
                                <li><a href="{{ asset($language_prefix.$settings['tag_base']) }}/{{ $tag['slug'] }}" class="mt-md-0 mt-2">{{ $tag['name'] }}</a></li>
                                @endforeach
                            </ul>

                        </div>
                    </div>
                    @endif
                    @endif

                    @if ($link_query->hidden_content != null)
                    <div class="row mt-3">
                        <div class="col-md-3 my-auto"><b>@lang('general.hidden_content')</b></div>
                        <div class="col-md-9 mt-1 mt-md-0">
                            @auth
                            <div class="hidden-content-area">
                                {!! Purifier::clean($link_query->hidden_content, 'youtube') !!}
                            </div>
                            @else
                            <div class="hidden-content">
                                @lang('general.hidden_content_message', ['register_link' => asset($language_prefix.'member-area/register'), 'login_link' => asset($language_prefix.'member-area/login')])
                            </div>
                            @endauth
                        </div>
                    </div>
                    @endif

                    @if ($link_query->address != null || count($link_query->locations) > 0)
                    <div class="row mt-3">
                        <div class="col-md-3"><b>@lang('general.address')</b></div>
                        <div class="col-md-9">{{ $link_query->address }}@if ($link_query->address != null && count($link_query->locations) > 0),@endif

                            @foreach ($link_query->locations as $location)

                            @if($location->parent_id == 0)
                            <a class="location" href="{{ asset($language_prefix.$settings['location_base']) }}/{{ $location_slug[$location->id] }}">
                                {{$location->title}}</a>
                            @else
                            <a class="location" href="{{ asset($language_prefix.$settings['location_base']) }}/{{ $location_slug[$location->parent_id] }}/{{ $location_slug[$location->id] }}">
                                {{$location->title}}</a>,
                            <a class="location" href="{{ asset($language_prefix.$settings['location_base']) }}/{{ $location_slug[$location->parent_id] }}">
                                {{$location_name[$location->parent_id]}}
                            </a>
                            @endif

                            @endforeach

                            @if ($link_query->address != null)
                            @foreach ($link_query->locations as $location)
                            <a href="https://maps.google.com/maps?daddr={{ $link_query->address }}@if (count($link_query->locations) > 0),@endif @if($location->parent_id == 0){{$location->title}}@else{{$location->title}}, {{$location_name[$location->parent_id]}}@endif" target="_blank" class="badge bg-directions mt-2" data-bs-toggle="tooltip" data-bs-placement="right" title="@lang('general.get_directions')">@lang('general.get_directions')</a>
                            @endforeach
                            @endif

                        </div>
                    </div>
                    @endif

                    @if ($link_query->phone_number != null)
                    <div class="row mt-3">
                        <div class="col-md-3"><b>@lang('general.phone_number')</b></div>
                        <div class="col-md-9"><a href="tel:{{ $data_to_pass['phone_number_callable'] }}" class="phone-number" data-bs-toggle="tooltip" data-bs-placement="right" title="@lang('general.call_now')">{{ $data_to_pass['phone_number_visible'] }}</a>@if ($settings['show_phone_number_country_code'] == '1') ({{ $data_to_pass['phone_country_code'] }})@endif</div>
                    </div>
                    @endif

                    @if ($link_query->email != null)
                    <div class="row mt-3">
                        <div class="col-md-3"><b>@lang('general.email')</b></div>
                        <div class="col-md-9"><a href="mailto:{{ $link_query->email }}" class="email" data-bs-toggle="tooltip" data-bs-placement="right" title="@lang('general.send_email')">{{ $link_query->email }}</a></div>
                    </div>
                    @endif

                    @if ($link_query->map_lat != '' && $link_query->map_lon != '')
                    <div class="row mt-3">
                        <div class="col-md-3"><b>@lang('general.map_view')</b></div>
                        <div class="col-md-9">
                            <div id="popup" class="shadow map-corner">
                                <div id="popup-content"></div>
                            </div>
                            <div id="map" data-title="{{$link_query->title}}" data-lat="{{$link_query->map_lat}}" data-lon="{{$link_query->map_lon}}" data-zoom="{{$link_query->map_zoom}}"></div>
                        </div>
                    </div>
                    @endif

                    @if ($other_contacts['facebook_url']['url'] != null || $other_contacts['twitter_url']['url'] != null || $other_contacts['instagram_url']['url'] != null || $other_contacts['linkedin_url']['url'] != null || $other_contacts['telegram_url']['url'] != null || $other_contacts['whatsapp_number']['number'] != null)
                    <div class="row mt-3">
                        <div class="col-md-3 my-auto"><b>@lang('general.other_contacts')</b></div>
                        <div class="col-md-9 mt-1 mt-md-0 social-media-profiles">
                            @if ($other_contacts['facebook_url']['url'] != null)<a href="{{$other_contacts['facebook_url']['url']}}" target="_blank"><i class="icon-facebook"></i></a>@endif
                            @if ($other_contacts['twitter_url']['url'] != null)<a href="{{$other_contacts['twitter_url']['url']}}" target="_blank"><i class="icon-twitter"></i></a>@endif
                            @if ($other_contacts['instagram_url']['url'] != null)<a href="{{$other_contacts['instagram_url']['url']}}" target="_blank"><i class="icon-instagram"></i></a>@endif
                            @if ($other_contacts['linkedin_url']['url'] != null)<a href="{{$other_contacts['linkedin_url']['url']}}" target="_blank"><i class="icon-linkedin"></i></a>@endif
                            @if ($other_contacts['whatsapp_number']['number'] != null)<a href="https://wa.me/{{$other_contacts['whatsapp_number']['number']}}" target="_blank"><i class="icon-whatsapp"></i></a>@endif
                            @if ($other_contacts['telegram_url']['url'] != null)<a href="{{$other_contacts['telegram_url']['url']}}" target="_blank"><i class="icon-paper-plane"></i></a>@endif
                        </div>
                    </div>
                    @endif

                    @if (!empty($deep_link_data['link_1']['url'] && $deep_link_data['link_1']['title']) || !empty($deep_link_data['link_2']['url'] && $deep_link_data['link_2']['title']) || !empty($deep_link_data['link_3']['url'] && $deep_link_data['link_3']['title']))
                    <div class="row mt-3">
                        <div class="col-md-3 my-auto"><b>@lang('general.more_from_this_site')</b></div>
                        <div class="col-md-9">
                            @foreach($deep_link_data as $title)
                            @if ($title['url'] != null && $title['title'] != null)
                            <a href="{{$title['url']}}" target="_blank" class="site-url" {!! $link_types[$title['type']] !!}>{{$title['title']}}</a>
                            @endif
                            @endforeach
                        </div>
                    </div>
                    @endif

                    @isset($link_query->screenshot)
                    <div class="row mt-3">
                        <div class="col-md-3 my-auto"><b>@lang('general.screenshot')</b></div>
                        <div class="col-md-9 mt-1 mt-md-0"><img src="{{ asset('images/screenshots') }}/{{ $link_query->screenshot }}" class="img-fluid detail-screenshot" alt="{{ $link_query->title }}"></div>
                    </div>
                    @endisset

                    @if ($settings['show_page_views'] == '1')
                    <div class="row mt-3">
                        <div class="col-md-3"><b>@lang('general.page_views')</b></div>
                        <div class="col-md-9">{{$link_query->page_views == '0' ? 1 : $link_query->page_views}}</div>
                    </div>
                    @endif

                    @if ($link_query->bypass_redirect == '0' && $settings['show_clicks'] == '1')
                    <div class="row mt-3">
                        <div class="col-md-3"><b>@lang('general.link_clicks')</b></div>
                        <div class="col-md-9">{{ $link_query->clicks }}</div>
                    </div>
                    @endif

                    @if ($settings['show_qr_code'] == '1')
                    <div class="row mt-3">
                        <div class="col-md-3 my-auto"><b>@lang('general.visit_with_qr_code')</b></div>
                        <div class="col-md-9 mt-1 mt-md-0"><img src="{{ asset(DNS2D::getBarcodePNGPath(url()->current(), 'QRCODE', 5, 5, '255,255,255', $link_query->slug)) }}" class="qr-code"></div>
                    </div>
                    @endif

                    <div class="row mt-3">
                        <div class="col-md-3 my-auto"><b>@lang('general.share')</b></div>
                        <div class="col-md-9 mt-1 mt-md-0">
                            <div class="row social-media m-0">
                                <div class="col-md-1 col facebook"><a onclick="sm_share('https://www.facebook.com/sharer/sharer.php?u={{url()->current()}}','Facebook','600','300');" href="javascript:void(0);"><i class="icon-facebook ml-2"></i></a></div>
                                <div class="col-md-1 col twitter"><a onclick="sm_share('http://twitter.com/share?text={{str_replace("'", "\'", $link_query->title)}}&url={{url()->current()}}','Twitter','600','450');" href="javascript:void(0);"><i class="icon-twitter ml-2"></i></a></div>
                                <div class="col-md-1 col linkedin"><a onclick="sm_share('https://www.linkedin.com/sharing/share-offsite/?url={{url()->current()}}','Linkedin','600','450');" href="javascript:void(0);"><i class="icon-linkedin ml-2"></i></a></div>
                                <div class="col-md-1 col telegram"><a onclick="sm_share('https://t.me/share/url?url={{url()->current()}}&text={{str_replace("'", "\'", $link_query->title)}}','Telegram','600','450');" href="javascript:void(0);"><i class="icon-paper-plane ml-2"></i></a></div>
                                <div class="col-md-1 col whatsapp"><a onclick="sm_share('https://api.whatsapp.com/send?text={{str_replace("'", "\'", $link_query->title)}} {{url()->current()}}','WhatsApp','700','600');" href="javascript:void(0);"><i class="icon-whatsapp ml-2"></i></a></div>
                                <div class="col-md-1 col email"><a href="mailto:?subject={{ $link_query->title }}&amp;body={{url()->current()}}"><i class="icon-envelope ml-2"></i></a></div>
                            </div>
                        </div>
                    </div>

                    @if ($settings['allow_widget_embed'] == '1')
                    <div class="row mt-3">
                        <div class="col-md-3"><b>@lang('general.add_to_your_site')</b><a data-bs-toggle="collapse" href="#show-iframe" role="button" aria-expanded="false" aria-controls="show-iframe" class="widget-preview mb-1 mb-md-0">@lang('general.preview_widget')</a>
                        </div>
                        <div class="col-md-9 mt-1 mt-md-0">
                            <div class="widget-selectable">
                                &lt;iframe src=&quot;{{ asset($language_prefix.'widget/'.$link_query->id.'') }}&quot; frameborder=&quot;0&quot; scrolling=&quot;no&quot; width=&quot;125&quot; height=&quot;125&quot;&gt;&lt;/iframe&gt;
                            </div>
                            <div class="collapse" id="show-iframe">
                                <iframe src="{{ asset($language_prefix.'widget/'.$link_query->id.'') }}" class="mt-3" frameborder="0" scrolling="no" width="125" height="125"></iframe>
                            </div>
                        </div>
                    </div>
                    @endif

                    @if ($settings['enable_report_form'] == '1')
                    <div class="row mt-3">
                        <div class="col-md-3"><b>@lang('general.report')</b></div>
                        <div class="col-md-9 mt-1 mt-md-0"><a href="javascript:void(0);" data-bs-toggle="modal" data-bs-target="#MyModal"><i class="icon-warning"></i> @lang('general.report_a_problem')</a></div>
                    </div>
                    @endif

                    @if ($settings['enable_user_reviews'] == '1')

                    <div class="ratings" id="rating" data-rating-id="1277"></div>

                    <div class="review-title mt-3 pt-3">@lang('general.user_reviews')<a href="#" class="add-comment btn float-end">@lang('general.add_comment_review')</a>
                        <div class="stars">
                            @for ($i = 1; $i <= 5; $i++) @if($i<=round($link_query->votes))
                                <span class="icon-star checked"></span>
                                @else
                                <span class="icon-star"></span>
                                @endif
                                @endfor
                        </div>
                    </div>

                    <div class="mt-2">@lang('general.based_on', ['total_votes' => $link_query->total_votes, 'total_reviews' => $data_to_pass['total_reviews']])</div>

                    <div class="user-ratings p-0 container mt-3">

                        @foreach ($comment_order as $rating => $total_rating )

                        @php $data_to_pass['total_reviews'] ? $bar_length=(100/$data_to_pass['total_reviews'])*$total_rating : $bar_length='0'; @endphp

                        <div class="row">
                            <div class="d-flex">
                                <div class="rating">{{ trans_choice('general.star', $rating) }}</div>
                                <div class="col mx-md-4 mx-3">
                                    <div class="progress" data-bar-width="{{$bar_length}}">
                                        <div class="progress-bar"></div>
                                    </div>
                                </div>
                                <div class="votes w-25px">{{$total_rating}}</div>
                            </div>
                        </div>

                        @endforeach

                    </div>

                    <div class="user-reviews">

                        @if ($link_reviews->isEmpty())
                        <div class="alert alert-warning show mt-1 mb-0" role="alert">@lang('general.no_reviews_yet')</div>
                        @endif

                        @foreach ($link_reviews as $comment)

                        <div class="review mt-2">
                            <p class="title">"{{{$comment->title}}}"</p>
                            <div class="row">
                                <div class="col-6">
                                    <p class="name">{{{$comment->name}}}</p>
                                </div>
                                <div class="col-6">
                                    <div class="stars float-end">
                                        @for ($i = 1; $i <= 5; $i++) @if($i<=round($comment->rating))
                                            <span class="icon-star checked"></span>
                                            @else
                                            <span class="icon-star"></span>
                                            @endif
                                            @endfor
                                    </div>
                                </div>
                            </div>
                            <p class="date" data-bs-toggle="tooltip" data-bs-placement="right" title="{{\Carbon\Carbon::parse($comment->created_at)->translatedFormat('F d, Y H:i:s')}}">
                                {{ \Carbon\Carbon::parse($comment->created_at)->diffForHumans() }}</p>

                            <p class="comment">{{{$comment->comment}}}</p>
                        </div>

                        @endforeach

                        @if (count($link_reviews) > '3')
                        <div class="rm-link show-more">@lang('general.show_more')</div>
                        @endif

                        <div class="comment-box" id="comment-section" data-fill-all-fields="@lang('general.fill_all_fields')">

                            <form id="comment-form">

                                <div class="review-title mt-3 mb-2" id="review-title" data-show-more="@lang('general.show_more')" data-show-less="@lang('general.show_less')">
                                    @lang('general.add_comment_review')</div>

                                <input type="hidden" name="content_id" value="{{$link_query->id}}" />
                                <input type="hidden" name="type" value="1" />

                                <div class="mb-3">
                                    <label for="name">@lang('general.your_name'): <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control mt-2" id="name" name="name" required>
                                </div>

                                <div class="mb-3">
                                    <label for="title">@lang('general.comment_title'): <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control mt-2" id="title" name="title" required>
                                </div>

                                <div class="mb-3">
                                    <label for="email">@lang('general.your_email'): <span class="text-danger">*</span></label>
                                    <input type="email" class="form-control mt-2" id="email" name="email" required>
                                    <small id="emailHelp" class="form-text text-muted">@lang('general.email_notification')</small>
                                </div>

                                <div class="mb-3">
                                    <label for="comment">@lang('general.your_comment'): <span class="text-danger">*</span></label>
                                    <textarea class="form-control mt-2" rows="5" id="comment" name="comment" maxlength="1000" required></textarea>
                                </div>

                                <div class="mb-3">
                                    <label for="rating">@lang('general.your_rating'): <span class="text-danger">*</span></label>
                                    <div class="user_ratings mt-1">
                                        <input type="radio" id="user_rating" name="user_rating" value="1">
                                        <input type="radio" id="user_rating" name="user_rating" value="2">
                                        <input type="radio" id="user_rating" name="user_rating" value="3">
                                        <input type="radio" id="user_rating" name="user_rating" value="4">
                                        <input type="radio" id="user_rating" name="user_rating" value="5" checked>
                                    </div>
                                    <div class="clearfix"></div>
                                </div>

                            </form>

                            <button type="submit" class="btn mt-2 comment-button" onclick="form_control()">@lang('general.submit')</button>

                            <div id="comment_result">
                                <div class="alert alert-warning show mt-3 mb-0" role="alert">
                                    @lang('general.comment_rules')</div>
                            </div>

                        </div>

                    </div>

                    @endif

                </div>

            </div>

            @if(!empty($ad[3]))<div class="mb-3 text-center">{!! $ad[3] !!}</div>@endif

        </div>
        <!-- /Grid Column -->

        <!-- Grid Column -->
        <div class="col-md-3 text-center mb-3">
            @if ($settings['sticky_ads_right_column'] == '1')<div class="sticky-top sticky-top-15">@endif
                @if(!empty($ad[5]))<div class="mb-3">{!! $ad[5] !!}</div>@endif
                @if ($settings['sticky_ads_right_column'] == '1')</div>@endif
        </div>
        <!-- /Grid Column -->

    </div>
    <!-- /Grid Row -->

</main>
<!-- /Container -->

@if ($settings['enable_report_form'] == '1')

<!-- Report Form -->

<div class="modal align-middle" id="MyModal">

    <div class="modal-dialog modal-dialog-centered">

        <div class="modal-content">

            <div class="modal-header">
                <h5 class="modal-title">@lang('general.report_a_problem')</h5>
                <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                    <i class="icon-close"></i>
                </button>
            </div>

            <div class="modal-body submission-box pt-1 pb-1" id="report-submission-section" data-error="@lang('general.error')" data-recaptcha-error="@lang('general.recaptcha_error')">

                <form id="report-submission-form">

                    <div class="mt-3">
                        <input type="text" class="form-control" id="name" name="name" placeholder="@lang('general.name')" required>
                    </div>

                    <div class="mt-3">
                        <input type="email" class="form-control" id="email" name="email" placeholder="@lang('general.email')" required>
                    </div>

                    <div class="mt-3">
                        <select title="@lang('general.select_a_reason')" id="reason" name="reason" class="form-select">
                            <option selected="selected" disabled="disabled">@lang('general.select_a_reason')</option>
                            @foreach($report_reasons as $reason)
                            <option value="{{$reason}}">{{$reason}}</option>
                            @endforeach
                        </select>
                    </div>

                    @if ($settings['enable_google_recaptcha'] == '1')
                    <div class="g-recaptcha mt-3" data-sitekey="{{ $settings['google_recaptcha_site_key'] }}"></div>
                    @endif

                    <div id="report-submission-result" class="mb-3"></div>

                    <div class="modal-footer pt-0 pe-0">
                        <button type="button" class="btn submit-button m-0 mt-1" onclick="report_submission_form()">@lang('general.submit')</button>
                    </div>

                </form>

            </div>

        </div>

    </div>

</div>

<!-- /Report Form -->

@endif

@endsection
