@extends('frontend::page')

@section('content')

<!-- Container -->
<main class="container links mt-3">

    <!-- Grid Row -->
    <div class="row">

        <!-- Grid Column -->
        <div class="col-md-9">

            @if(!empty($ad[4]))<div class="mb-3 text-center">{!! $ad[4] !!}</div>@endif

            <!-- Search Box -->
            @include('frontend::inc.partials', ['type' => '1'])
            <!-- /Search Box -->

            @if ($settings['breadcrumbs'] == '1')
            <div class="d-flex">
                <!-- Breadcrumbs -->
                <div class="breadcrumbs mb-3">
                    <a href="{{ asset($language_prefix) }}">@lang('general.homepage')</a> <span class="sep">›</span> @if ($category_query->parent_id != 0) <a href="{{ asset($language_prefix.$settings['location_base']) }}/{{ $data_to_pass['parent_category_slug'] }}">{{ $data_to_pass['parent_category_name'] }}</a> <span class="sep">›</span> @endif <a href="{{url()->current()}}">{{ $data_to_pass['category_name'] }}</a>
                </div>
            </div>

            @if ($settings['schema_breadcrumbs'] == '1')
            {!! $breadcrumb_schema_data->toScript() !!}
            @endif
            <!-- /Breadcrumbs -->
            @endif

            @if($sub_categories->isNotEmpty())
            <!-- Subcategories -->
            <div class="col-12 mb-3">
                <div class="sub-categories">
                    <div class="row pb-2">
                        <span class="section-title mb-2 pt-2">@lang('general.cities')</span>
                        @foreach($sub_categories as $submenu)
                        <div class="col-md-4 col-6 pb-1">
                            <a href="{{ asset($language_prefix.$settings['location_base']) }}/{{ $category_query->slug }}/{{ $submenu->slug }}"><i class="icon-chevron-right"></i> {{ $submenu->title }}@if ($settings['sub_count_category'] == '1') ({{ $submenu->item_count }})@endif</a>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
            <!-- /Subcategories -->
            @endif

            @if($links->isEmpty())
            <div class="col-12">
                <h6 class="alert alert-warning">@lang('general.no_record_found')</h6>
            </div>
            @endif

            <div class="infinite-scroll" id="infinite-scroll">

                <!-- Links -->
                @foreach ($links as $key => $link)

                @if(empty($link->image))
                @php $link->image='no_image.png'; @endphp
                @endif

                <div class="other-links col-12 mb-3">
                    <div class="shadow-sm p-2 bg-white rounded">
                        <div class="row p-1">
                            <a href="@if ($link->bypass_details == '0'){{ asset($language_prefix.$settings['detail_base']) }}/{{ $link->slug }}@else{{ $link->url }}@endif" @if ($link->bypass_details == '1') target="_blank"{!! $link_types[$link->bypass_details_type] !!}@endif>
                                <div class="d-flex">
                                    <div class="me-2">
                                        @if($settings['infinite_scroll'] == '1' && $links->currentPage() != 1 )
                                        <img src="{{ asset('images/links') }}/{{ $link->image }}" class="site-icon rounded" alt="{{ $link->title }}">
                                        @else
                                        <img src="{{ asset('images/pixel.png') }}" data-src="{{ asset('images/links') }}/{{ $link->image }}" class="site-icon rounded lazy" alt="{{ $link->title }}">
                                        <noscript>
                                            <img src="{{ asset('images/links') }}/{{ $link->image }}" class="site-icon rounded" alt="{{ $link->title }}" />
                                        </noscript>
                                        @endif
                                    </div>
                                    <div class="ps-1 my-md-0 my-auto">
                                        <span class="link-title">{{ $link->title }}</span>@if($link->badge == '1') <i class="icon-check-circle title-badge" data-bs-toggle="tooltip" data-bs-placement="top" title="@lang('general.badge_title')"></i>@endif{{''}}@if($link->featured_category == '1' && $settings['show_featured_text'] == '1')<span class="featured">@lang('general.featured')</span>@endif
                                        <div>
                                            {!!stars($link->votes, 2, 1)!!}
                                        </div>
                                        <p class="description m-0">{{{ $link->description }}}</p>
                                        <span class="site-url">
                                            @if(empty($link->visible_url))
                                            {{ $link->url }}
                                            @else
                                            {{ $link->visible_url }}
                                            @endif
                                        </span>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>

                @endforeach
                <!-- /Links -->

            </div>

            @if($settings['infinite_scroll'] == '0' )
            @if ($links->hasPages())
            <!-- Pagination -->
            <div class="d-flex mt-3">
                <div class="mx-auto">
                    {{ $links->onEachSide(1)->links() }}
                </div>
            </div>
            <!-- /Pagination -->
            @endif
            @endif

            @if($category_query->custom_content != null )
            <div class="shadow-sm p-2 bg-white custom-content rounded mb-3">
                <div class="mx-1">
                    {!! $category_query->custom_content !!}
                </div>
            </div>
            @endif

            @if($settings['infinite_scroll'] == '1' )
            @if($links->currentPage() != $links->lastPage() )

            <!-- Loading -->
            <div class="container text-center">
                <div class="page-load-status">
                    <div class="infinite-scroll-request loader-ellips mb-3">
                        @lang('general.loading')
                    </div>
                </div>
            </div>
            <!-- /Loading -->

            <!-- Pagination -->
            <p class="pagination-next">
                <a class="pagination__next" href="{{$links->nextPageUrl()}}">Next Page</a>
            </p>
            <!-- /Pagination -->

            @endif
            @endif

            @if(!empty($ad[3]))<div class="mb-3 text-center">{!! $ad[3] !!}</div>@endif

        </div>
        <!-- /Grid Column -->

        <!-- Grid Column -->
        <div class="col-md-3 text-center mb-3">
            @if ($settings['sticky_ads_right_column'] == '1')<div class="sticky-top sticky-top-15">@endif
                @if(!empty($ad[5]))<div class="mb-3">{!! $ad[5] !!}</div>@endif
                @if ($settings['sticky_ads_right_column'] == '1')</div>@endif
        </div>
        <!-- /Grid Column -->

    </div>
    <!-- /Grid Row -->

</main>
<!-- /Container -->

@endsection