@extends('rtl-frontend::page')

@section('content')

<!-- Container -->
<main class="container">

    <!-- Grid Row -->
    <div class="row member-area mt-3">

        <div class="col-md-3 menu">

            <div class="bg-white shadow-sm rounded p-2 pb-0">
                <!-- Left Column -->
                @include('rtl-frontend::inc.partials', ['type' => '3'])
                <!-- /Left Column -->
            </div>

        </div>

        <div class="col-md-9 mb-3">

            @if($links->isEmpty())
            <h6 class="alert alert-warning">@lang('general.no_links_yet')</h6>
            @else

            <div class="bg-white shadow-sm rounded px-2">

                <div class="table-responsive">
                    <table class="table align-middle mb-0">
                        <thead>
                            <tr>
                                <th class="col-1">@lang('general.id')</th>
                                <th class="col-3">@lang('general.url')</th>
                                <th class="col-3">@lang('general.expire_date')</th>
                                <th class="col-1">@lang('general.subscription')</th>
                                <th class="col-1">@lang('general.duration')</th>
                                <th class="col-1">@lang('general.renew')</th>
                                <th class="col-1">@lang('general.status')</th>
                                <th class="col-1">@lang('general.details')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($links as $link)
                            <tr>
                                <th>#{{ $link->id }}</th>
                                <td><a href="{{ $link->url }}" target="_blank">{{ $link->url }}</a></td>
                                <td>{{$link->expire_at == null ? __('general.never') : \Carbon\Carbon::parse($link->expire_at)->translatedFormat('F d, Y H:i')}}</td>
                                <td>@if($link->is_subscription == '1') @lang('general.yes') @else - @endif</td>
                                <td>{{$durations[$link->duration]}}</td>
                                <td>@if(($link->status=='2' || $link->status=='4' || $link->status=='5') && $link->expire_at != null && $link->price != '0.00' && $link->is_subscription == '0' && $link->duration != '0') <a href="{{ URL::to($language_prefix.'member-area/renew-package/'.$link->id.'') }}"><span class="badge renew">Renew</span></a> @else - @endif</td>
                                <td>
                                    @if($link->status=='2')
                                    <span class="badge approved">@lang('general.approved')</span>
                                    @endif

                                    @if($link->status=='3')
                                    <span class="badge rejected">@lang('general.rejected')</span>
                                    @endif

                                    @if($link->status=='4')
                                    <span class="badge grace-period">@lang('general.grace_period')</span>
                                    @endif

                                    @if($link->status=='5')
                                    <span class="badge expired">@lang('general.expired')</span>
                                    @endif
                                </td>
                                <td><a href="{{ URL::to($language_prefix.'member-area/edit/'.$link->id.'') }}" class="btn btn-sm view-btn">@if($settings['allow_user_updates'] == '1')@lang('general.edit')@else @lang('general.view')@endif</a></td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>

                    <!-- Pagination -->
                    <div class="d-flex">
                        <div class="mx-auto">
                            {{ $links->onEachSide(1)->links() }}
                        </div>
                    </div>
                    <!-- /Pagination -->

                </div>

            </div>

            @endif

        </div>

    </div>
    <!-- /Grid row -->

</main>
<!-- /Container -->

@endsection