@extends('rtl-frontend::page')

@section('content')

@foreach ($packages as $package)
@php $package_name[$package->id]=$package->title; @endphp
@endforeach
@foreach ($payment_methods as $method)
@php $payment_method[$method->id]=$method->title; @endphp
@endforeach
@foreach ($categories as $category)
@php $category_name[$category->id]=$category->title; @endphp
@endforeach

<!-- Container -->
<main class="container">

    <!-- Grid Row -->
    <div class="row member-area mt-3">

        <div class="col-md-3 menu">

            <div class="bg-white shadow-sm rounded p-2 pb-0">
                <!-- Left Column -->
                @include('rtl-frontend::inc.partials', ['type' => '3'])
                <!-- /Left Column -->
            </div>

        </div>

        <div class="col-md-9 mb-3">

            <!-- Modal -->
            <div class="modal fade" id="exampleModalLong" tabindex="-1" role="dialog" aria-labelledby="exampleModalLongTitle" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLongTitle">@lang('general.bank_accounts')</h5>
                            <button type="button" class="close" data-bs-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body py-0">

                            @foreach($banks as $bank)
                            <div class="alert alert-warning pb-0 mb-3">
                                <b>{{$bank->bank_name}}</b>
                                {!! Purifier::clean($bank->details, 'titles') !!}
                            </div>
                            @endforeach

                        </div>

                    </div>
                </div>
            </div>

            <div class="bg-white shadow-sm rounded p-2">

                @if($order_query->payment_status == '1')

                <div class="alert alert-success m-1 pb-0">
                    <p>@lang('general.payment_notification_received')</p>
                </div>

                @else

                <div class="m-1 mb-3">

                    @if(count($errors) > 0)
                    <div class="alert alert-danger pb-0" role="alert">
                        @foreach($errors->all() as $error)
                        <p><b>@lang('general.error'):</b> {{$error}}</p>
                        @endforeach
                    </div>
                    @endif

                    <div class="alert alert-success mb-0">
                        @lang('general.amount_to_be_paid', ['amount' => $order_query->currency_symbol.$order_query->price])<br />
                        @lang('general.reference_code'): <b>{{$order_query->bank_reference_code}}</b>
                        <br />
                        <small class="text-dark">@lang('general.bank_transfer_notice')</small>

                        <a href="#" role="button" class="d-block mt-3" data-bs-toggle="modal" data-bs-target="#exampleModalLong">
                            <small class="fw-bold">@lang('general.list_of_bank_accounts')</small>
                        </a>
                    </div>

                </div>

                <div class="p-1 mt-1">
                    <h6 class="fw-bold submission-head-title">@lang('general.bank_payment_notification')</h6>
                </div>

                <div class="p-1">

                    <form method="POST" action="{{ asset($language_prefix.'member-area/payment-notification/'.$order_query->id.'') }}">
                        @csrf

                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.sender_name') <span class="text-danger">*</span></label>
                            <input type="text" name="sender_name" class="form-control" value="{{ old('sender_name') }}">
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.bank_account') <span class="text-danger">*</span></label>
                            <select title="@lang('general.bank_account')" name="bank_account" class="form-select">
                                @foreach($banks as $bank)
                                <option value="{{ $bank->id }}" {{ old('bank_account') == $bank->id ? 'selected' : '' }}>{{ $bank->bank_name }}
                                </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.additional_details')</label>
                            <textarea class="form-control" name="additional_details" rows="3">{{ old('additional_details') }}</textarea>
                        </div>

                        <button class="btn update-btn" type="submit">@lang('general.submit')</button>

                    </form>

                </div>

                @endif

            </div>

        </div>

    </div>
    <!-- /Grid row -->

</main>
<!-- /Container -->

@endsection