// Delete Prompt
$(document).ready(function() {
  "use strict";

  $("._delete_data").on('click', function(e) {
    var data_id = $(this).attr("data-id");
    var delete_data = document.getElementById("table");
    var delete_message = delete_data.getAttribute("data-delete-prompt");
    var delete_yes = delete_data.getAttribute("data-yes");
    var delete_cancel = delete_data.getAttribute("data-cancel");

    Swal.fire({
      title: delete_message,
      type: "error",
      showCancelButton: true,
      confirmButtonText: delete_yes,
      cancelButtonText: delete_cancel
    }).then(result => {
      if (result.value) {
        $(document)
          .find("#delete_from_" + data_id)
          .submit();
      }
    });
  });
});

// Submission Delete Prompt
$(document).ready(function() {
  "use strict";

  $("._submission_delete_data").on('click', function(e) {
    var data_id = $(this).attr("data-id");
    var delete_data = document.getElementById("submission-actions");
    var delete_message = delete_data.getAttribute("data-delete-prompt");
    var delete_yes = delete_data.getAttribute("data-yes");
    var delete_cancel = delete_data.getAttribute("data-cancel");
    var delete_reason = delete_data.getAttribute("data-reason");

    Swal.fire({
      title: delete_message,
      type: "error",
      input: 'text',
      inputPlaceholder: delete_reason,
      showCancelButton: true,
      inputValidator: (value) => {
        if (!value) {
          return delete_reason
        }
      },
      confirmButtonText: delete_yes,
      cancelButtonText: delete_cancel,
    }).then(result => {
      if (result.value) {
        $("#submission_delete_from_" + data_id).append('<input type="hidden" name="reason" value="'+result.value+'" />')
        $(document)
          .find("#submission_delete_from_" + data_id)
          .submit();
      }
    });
  });
});

// Comment Approval/Delete Prompt - Approved
$(document).ready(function() {
  "use strict";

  $('.show_comment_approved').click(function(e) {
      event.preventDefault()

      var data_id = $(this).attr('data-id');
      var url = this.href;
      var comment_details = $(this).data("comment-details");
      var comment_title = $(this).data("comment-title");
      var delete_data = document.getElementById('table');
      var mark_unapproved = delete_data.getAttribute('data-mark-unapproved');
      var delete_cancel = delete_data.getAttribute('data-cancel');

      Swal.fire({
          title: comment_title,
          text: comment_details,
          type: 'warning',
          showCancelButton: true,
          confirmButtonText: mark_unapproved,
          cancelButtonText: delete_cancel,
      }).then((result) => {
          if (result.value) {
              window.location = url + '?approve=0';
          }
      })
  });
});

// Comment Approval/Delete Prompt - Not Approved
$(document).ready(function() {
  "use strict";

  $('.show_comment_not_approved').click(function(e) {
      event.preventDefault()

      var data_id = $(this).attr('data-id');
      var url = this.href;
      var comment_details = $(this).data("comment-details");
      var comment_title = $(this).data("comment-title");
      var delete_data = document.getElementById('table');
      var delete_cancel = delete_data.getAttribute('data-cancel');
      var approve = delete_data.getAttribute('data-approve');

      Swal.fire({
          title: "" + comment_title + "",
          text: "" + comment_details + "",
          type: 'warning',
          showCancelButton: true,
          confirmButtonText: approve,
          cancelButtonText: delete_cancel
      }).then((result) => {
          if (result.value) {
              window.location = url + '?approve=1';
          }
      })
  });
});

// Version Check
$(document).ready(function() {
  "use strict";

  $(".v_control").on('click', function(e) {
    var version_data = document.getElementById("v_control");
    var version_control = version_data.getAttribute("data-version-control");
    var version_info = version_data.getAttribute("data-version-info");
    var latest_version = version_data.getAttribute("data-latest-version");
    var version_control_fail = version_data.getAttribute(
      "data-version-control-fail"
    );

    const ipAPI = "https://www.foxart.co/version/link-directory-pro.json.php";

    Swal.queue([
      {
        title: version_control,
        confirmButtonText: latest_version,
        text: version_info,
        showLoaderOnConfirm: true,
        preConfirm: () => {
          return fetch(ipAPI)
            .then(response => response.json())
            .then(data => Swal.insertQueueStep(data.version))
            .catch(() => {
              Swal.insertQueueStep({
                icon: "error",
                title: version_control_fail
              });
            });
        }
      }
    ]);
  });
});

// Enable/Disable Form Elements Based on Redirection Bypass Status
$(function() {
  "use strict";

  if ($("#bypass_redirect").prop("checked")) {
    $("#bypass_type").prop("disabled", false);
    $("#bypass_type").selectpicker("refresh");
  } else {
    $("#bypass_type").prop("disabled", true);
    $("#bypass_type").selectpicker("refresh");
  }

  $(document).on("ifChanged", "#bypass_redirect", function() {
    if ($(this).prop("checked")) {
      $("#bypass_type").prop("disabled", false);
      $("#bypass_type").selectpicker("refresh");
    } else {
      $("#bypass_type").prop("disabled", true);
      $("#bypass_type").selectpicker("refresh");
    }
  });
});


// Enable/Disable Form Elements Based on Detail Page Bypass Status
$(function() {
  "use strict";

  if ($("#bypass_details").prop("checked")) {
    $("#bypass_details_type").prop("disabled", false);
    $("#bypass_details_type").selectpicker("refresh");
  } else {
    $("#bypass_details_type").prop("disabled", true);
    $("#bypass_details_type").selectpicker("refresh");
  }

  $(document).on("ifChanged", "#bypass_details", function() {
    if ($(this).prop("checked")) {
      $("#bypass_details_type").prop("disabled", false);
      $("#bypass_details_type").selectpicker("refresh");
    } else {
      $("#bypass_details_type").prop("disabled", true);
      $("#bypass_details_type").selectpicker("refresh");
    }
  });
});

// Retrieve Link Details
function get_details() {
  "use strict";

    var url = document.getElementById("url").value;
    var base_url = $('base').attr('href');
    var get_url= base_url + "?url=" + url;
  
  if (url == "") {
    Swal.fire("Error", "Please enter a URL", "warning");
  } else {
    $.ajax({
      url: get_url,
      async: true,
      success: function(response) {
        var response_data = JSON.parse(response);
        $("#title").val(response_data[0]["title"]);
        $("#description").val(response_data[1]["description"]);
      },
      error: function() {
        Swal.fire("Error", "Couldn't Retrieve Details", "warning");
      }
    });
  }
}

// Sort Items
$(function() {
  "use strict";

  var base_url = $('base').attr('href') + '/';

  $(".sortable-posts").sortable({
    stop: function() {
      var sort_type = $(this).attr("id");
      $.map($(this).find("tr"), function(el) {
        var id = el.id;
        var sort = $(el).index();
        var sort_url = ""+ base_url + sort_type + "";
        $.ajax({
          url: sort_url,
          type: "GET",
          data: {
            id: id,
            sort: sort
          },
          success: function(response) {
            if (response.status == "success") {
              console.log(response);
            } else {
              console.log(response);
            }
          }
        });
        $(".sortable-posts").disableSelection();
      });
    }
  });
});

// Summernote - Text Editor
$(function() {
  "use strict";

  $(".textarea").summernote({ height: 250 });

  $('.textarea-style').on('summernote.change.codeview', function(we, contents, $editable) {
    $('.textarea-style').val(contents);
  });
});

// Checkbox Style
$(document).ready(function() {
  "use strict";

  $("input").iCheck({
    checkboxClass: "icheckbox_square-purple"
  });
});

// Change Button Color If an Image Has Been Selected
$(document).ready(function(){
  "use strict";

  $("#browse-color-image").change(function(){
      this.classList.add('sel');
  });
});

// Change Button Color If an Screenshot Has Been Selected
$(document).ready(function(){
  "use strict";

  $("#browse-color-screenshot").change(function(){
      this.classList.add('sel');
  });
});

// Color Picker
$(function () {
  $('.my-colorpicker').colorpicker()
});

// Ekko Lightbox
$(function() {
  "use strict";

  $(document).on("click", '[data-toggle="lightbox"]', function(event) {
    event.preventDefault();
    $(this).ekkoLightbox({
      alwaysShowClose: false
    });
  });
});

// Remove screenshots
$(document).ready(function() {
    "use strict";

    $(".remove_gallery").click(function(){
        var screenshots_data = document.getElementById('gallery');
        var content_deleted = screenshots_data.getAttribute('data-content-deleted');
        var succesfully_deleted = screenshots_data.getAttribute('data-succesfully-deleted');

        $(this).closest(".col-md-2").fadeOut('300');
        var image_name=$(this).data("name");
        var link_id=$(this).data("link-id");
          $.ajax({
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            url: "/admin/multiple-file-upload/delete",
            type: "POST",
            data:{"image_name":image_name,"link_id":link_id}
          }).done(function(data) {
            Swal.fire(
                content_deleted,
                succesfully_deleted,
                'success'
              )
              });
    }); 
});

// Remove screenshots
function bindFunc(){
    "use strict";

    $(".remove_gallery").click(function(){
        var screenshots_data = document.getElementById('gallery');
        var content_deleted = screenshots_data.getAttribute('data-content-deleted');
        var succesfully_deleted = screenshots_data.getAttribute('data-succesfully-deleted');

        $(this).closest(".col-md-2").fadeOut('300');
        var image_name=$(this).data("name");
        var link_id=$(this).data("link-id");
        $.ajax({
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            url: "/admin/multiple-file-upload/delete",
            type: "POST",
            data:{"image_name":image_name,"link_id":link_id}
          }).done(function(data) {
            Swal.fire(
                content_deleted,
                succesfully_deleted,
                'success'
              )
          });
    }); 
}
  
// Upload screenshots
$(document).ready(function() {
    "use strict";
    
    $('#gallery_form').ajaxForm({
        beforeSend: function() {
            $('.progress-bar').text('0%');
            $('.progress-bar').css('width', '0%');
        },
        uploadProgress: function(event, position, total, percentComplete) {
            $('.progress-bar').text(percentComplete + '0%');
            $('.progress-bar').css('width', percentComplete + '0%');
        },
        success: function(data) {
            if (data.success) {
                $('#success').html('<div class="text-success text-center"><b>' + data.success +
                    '</b></div><br />');
                $('#success').append(data.image);
                $('.progress-bar').text('Uploaded');
                $('.progress-bar').css('width', '100%');
                bindFunc()

            } else {}
        }
    });
});