<?php
namespace App\Http\Controllers;

use App;
use App\Models\Notification;
use App\Models\Translation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\View;
use Intervention\Image\ImageManagerStatic as Image;

class NotificationsController extends Controller
{

    public function __construct()
    {
        $this->middleware('auth');

        // Site Settings
        $site_settings = DB::table('settings')->get();

        foreach ($site_settings as $setting) {
            $setting_name = $setting->name;
            $this->$setting_name = $setting->value;
            $settings[$setting->name] = $setting->value;
        }
        
        // List of languages
        $translations = Translation::orderBy('id', 'ASC')->get();
         
        foreach ($translations as $language) {
            $language_id[$language->code] = $language->id;
            if ( $settings['root_language'] == '1' && $language->code == $settings['site_language'] ) {
            $language_prefix[$language->id] = '/';
            } else {
            $language_prefix[$language->id] = $language->code.'/';
            }
        }
        
        $site_language_id=$language_id[$settings['site_language']];
        
        // Pass data to views
        View::share(['settings' => $settings, 'translations' => $translations, 'site_language_id' => $site_language_id, 'language_prefix' => $language_prefix]);
    }
    
    /** Index */
    public function index()
    {
        // Mark all notifications as read
        DB::table('notifications')->update(['notification_read' => '1']);
        
         // List of Notifications
        $notifications_list = DB::table('notifications')->orderBy('id', 'DESC')->paginate(15);
        
        // Return view
        return view('adminlte::notifications.index')->with('notifications_list', $notifications_list);
    }


}
