<?php
namespace App\Http\Controllers;

use App;
use App\Models\Page;
use App\Models\Translation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\View;
use Redirect;

class PageController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');

        // Site Settings
        $site_settings = DB::table('settings')->get();

        foreach ($site_settings as $setting) {
            $setting_name = $setting->name;
            $this->$setting_name = $setting->value;
            if ($setting->language == null) {
                $settings[$setting->name] = $setting->value;
            } else {
                $settings[$setting->name . '-' . $setting->language] = $setting->value;
            }
        }
        
        // List of languages
        $translations = Translation::orderBy('id', 'ASC')->get();
        
        foreach ($translations as $language) {
            $language_id[$language->code] = $language->id;
            $language_code[$language->id]=$language->icon;
            if ( $settings['root_language'] == '1' && $language->code == $settings['site_language'] ) {
            $language_prefix[$language->id] = '/';
            } else {
            $language_prefix[$language->id] = $language->code.'/';
            }            
        }
        
        $site_language_id=$language_id[$settings['site_language']];

        // Array Data
        $array_data = array(
            'language_code' => $language_code,
            'site_language_id' => $language_id[$settings['site_language']],
            'language_prefix' => $language_prefix,
        );

        // Pass data to views
        View::share(['settings' => $settings, 'translations' => $translations, 'array_data' => $array_data]);
    }

    /** Index */
    public function index(Request $request)
    {
        if ($request->has('sort')) {
            // List of pages
            $posts = Page::orderBy('sort', 'ASC')->get();

            $id = $request->input('id');
            $sorting = $request->input('sort');

            // Update sort order
            foreach ($posts as $item) {
                Page::where('id', '=', $id)->update(array(
                    'sort' => $sorting,
                ));
            }
            return \Response::json('success', 200);
        }

        // Return view
        return view('adminlte::pages.index')->with('language_menu', '1');
    }
    
     /** Page List */
    public function page_list(Request $request)
    {
        $id = request()->id;

        // List of pages
        $pages = Page::orderBy('sort', 'ASC')->where('language', $id)->get();

        // Return view
        return view('adminlte::pages.index')->with('pages', $pages)->with('language_menu', '0');
    }

    /** Create */
    public function create()
    {
        // Return view
        return view('adminlte::pages.create');
    }

    /** Store */
    public function store(Request $request)
    {
        // Check if slug exists
        $slug_check = Page::where('slug', $request->get('slug'))->first();

        // Return error message if slug is in use
        if ($slug_check != null) {
            return Redirect::back()->withErrors(__('admin.slug_in_use'));
        }

        $this->validate($request, [
            'title' => 'required|max:255',
            'details' => 'required',
            'custom_title' => 'nullable|max:255',
            'custom_description' => 'nullable|max:255',
        ]);

        $page = new Page;
        $page->slug = $request->get('slug');
        $page->title = $request->get('title');
        $page->custom_title = $request->get('custom_title');
        $page->custom_description = $request->get('custom_description');
        $page->navbar = $request->get('navbar') ? 1 : 0;
        $page->footer = $request->get('footer') ? 1 : 0;
        $page->language = $request->get('language');
        
        $page->details = $request->get('details');

        preg_match_all('/src="(data:image\/[^;]+;base64[^"]+)"/', $page->details, $result, PREG_PATTERN_ORDER);

        $total_images = count($result[0]);

        for ($x = 0; $x <= $total_images-1; $x++) {
                $data = substr($result[0][$x], strpos($result[0][$x], ',') + 1);
                $data = base64_decode($data);
            if ($this->save_as_webp == '1') {
                    $file_name = time() . rand(11111, 99999) . '.webp';
            } else {
                    $file_name = time() . rand(11111, 99999) . '.png';
            }
            \File::put(public_path(). '/images/uploads/' . $file_name, $data);
            $imagefile=asset('images/uploads').'/'.$file_name;
            $page->details = str_replace($result[0][$x], "src=\"$imagefile\" class=\"img-fluid\"", $page->details);
            $page->details = preg_replace('/(\<img[^>]+)(style\=\"[^\"]+\")([^>]+)(>)/', '${1}${3}${4}', $page->details);
        }

        // Retrieve last item in sort order and add +1
        $page->sort = Page::max('sort') + 1;

        $page->save();

        if ($request->get('slug') == null) {
            $page->slug = null;
            $page->update(['title' => $page->title]);
        }

        // Ping Google
        if ($this->ping_google == '1') {
            $sitemap_url = asset('sitemap/pages');
            $ch = curl_init("https://www.google.com/webmasters/tools/ping?sitemap=$sitemap_url");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $result = curl_exec($ch);
            curl_close($ch);
        }

        // Redirect to page edit page
        return redirect()->route('pages.edit', $page->id)->with('success', __('admin.data_added'));
    }

    /** Edit */
    public function edit($id)
    {
        // Retrieve page details
        $page = Page::find($id);

        // Return 404 page if page not found
        if ($page == null) {
            abort(404);
        }

        // Return view
        return view('adminlte::pages.edit', compact('page', 'id'));
    }

    /** Update */
    public function update(Request $request, $id)
    {
        // Check if slug exists
        $slug_check = Page::where('slug', $request->get('slug'))->where('id', '!=', $id)->first();

        // Return error message if slug is in use
        if ($slug_check != null) {
            return Redirect::back()->withErrors(__('admin.slug_in_use'));
        }

        $this->validate($request, [
            'title' => 'required|max:255',
            'details' => 'required',
            'custom_title' => 'nullable|max:255',
            'custom_description' => 'nullable|max:255',
        ]);

        // Retrieve page details
        $page = Page::find($id);
        $page->slug = $request->get('slug');
        $page->title = $request->get('title');
        $page->custom_title = $request->get('custom_title');
        $page->custom_description = $request->get('custom_description');
        $page->navbar = $request->get('navbar') ? 1 : 0;
        $page->footer = $request->get('footer') ? 1 : 0;
        $page->language = $request->get('language');

        $page->details = $request->get('details');

        preg_match_all('/src="(data:image\/[^;]+;base64[^"]+)"/', $page->details, $result, PREG_PATTERN_ORDER);

        $total_images = count($result[0]);

        for ($x = 0; $x <= $total_images-1; $x++) {
                $data = substr($result[0][$x], strpos($result[0][$x], ',') + 1);
                $data = base64_decode($data);
            if ($this->save_as_webp == '1') {
                    $file_name = time() . rand(11111, 99999) . '.webp';
            } else {
                    $file_name = time() . rand(11111, 99999) . '.png';
            }
            \File::put(public_path(). '/images/uploads/' . $file_name, $data);
            $imagefile=asset('images/uploads').'/'.$file_name;
            $page->details = str_replace($result[0][$x], "src=\"$imagefile\" class=\"img-fluid\"", $page->details);
            $page->details = preg_replace('/(\<img[^>]+)(style\=\"[^\"]+\")([^>]+)(>)/', '${1}${3}${4}', $page->details);
        }

        // Ping Google
        if ($page->isDirty() && $this->ping_google == '1') {
            $sitemap_url = asset('sitemap/pages');
            $ch = curl_init("https://www.google.com/webmasters/tools/ping?sitemap=$sitemap_url");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $result = curl_exec($ch);
            curl_close($ch);
        }

        if ($request->get('slug') == null) {
            $page->slug = null;
            $page->update(['title' => $page->title]);
        }

        $page->save();

        // Redirect to page edit page
        return redirect()->route('pages.edit', $page->id)->with('success', __('admin.data_updated'));
    }

    /** Destroy */
    public function destroy($id)
    {
        // Retrieve page details
        $page = Page::find($id);

        $page->delete();

        // Ping Google
        if ($this->ping_google == '1') {
            $sitemap_url = asset('sitemap/pages');
            $ch = curl_init("https://www.google.com/webmasters/tools/ping?sitemap=$sitemap_url");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $result = curl_exec($ch);
            curl_close($ch);
        }

        // Redirect to list of pages
        return redirect()->back()->with('success', __('admin.data_deleted'));
    }

}