<?php

namespace App\Http\Controllers;

use App\Models\Link;
use App\Models\Article;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\View;

class RssController extends Controller
{

    public function __construct()
    {
        // Site Settings
        $site_settings = DB::table('settings')->get();

        foreach ($site_settings as $setting) {
            $this->settings[$setting->name] = $setting->value;
        }
        
        $languages = DB::table('translations')->OrderBy('sort', 'ASC')->get();

        $lang_codes = [];
        foreach ($languages as $language) {
            array_push($lang_codes, $language->code);
            $language_id[$language->code] = $language->id;
            $language_icon[$language->code] = $language->icon;
            $language_code[$language->id] = $language->code;
        }
        
       if ($this->settings['root_language'] == '1') {
            
            if (request()->segment(1) == $this->settings['site_language']) {
                abort(404);
            }

            if (in_array(request()->segment(1), $lang_codes) && request()->segment(1) != $this->settings['site_language']) {
                $this->language_id = $language_id[request()->segment(1)];
                $this->language_code = request()->segment(1);
                $language_icon_code=$language_icon[request()->segment(1)];
            } else {
                $this->language_id = $language_id[$this->settings['site_language']];
                $this->language_code = null;
                $language_icon_code=$language_icon[$this->settings['site_language']];
            }
            
        } else {

            if (!in_array(request()->segment(1), $lang_codes)) {
                abort(404);
            }

            $this->language_code = request()->segment(1);
            $this->language_id = $language_id[$this->language_code];
            
            $language_icon_code=$language_icon[$this->language_code];
        }
        
        $this->language_prefix = $this->language_code . '/';

        // Pass data to views
        View::share(['language_code' => $language_code[$this->language_id]]);

    }

    /** Links */
    public function links()
    {
        // List of latest links
        $links = Link::orderBy('id', 'desc')->where('bypass_details', '0')->where('enabled', '1')->where('language', $this->language_id)->limit(10)->get();

        // Return view
        return response()->view('frontend::rss.links', ['links' => $links, 'settings' => $this->settings, 'language_prefix' => $this->language_prefix])->header('Content-Type', 'application/xml');
    }

      /** Articles */
      public function articles()
      {
          // List of latest articles
          $articles = Article::orderBy('id', 'desc')->where('language', $this->language_id)->limit(10)->get();
  
          // Return view
          return response()->view('frontend::rss.articles', ['articles' => $articles, 'settings' => $this->settings, 'language_prefix' => $this->language_prefix])->header('Content-Type', 'application/xml');
      }

}
