<?php

namespace App\Http\Middleware;

use Closure;

class MemberMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if (\Auth::check() && \Auth::user()->user_type == '2') {
            // Logout user if account is disabled
            if (\Auth::user()->disabled == '1') {
                \Auth::logout();
                return \Redirect::to('member-area/login');
            }
            return $next($request);
        }

        return \Redirect::to(env('ADMIN_URL'));
    }
}
