<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class Bankpaymentnotification extends Mailable
{
    use Queueable, SerializesModels;

    public $mail_from;
    public $site_title;
    public $sender_name;
    public $details;
    public $amount;
    public $bank_account;
    public $url;
    public $reference_code;
    
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($sender_name, $bank_account, $details, $amount, $site_title, $mail_from, $url, $reference_code)
    {
        $this->sender_name = $sender_name;
        $this->bank_account = $bank_account;
        $this->details = $details;
        $this->amount = $amount;
        $this->site_title = $site_title;
        $this->mail_from = $mail_from;
        $this->url = $url;
        $this->reference_code = $reference_code;
        }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from($this->mail_from)->markdown('vendor.frontend.mail.bank_payment_notification')->subject(__('general.bank_payment_received'));
    }
}
