<?php

namespace App\Models;

use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Model;

class Link extends Model
{
    use Sluggable;
    use \Conner\Tagging\Taggable;

    /**
     * Return the sluggable configuration array for this model.
     *
     * @return array
     */
    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => 'title',
            ],
        ];
    }

    protected $fillable = [
        'title',
        'description',
        'image',
        'slug',
        'url',
        'visible_url',
        'bypass_redirect',
        'bypass_type',
        'deep_links',
        'page_views',
        'clicks',
        'featured_category',
        'featured_home',
    ];

    public function categories()
    {
        return $this->belongsToMany(Category::class);
    }
    
       public function locations()
    {
        return $this->belongsToMany(Location::class);
    }
}
