<?php

namespace App\Providers;

use App;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\View;
use Illuminate\Support\ServiceProvider;
use Illuminate\Pagination\Paginator;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        //
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {
        Schema::defaultStringLength(191);

        $this->loadViews();

        $this->app->singleton('site_lang', function () {

            // Retrieve settings
            $site_settings = DB::table('settings')->get();

            foreach ($site_settings as $setting) {
                $settings[$setting->name] = $setting->value;
            }

            return $settings['site_language'];

        });
        
        Paginator::useBootstrap();

        // Set default site language
        App::setLocale(app('site_lang'));
    }

    private function packagePath($path)
    {
        return __DIR__ . "../../$path";
    }

    private function loadViews()
    {
        $this->loadViewsFrom(__DIR__ . '/views/vendor/frontend', 'frontend');
        $this->loadViewsFrom(__DIR__ . '/views/vendor/rtl-frontend', 'rtl-frontend');

    }

}
