@extends('adminlte::page')

@section('content')

@if(empty($searchquery))
@section('content_header', __('admin.links'))
@else
@section('content_header', __('admin.search_links'))
@endif

@if(empty($searchquery))

@if(env('MAIL_USERNAME') == null || env('MAIL_PASSWORD') == null || env('MAIL_ENCRYPTION') == null || env('MAIL_FROM_ADDRESS') == null || env('MAIL_FROM_NAME') == null)
<div class="callout env-warning">
    <h4>@lang('admin.warning')</h4>
    <p>@lang('admin.env_warning')</p>
</div>
@endif

<!-- Info boxes -->
<div class="row">

    <div class="col-md-3 col-sm-6 col-xs-12">
        <div class="info-box">
            <span class="info-box-icon"><i class="fas fa-user"></i></span>
            <div class="info-box-content">
                <span class="info-box-text">@lang('admin.total_members')</span>
                <span class="info-box-number">{{number_format($array_data['total_members'])}}</span>
            </div>
            <!-- /.info-box-content -->
        </div>
        <!-- /.info-box -->
    </div>
    <!-- /.col -->

    <!-- fix for small devices only -->
    <div class="clearfix visible-sm-block"></div>

    <div class="col-md-3 col-sm-6 col-xs-12">
        <div class="info-box">
            <span class="info-box-icon"><i class="fas fa-link"></i></span>

            <div class="info-box-content">
                <span class="info-box-text">@lang('admin.total_links')</span>
                <span class="info-box-number">{{number_format($array_data['total_links'])}}</span>
            </div>
            <!-- /.info-box-content -->
        </div>
        <!-- /.info-box -->
    </div>
    <!-- /.col -->

    <!-- fix for small devices only -->
    <div class="clearfix visible-sm-block"></div>

    <div class="col-md-3 col-sm-6 col-xs-12">
        <div class="info-box">
            <span class="info-box-icon"><i class="fas fa-comments"></i></span>

            <div class="info-box-content">
                <span class="info-box-text">@lang('admin.pending_comments')</span>
                <span class="info-box-number">{{number_format($array_data['pending_comments'])}}</span>
                <a href="{{ asset(env('ADMIN_URL').'/comments') }}" id="view-submissions">@lang('admin.view_comments')</a>
            </div>
            <!-- /.info-box-content -->
        </div>
        <!-- /.info-box -->
    </div>
    <!-- /.col -->

    <div class="col-md-3 col-sm-6 col-xs-12">
        <div class="info-box">
            <span class="info-box-icon"><i class="fas fa-hourglass-start"></i></span>

            <div class="info-box-content">
                <span class="info-box-text">@lang('admin.pending_submissions')</span>
                <span class="info-box-number">{{number_format($array_data['pending_submissions'])}}</span>
                <a href="{{ asset(env('ADMIN_URL').'/submissions') }}" id="view-submissions">@lang('admin.view_submissions')</a>
            </div>
            <!-- /.info-box-content -->
        </div>
        <!-- /.info-box -->
    </div>
    <!-- /.col -->

</div>
<!-- /.row -->

@endif

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            <!-- box-body -->
            <div class="box-body no-padding">

                <a href="{{ asset(env('ADMIN_URL').'/links/create') }}" class="btn bg-purple btn-flat margin"><i class="fas fa-plus-square"></i>
                    @lang('admin.create_link')</a>
                    
                         <a href="{{ asset(env('ADMIN_URL').'/links/create_links_bulk') }}" class="btn bg-olive btn-flat"><i class="fas fa-plus-square"></i>
                    @lang('admin.create_links_in_bulk')</a>
                    
                <div class="table-responsive">
                    <table class="table table-striped" id="table" data-delete-prompt="@lang('admin.delete_prompt')" data-yes="@lang('admin.yes')" data-cancel="@lang('admin.cancel')">
                        <tr>
                            <th class="col-md-1">ID</th>
                            <th class="col-md-3">@lang('admin.title')</th>
                            <th class="col-md-1">@lang('admin.page_views')</th>
                            <th class="col-md-1">@lang('admin.clicks')</th>
                            <th class="col-md-1">@lang('admin.user')</th>
                            <th class="col-md-1">@lang('admin.package')</th>
                            <th class="col-md-1">@lang('admin.date')</th>
                            <th class="col-md-1">@lang('admin.details')</th>
                            <th class="col-md-1">@lang('admin.edit')</th>
                            <th class="col-md-1">@lang('admin.delete')</th>
                        </tr>
                        @foreach($links as $row)
                        <tr>
                            <td>{{$row['id']}}</td>
                            <td>@if($row->bypass_details =='1' || $row->status == '5') {{$row['title']}} @else <a href="{{ asset($array_data['language_prefix'][$row->language].$settings['detail_base'.'-'.$row->language]) }}/{{ $row->slug }}" class="text-black" target="_blank">{{$row['title']}}</a> @endif @if($row->status == '4')<span class="badge grace-period">@lang('admin.grace_period')</span>@endif @if($row->status == '5')<span class="badge expired">@lang('admin.expired')</span>@endif</td>
                            <td>{{$row['page_views']}}</td>
                            <td>{{$row['clicks']}}</td>
                            <td><a href="{{ asset(env('ADMIN_URL').'/search?user='.$row->owner.'') }}" class="text-black"><u>{{ $array_data['username'][$row->owner] }}</u></a></td>
                            <td>@if($row->package!='0')<a href="{{ asset(env('ADMIN_URL').'/search?package='.$row->package.'') }}" class="text-black"><u>{{ $array_data['package_name'][$row->package] }}</a>@else - @endif</td>
                            <td>{{\Carbon\Carbon::parse($row->created_at)->translatedFormat('M d, Y')}}</td>
                            <td><span class="fi fi-{{$array_data['language_icon'][$row->language]}}"></span> @isset($row['reciprocal_link']) <a href="{{$row['reciprocal_link']}}" target="_blank"><span class="label label-dark">BL</span></a> @endif @if ($row->featured_home == '1')<span class="label label-turquoise">H</span>@endif @if ($row->featured_category == '1')<span class="label label-purple">C</span>@endif</td>
                            <td><a href="{{action('App\Http\Controllers\LinkController@edit', $row['id'])}}" class="btn btn-sm bg-purple"><i class="fas fa-edit"></i> @lang('admin.edit')</a>
                            </td>
                            <td>
                                <form id="delete_from_{{$row->id}}" method="POST" action="{{action('App\Http\Controllers\LinkController@destroy', $row['id'])}}">
                                    {{ csrf_field() }}
                                    {{ method_field('DELETE') }}
                                    <a href="javascript:void(0);" data-id="{{$row->id}}" class="_delete_data">
                                        <span class="btn btn-sm bg-red"><i class="fas fa-ban"></i>
                                            @lang('admin.delete')</span>
                                    </a>
                                </form>
                            </td>
                        </tr>
                        @endforeach
                    </table>
                </div>

            </div>
            <!-- /.box-body -->

        </div>
        <!-- /.general form elements -->

        @if($links->isEmpty())
        <h6 class="alert alert-danger">@lang('admin.no_record').</h6>
        @endif

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

{{ $links->appends(Request::only(['term', 'user', 'package']))->links()}}

@endsection