@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.members'))

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            <!-- box-body -->
            <div class="box-body no-padding">

                <a href="{{ asset(env('ADMIN_URL').'/members/create') }}" class="btn bg-purple btn-flat margin"><i class="fas fa-plus-square"></i>
                    @lang('admin.create_member')</a>
                <div class="table-responsive">
                    <table class="table table-striped" id="table" data-delete-prompt="@lang('admin.delete_prompt')" data-yes="@lang('admin.yes')" data-cancel="@lang('admin.cancel')">
                        <tr>
                            <th class="col-md-1">ID</th>
                            <th class="col-md-5">@lang('admin.name')</th>
                            <th class="col-md-1">@lang('admin.link_count')</th>
                            <th class="col-md-2">@lang('admin.contact_member')</th>
                            <th class="col-md-1">@lang('admin.date')</th>
                            <th class="col-md-1">@lang('admin.edit')</th>
                            <th class="col-md-1">@lang('admin.delete')</th>
                        </tr>
                        <tbody>
                            @foreach($members as $row)
                            <tr id="{{ $row->id }}">
                                <td>{{$row->id}}</td>
                                <td>{{$row->name}}</td>
                                <td><a href="{{ asset(env('ADMIN_URL').'/search?user='.$row->id.'') }}" class="text-black"><u>{{ count($row->children) }}</u></a></td>
                                <td><a href="{{ asset(env('ADMIN_URL').'/members/send_email/'.$row->id.'') }}" class="text-black"><u>@lang('admin.send_email_to_member')</u></a></td>
                                <td>{{\Carbon\Carbon::parse($row->created_at)->translatedFormat('M d, Y')}}</td>
                                <td><a href="{{action('App\Http\Controllers\MemberController@edit', $row->id)}}" class="btn btn-link btn-sm bg-purple"><i class="fas fa-edit"></i>
                                        @lang('admin.edit')
                                    </a></td>
                                <td>
                                    <form id="delete_from_{{$row->id}}" method="POST" action="{{action('App\Http\Controllers\MemberController@destroy', $row['id'])}}">
                                        {{ csrf_field() }}
                                        {{ method_field('DELETE') }}
                                        <a href="javascript:void(0);" data-id="{{$row->id}}" class="_delete_data">
                                            <span class="btn btn-sm bg-red"><i class="fas fa-ban"></i>
                                                @lang('admin.delete')</span>
                                        </a>
                                    </form>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

            </div>
            <!-- /.box-body -->

        </div>
        <!-- /.general form elements -->

        @if($members->isEmpty())
        <h6 class="alert alert-danger">@lang('admin.no_record').</h6>
        @endif

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

{{ $members->onEachSide(1)->links() }}

@endsection