@extends('adminlte::page')

@section('content')

@section('content_header', __('admin.mail_settings'))

<!-- box -->
<div class="row">

    <!-- col -->
    <div class="col-md-12">

        @if(count($errors) > 0)
        <div class="alert alert-danger">
            @foreach($errors->all() as $error)
            <p><i class="fas fa-minus-circle"></i> {{$error}}</p>
            @endforeach
        </div>
        @endif @if(Session::has('success'))
        <div class="alert alert-success">
            <p><i class="fas fa-check-circle"></i> {{ Session::get('success') }}</p>
        </div>
        @endif

        <!-- general form elements -->
        <div class="box">

            <!-- form -->
            <form method="POST" enctype="multipart/form-data" action="{{url(env('ADMIN_URL').'/mail_settings')}}">
                @csrf @method('POST')

                <!-- box-body -->
                <div class="box-body">

                    <div class="form-group">
                        <label>@lang('admin.email_logo')<br /><span class="label bg-dark">250x50</span></label>
                        <div class="logo-box mt-5">
                            <img src="{{ asset('/images/email_logo.png') }}?r={{Str::random(40)}}" class="img-responsive icon-preview">
                        </div>
                        <label class="btn btn-outline btn-sm" id="browse-color-image">@lang('admin.browse')<input type="file" name="email_logo" id="import-file-select" class="hidden"></label>
                    </div>

                    <div class="form-group">
                        <label>@lang('admin.email_footer_message')</label>
                        <textarea class="form-control" name="email_footer_message" rows="5">{{$settings['email_footer_message']}}</textarea>
                    </div>

                    <!-- row -->
                    <div class="row">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.use_text_logo_in_emails') </label><br />
                                <input type="checkbox" name="use_text_logo_in_emails" {{ $settings['use_text_logo_in_emails'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.submission_notification_mail') </label><br />
                                <input type="checkbox" name="submission_notification_mail" {{ $settings['submission_notification_mail'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                        <div class="col-md-4">
                            <div class="form-group">
                                <label>@lang('admin.send_expire_notification')</label><br />
                                <input type="checkbox" name="send_expire_notification" {{ $settings['send_expire_notification'] == 1 ? 'checked' : '' }}>
                            </div>
                        </div>

                    </div>
                    <!-- /.row -->

                </div>
                <!-- /.box-body -->

                <div class="box-footer">
                    <button type="submit" class="btn btn-primary">@lang('admin.submit')</button>
                </div>

            </form>
            <!-- /.form -->

        </div>
        <!-- /.general form elements -->

    </div>
    <!-- /.col -->

</div>
<!-- /.box -->

@endsection