@extends('frontend::page')

@section('content')

<!-- Container -->
<main class="container links mt-3">

    <!-- Grid Row -->
    <div class="row">

        <!-- Grid Column -->
        <div class="col-md-9 mb-3">

            @if(!empty($ad[4]))<div class="mb-3 text-center">{!! $ad[4] !!}</div>@endif

            <!-- Search Box -->
            @include('frontend::inc.partials', ['type' => '1'])
            <!-- /Search Box -->

            @if ($settings['breadcrumbs'] == '1')
            <!-- Breadcrumbs -->
            <div class="breadcrumbs mb-3">
                <a href="{{ asset($language_prefix) }}">@lang('general.homepage')</a> <span class="sep">›</span> <a href="{{url()->current()}}">@lang('general.contact')</a>
            </div>

            @if ($settings['schema_breadcrumbs'] == '1')
            {!! $breadcrumb_schema_data->toScript() !!}
            @endif
            <!-- /Breadcrumbs -->
            @endif

            <div class="bg-forms shadow-sm rounded mb-3 p-3">
                @lang('general.contact_notice')
            </div>

            <div id="contact-form-section" data-error="@lang('general.error')" data-recaptcha-error="@lang('general.recaptcha_error')">

                <div class="shadow-sm p-2 bg-white rounded">

                    <div class="p-1">

                        <form id="contact-form">

                            <div class="row">
                                <div class="col-md-12 mb-2">
                                    <label for="name" class="form-label">@lang('general.name') <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="name" name="name" required>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12 mb-2">
                                    <label for="email" class="form-label">@lang('general.email') <span class="text-danger">*</span></label>
                                    <input type="email" class="form-control" id="email" name="email" required>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12 mb-2">
                                    <label for="subject" class="form-label">@lang('general.subject') <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="subject" name="subject" required>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="message" class="form-label">@lang('general.message') <span class="text-danger">*</span></label>
                                <textarea class="form-control" id="message" name="message" rows="3"></textarea>
                            </div>

                            @if ($settings['enable_google_recaptcha'] == '1')
                            <div class="g-recaptcha mb-3" data-sitekey="{{ $settings['google_recaptcha_site_key'] }}"></div>
                            @endif

                        </form>

                        <div id="contact-form-result"></div>

                        <button type="submit" class="btn submit-button" onclick="contact_form()">@lang('general.submit')</button>

                    </div>

                </div>

            </div>

            @if(!empty($ad[3]))<div class="mt-3 text-center">{!! $ad[3] !!}</div>@endif

        </div>
        <!-- /Grid column -->

        <!-- Grid Column -->
        <div class="col-md-3 text-center mb-3">
            @if ($settings['sticky_ads_right_column'] == '1')<div class="sticky-top sticky-top-15">@endif
                @if(!empty($ad[5]))<div class="mb-3">{!! $ad[5] !!}</div>@endif
                @if ($settings['sticky_ads_right_column'] == '1')</div>@endif
        </div>
        <!-- /Grid Column -->

    </div>
    <!-- /Grid row -->

</main>
<!-- /Container -->

@endsection