@extends('frontend::page')

@section('content')

<!-- Container -->
<main class="container custom-page mt-3">

    <!-- Grid Row -->
    <div class="row">

        <!-- Grid Column -->
        <div class="col-md-9">

            @if(!empty($ad[4]))<div class="mb-3 text-center">{!! $ad[4] !!}</div>@endif

            <!-- Search Box -->
            @include('frontend::inc.partials', ['type' => '1'])
            <!-- /Search Box -->

            @if ($settings['breadcrumbs'] == '1')
            <!-- Breadcrumbs -->
            <div class="breadcrumbs mb-3">
                <a href="{{ asset($language_prefix) }}">@lang('general.homepage')</a> <span class="sep">›</span> <a href="{{url()->current()}}">{{$page_query->title}}</a>
            </div>

            @if ($settings['schema_breadcrumbs'] == '1')
            {!! $breadcrumb_schema_data->toScript() !!}
            @endif
            <!-- /Breadcrumbs -->
            @endif

            <!-- Page Content -->
            <div class="shadow-sm p-2 bg-white rounded mb-3 pb-0">
                <div class="p-1">
                    <h2>{{$page_query->title}}</h2>
                    {!! $page_query->details !!}
                </div>
            </div>
            <!-- /Page Content -->

            @if(!empty($ad[3]))<div class="mb-3 text-center">{!! $ad[3] !!}</div>@endif

        </div>
        <!-- /Grid Column -->

        <!-- Grid Column -->
        <div class="col-md-3 text-center mb-3">
            @if ($settings['sticky_ads_right_column'] == '1')<div class="sticky-top sticky-top-15">@endif
                @if(!empty($ad[5]))<div class="mb-3">{!! $ad[5] !!}</div>@endif
                @if ($settings['sticky_ads_right_column'] == '1')</div>@endif
        </div>
        <!-- /Grid Column -->

    </div>
    <!-- /Grid row -->

</main>
<!-- /Container -->

@endsection