@extends('frontend::page')

@section('content')

<!-- Container -->
<main class="container links mt-3">

    <!-- Grid Row -->
    <div class="row">

        <!-- Grid Column -->
        <div class="col-md-9">

            @if(!empty($ad[4]))<div class="mb-3 text-center">{!! $ad[4] !!}</div>@endif

            @if ($settings['article_boxes_on_home_page'] == '1')
            <!-- Article Boxes -->
            @include('frontend::inc.partials', ['type' => '2'])
            <!-- /Article Boxes -->
            @endif

            <!-- Main Row -->
            <div class="row">

                <!-- Search Box -->
                @include('frontend::inc.partials', ['type' => '1'])
                <!-- /Search Box -->

                @if($categories->isEmpty())
                <div class="col-12">
                    <h6 class="alert alert-warning">@lang('general.no_category_added')</h6>
                </div>
                @endif

                <!-- Featured Links -->
                @foreach ($featured_links as $link)

                @if(empty($link->image))
                @php $link->image='no_image.png'; @endphp
                @endif

                <div class="col-12 mb-3">
                    <div class="shadow-sm p-2 bg-featured rounded">
                        <div class="row p-1">
                            <a href="@if ($link->bypass_details == '0'){{ asset($language_prefix.$settings['detail_base']) }}/{{ $link->slug }}@else{{ $link->url }}@endif" @if ($link->bypass_details == '1') target="_blank"{!! $link_types[$link->bypass_details_type] !!}@endif>
                                <div class="d-flex">
                                    <div class="me-2"><img src="{{ asset('images/pixel.png') }}" data-src="{{ asset('images/links') }}/{{ $link->image }}" class="site-icon rounded lazy" alt="{{ $link->title }}"></div>
                                    <div class="ps-1 my-md-0 my-auto">
                                        <span class="link-title">{{ $link->title }}</span>@if($link->badge == '1') <i class="icon-check-circle title-badge" data-bs-toggle="tooltip" data-bs-placement="top" title="@lang('general.badge_title')"></i>@endif{{''}}@if ($settings['show_featured_text'] == '1')<span class="featured">@lang('general.featured')</span>@endif
                                        <div>
                                            {!!stars($link->votes, 2, 1)!!}
                                        </div>
                                        <p class="description m-0">{{{ $link->description }}}</p>
                                        <span class="site-url">
                                            @if(empty($link->visible_url))
                                            {{ $link->url }}
                                            @else
                                            {{ $link->visible_url }}
                                            @endif
                                        </span>
                                    </div>
                                </div>
                            </a>
                        </div>
                    </div>
                </div>

                @endforeach
                <!-- /Featured Links -->

                <!-- Links -->
                @foreach ($categories_home as $category)

                @if(empty($category->image))
                @php $category->image='no_image.png'; @endphp
                @endif

                <div class="col-md-6 col-12 mb-3">
                    <div class="shadow-sm p-2 bg-white rounded">
                        <div class="row p-1">
                            <div class="d-flex">
                                <div class="me-2 my-auto">
                                    <a href="{{ asset($language_prefix.$settings['category_base']) }}/{{ $category->slug }}">
                                        <img src="{{ asset('images/pixel.png') }}" data-src="{{ asset('images/categories') }}/{{ $category->image }}" class="site-icon rounded lazy" alt="{{ $category->title }}">
                                        <noscript>
                                            <img src="{{ asset('images/categories') }}/{{ $category->image }}" class="site-icon rounded" alt="{{ $category->title }}" />
                                        </noscript>
                                    </a>
                                </div>
                                <div class="ps-1">
                                    <a href="{{ asset($language_prefix.$settings['category_base']) }}/{{ $category->slug }}" class="section-title">{{ $category->title }}@if ($settings['count_home'] == '1') ({{ $category->item_count }})@endif</a>

                                    @foreach($category->home_categories as $submenu)

                                    @if($submenu->home_page == '1')
                                    <a href="{{ asset($language_prefix.$settings['category_base']) }}/{{$category->slug}}/{{ $submenu->slug }}" class="sub-link">{{ $submenu->title }}@if ($settings['sub_count_home'] == '1') ({{ $submenu->item_count }})@endif</a>
                                    @endif

                                    @endforeach

                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                @endforeach
                <!-- /Links -->

            </div>
            <!-- /Main Row -->

            <div class="row">
                <div class="col-md-6">

                    <h2 class="h2-title mb-3">@lang('general.latest_links')</h2>

                    <!-- Links -->
                    @foreach ($latest_links as $link)

                    @if(empty($link->image))
                    @php $link->image='no_image.png'; @endphp
                    @endif

                    <div class="mb-3">
                        <div class="shadow-sm p-2 bg-white rounded">
                            <div class="row p-1">
                                <a href="@if ($link->bypass_details == '0'){{ asset($language_prefix.$settings['detail_base']) }}/{{ $link->slug }}@else{{ $link->url }}@endif" @if ($link->bypass_details == '1') target="_blank"{!! $link_types[$link->bypass_details_type] !!}@endif>
                                    <div class="d-flex">
                                        <div class="me-2">
                                            <img src="{{ asset('images/pixel.png') }}" data-src="{{ asset('images/links') }}/{{ $link->image }}" class="site-icon-small rounded lazy" alt="{{ $link->title }}">
                                            <noscript>
                                                <img src="{{ asset('images/links') }}/{{ $link->image }}" class="site-icon rounded" alt="{{ $link->title }}" />
                                            </noscript>
                                        </div>
                                        <div class="ps-1 my-md-0 my-auto">
                                            <span class="link-title">{{ $link->title }}</span>@if($link->badge == '1') <i class="icon-check-circle title-badge" data-bs-toggle="tooltip" data-bs-placement="top" title="@lang('general.badge_title')"></i>@endif
                                            <p class="description m-0">{{{ $link->description }}}</p>
                                            <span class="site-url">
                                                @if(empty($link->visible_url))
                                                {{ $link->url }}
                                                @else
                                                {{ $link->visible_url }}
                                                @endif
                                            </span>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>

                    @endforeach
                    <!-- /Links -->

                </div>

                <div class="col-md-6">

                    <h2 class="h2-title mb-3">@lang('general.popular_links')</h2>

                    <!-- Links -->
                    @foreach ($popular_links as $link)

                    @if(empty($link->image))
                    @php $link->image='no_image.png'; @endphp
                    @endif

                    <div class="mb-3">
                        <div class="shadow-sm p-2 bg-white rounded">
                            <div class="row p-1">
                                <a href="@if ($link->bypass_details == '0'){{ asset($language_prefix.$settings['detail_base']) }}/{{ $link->slug }}@else{{ $link->url }}@endif" @if ($link->bypass_details == '1') target="_blank"{!! $link_types[$link->bypass_details_type] !!}@endif>
                                    <div class="d-flex">
                                        <div class="me-2">
                                            <img src="{{ asset('images/pixel.png') }}" data-src="{{ asset('images/links') }}/{{ $link->image }}" class="site-icon-small rounded lazy" alt="{{ $link->title }}">
                                            <noscript>
                                                <img src="{{ asset('images/links') }}/{{ $link->image }}" class="site-icon rounded" alt="{{ $link->title }}" />
                                            </noscript>
                                        </div>
                                        <div class="ps-1 my-md-0 my-auto">
                                            <span class="link-title">{{ $link->title }}</span>@if($link->badge == '1') <i class="icon-check-circle title-badge" data-bs-toggle="tooltip" data-bs-placement="top" title="@lang('general.badge_title')"></i>@endif
                                            <p class="description m-0">{{{ $link->description }}}</p>

                                            <span class="site-url">
                                                @if(empty($link->visible_url))
                                                {{ $link->url }}
                                                @else
                                                {{ $link->visible_url }}
                                                @endif
                                            </span>
                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>

                    @endforeach
                    <!-- /Links -->

                </div>
            </div>

            <!-- User Reviews -->
            @if(count($latest_reviews) > 0)

            <h2 class="h2-title mb-3">@lang('general.latest_reviews')</h2>

            <div class="row latest-reviews">
                @foreach ($latest_reviews as $review)
                <div class="col-md-4 col-12 mb-3">
                    <a href="{{ asset($language_prefix.$settings['detail_base']) }}/{{ $review->slug }}">
                        <div class="box rounded shadow-sm">
                            <span class="title mb-1">"{{$review->title}}"</span>
                            {!!stars($review->rating, 2, 1)!!}

                            <p class="mt-1 mb-1">{{$review->comment}}</p>

                            <div class="d-flex mt-2">
                                <div class="flex-shrink-0">
                                    <img src="{{ asset('images/pixel.png') }}" data-src="{{ asset('images/links') }}/{{ $review->image ?? 'no_image.png'; }}" class="rounded-circle lazy" alt="{{$review->link_title}}">
                                </div>
                                <div class="flex-grow-1 ms-2 my-auto">
                                    <span class="site-name">{{$review->link_title}}</span>
                                    <span class="name">{{$review->name}}</span>
                                </div>
                            </div>


                        </div>
                    </a>
                </div>

                @endforeach

            </div>

            @endif
            <!-- /User Reviews -->

            @if ($settings['article_boxes_on_home_page'] == '2')
            <!-- Article Boxes -->
            @include('frontend::inc.partials', ['type' => '2'])
            <!-- /Article Boxes -->
            @endif

            @if(!empty($ad[3]))<div class="mb-3 text-center">{!! $ad[3] !!}</div>@endif

        </div>
        <!-- /Grid Column -->

        <!-- Grid Column -->
        <div class="col-md-3 text-center mb-3">
            @if ($settings['sticky_ads_right_column'] == '1')<div class="sticky-top sticky-top-15">@endif
                @if(!empty($ad[5]))<div class="mb-3">{!! $ad[5] !!}</div>@endif
                @if ($settings['sticky_ads_right_column'] == '1')</div>@endif
        </div>
        <!-- /Grid Column -->

    </div>
    <!-- /Grid row -->

</main>
<!-- /Container -->

@endsection
