@extends('frontend::page')

@section('content')

@push('assets_header')
<!-- Bootstrap Select -->
<link rel="stylesheet" href="{{ asset('css/bootstrap-select.min.css') }}">

@endpush

@push('assets_footer')
<!-- Bootstrap Bundle -->
<script src="{{ asset('js/bootstrap.bundle.min.js') }}"></script>

<!-- Bootstrap Select -->
<script src="{{ asset('js/bootstrap-select.min.js') }}"></script>
@endpush

@foreach ($languages as $language)
@php $language_code[$language->id]=strtoupper($language->code); @endphp
@endforeach

<!-- Container -->
<main class="container">

    <!-- Grid Row -->
    <div class="row member-area mt-3">

        <div class="col-md-3 menu">

            <div class="bg-white shadow-sm rounded p-2 pb-0">
                <!-- Left Column -->
                @include('frontend::inc.partials', ['type' => '3'])
                <!-- /Left Column -->
            </div>

        </div>

        <div class="col-md-9 mb-3">

            <div class="bg-white shadow-sm rounded p-2">

                <div class="p-1">

                    @if(count($errors) > 0)
                    <div class="alert alert-danger login-alert" role="alert">
                        @foreach($errors->all() as $error)
                        <p><b>@lang('general.error'):</b> {{$error}}</p>
                        @endforeach
                    </div>
                    @endif

                    @if(Session::has('success'))
                    <div class="alert alert-success login-alert">
                        <p>{{ Session::get('success') }}</p>
                    </div>
                    @endif

                    <form method="POST" enctype="multipart/form-data" action="{{ asset('member-area/edit/'.request()->route('id')) }}">
                        @csrf

                        <input type="hidden" name="link_id" value="{{$link_query->id}}">

                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.title') <span class="text-danger">*</span></label>
                            <input type="text" name="title" class="form-control" value="{{$link_query->title}}">
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.url') <span class="text-danger">*</span></label>
                            <input type="text" name="url" class="form-control" value="{{$link_query->url}}">
                        </div>

                        @if($link_query->allow_visible_url=='1')
                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.visible_url')</label>
                            <input type="text" name="visible_url" class="form-control" value="{{$link_query->visible_url}}">
                        </div>
                        @endif

                        @if($link_query->allow_bypass_redirect=='1')
                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.bypass_redirect')</label><br />
                            <input type="checkbox" class="form-check-input" id="bypass_redirect" name="bypass_redirect" {{ $link_query->bypass_redirect == 1 ? 'checked' : '' }}>
                        </div>
                        @endif

                        @if($link_query->allow_bypass_details=='1')
                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.bypass_details')</label><br />
                            <input type="checkbox" class="form-check-input" id="bypass_details" name="bypass_details" {{ $link_query->bypass_details == 1 ? 'checked' : '' }}>
                        </div>
                        @endif

                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.description') <span class="text-danger">*</span></label>
                            <textarea class="form-control" name="description" rows="3">{{$link_query->description}}</textarea>
                        </div>
      
                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.category') <span class="text-danger">*</span></label>
                        <select class="selectpicker form-control" name="categories[]" data-live-search="true" data-live-search="true" multiple="multiple" required="required">
                                @foreach($submission_categories as $category)
                                <option value="{{ $category->id }}" @php if(in_array($category->id, $link_query->categories->pluck('id')->toArray())) { echo ' selected'; } @endphp>[{{$language_code[$category->language]}}] {{ $category->title }}</option>

                                @foreach($category->children as $submenu)
                                <option value="{{ $submenu->id }}" @php if(in_array($submenu->id, $link_query->categories->pluck('id')->toArray())) { echo ' selected'; } @endphp>[{{$language_code[$category->language]}}] {{ $category->title }} › {{ $submenu->title }}</option>

                                @endforeach

                                @endforeach
                            </select>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.site_icon_description')</label>
                            <input class="form-control" type="file" id="image" name="image">
                        </div>

                        @if($link_query->allow_phone_number=='1')
                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.phone_number')</label>
                            <input type="text" name="phone_number" class="form-control" value="{{$link_query->phone_number}}">
                        </div>
                        @endif

                        @if($link_query->allow_email=='1')
                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.email')</label>
                            <input type="text" name="email" class="form-control" value="{{$link_query->email}}">
                        </div>
                        @endif

                        @if($link_query->allow_address=='1')
                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.address')</label>
                            <textarea class="form-control" name="address" rows="3">{{$link_query->address}}</textarea>
                        </div>
                        @endif

                        @if($link_query->allow_deep_links=='1')

                        <h6 class="mb-3 fw-bold submission-head-title">@lang('general.deep_links')</h6>

                        @foreach($deep_link_data as $title)

                        @if($loop->iteration<=$link_query->allowed_deep_links_count)

                            <!-- row -->
                            <div class="row">

                                <div class="col-md-6 mb-3">
                                    <label class="form-label fw-bold">@lang('admin.deep_link') {{$loop->iteration}} @lang('admin.title')</label>
                                    <input type="text" name="deep_link_{{$loop->iteration}}_title" class="form-control" value="{{$title['title']}}" />
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label class="form-label fw-bold">@lang('admin.deep_link') {{$loop->iteration}} @lang('admin.url')</label>
                                    <input type="text" name="deep_link_{{$loop->iteration}}_url" class="form-control" value="{{$title['url']}}" />
                                </div>

                            </div>
                            <!-- /.row -->

                            @endif

                            @endforeach

                            @endif

                            @if($link_query->allow_deep_links=='1')

                            <h6 class="mb-3 fw-bold submission-head-title">@lang('general.other_contacts')</h6>

                            <!-- row -->
                            <div class="row">

                                <div class="col-md-4 mb-3">
                                    <label class="form-label fw-bold">@lang('admin.facebook_url')</label>
                                    <input type="text" name="facebook_url" class="form-control" value="{{$other_contacts['facebook_url']['url']}}" />
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label class="form-label fw-bold">@lang('admin.twitter_url')</label>
                                    <input type="text" name="twitter_url" class="form-control" value="{{$other_contacts['twitter_url']['url']}}" />
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label class="form-label fw-bold">@lang('admin.instagram_url')</label>
                                    <input type="text" name="instagram_url" class="form-control" value="{{$other_contacts['instagram_url']['url']}}" />
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label class="form-label fw-bold">@lang('admin.linkedin_url')</label>
                                    <input type="text" name="linkedin_url" class="form-control" value="{{$other_contacts['linkedin_url']['url']}}" />
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label class="form-label fw-bold">@lang('admin.whatsapp_number')</label>
                                    <input type="text" name="whatsapp_number" class="form-control" value="{{$other_contacts['whatsapp_number']['number']}}" />
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label class="form-label fw-bold">@lang('admin.telegram_url')</label>
                                    <input type="text" name="telegram_url" class="form-control" value="{{$other_contacts['telegram_url']['url']}}" />
                                </div>

                            </div>
                            <!-- /.row -->

                            @endif

                            <button class="btn update-btn" type="submit" @if($settings['allow_user_updates']=='0' ) disabled @endif>@lang('general.submit')</button>

                    </form>

                </div>
            </div>

        </div>

    </div>
    <!-- /Grid row -->

</main>
<!-- /Container -->

@endsection