@extends('frontend::page')

@section('content')

@foreach ($payment_methods as $method)
@php $payment_method[$method->id]=__('general.'.$method->title.''); @endphp
@endforeach

<!-- Container -->
<main class="container">

    <!-- Grid Row -->
    <div class="row member-area mt-3">

        <div class="col-md-3 menu">

            <div class="bg-white shadow-sm rounded p-2 pb-0">
                <!-- Left Column -->
                @include('frontend::inc.partials', ['type' => '3'])
                <!-- /Left Column -->
            </div>

        </div>

        <div class="col-md-9 mb-3">

            @if($orders->isEmpty())
            <h6 class="alert alert-warning">@lang('general.no_orders_yet')</h6>
            @else

            <div class="bg-white shadow-sm rounded px-2">

                <div class="table-responsive">
                    <table class="table align-middle mb-0">
                        <thead>
                            <tr>
                                <th class="col-1">@lang('general.order_id')</th>
                                <th class="col-1">@lang('general.total')</th>
                                <th class="col-2">@lang('general.payment_method')</th>
                                <th class="col-1">@lang('general.details')</th>
                                <th class="col-2">@lang('general.date')</th>
                                <th class="col-1">@lang('general.link_id')</th>
                                <th class="col-2">@lang('general.status')</th>
                                <th class="col-1">@lang('general.details')</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($orders as $order)
                            <tr>
                                <th>#{{ $order->id }}</th>
                                <td>@if($order->price=='0.00')@lang('general.free') @else{{$order->currency_symbol}}{{$order->price}}@endif</td>
                                <td>{{ $payment_method[$order->payment_method] ?? '-' }}</td>
                                <td>{{$order->is_renewal == 1 ? __('general.renewal') : __('general.submission') }}</td>
                                <td>{{\Carbon\Carbon::parse($order->created_at)->translatedFormat('F d, Y H:i')}}</td>
                                <td>@isset($order->link_id) #{{$order->link_id}}@else - @endif</td>
                                <td>
                                    {{-- Bank Payments --}}
                                    @if($order->payment_method == '2')
                                    @if($order->payment_status=='0')<span class="badge not-paid">@lang('general.not_paid')</span> <a href="{{ asset($language_prefix.'member-area/payment-notification/'.$order->id.'') }}" class="badge pay-now">@lang('general.payment_notification')</a>@endif
                                    @if($order->payment_status=='1')<span class="badge paid">@lang('general.paid')</span>@endif
                                    @endif

                                    {{-- PayPal --}}
                                    @if($order->payment_method == '1' || $order->payment_method == '5')
                                    @if($order->payment_status == '0')<span class="badge not-paid">@lang('general.not_paid')</span>@endif
                                    @if($order->payment_status == '1')<span class="badge paid">@lang('general.paid')</span>@endif
                                    @if($order->payment_status == '2')<span class="badge pending">@lang('general.processing_subscription')</span>@endif

                                    @if($_ENV['PAYPAL_MODE'] == 'live' && $order->payment_method=='1' && $order->payment_status=='0')<a href="https://www.paypal.com/checkoutnow?token={{$order->payment_id}}" target="_blank" class="badge pay-now">@lang('general.pay_now')</a>@endif
                                        @if($_ENV['PAYPAL_MODE'] == 'sandbox' && $order->payment_method=='1' && $order->payment_status=='0')<a href="https://www.sandbox.paypal.com/checkoutnow?token={{$order->payment_id}}" target="_blank" class="badge pay-now">@lang('general.pay_now')</a>
                                        @endif

                                        @if($_ENV['PAYPAL_MODE'] == 'live' && $order->payment_method=='5' && $order->payment_status=='0')<a href="https://www.paypal.com/webapps/billing/subscriptions?ba_token={{$order->subscription_token}}" target="_blank" class="badge pay-now">@lang('general.pay_now')</a>@endif
                                            @if($_ENV['PAYPAL_MODE'] == 'sandbox' && $order->payment_method=='5' && $order->payment_status=='0')<a href="https://www.sandbox.paypal.com/webapps/billing/subscriptions?ba_token={{$order->subscription_token}}" target="_blank" class="badge pay-now">@lang('general.pay_now')</a>@endif
                                            @endif

                                            {{-- Stripe --}}
                                            @if($order->payment_method == '3')
                                            @if($order->payment_status == '0')<span class="badge not-paid">@lang('general.not_paid')</span> <a href="{{ asset($language_prefix.'member-area/stripe-payment/'.$order->id.'') }}" class="badge pay-now">@lang('general.pay_now')</a>@endif
                                            @if($order->payment_status == '1')<span class="badge paid">@lang('general.paid')</span>@endif
                                            @endif

                                            {{-- Coinbase --}}
                                            @if($order->payment_method == '4')
                                            @if($order->payment_status == '0')<span class="badge not-paid">@lang('general.not_paid')</span> <a href="https://commerce.coinbase.com/charges/{{$order->payment_id}}" target="_blank" class="badge pay-now">@lang('general.pay_now')</a>@endif
                                            @if($order->payment_status == '1')<span class="badge paid">@lang('general.paid')</span>@endif
                                            @if($order->payment_status == '3')<span class="badge processing">@lang('general.processing')</span>@endif
                                            @if($order->payment_status == '4')<span class="badge expired">@lang('general.expired')</span>@endif
                                            @endif

                                            {{-- Pending Approval --}}
                                            @if($order->status=='1')<span class="badge pending">@lang('general.pending_approval')</span>@endif

                                            {{-- Approved --}}
                                            @if($order->status=='2')<span class="badge approved">@lang('general.approved')</span>@endif

                                            {{-- Rejected --}}
                                            @if($order->status=='3')<span class="badge rejected">@lang('general.rejected')</span>@endif
                                </td>
                                <td><a href="{{ URL::to($language_prefix.'member-area/order/'.$order->id.'') }}" class="btn btn-sm view-btn">@lang('general.view')</a></td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>

                    <!-- Pagination -->
                    <div class="d-flex">
                        <div class="mx-auto">
                            {{ $orders->onEachSide(1)->links() }}
                        </div>
                    </div>
                    <!-- /Pagination -->

                </div>

            </div>

            @endif

        </div>

    </div>
    <!-- /Grid row -->

</main>
<!-- /Container -->

@endsection