@extends('frontend::page')

@section('content')

<!-- Container -->
<main class="container">

    <!-- Grid Row -->
    <div class="row member-area mt-3">

        <div class="col-md-3 menu">

            <div class="bg-white shadow-sm rounded p-2 pb-0">
                <!-- Left Column -->
                @include('frontend::inc.partials', ['type' => '3'])
                <!-- /Left Column -->
            </div>

        </div>

        <div class="col-md-9 mb-3">

            <div class="bg-white shadow-sm rounded p-2">

                <div class="p-1 py-2">

                    @if(count($errors) > 0)
                    <div class="alert alert-danger login-alert" role="alert">
                        @foreach($errors->all() as $error)
                        <p><b>@lang('general.error'):</b> {{$error}}</p>
                        @endforeach
                    </div>
                    @endif @if(Session::has('success'))
                    <div class="alert alert-success login-alert">
                        <p>{{ Session::get('success') }}</p>
                    </div>
                    @endif

                    <form action="{{url()->current()}}" method="POST" id="subscribe-form">
                        @csrf

                        <label for="card-element" class="mb-1 fw-bold">@lang('general.credit_or_debit_card')</label>

                        <span class="d-block">@lang('general.amount_to_be_paid', ['amount' => "$order_details->currency_symbol$order_details->price"])</span>

                        <div id="card-element" class="form-control mb-3 mt-2 stripe-form"></div>

                        <div id="payment_result"></div>

                        <button id="card-button" class="btn pay-button" data-secret="{{$intent->client_secret}}">
                            @lang('general.pay_now')
                        </button>

                    </form>

                </div>

            </div>

        </div>

    </div>
    <!-- /Grid row -->

</main>
<!-- /Container -->

<script src="https://js.stripe.com/v3/"></script>

<script>
const stripe = Stripe('{{ env('STRIPE_KEY') }}');
var elements = stripe.elements();

var card = elements.create('card', {
    hidePostalCode: true
});
card.mount('#card-element');
card.addEventListener('change', function(event) {

});

const cardButton = document.getElementById('card-button');
const clientSecret = cardButton.dataset.secret;

cardButton.addEventListener('click', async (e) => {
    e.preventDefault();
    const {
        setupIntent,
        error
    } = await stripe.confirmCardSetup(
        clientSecret, {
            payment_method: {
                card: card
            }
        }
    );

    if (error) {
        $('#payment_result').html('<div class="alert alert-danger mb-3" role="alert">' + error.message + '</div>');
    } else {
        paymentMethodHandler(setupIntent.payment_method);
    }
});

function paymentMethodHandler(payment_method) {
    var form = document.getElementById('subscribe-form');
    var hiddenInput = document.createElement('input');
    hiddenInput.setAttribute('type', 'hidden');
    hiddenInput.setAttribute('name', 'payment_method');
    hiddenInput.setAttribute('value', payment_method);
    form.appendChild(hiddenInput);
    form.submit();
}
</script>

@endsection