@extends('frontend::page')

@section('content')

<!-- Container -->
<main class="container links mt-3">

    <!-- Grid Row -->
    <div class="row">

        <!-- Grid Column -->
        <div class="col-md-9">

            @if(!empty($ad[4]))<div class="mb-3 text-center">{!! $ad[4] !!}</div>@endif

            <!-- Search Box -->
            @include('frontend::inc.partials', ['type' => '1'])
            <!-- /Search Box -->

            @if (request()->method() == 'GET')
            <div class="col-12">
                <h6 class="alert alert-warning">@lang('general.search_box_warning')</h6>
            </div>
            @else

            @if ($settings['breadcrumbs'] == '1')
            <!-- Breadcrumbs -->
            <div class="breadcrumbs mb-3">
                <a href="{{ asset($language_prefix) }}">@lang('general.homepage')</a> <span class="sep">›</span> <a href="{{ asset($language_prefix) }}">@lang('general.search_results_for') <b>"{{$search_query}}"</b></a>
            </div>
            <!-- /Breadcrumbs -->
            @endif

            @if ($settings['search_categories'] == '1')
            @if($category_search->isNotEmpty())
            <!-- Subcategories -->
            <div class="col-12 mb-3">
                <div class="sub-categories">
                    <div class="row pb-2">
                        <span class="section-title mb-2 pt-2">@lang('general.categories')</span>
                        @foreach($category_search as $category)
                        <div class="col-md-12 pb-1">
                            <a href="{{ asset($language_prefix.$settings['category_base']) }}/@if ($category->parent_id == '0')@else{{ $category_slug[$category->parent_id] }}/@endif{{ $category->slug }}">@if ($category->parent_id != '0'){{ $category_name[$category->parent_id] }} › @endif{{ $category->title }}</a>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
            <!-- /Subcategories -->
            @endif
            @endif

            @if($errors->any())
            <div class="col-12">
                <h6 class="alert alert-warning">@lang('general.min_3_letters')</h6>
            </div>
            @else

            @if($links->isEmpty())
            <div class="col-12">
                <h6 class="alert alert-warning">@lang('general.no_search_results')</h6>
            </div>
            @endif

            <!-- Links -->
            @foreach ($links as $link)

            @if(empty($link->image))
            @php $link->image='no_image.png'; @endphp
            @endif

            <div class="col-12 mb-3">
                <div class="shadow-sm p-2 @if($link->featured_category == '1') bg-featured @else bg-white @endif rounded">
                    <div class="row p-1">
                        <a href="@if ($link->bypass_details == '0'){{ asset($language_prefix.$settings['detail_base']) }}/{{ $link->slug }}@else{{ $link->url }}@endif" @if ($link->bypass_details == '1') target="_blank"{!! $link_types[$link->bypass_details_type] !!}@endif>
                            <div class="d-flex">
                                <div class="me-2">
                                    <img src="{{ asset('images/pixel.png') }}" data-src="{{ asset('images/links') }}/{{ $link->image }}" class="site-icon rounded lazy" alt="{{ $link->title }}">
                                    <noscript>
                                        <img src="{{ asset('images/links') }}/{{ $link->image }}" class="site-icon rounded" alt="{{ $link->title }}" />
                                    </noscript>
                                </div>
                                <div class="ps-1 my-md-0 my-auto">
                                    <span class="link-title">{{ $link->title }}</span>@if($link->badge == '1') <i class="icon-check-circle title-badge" data-bs-toggle="tooltip" data-bs-placement="top" title="@lang('general.badge_title')"></i>@endif{{''}}@if($link->featured_category == '1' && $settings['show_featured_text'] == '1')<span class="featured">@lang('general.featured')</span>@endif
                                    <div>
                                        {!!stars($link->votes, 2, 1)!!}
                                    </div>
                                           <p class="description m-0">{{{ $link->description }}}</p>
                                    <span class="site-url">
                                        @if(empty($link->visible_url))
                                        {{ $link->url }}
                                        @else
                                        {{ $link->visible_url }}
                                        @endif
                                    </span>
                                </div>
                            </div>
                        </a>
                    </div>
                </div>
            </div>

            @endforeach
            <!-- /Links -->

            @endif

            @endif

            @if(!empty($ad[3]))<div class="mb-3 text-center">{!! $ad[3] !!}</div>@endif

        </div>
        <!-- /Grid Column -->

        <!-- Grid Column -->
        <div class="col-md-3 text-center mb-3">
            @if ($settings['sticky_ads_right_column'] == '1')<div class="sticky-top sticky-top-15">@endif
                @if(!empty($ad[5]))<div class="mb-3">{!! $ad[5] !!}</div>@endif
                @if ($settings['sticky_ads_right_column'] == '1')</div>@endif
        </div>
        <!-- /Grid Column -->

    </div>
    <!-- /Grid Row -->

</main>
<!-- /Container -->

@endsection