<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
{!!
\MetaTag::setPath()
->setDefault(['robots' => 'follow', 'canonical' => url()->full()])
->setDefault(['og_site_name' => $settings['site_title']])
->setDefault(['og_locale' => $locale_tag])
->render()
!!}
<meta name="csrf-token" content="{{ csrf_token() }}" />
<link rel="alternate" type="application/rss+xml" title="{{$settings['site_title']}}" href="{{ asset($language_prefix.'rss') }}" />
<link rel="icon" type="image/png" href="{{ asset('images/favicon.png') }}" />
<meta property="base_url" content="{{ rtrim(asset($language_prefix), "/") }}">
<!-- Bootstrap 5.0.1 -->
<link href="{{ asset('css/bootstrap.min.css') }}" rel="stylesheet">
<!-- Font Icons -->
<link href="{{ asset('css/font-icons.css') }}" rel="stylesheet">
<!-- Flag Icons -->
<link href="{{ asset('css/flag-icons.min.css') }}" rel="stylesheet">
<!-- simpleLightbox -->
<link href="{{ asset('css/simpleLightbox.min.css') }}" rel="stylesheet">
@if ($settings['enable_live_ajax_search'] == '1')
<!-- jQuery UI -->
<link href="{{ asset('css/jquery-ui.min.css') }}" rel="stylesheet">
@endif
<!-- Common Styles -->
<link href="{{ asset('css/app.css') }}" rel="stylesheet">
<!-- Common Styles - RTL -->
<link href="{{ asset('css/app-rtl.css') }}" rel="stylesheet">
<!-- Custom Styles -->
<link href="{{ asset('css/custom.css') }}" rel="stylesheet">
<!-- jQuery -->
<script src="{{ asset('js/jquery-3.6.1.min.js') }}"></script>
<!-- js-cookie -->
<script src="{{ asset('js/js.cookie.min.js') }}"></script>
<!-- Other JS - RTL-->
<script src="{{ asset('js/other-rtl.js') }}"></script>
<!-- Other JS -->
<script src="{{ asset('js/other.js') }}"></script>
<!-- Lazy Load -->
<script src="{{ asset('js/jquery.lazy.min.js') }}"></script>
<!-- notificationManager -->
<script src="{{ asset('js/notificationManager.js') }}"></script>

@stack('assets_header')

@isset($localBusiness){!! $localBusiness->toScript() !!}@endif

@if (\Request::is("*$settings[detail_base]/*"))
<link href="{{ asset('css/ol.css') }}" rel="stylesheet">
<script src="{{ asset('js/ol.js') }}"></script>
@endif

@if(!empty($settings['meta_theme_color']))
<meta name="theme-color" content="{{ $settings['meta_theme_color'] }}">
@endisset

@if ($settings['infinite_scroll'] == '1')
<!-- Infinite Scroll -->
<script src="{{ asset('js/infinite-scroll.pkgd.min.js') }}"></script>
@endif

@if ($settings['enable_google_recaptcha'] == '1')
<!-- Google reCAPTCHA -->
<script src="https://www.google.com/recaptcha/api.js" async defer></script>
@endif

@if ($settings['enable_pwa'] == '1')
<script type="module">
    import 'https://cdn.jsdelivr.net/npm/@pwabuilder/pwaupdate';
   const el = document.createElement('pwa-update');
   document.body.appendChild(el);
</script>

<link rel="manifest" href="{{ asset('manifest.json') }}">
@endif

@if (!empty($settings['ga_tracking_id']))
<!-- Global site tag (gtag.js) - Google Analytics -->
<script async src="https://www.googletagmanager.com/gtag/js?id={{$settings['ga_tracking_id']}}"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag('js', new Date());

  gtag('config', '{{$settings['ga_tracking_id']}}');
</script>
@endif

@if (!empty($settings['ga_publisher_id']))
<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-{{$settings['ga_publisher_id']}}" crossorigin="anonymous"></script>
@endif

{!!$settings['before_head_tag']!!}