@extends('rtl-frontend::page')

@section('content')

@push('assets_header')
<!-- Bootstrap Select -->
<link rel="stylesheet" href="{{ asset('css/bootstrap-select.min.css') }}">

@endpush

@push('assets_footer')
<!-- Bootstrap Bundle -->
<script src="{{ asset('js/bootstrap.bundle.min.js') }}"></script>

<!-- Bootstrap Select -->
<script src="{{ asset('js/bootstrap-select.min.js') }}"></script>
@endpush

@foreach ($languages as $language)
@php $language_code[$language->id]=strtoupper($language->code); @endphp
@endforeach

<!-- Container -->
<main class="container">

    <!-- Grid Row -->
    <div class="row member-area mt-3">

        <div class="col-md-3 menu">

            <div class="bg-white shadow-sm rounded p-2 pb-0">
                <!-- Left Column -->
                @include('rtl-frontend::inc.partials', ['type' => '3'])
                <!-- /Left Column -->
            </div>

        </div>

        <div class="col-md-9 mb-3">

            <div class="bg-white shadow-sm rounded p-2">

                <div class="p-1">

                    @if(count($errors) > 0)
                    <div class="alert alert-danger login-alert" role="alert">
                        @foreach($errors->all() as $error)
                        <p><b>@lang('general.error'):</b> {{$error}}</p>
                        @endforeach
                    </div>
                    @endif

                    @if(Session::has('success'))
                    <div class="alert alert-success login-alert mb-0">
                        <p>@if(Session::has('bank_payment_details')) @lang('general.bank_payment_submission_thanks', ['link' => asset($language_prefix.'member-area/payment-notification/'.Session::get('bank_payment_details').'')]) @else {{ Session::get('success') }} @endif</p>
                    </div>

                    @else

                    <form method="POST" enctype="multipart/form-data" action="{{ asset($language_prefix.'member-area/submit-link') }}">
                        @csrf

                        <input type="hidden" name="package_id" value="{{$package_query->id}}">

                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.title') <span class="text-danger">*</span></label>
                            <input type="text" name="title" class="form-control" value="{{ old('title') }}">
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.url') <span class="text-danger">*</span></label>
                            <input type="text" name="url" class="form-control" value="{{ old('url') }}">
                        </div>

                        @if($package_query->visible_url=='1')
                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.visible_url')</label>
                            <input type="text" name="visible_url" class="form-control" value="{{ old('visible_url') }}">
                        </div>
                        @endif

                        @if($package_query->bypass_redirect=='1')
                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.bypass_redirect')</label><br />
                            <input type="checkbox" class="form-check-input" id="bypass_redirect" name="bypass_redirect" {{ old('bypass_redirect') == "on" ? 'checked' : '' }}>
                        </div>
                        @endif

                        @if($package_query->bypass_details=='1')
                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.bypass_details')</label><br />
                            <input type="checkbox" class="form-check-input" id="bypass_details" name="bypass_details" {{ old('bypass_details') == "on" ? 'checked' : '' }}>
                        </div>
                        @endif

                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.description') <span class="text-danger">*</span></label>
                            <textarea class="form-control" name="description" rows="3">{{ old('description') }}</textarea>
                        </div>

                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.category') <span class="text-danger">*</span></label>
                        <select class="selectpicker form-control" name="categories[]" data-live-search="true" data-live-search="true" id="multi-categories" multiple="multiple" required="required">
                                @foreach($submission_categories as $category)
                                <option value="{{ $category->id }}" data-lang="{{ $category->language }}" @if (old("categories")){{ (in_array($category->id, old("categories")) ? "selected":"") }}@endif>[{{$language_code[$category->language]}}] {{ $category->title }}</option>

                                @foreach($category->children as $submenu)
                                <option value="{{ $submenu->id }}" data-lang="{{ $category->language }}" @if (old("categories")){{ (in_array($submenu->id, old("categories")) ? "selected":"") }}@endif>[{{$language_code[$category->language]}}] {{ $category->title }} › {{ $submenu->title }}</option>

                                @endforeach

                                @endforeach
                            </select>
                        </div>
                        
                        <script>
                            $('#multi-categories').on('loaded.bs.select', function(e) {
                                var value = $('option:selected', this).attr('data-lang');
                                var selectedOptions = jQuery('#multi-categories option:selected');

                                if (selectedOptions.length > 0) {
                                    $("#multi-categories [data-lang!='" + value + "']").attr("disabled", "true");
                                    $('#multi-categories').selectpicker('refresh');
                                } else {
                                    $("#multi-categories [data-lang!='" + value + "']").removeAttr("disabled", "true");
                                    $('#multi-categories').selectpicker('refresh');
                                }

                            });
                            $('#multi-categories').on('changed.bs.select', function(e) {
                                var value = $('option:selected', this).attr('data-lang');

                                var selectedOptions = jQuery('#multi-categories option:selected');

                                if (selectedOptions.length > 0) {
                                    $("#multi-categories [data-lang!='" + value + "']").attr("disabled", "true");
                                    $('#multi-categories').selectpicker('refresh');
                                } else {
                                    $("#multi-categories [data-lang!='" + value + "']").removeAttr("disabled", "true");
                                    $('#multi-categories').selectpicker('refresh');
                                }
                            });

                        </script>

                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.site_icon_description')@if($settings['optional_submission_icon']=='0') <span class="text-danger">*</span>@endif</label>
                            <input class="form-control" type="file" id="image" name="image">
                        </div>

                        @if($package_query->phone_number=='1')
                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.phone_number')</label>
                            <input type="text" name="phone_number" class="form-control" value="{{ old('phone_number') }}">
                        </div>
                        @endif

                        @if($package_query->email=='1')
                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.email')</label>
                            <input type="text" name="email" class="form-control" value="{{ old('email') }}">
                        </div>
                        @endif

                        @if($package_query->address=='1')
                        <div class="mb-3">
                            <label class="form-label fw-bold">@lang('general.address')</label>
                            <textarea class="form-control" name="address" rows="3">{{ old('address') }}</textarea>
                        </div>
                        @endif

                        @if($package_query->deep_links=='1')

                        <h6 class="mb-3 fw-bold submission-head-title">@lang('general.deep_links')</h6>

                        @for ($i = 1; $i < $package_query->deep_links_count+1; $i++)
                            <!-- row -->
                            <div class="row">

                                <div class="col-md-6 mb-3">
                                    <label class="form-label fw-bold">@lang('admin.deep_link') {{$i}} @lang('admin.title')</label>
                                    <input type="text" name="deep_link_{{$i}}_title" class="form-control" value="{{ old('deep_link_'.$i.'_title') }}" />
                                </div>

                                <div class="col-md-6 mb-3">
                                    <label class="form-label fw-bold">@lang('admin.deep_link') {{$i}} @lang('admin.url')</label>
                                    <input type="text" name="deep_link_{{$i}}_url" class="form-control" value="{{ old('deep_link_'.$i.'_url') }}" />
                                </div>

                            </div>
                            <!-- /.row -->

                            @endfor

                            @endif

                            @if($package_query->other_contacts=='1')

                            <h6 class="mb-3 fw-bold submission-head-title">@lang('general.other_contacts')</h6>

                            <!-- row -->
                            <div class="row">

                                <div class="col-md-4 mb-3">
                                    <label class="form-label fw-bold">@lang('admin.facebook_url')</label>
                                    <input type="text" name="facebook_url" class="form-control" value="{{old('facebook_url')}}" />
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label class="form-label fw-bold">@lang('admin.twitter_url')</label>
                                    <input type="text" name="twitter_url" class="form-control" value="{{old('twitter_url')}}" />
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label class="form-label fw-bold">@lang('admin.instagram_url')</label>
                                    <input type="text" name="instagram_url" class="form-control" value="{{old('instagram_url')}}" />
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label class="form-label fw-bold">@lang('admin.linkedin_url')</label>
                                    <input type="text" name="linkedin_url" class="form-control" value="{{old('linkedin_url')}}" />
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label class="form-label fw-bold">@lang('admin.whatsapp_number')</label>
                                    <input type="text" name="whatsapp_number" class="form-control" value="{{old('whatsapp_number')}}" />
                                </div>

                                <div class="col-md-4 mb-3">
                                    <label class="form-label fw-bold">@lang('admin.telegram_url')</label>
                                    <input type="text" name="telegram_url" class="form-control" value="{{old('telegram_url')}}" />
                                </div>

                            </div>
                            <!-- /.row -->

                            @endif

                            @if($package_query->reciprocal_link=='1')

                            <div class="mb-3">
                                <label class="form-label fw-bold">@lang('general.reciprocal_link') <span class="text-danger">*</span></label>
                                <input type="text" name="reciprocal_link" class="form-control" value="{{ old('reciprocal_link') }}">
                            </div>

                            <div class="mb-3">
                                <label class="form-label fw-bold">@lang('general.reciprocal_link_code')</label>
                                <div class="clearfix"></div>
                                <small class="text-muted">@lang('general.reciprocal_link_notice')</small>
                                <textarea class="form-control mt-3" name="reciprocal_link_code" rows="3" onClick="this.select();" readonly>{{ $settings['reciprocal_link_code'] }}</textarea>
                            </div>

                            @endif

                            @if($package_query->price != '0.00')

                            <h6 class="mb-3 fw-bold submission-head-title">@lang('general.payment_method')</h6>

                            <div class="d-block my-3">

                                @foreach($payment_methods as $payment)
                                @if(($payment->subscription == '0' || $package_query->duration != '0') && ($payment->id != '3' || $package_query->price >= '0.5'))
                                <div class="custom-control mb-1 custom-radio">
                                    <input id="p_{{$payment->id}}" name="payment" type="radio" class="form-check-input" value="{{$payment->id}}" {{ old('payment') == $payment->id ? 'checked' : '' }}>
                                    <label class="custom-control-label" for="p_{{$payment->id}}">@lang('general.'.$payment->title)</label>
                                </div>
                                @endif
                                @endforeach

                            </div>

                            @endif

                            <button class="btn update-btn" type="submit">@lang('general.submit')</button>

                    </form>

                    @endif

                </div>
            </div>

        </div>

    </div>
    <!-- /Grid row -->

</main>
<!-- /Container -->

@endsection