(function(f) {
    if (typeof exports === "object" && typeof module !== "undefined") {
        module.exports = f()
    } else if (typeof define === "function" && define.amd) {
        define([], f)
    } else {
        var g;
        if (typeof window !== "undefined") {
            g = window
        } else if (typeof global !== "undefined") {
            g = global
        } else if (typeof self !== "undefined") {
            g = self
        } else {
            g = this
        }
        g.kbpgp = f()
    }
})(function() {
    var define, module, exports;
    return (function() {
        function e(t, n, r) {
            function s(o, u) {
                if (!n[o]) {
                    if (!t[o]) {
                        var a = typeof require == "function" && require;
                        if (!u && a) return a(o, !0);
                        if (i) return i(o, !0);
                        var f = new Error("Cannot find module '" + o + "'");
                        throw f.code = "MODULE_NOT_FOUND", f
                    }
                    var l = n[o] = {
                        exports: {}
                    };
                    t[o][0].call(l.exports, function(e) {
                        var n = t[o][1][e];
                        return s(n ? n : e)
                    }, l, l.exports, e, t, n, r)
                }
                return n[o].exports
            }
            var i = typeof require == "function" && require;
            for (var o = 0; o < r.length; o++) s(r[o]);
            return s
        }
        return e
    })()({
        1: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var C, DSA, ECDH, ECDSA, EDDSA, ElGamal, RSA, get_class;

                C = require('./const').openpgp.public_key_algorithms;

                RSA = require('./rsa').RSA;

                DSA = require('./dsa').DSA;

                ElGamal = require('./elgamal').ElGamal;

                ECDSA = require('./ecc/ecdsa').ECDSA;

                ECDH = require('./ecc/ecdh').ECDH;

                EDDSA = require('./ecc/eddsa').EDDSA;

                get_class = function(n) {
                    switch (n) {
                        case C.RSA:
                        case C.RSA_ENCRYPT_ONLY:
                        case C.RSA_SIGN_ONLY:
                            return RSA;
                        case C.ELGAMAL:
                            return ElGamal;
                        case C.DSA:
                            return DSA;
                        case C.ECDSA:
                            return ECDSA;
                        case C.ECDH:
                            return ECDH;
                        case C.EDDSA:
                            return EDDSA;
                        default:
                            throw new Error("unknown public key system: " + n);
                    }
                };

                module.exports = {
                    get_class: get_class,
                    RSA: RSA,
                    DSA: DSA,
                    ElGamal: ElGamal
                };

            }).call(this);

        }, {
            "./const": 5,
            "./dsa": 6,
            "./ecc/ecdh": 9,
            "./ecc/ecdsa": 10,
            "./ecc/eddsa": 11,
            "./elgamal": 13,
            "./rsa": 69
        }],
        2: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var BaseKey, BaseKeyPair, C, K, SHA256, SHA512, SRF, bn, bufeq_secure, iced, konst, __iced_k, __iced_k_noop, _ref;

                    iced = require('iced-runtime');
                    __iced_k = __iced_k_noop = function() {};

                    konst = require('./const');

                    C = konst.openpgp;

                    K = konst.kb;

                    _ref = require('./hash'), SHA256 = _ref.SHA256, SHA512 = _ref.SHA512;

                    bn = require('./bn');

                    bufeq_secure = require('pgp-utils').util.bufeq_secure;

                    SRF = require('./rand').SRF;

                    exports.BaseKey = BaseKey = (function() {
                        function BaseKey() {}

                        BaseKey.alloc = function(klass, raw, d) {
                            var err, o, orig_len, _i, _len, _ref1, _ref2;
                            if (d == null) {
                                d = {};
                            }
                            orig_len = raw.length;
                            err = null;
                            _ref1 = klass.ORDER;
                            for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                                o = _ref1[_i];
                                if (err == null) {
                                    _ref2 = bn.mpi_from_buffer(raw), err = _ref2[0], d[o] = _ref2[1], raw = _ref2[2];
                                }
                            }
                            if (err) {
                                return [err, null];
                            } else {
                                return [null, new klass(d), orig_len - raw.length];
                            }
                        };

                        BaseKey.prototype.serialize = function() {
                            var e;
                            return Buffer.concat((function() {
                                var _i, _len, _ref1, _results;
                                _ref1 = this.ORDER;
                                _results = [];
                                for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                                    e = _ref1[_i];
                                    _results.push(this[e].to_mpi_buffer());
                                }
                                return _results;
                            }).call(this));
                        };

                        BaseKey.prototype.validity_check = function(cb) {
                            return cb(null);
                        };

                        return BaseKey;

                    })();

                    exports.BaseKeyPair = BaseKeyPair = (function() {
                        function BaseKeyPair(_arg) {
                            this.priv = _arg.priv, this.pub = _arg.pub;
                            this.pub.parent = this;
                            if (this.priv != null) {
                                this.priv.parent = this;
                            }
                        }

                        BaseKeyPair.prototype.serialize = function() {
                            return this.pub.serialize();
                        };

                        BaseKeyPair.prototype.hash = function() {
                            return SHA256(this.serialize());
                        };

                        BaseKeyPair.prototype.ekid = function() {
                            return Buffer.concat([new Buffer([K.kid.version, this.get_type()]), this.hash(), new Buffer([K.kid.trailer])]);
                        };

                        BaseKeyPair.prototype.can_sign = function() {
                            return this.priv != null;
                        };

                        BaseKeyPair.prototype.can_decrypt = function() {
                            return this.priv != null;
                        };

                        BaseKeyPair.prototype.has_private = function() {
                            return this.priv != null;
                        };

                        BaseKeyPair.prototype.fulfills_flags = function(flags) {
                            return false;
                        };

                        BaseKeyPair.prototype.is_toxic = function() {
                            return false;
                        };

                        BaseKeyPair.prototype.nbits = function() {
                            var _ref1;
                            return (_ref1 = this.pub) != null ? _ref1.nbits() : void 0;
                        };

                        BaseKeyPair.prototype.good_for_flags = function() {
                            return C.key_flags.encrypt_comm | C.key_flags.encrypt_storage | C.key_flags.certify_keys | C.key_flags.sign_data;
                        };

                        BaseKeyPair.prototype.eq = function(k2) {
                            return (this.type === k2.type) && (bufeq_secure(this.serialize(), k2.serialize()));
                        };

                        BaseKeyPair.prototype.can_perform = function(ops_mask) {
                            if ((ops_mask & konst.ops.sign) && !this.can_sign()) {
                                return false;
                            } else if ((ops_mask & konst.ops.decrypt) && !this.can_decrypt()) {
                                return false;
                            } else {
                                return true;
                            }
                        };

                        BaseKeyPair.parse = function(klass, pub_raw) {
                            var err, key, len, _ref1;
                            _ref1 = klass.Pub.alloc(pub_raw), err = _ref1[0], key = _ref1[1], len = _ref1[2];
                            if (key != null) {
                                key = new klass({
                                    pub: key
                                });
                            }
                            return [err, key, len];
                        };

                        BaseKeyPair.parse_kb = function(klass, pub_raw) {
                            var err, key, len, _ref1;
                            _ref1 = klass.Pub.alloc_kb(pub_raw), err = _ref1[0], key = _ref1[1], len = _ref1[2];
                            if (key != null) {
                                key = new klass({
                                    pub: key
                                });
                            }
                            return [err, key, len];
                        };

                        BaseKeyPair.prototype.add_priv = function(priv_raw) {
                            var err, len, _ref1;
                            _ref1 = Priv.alloc(priv_raw), err = _ref1[0], this.priv = _ref1[1], len = _ref1[2];
                            return [err, len];
                        };

                        BaseKeyPair.alloc = function(klass, _arg) {
                            var err, priv, pub, _ref1, _ref2;
                            pub = _arg.pub, priv = _arg.priv;
                            _ref1 = klass.Pub.alloc(pub), err = _ref1[0], pub = _ref1[1];
                            if ((err == null) && (priv != null)) {
                                _ref2 = klass.Priv.alloc(priv, pub), err = _ref2[0], priv = _ref2[1];
                            }
                            if (err != null) {
                                return [err, null];
                            } else {
                                return [
                                    null, new klass({
                                        priv: priv,
                                        pub: pub
                                    })
                                ];
                            }
                        };

                        BaseKeyPair.prototype.read_priv = function(raw_priv) {
                            var err, _ref1;
                            _ref1 = this.Priv.alloc(raw_priv, this.pub), err = _ref1[0], this.priv = _ref1[1];
                            return err;
                        };

                        BaseKeyPair.prototype.find = function(i) {
                            return i.mod(this.max_value());
                        };

                        BaseKeyPair.prototype.hide = function(_arg, cb) {
                            var L, err, i, max, n, r, r_bits, ret, slosh, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            i = _arg.i, max = _arg.max, slosh = _arg.slosh;
                            ret = err = null;
                            n = this.max_value();
                            (function(_this) {
                                return (function(__iced_k) {
                                    if ((L = n.bitLength()) > max) {
                                        return __iced_k(err = new Error("Can't hide > " + max + " bits; got " + L));
                                    } else {
                                        r_bits = (max - L) + slosh;
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/Users/max/src/keybase/kbpgp/src/basekeypair.iced",
                                                funcname: "BaseKeyPair.hide"
                                            });
                                            SRF().random_nbit(r_bits, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        return r = arguments[0];
                                                    };
                                                })(),
                                                lineno: 127
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(function() {
                                            return __iced_k(ret = r.multiply(n).add(i));
                                        });
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err, ret);
                                };
                            })(this));
                        };

                        BaseKeyPair.prototype.validity_check = function(cb) {
                            return this.pub.validity_check(cb);
                        };

                        BaseKeyPair.prototype._dsa_verify_update_and_check_hash = function(_arg, cb) {
                            var data, err, hash, hasher, klass, sig, v, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref1;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            sig = _arg.sig, data = _arg.data, hasher = _arg.hasher, hash = _arg.hash, klass = _arg.klass;
                            err = null;
                            if (Buffer.isBuffer(sig)) {
                                _ref1 = klass.read_sig_from_buf(sig), err = _ref1[0], sig = _ref1[1];
                            }
                            hash || (hash = hasher(data));
                            (function(_this) {
                                return (function(__iced_k) {
                                    if (sig.length !== 2) {
                                        return __iced_k(err = new Error("Need an [r,s] pair for a DSA-style signature"));
                                    } else {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/Users/max/src/keybase/kbpgp/src/basekeypair.iced",
                                                funcname: "BaseKeyPair._dsa_verify_update_and_check_hash"
                                            });
                                            _this.pub.verify(sig, hash, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        err = arguments[0];
                                                        return v = arguments[1];
                                                    };
                                                })(),
                                                lineno: 148
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(__iced_k);
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err);
                                };
                            })(this));
                        };

                        return BaseKeyPair;

                    })();

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "./bn": 4,
            "./const": 5,
            "./hash": 16,
            "./rand": 67,
            "buffer": 126,
            "iced-runtime": 183,
            "pgp-utils": 229
        }],
        3: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var BaseX, BigInteger, base32, base58, buffer_to_ui8a, nbi, nbs, nbv, _ref;

                    _ref = require('bn'), nbv = _ref.nbv, nbi = _ref.nbi, BigInteger = _ref.BigInteger;

                    nbs = require('./bn').nbs;

                    buffer_to_ui8a = require('./util').buffer_to_ui8a;

                    BaseX = (function() {
                        function BaseX(alphabet) {
                            var a, i, _i, _len, _ref1;
                            this.alphabet = alphabet;
                            this.base = this.alphabet.length;
                            this.basebn = nbv(this.base);
                            this.lookup = {};
                            _ref1 = this.alphabet;
                            for (i = _i = 0, _len = _ref1.length; _i < _len; i = ++_i) {
                                a = _ref1[i];
                                this.lookup[a] = i;
                            }
                        }

                        BaseX.prototype.encode = function(buffer) {
                            var c, chars, num, pad, q, r, _i, _len;
                            num = nbi().fromBuffer(buffer);
                            chars = (function() {
                                var _ref1, _results;
                                _results = [];
                                while (num.compareTo(BigInteger.ZERO) > 0) {
                                    _ref1 = num.divideAndRemainder(this.basebn), q = _ref1[0], r = _ref1[1];
                                    c = this.alphabet[r.intValue()];
                                    num = q;
                                    _results.push(c);
                                }
                                return _results;
                            }).call(this);
                            chars.reverse();
                            pad = [];
                            for (_i = 0, _len = buffer.length; _i < _len; _i++) {
                                c = buffer[_i];
                                if (c === 0) {
                                    pad.push(this.alphabet[0]);
                                } else {
                                    break;
                                }
                            }
                            return (pad.concat(chars)).join('');
                        };

                        BaseX.prototype.decode = function(str) {
                            var base, c, char_index, i, num, pad, start, _i, _j, _len, _ref1;
                            num = BigInteger.ZERO;
                            base = BigInteger.ONE;
                            i = 0;
                            for (i = _i = 0, _len = str.length; _i < _len; i = ++_i) {
                                c = str[i];
                                if (c !== this.alphabet[0]) {
                                    break;
                                }
                            }
                            start = i;
                            pad = new Buffer((function() {
                                var _j, _results;
                                _results = [];
                                for (i = _j = 0; 0 <= start ? _j < start : _j > start; i = 0 <= start ? ++_j : --_j) {
                                    _results.push(0);
                                }
                                return _results;
                            })());
                            _ref1 = str.slice(start);
                            for (i = _j = _ref1.length - 1; _j >= 0; i = _j += -1) {
                                c = _ref1[i];
                                if ((char_index = this.lookup[c]) == null) {
                                    throw new Error('Value passed is not a valid BaseX string.');
                                }
                                num = num.add(base.multiply(nbv(char_index)));
                                base = base.multiply(this.basebn);
                            }
                            return Buffer.concat([pad, new Buffer(num.toByteArray())]);
                        };

                        return BaseX;

                    })();

                    exports.base58 = base58 = new BaseX('123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz');

                    exports.base32 = base32 = new BaseX('abcdefghijkmnpqrstuvwxyz23456789');

                    exports.base91 = new BaseX("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789`~!@#$%^&*()-_=+{}[]|;:,<>./?");

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "./bn": 4,
            "./util": 72,
            "bn": 90,
            "buffer": 126
        }],
        4: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var BigInteger, bn_from_left_n_bits, buffer_shift_right, buffer_to_ui8a, mpi_byte_length, mpi_from_buffer, mpi_to_padded_octets, nbi, nbits, nbs, nbv, toMPI, _ref;

                    _ref = require('bn'), nbv = _ref.nbv, nbi = _ref.nbi, BigInteger = _ref.BigInteger, nbits = _ref.nbits;

                    buffer_to_ui8a = require('./util').buffer_to_ui8a;

                    nbs = function(s, base) {
                        var r;
                        if (base == null) {
                            base = 10;
                        }
                        r = nbi();
                        return r.fromString(s, base);
                    };

                    mpi_byte_length = function(bn) {
                        return bn.toByteArray().length;
                    };

                    toMPI = function(bn) {
                        var ba, hdr, size;
                        ba = bn.toByteArray();
                        size = (ba.length - 1) * 8 + nbits(ba[0]);
                        hdr = new Buffer(2);
                        hdr.writeUInt16BE(size, 0);
                        return Buffer.concat([hdr, new Buffer(ba)]);
                    };

                    mpi_from_buffer = function(raw) {
                        var err, hdr, i, n_bits, n_bytes;
                        err = i = null;
                        if (raw.length < 2) {
                            err = new Error("need at least 2 bytes; got " + raw.length);
                        } else {
                            hdr = new Buffer(raw.slice(0, 2));
                            raw = raw.slice(2);
                            n_bits = hdr.readUInt16BE(0);
                            n_bytes = Math.ceil(n_bits / 8);
                            if (raw.length < n_bytes) {
                                err = new Error("MPI said " + n_bytes + " bytes but only got " + raw.length);
                            } else {
                                i = nbi().fromBuffer(raw.slice(0, n_bytes));
                                raw = raw.slice(n_bytes);
                            }
                        }
                        return [err, i, raw, n_bytes + 2];
                    };

                    mpi_to_padded_octets = function(bn, base) {
                        var ba, diff, i, n, pad;
                        n = base.mpi_byte_length();
                        ba = bn.toByteArray();
                        diff = n - ba.length;
                        pad = new Buffer((function() {
                            var _i, _results;
                            _results = [];
                            for (i = _i = 0; 0 <= diff ? _i < diff : _i > diff; i = 0 <= diff ? ++_i : --_i) {
                                _results.push(0);
                            }
                            return _results;
                        })());
                        return Buffer.concat([pad, new Buffer(ba)]);
                    };

                    buffer_shift_right = function(buf, nbits) {
                        var c, i, l, mask, nbytes, nxt, rem, _i, _ref1;
                        nbytes = nbits >> 3;
                        rem = nbits % 8;
                        buf = buf.slice(0, buf.length - nbytes);
                        l = buf.length;
                        mask = (1 << rem) - 1;
                        for (i = _i = _ref1 = l - 1; _ref1 <= 0 ? _i <= 0 : _i >= 0; i = _ref1 <= 0 ? ++_i : --_i) {
                            c = buf.readUInt8(i) >> rem;
                            if (i > 0) {
                                nxt = buf.readUInt8(i - 1) & mask;
                                c |= nxt << (8 - rem);
                            }
                            buf.writeUInt8(c, i);
                        }
                        return buf;
                    };

                    bn_from_left_n_bits = function(raw, bits) {
                        var buf, bytes, rem, ret;
                        if (raw.length * 8 <= bits) {
                            return nbi().fromBuffer(raw);
                        } else {
                            rem = bits % 8;
                            bytes = (bits >> 3) + (rem ? 1 : 0);
                            buf = raw.slice(0, bytes);
                            ret = nbi().fromBuffer(buf);
                            if (rem > 0) {
                                ret = ret.shiftRight(8 - rem);
                            }
                            return ret;
                        }
                    };

                    exports.toMPI = toMPI;

                    exports.nbs = nbs;

                    exports.mpi_from_buffer = mpi_from_buffer;

                    exports.mpi_to_padded_octets = mpi_to_padded_octets;

                    exports.buffer_shift_right = buffer_shift_right;

                    exports.bn_from_left_n_bits = bn_from_left_n_bits;

                    BigInteger.prototype.to_mpi_buffer = function() {
                        return toMPI(this);
                    };

                    BigInteger.prototype.mpi_byte_length = function() {
                        return mpi_byte_length(this);
                    };

                    BigInteger.prototype.to_padded_octets = function(base) {
                        return mpi_to_padded_octets(this, base);
                    };

                    exports.BigInteger = BigInteger;

                    exports.nbi = nbi;

                    exports.nbv = nbv;

                    exports.nbits = nbits;

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "./util": 72,
            "bn": 90,
            "buffer": 126
        }],
        5: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var config, k, openpgp, v;

                exports.openpgp = openpgp = {
                    public_key_algorithms: {
                        RSA: 1,
                        RSA_ENCRYPT_ONLY: 2,
                        RSA_SIGN_ONLY: 3,
                        ELGAMAL: 16,
                        DSA: 17,
                        ECDH: 18,
                        ECDSA: 19,
                        ELGAMAL_SIGN_AND_ENCRYPT: 20,
                        EDDSA: 22
                    },
                    symmetric_key_algorithms: {
                        CAST5: 3,
                        AES128: 7,
                        AES192: 8,
                        AES256: 9
                    },
                    hash_algorithms: {
                        MD5: 1,
                        SHA1: 2,
                        RIPEMD160: 3,
                        SHA256: 8,
                        SHA384: 9,
                        SHA512: 10,
                        SHA224: 11
                    },
                    sig_subpacket: {
                        creation_time: 2,
                        expiration_time: 3,
                        exportable_certificate: 4,
                        trust_signature: 5,
                        regular_expression: 6,
                        revocable: 7,
                        key_expiration_time: 9,
                        preferred_symmetric_algorithms: 11,
                        revocation_key: 12,
                        issuer: 16,
                        notation_data: 20,
                        preferred_hash_algorithms: 21,
                        preferred_compression_algorithms: 22,
                        key_server_preferences: 23,
                        preferred_key_server: 24,
                        primary_user_id: 25,
                        policy_uri: 26,
                        key_flags: 27,
                        signers_user_id: 28,
                        reason_for_revocation: 29,
                        features: 30,
                        signature_target: 31,
                        embedded_signature: 32,
                        issuer_fingerprint: 33,
                        experimental_low: 101,
                        experimental_high: 110
                    },
                    sig_types: {
                        binary_doc: 0x00,
                        canonical_text: 0x01,
                        issuer: 0x10,
                        persona: 0x11,
                        casual: 0x12,
                        positive: 0x13,
                        subkey_binding: 0x18,
                        primary_binding: 0x19,
                        direct: 0x1f,
                        key_revocation: 0x20,
                        subkey_revocation: 0x28,
                        certificate_revocation: 0x30
                    },
                    message_types: {
                        generic: 0,
                        public_key: 4,
                        private_key: 5,
                        signature: 8,
                        clearsign: 9
                    },
                    s2k: {
                        plain: 0,
                        salt: 1,
                        salt_iter: 3,
                        gnu: 101,
                        gnu_dummy: 1001
                    },
                    s2k_convention: {
                        none: 0,
                        checksum: 255,
                        sha1: 254
                    },
                    ecdh: {
                        param_bytes: 3,
                        version: 1
                    },
                    packet_tags: {
                        PKESK: 1,
                        signature: 2,
                        one_pass_sig: 4,
                        secret_key: 5,
                        public_key: 6,
                        secret_subkey: 7,
                        compressed: 8,
                        literal: 11,
                        public_subkey: 14,
                        userid: 13,
                        user_attribute: 17,
                        SEIPD: 18,
                        MDC: 19
                    },
                    literal_formats: {
                        binary: 0x62,
                        text: 0x74,
                        utf8: 0x75
                    },
                    versions: {
                        PKESK: 3,
                        SEIPD: 1,
                        one_pass_sig: 3,
                        keymaterial: {
                            V4: 4
                        },
                        signature: {
                            V2: 2,
                            V3: 3,
                            V4: 4
                        }
                    },
                    signatures: {
                        key: 0x99,
                        userid: 0xb4,
                        user_attribute: 0xd1
                    },
                    key_flags: {
                        certify_keys: 0x1,
                        sign_data: 0x2,
                        encrypt_comm: 0x4,
                        encrypt_storage: 0x8,
                        private_split: 0x10,
                        auth: 0x20,
                        shared: 0x80
                    },
                    features: {
                        modification_detection: 0x1
                    },
                    key_server_preferences: {
                        no_modify: 0x80
                    },
                    compression: {
                        none: 0,
                        zip: 1,
                        zlib: 2,
                        bzip: 3
                    }
                };

                exports.kb = {
                    key_encryption: {
                        none: 0,
                        triplesec_v1: 1,
                        triplesec_v2: 2,
                        triplesec_v3: 3
                    },
                    packet_tags: {
                        p3skb: 0x201,
                        signature: 0x202,
                        encryption: 0x203
                    },
                    public_key_algorithms: {
                        NACL_EDDSA: 0x20,
                        NACL_DH: 0x21
                    },
                    versions: {
                        V1: 1
                    },
                    padding: {
                        EMSA_PCKS1_v1_5: 3,
                        RSASSA_PSS: 4
                    },
                    key_defaults: {
                        primary: {
                            expire_in: 0,
                            nbits: {
                                RSA: 4096,
                                ECDSA: 384,
                                DSA: 2048
                            }
                        },
                        sub: {
                            expire_in: 24 * 60 * 60 * 365 * 8,
                            nbits: {
                                RSA: 2048,
                                ECDH: 256,
                                ECDSA: 256,
                                DSA: 2048,
                                ELGAMAL: 2048
                            }
                        }
                    },
                    kid: {
                        version: 1,
                        trailer: 0x0a,
                        algo: 8,
                        len: 32
                    }
                };

                exports.ops = {
                    encrypt: 0x1,
                    decrypt: 0x2,
                    verify: 0x4,
                    sign: 0x8
                };

                exports.header = {
                    version: "Keybase OpenPGP",
                    comment: "https://keybase.io/crypto"
                };

                config = {
                    default_key_expire_in: 24 * 60 * 60 * 365 * 4
                };

                for (k in config) {
                    v = config[k];
                    exports[k] = v;
                }

            }).call(this);

        }, {}],
        6: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var ASP, BaseKey, BaseKeyPair, BigInteger, C, K, MRF, Pair, Priv, Pub, SRF, bn, bufeq_secure, iced, konst, make_esc, nbits, nbv, __iced_k, __iced_k_noop, _ref, _ref1, _ref2, _ref3,
                        __hasProp = {}.hasOwnProperty,
                        __extends = function(child, parent) {
                            for (var key in parent) {
                                if (__hasProp.call(parent, key)) child[key] = parent[key];
                            }

                            function ctor() {
                                this.constructor = child;
                            }
                            ctor.prototype = parent.prototype;
                            child.prototype = new ctor();
                            child.__super__ = parent.prototype;
                            return child;
                        };

                    iced = require('iced-runtime');
                    __iced_k = __iced_k_noop = function() {};

                    bn = require('./bn');

                    nbits = bn.nbits, nbv = bn.nbv, BigInteger = bn.BigInteger;

                    _ref = require('./rand'), SRF = _ref.SRF, MRF = _ref.MRF;

                    _ref1 = require('./util'), bufeq_secure = _ref1.bufeq_secure, ASP = _ref1.ASP;

                    make_esc = require('iced-error').make_esc;

                    konst = require('./const');

                    C = konst.openpgp;

                    K = konst.kb;

                    _ref2 = require('./basekeypair'), BaseKey = _ref2.BaseKey, BaseKeyPair = _ref2.BaseKeyPair;

                    _ref3 = require('./rand'), SRF = _ref3.SRF, MRF = _ref3.MRF;

                    Pub = (function(_super) {
                        __extends(Pub, _super);

                        Pub.type = C.public_key_algorithms.DSA;

                        Pub.prototype.type = Pub.type;

                        Pub.ORDER = ['p', 'q', 'g', 'y'];

                        Pub.prototype.ORDER = Pub.ORDER;

                        function Pub(_arg) {
                            this.p = _arg.p, this.q = _arg.q, this.g = _arg.g, this.y = _arg.y;
                        }

                        Pub.alloc = function(raw) {
                            return BaseKey.alloc(Pub, raw);
                        };

                        Pub.prototype.trunc_hash = function(h) {
                            return bn.bn_from_left_n_bits(h, this.q.bitLength());
                        };

                        Pub.prototype.nbits = function() {
                            var _ref4;
                            return (_ref4 = this.p) != null ? _ref4.bitLength() : void 0;
                        };

                        Pub.prototype.verify = function(_arg, h, cb) {
                            var err, hi, r, s, u1, u2, v, w;
                            r = _arg[0], s = _arg[1];
                            err = null;
                            hi = this.trunc_hash(h);
                            w = s.modInverse(this.q);
                            u1 = hi.multiply(w).mod(this.q);
                            u2 = r.multiply(w).mod(this.q);
                            v = this.g.modPow(u1, this.p).multiply(this.y.modPow(u2, this.p)).mod(this.p).mod(this.q);
                            if (!v.equals(r)) {
                                err = new Error("verification failed");
                            }
                            return cb(err);
                        };

                        return Pub;

                    })(BaseKey);

                    Priv = (function(_super) {
                        __extends(Priv, _super);

                        Priv.ORDER = ['x'];

                        Priv.prototype.ORDER = Priv.ORDER;

                        function Priv(_arg) {
                            this.x = _arg.x, this.pub = _arg.pub;
                        }

                        Priv.alloc = function(raw, pub) {
                            return BaseKey.alloc(Priv, raw, {
                                pub: pub
                            });
                        };

                        Priv.prototype.sign = function(h, cb) {
                            var err, g, hi, k, p, q, r, s, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref4;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            err = null;
                            _ref4 = this.pub, p = _ref4.p, q = _ref4.q, g = _ref4.g;
                            hi = this.pub.trunc_hash(h);
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/dsa.iced",
                                        funcname: "Priv.sign"
                                    });
                                    SRF().random_zn(q.subtract(bn.nbv(2)), __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return k = arguments[0];
                                            };
                                        })(),
                                        lineno: 76
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    k = k.add(bn.BigInteger.ONE);
                                    r = g.modPow(k, p).mod(q);
                                    s = (k.modInverse(q).multiply(hi.add(_this.x.multiply(r)))).mod(q);
                                    return cb([r, s]);
                                };
                            })(this));
                        };

                        return Priv;

                    })(BaseKey);

                    Pair = (function(_super) {
                        __extends(Pair, _super);

                        Pair.Pub = Pub;

                        Pair.prototype.Pub = Pub;

                        Pair.Priv = Priv;

                        Pair.prototype.Priv = Priv;

                        Pair.type = C.public_key_algorithms.DSA;

                        Pair.prototype.type = Pair.type;

                        Pair.prototype.get_type = function() {
                            return this.type;
                        };

                        Pair.klass_name = "DSA";

                        function Pair(_arg) {
                            var priv, pub;
                            pub = _arg.pub, priv = _arg.priv;
                            Pair.__super__.constructor.call(this, {
                                pub: pub,
                                priv: priv
                            });
                        }

                        Pair.parse = function(pub_raw) {
                            return BaseKeyPair.parse(Pair, pub_raw);
                        };

                        Pair.prototype.can_encrypt = function() {
                            return false;
                        };

                        Pair.prototype.fulfills_flags = function(flags) {
                            var good_for;
                            good_for = this.good_for_flags();
                            return (flags & good_for) === flags;
                        };

                        Pair.prototype.good_for_flags = function() {
                            return C.key_flags.certify_keys | C.key_flags.sign_data;
                        };

                        Pair.prototype.verify_unpad_and_check_hash = function(_arg, cb) {
                            var data, hash, hasher, sig;
                            sig = _arg.sig, data = _arg.data, hasher = _arg.hasher, hash = _arg.hash;
                            return this._dsa_verify_update_and_check_hash({
                                sig: sig,
                                data: data,
                                hasher: hasher,
                                hash: hash,
                                klass: Pair
                            }, cb);
                        };

                        Pair.prototype.pad_and_sign = function(data, _arg, cb) {
                            var h, hasher, s, sig, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            hasher = _arg.hasher;
                            hasher || (hasher = SHA512);
                            h = hasher(data);
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/dsa.iced",
                                        funcname: "Pair.pad_and_sign"
                                    });
                                    _this.priv.sign(h, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return sig = arguments[0];
                                            };
                                        })(),
                                        lineno: 128
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(null, Buffer.concat((function() {
                                        var _i, _len, _results;
                                        _results = [];
                                        for (_i = 0, _len = sig.length; _i < _len; _i++) {
                                            s = sig[_i];
                                            _results.push(s.to_mpi_buffer());
                                        }
                                        return _results;
                                    })()));
                                };
                            })(this));
                        };

                        Pair.parse_sig = function(slice) {
                            var buf, err, n, ret, _ref4;
                            buf = slice.peek_rest_to_buffer();
                            _ref4 = Pair.read_sig_from_buf(buf), err = _ref4[0], ret = _ref4[1], n = _ref4[2];
                            if (err != null) {
                                throw err;
                            }
                            slice.advance(n);
                            return ret;
                        };

                        Pair.read_sig_from_buf = function(buf) {
                            var err, n, o, order, orig_len, ret, x;
                            orig_len = buf.length;
                            order = ['r', 's'];
                            err = null;
                            ret = (function() {
                                var _i, _len, _ref4, _results;
                                _results = [];
                                for (_i = 0, _len = order.length; _i < _len; _i++) {
                                    o = order[_i];
                                    if (!(err == null)) {
                                        continue;
                                    }
                                    _ref4 = bn.mpi_from_buffer(buf), err = _ref4[0], x = _ref4[1], buf = _ref4[2];
                                    _results.push(x);
                                }
                                return _results;
                            })();
                            n = orig_len - buf.length;
                            return [err, ret, n];
                        };

                        return Pair;

                    })(BaseKeyPair);

                    exports.DSA = exports.Pair = Pair;

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "./basekeypair": 2,
            "./bn": 4,
            "./const": 5,
            "./rand": 67,
            "./util": 72,
            "buffer": 126,
            "iced-error": 179,
            "iced-runtime": 183
        }],
        7: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var BaseEccKey, SlicerBuffer, alloc_by_name, alloc_by_nbits, alloc_by_oid, iced, __iced_k, __iced_k_noop, _ref;

                    iced = require('iced-runtime');
                    __iced_k = __iced_k_noop = function() {};

                    SlicerBuffer = require('../openpgp/buffer').SlicerBuffer;

                    _ref = require('./curves'), alloc_by_nbits = _ref.alloc_by_nbits, alloc_by_oid = _ref.alloc_by_oid, alloc_by_name = _ref.alloc_by_name;

                    exports.BaseEccKey = BaseEccKey = (function() {
                        function BaseEccKey(_arg) {
                            this.curve = _arg.curve, this.R = _arg.R;
                        }

                        BaseEccKey.prototype.serialize = function() {
                            var oid;
                            oid = this.curve.oid;
                            return Buffer.concat([new Buffer([oid.length]), oid, this.curve.point_to_mpi_buffer(this.R)]);
                        };

                        BaseEccKey._alloc = function(klass, raw) {
                            var R, curve, err, l, len, oid, pre, pub, sb, _ref1, _ref2;
                            sb = new SlicerBuffer(raw);
                            pre = sb.rem();
                            l = sb.read_uint8();
                            oid = sb.read_buffer(l);
                            _ref1 = alloc_by_oid(oid), err = _ref1[0], curve = _ref1[1];
                            if (err != null) {
                                throw err;
                            }
                            _ref2 = curve.mpi_point_from_slicer_buffer(sb), err = _ref2[0], R = _ref2[1];
                            if (err != null) {
                                throw err;
                            }
                            pub = new klass({
                                curve: curve,
                                R: R
                            });
                            pub.read_params(sb);
                            len = pre - sb.rem();
                            return [pub, len];
                        };

                        BaseEccKey.alloc = function(klass, raw) {
                            var e, err, len, pub, _ref1;
                            pub = len = err = null;
                            try {
                                _ref1 = BaseEccKey._alloc(klass, raw), pub = _ref1[0], len = _ref1[1];
                            } catch (_error) {
                                e = _error;
                                err = e;
                            }
                            return [err, pub, len];
                        };

                        BaseEccKey.prototype.validity_check = function(cb) {
                            return cb(null);
                        };

                        return BaseEccKey;

                    })();

                    exports.generate = function(_arg, cb) {
                        var Pair, R, asp, curve, curve_name, err, nbits, priv, pub, ret, x, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref1, _ref2;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        nbits = _arg.nbits, asp = _arg.asp, curve_name = _arg.curve_name, Pair = _arg.Pair;
                        ret = null;
                        if (curve_name) {
                            _ref1 = alloc_by_name(curve_name), err = _ref1[0], curve = _ref1[1];
                        } else {
                            _ref2 = alloc_by_nbits(nbits), err = _ref2[0], curve = _ref2[1];
                        }
                        (function(_this) {
                            return (function(__iced_k) {
                                if (err == null) {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/Users/max/src/keybase/kbpgp/src/ecc/base.iced",
                                            funcname: "generate"
                                        });
                                        curve.generate(__iced_deferrals.defer({
                                            assign_fn: (function() {
                                                return function() {
                                                    x = arguments[0].x;
                                                    return R = arguments[0].R;
                                                };
                                            })(),
                                            lineno: 58
                                        }));
                                        __iced_deferrals._fulfill();
                                    })(function() {
                                        pub = new Pair.Pub({
                                            curve: curve,
                                            R: R
                                        });
                                        priv = new Pair.Priv({
                                            pub: pub,
                                            x: x
                                        });
                                        return __iced_k(ret = new Pair({
                                            pub: pub,
                                            priv: priv
                                        }));
                                    });
                                } else {
                                    return __iced_k();
                                }
                            });
                        })(this)((function(_this) {
                            return function() {
                                return cb(err, ret);
                            };
                        })(this));
                    };

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../openpgp/buffer": 37,
            "./curves": 8,
            "buffer": 126,
            "iced-runtime": 183
        }],
        8: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var BigInteger, Curve, Curve25519, H, OIDS, OID_LOOKUP, OID_NAMES, SRF, SlicerBuffer, base, bn, brainpool_p256, brainpool_p384, brainpool_p512, cv25519, iced, k, kbnacl, nist_p256, nist_p384, nist_p521, uint_to_buffer, v, __iced_k, __iced_k_noop,
                        __hasProp = {}.hasOwnProperty,
                        __extends = function(child, parent) {
                            for (var key in parent) {
                                if (__hasProp.call(parent, key)) child[key] = parent[key];
                            }

                            function ctor() {
                                this.constructor = child;
                            }
                            ctor.prototype = parent.prototype;
                            child.prototype = new ctor();
                            child.__super__ = parent.prototype;
                            return child;
                        };

                    iced = require('iced-runtime');
                    __iced_k = __iced_k_noop = function() {};

                    BigInteger = require('../bn').BigInteger;

                    base = require('keybase-ecurve');

                    uint_to_buffer = require('../util').uint_to_buffer;

                    SlicerBuffer = require('../openpgp/buffer').SlicerBuffer;

                    SRF = require('../rand').SRF;

                    bn = require('../bn');

                    kbnacl = require('keybase-nacl');

                    exports.H = H = function(x) {
                        return BigInteger.fromHex(x.split(/\s+/).join(''));
                    };

                    exports.Curve = Curve = (function(_super) {
                        __extends(Curve, _super);

                        function Curve(_arg) {
                            var Gx, Gy, a, b, h, n, p;
                            p = _arg.p, a = _arg.a, b = _arg.b, Gx = _arg.Gx, Gy = _arg.Gy, n = _arg.n, h = _arg.h, this.oid = _arg.oid;
                            h || (h = BigInteger.ONE);
                            Curve.__super__.constructor.call(this, p, a, b, Gx, Gy, n, h);
                        }

                        Curve.prototype.mkpoint = function(_arg) {
                            var x, y;
                            x = _arg.x, y = _arg.y;
                            return base.Point.fromAffine(this, x, y);
                        };

                        Curve.prototype.nbits = function() {
                            return this.p.bitLength();
                        };

                        Curve.prototype.mpi_bit_size = function() {
                            return 2 * this.mpi_coord_bit_size() + 3;
                        };

                        Curve.prototype.mpi_byte_size = function() {
                            return Math.ceil(this.mpi_bit_size() / 8);
                        };

                        Curve.prototype.mpi_coord_byte_size = function() {
                            return Math.ceil(this.nbits() / 8);
                        };

                        Curve.prototype.mpi_coord_bit_size = function() {
                            return this.mpi_coord_byte_size() * 8;
                        };

                        Curve.prototype._mpi_point_from_slicer_buffer = function(sb) {
                            var b, bits, coord_bytes, n_bits, n_bytes, point, x, y, _ref;
                            n_bits = sb.read_uint16();
                            n_bytes = Math.ceil(n_bits / 8);
                            if (n_bytes !== (b = this.mpi_byte_size())) {
                                bits = this.mpi_bit_size();
                                throw new Error("Need " + b + " bytes (" + bits + " bits) for this curve; got " + n_bytes + " (" + n_bits + " bits)");
                            }
                            if (sb.read_uint8() !== 0x4) {
                                throw new Error("Can only handle 0x4 prefix for MPI representations");
                            }
                            coord_bytes = this.mpi_coord_byte_size();
                            _ref = [BigInteger.fromBuffer(sb.read_buffer(coord_bytes)), BigInteger.fromBuffer(sb.read_buffer(coord_bytes))], x = _ref[0], y = _ref[1];
                            point = this.mkpoint({
                                x: x,
                                y: y
                            });
                            if (!this.isOnCurve(point)) {
                                throw new Error("Given ECC point isn't on the given curve; data corruption detected.");
                            }
                            return [null, point];
                        };

                        Curve.prototype.mpi_point_from_buffer = function(b) {
                            return this.mpi_point_from_slicer_buffer(new SlicerBuffer(b));
                        };

                        Curve.prototype.mpi_point_from_slicer_buffer = function(sb) {
                            var e, err, point, _ref;
                            err = point = null;
                            try {
                                _ref = this._mpi_point_from_slicer_buffer(sb), err = _ref[0], point = _ref[1];
                            } catch (_error) {
                                e = _error;
                                err = e;
                            }
                            return [err, point];
                        };

                        Curve.prototype.point_to_mpi_buffer_compact = function(p) {
                            return p.affineX.toBuffer(this.mpi_coord_byte_size());
                        };

                        Curve.prototype.point_to_mpi_buffer = function(p) {
                            var ret, sz;
                            sz = this.mpi_coord_byte_size();
                            ret = Buffer.concat([uint_to_buffer(16, this.mpi_bit_size()), new Buffer([0x4]), p.affineX.toBuffer(sz), p.affineY.toBuffer(sz)]);
                            return ret;
                        };

                        Curve.prototype.random_scalar = function(cb) {
                            var k, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/ecc/curves.iced",
                                        funcname: "Curve.random_scalar"
                                    });
                                    SRF().random_zn(_this.n.subtract(bn.nbv(2)), __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return k = arguments[0];
                                            };
                                        })(),
                                        lineno: 103
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    k = k.add(bn.BigInteger.ONE);
                                    return cb(k);
                                };
                            })(this));
                        };

                        Curve.prototype.coord_to_mpi_buffer = function(p) {
                            var byte_size;
                            byte_size = this.mpi_coord_byte_size();
                            return Buffer.concat([uint_to_buffer(16, byte_size * 8), p.toBuffer(byte_size)]);
                        };

                        Curve.prototype.mpi_from_buffer = function(raw) {
                            return bn.mpi_from_buffer(raw);
                        };

                        Curve.prototype.encrypt = function(R, cb) {
                            var G, S, V, n, v, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            n = this.n, G = this.G;
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/ecc/curves.iced",
                                        funcname: "Curve.encrypt"
                                    });
                                    _this.random_scalar(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return v = arguments[0];
                                            };
                                        })(),
                                        lineno: 134
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    V = G.multiply(v);
                                    S = R.multiply(v);
                                    return cb({
                                        V: V,
                                        S: S
                                    });
                                };
                            })(this));
                        };

                        Curve.prototype.decrypt = function(x, V) {
                            return V.multiply(x);
                        };

                        Curve.prototype.generate = function(cb) {
                            var R, x, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/ecc/curves.iced",
                                        funcname: "Curve.generate"
                                    });
                                    _this.random_scalar(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return x = arguments[0];
                                            };
                                        })(),
                                        lineno: 157
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    R = _this.G.multiply(x);
                                    return cb({
                                        x: x,
                                        R: R
                                    });
                                };
                            })(this));
                        };

                        return Curve;

                    })(base.Curve);

                    exports.Curve25519 = Curve25519 = (function(_super) {
                        __extends(Curve25519, _super);

                        function Curve25519(_arg) {
                            this.oid = _arg.oid;
                        }

                        Curve25519.prototype.nbits = function() {
                            return 256;
                        };

                        Curve25519.prototype.mpi_bit_size = function() {
                            return 263;
                        };

                        Curve25519.prototype._mpi_point_from_slicer_buffer = function(sb) {
                            var b, bits, n_bits, n_bytes, point;
                            n_bits = sb.read_uint16();
                            n_bytes = Math.ceil(n_bits / 8);
                            if (n_bytes !== (b = this.mpi_byte_size())) {
                                bits = this.mpi_bit_size();
                                throw new Error("Need " + b + " bytes (" + bits + " bits) for this curve; got " + n_bytes + " (" + n_bits + " bits)");
                            }
                            if (sb.read_uint8() !== 0x40) {
                                throw new Error("Can only handle 0x40 prefix for 25519 MPI representations");
                            }
                            n_bytes = this.mpi_coord_byte_size();
                            point = sb.read_buffer(n_bytes);
                            return [null, point];
                        };

                        Curve25519.prototype.point_to_mpi_buffer_compact = function(p) {
                            return p;
                        };

                        Curve25519.prototype.point_to_mpi_buffer = function(p) {
                            var ret, sz;
                            sz = this.mpi_coord_byte_size();
                            ret = Buffer.concat([uint_to_buffer(16, this.mpi_bit_size()), new Buffer([0x40]), p]);
                            return ret;
                        };

                        Curve25519.prototype.random_scalar = function(cb) {
                            return SRF().random_bytes(this.mpi_coord_byte_size(), cb);
                        };

                        Curve25519.prototype.coord_to_mpi_buffer = function(p) {
                            var byte_size;
                            byte_size = this.mpi_coord_byte_size();
                            return Buffer.concat([uint_to_buffer(16, byte_size * 8), p]);
                        };

                        Curve25519.prototype.mpi_from_buffer = function(raw) {
                            var err, hdr, i, n_bits, n_bytes;
                            err = i = null;
                            if (raw.length < 2) {
                                err = new Error("need at least 2 bytes; got " + raw.length);
                            } else {
                                hdr = new Buffer(raw.slice(0, 2));
                                raw = raw.slice(2);
                                n_bits = hdr.readUInt16BE(0);
                                n_bytes = Math.ceil(n_bits / 8);
                                if (raw.length < n_bytes) {
                                    err = new Error("MPI said " + n_bytes + " bytes but only got " + raw.length);
                                } else {
                                    i = raw.slice(0, n_bytes);
                                    raw = raw.slice(n_bytes);
                                }
                            }
                            return [err, i, raw, n_bytes + 2];
                        };

                        Curve25519.prototype.encrypt = function(R, cb) {
                            var S, V, nacl, v, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/ecc/curves.iced",
                                        funcname: "Curve25519.encrypt"
                                    });
                                    _this.random_scalar(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return v = arguments[0];
                                            };
                                        })(),
                                        lineno: 257
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    nacl = kbnacl.alloc({});
                                    V = nacl.scalarmult_base(v);
                                    S = nacl.scalarmult(v, R);
                                    return cb({
                                        V: V,
                                        S: S
                                    });
                                };
                            })(this));
                        };

                        Curve25519.reverse_buf = function(buf) {
                            var X, i, _i, _ref;
                            X = new Buffer(buf.length);
                            for (i = _i = 0, _ref = buf.length; 0 <= _ref ? _i < _ref : _i > _ref; i = 0 <= _ref ? ++_i : --_i) {
                                X[buf.length - 1 - i] = buf[i];
                            }
                            return X;
                        };

                        Curve25519.prototype.decrypt = function(x, V) {
                            var S;
                            x = Curve25519.reverse_buf(x);
                            S = kbnacl.alloc({}).scalarmult(x, V);
                            return S;
                        };

                        Curve25519.prototype.generate = function(cb) {
                            var R, x, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/ecc/curves.iced",
                                        funcname: "Curve25519.generate"
                                    });
                                    _this.random_scalar(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return x = arguments[0];
                                            };
                                        })(),
                                        lineno: 291
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    R = kbnacl.alloc({}).scalarmult_base(x);
                                    x = Curve25519.reverse_buf(x);
                                    return cb({
                                        x: x,
                                        R: R
                                    });
                                };
                            })(this));
                        };

                        return Curve25519;

                    })(Curve);

                    exports.nist_p256 = nist_p256 = function() {
                        var Gx, Gy, a, b, n, p;
                        p = H("FFFFFFFF 00000001 00000000 00000000 00000000 FFFFFFFF FFFFFFFF FFFFFFFF");
                        a = H("FFFFFFFF 00000001 00000000 00000000 00000000 FFFFFFFF FFFFFFFF FFFFFFFC");
                        b = H("5AC635D8 AA3A93E7 B3EBBD55 769886BC 651D06B0 CC53B0F6 3BCE3C3E 27D2604B");
                        n = H("FFFFFFFF 00000000 FFFFFFFF FFFFFFFF BCE6FAAD A7179E84 F3B9CAC2 FC632551");
                        Gx = H("6B17D1F2 E12C4247 F8BCE6E5 63A440F2 77037D81 2DEB33A0 F4A13945 D898C296");
                        Gy = H("4FE342E2 FE1A7F9B 8EE7EB4A 7C0F9E16 2BCE3357 6B315ECE CBB64068 37BF51F5");
                        return new Curve({
                            p: p,
                            a: a,
                            b: b,
                            Gx: Gx,
                            Gy: Gy,
                            n: n,
                            oid: OIDS.nist_p256
                        });
                    };

                    exports.nist_p384 = nist_p384 = function() {
                        var Gx, Gy, a, b, n, p;
                        p = H('ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe ffffffff 00000000 00000000 ffffffff');
                        a = H('ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffe ffffffff 00000000 00000000 fffffffc');
                        b = H('b3312fa7 e23ee7e4 988e056b e3f82d19 181d9c6e fe814112 0314088f 5013875a c656398d 8a2ed19d 2a85c8ed d3ec2aef');
                        n = H('ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff c7634d81 f4372ddf 581a0db2 48b0a77a ecec196a ccc52973');
                        Gx = H('aa87ca22 be8b0537 8eb1c71e f320ad74 6e1d3b62 8ba79b98 59f741e0 82542a38 5502f25d bf55296c 3a545e38 72760ab7');
                        Gy = H('3617de4a 96262c6f 5d9e98bf 9292dc29 f8f41dbd 289a147c e9da3113 b5f0b8c0 0a60b1ce 1d7e819d 7a431d7c 90ea0e5f');
                        return new Curve({
                            p: p,
                            a: a,
                            b: b,
                            Gx: Gx,
                            Gy: Gy,
                            n: n,
                            oid: OIDS.nist_p384
                        });
                    };

                    exports.nist_p521 = nist_p521 = function() {
                        var Gx, Gy, a, b, n, p;
                        p = H('000001ff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff');
                        a = H('000001ff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffc');
                        b = H('00000051 953eb961 8e1c9a1f 929a21a0 b68540ee a2da725b 99b315f3 b8b48991 8ef109e1 56193951 ec7e937b 1652c0bd 3bb1bf07 3573df88 3d2c34f1 ef451fd4 6b503f00');
                        n = H('000001ff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff ffffffff fffffffa 51868783 bf2f966b 7fcc0148 f709a5d0 3bb5c9b8 899c47ae bb6fb71e 91386409');
                        Gx = H('000000c6 858e06b7 0404e9cd 9e3ecb66 2395b442 9c648139 053fb521 f828af60 6b4d3dba a14b5e77 efe75928 fe1dc127 a2ffa8de 3348b3c1 856a429b f97e7e31 c2e5bd66');
                        Gy = H('00000118 39296a78 9a3bc004 5c8a5fb4 2c7d1bd9 98f54449 579b4468 17afbd17 273e662c 97ee7299 5ef42640 c550b901 3fad0761 353c7086 a272c240 88be9476 9fd16650');
                        return new Curve({
                            p: p,
                            a: a,
                            b: b,
                            Gx: Gx,
                            Gy: Gy,
                            n: n,
                            oid: OIDS.nist_p521
                        });
                    };

                    exports.brainpool_p256 = brainpool_p256 = function() {
                        var Gx, Gy, a, b, n, p;
                        p = H('a9fb57db a1eea9bc 3e660a90 9d838d72 6e3bf623 d5262028 2013481d 1f6e5377');
                        a = H('7d5a0975 fc2c3057 eef67530 417affe7 fb8055c1 26dc5c6c e94a4b44 f330b5d9');
                        b = H('26dc5c6c e94a4b44 f330b5d9 bbd77cbf 95841629 5cf7e1ce 6bccdc18 ff8c07b6');
                        n = H('a9fb57db a1eea9bc 3e660a90 9d838d71 8c397aa3 b561a6f7 901e0e82 974856a7');
                        Gx = H('8bd2aeb9 cb7e57cb 2c4b482f fc81b7af b9de27e1 e3bd23c2 3a4453bd 9ace3262');
                        Gy = H('547ef835 c3dac4fd 97f8461a 14611dc9 c2774513 2ded8e54 5c1d54c7 2f046997');
                        return new Curve({
                            p: p,
                            a: a,
                            b: b,
                            Gx: Gx,
                            Gy: Gy,
                            n: n,
                            oid: OIDS.brainpool_p256
                        });
                    };

                    exports.brainpool_p384 = brainpool_p384 = function() {
                        var Gx, Gy, a, b, n, p;
                        p = H('8cb91e82 a3386d28 0f5d6f7e 50e641df 152f7109 ed5456b4 12b1da19 7fb71123 acd3a729 901d1a71 87470013 3107ec53');
                        a = H('7bc382c6 3d8c150c 3c72080a ce05afa0 c2bea28e 4fb22787 139165ef ba91f90f 8aa5814a 503ad4eb 04a8c7dd 22ce2826');
                        b = H('04a8c7dd 22ce2826 8b39b554 16f0447c 2fb77de1 07dcd2a6 2e880ea5 3eeb62d5 7cb43902 95dbc994 3ab78696 fa504c11');
                        n = H('8cb91e82 a3386d28 0f5d6f7e 50e641df 152f7109 ed5456b3 1f166e6c ac0425a7 cf3ab6af 6b7fc310 3b883202 e9046565');
                        Gx = H('1d1c64f0 68cf45ff a2a63a81 b7c13f6b 8847a3e7 7ef14fe3 db7fcafe 0cbd10e8 e826e034 36d646aa ef87b2e2 47d4af1e');
                        Gy = H('8abe1d75 20f9c2a4 5cb1eb8e 95cfd552 62b70b29 feec5864 e19c054f f9912928 0e464621 77918111 42820341 263c5315');
                        return new Curve({
                            p: p,
                            a: a,
                            b: b,
                            Gx: Gx,
                            Gy: Gy,
                            n: n,
                            oid: OIDS.brainpool_p384
                        });
                    };

                    exports.brainpool_p512 = brainpool_p512 = function() {
                        var Gx, Gy, a, b, n, p;
                        p = H('aadd9db8 dbe9c48b 3fd4e6ae 33c9fc07 cb308db3 b3c9d20e d6639cca 70330871 7d4d9b00 9bc66842 aecda12a e6a380e6 2881ff2f 2d82c685 28aa6056 583a48f3');
                        a = H('7830a331 8b603b89 e2327145 ac234cc5 94cbdd8d 3df91610 a83441ca ea9863bc 2ded5d5a a8253aa1 0a2ef1c9 8b9ac8b5 7f1117a7 2bf2c7b9 e7c1ac4d 77fc94ca');
                        b = H('3df91610 a83441ca ea9863bc 2ded5d5a a8253aa1 0a2ef1c9 8b9ac8b5 7f1117a7 2bf2c7b9 e7c1ac4d 77fc94ca dc083e67 984050b7 5ebae5dd 2809bd63 8016f723');
                        n = H('aadd9db8 dbe9c48b 3fd4e6ae 33c9fc07 cb308db3 b3c9d20e d6639cca 70330870 553e5c41 4ca92619 41866119 7fac1047 1db1d381 085ddadd b5879682 9ca90069');
                        Gx = H('81aee4bd d82ed964 5a21322e 9c4c6a93 85ed9f70 b5d916c1 b43b62ee f4d0098e ff3b1f78 e2d0d48d 50d1687b 93b97d5f 7c6d5047 406a5e68 8b352209 bcb9f822');
                        Gy = H('7dde385d 566332ec c0eabfa9 cf7822fd f209f700 24a57b1a a000c55b 881f8111 b2dcde49 4a5f485e 5bca4bd8 8a2763ae d1ca2b2f a8f05406 78cd1e0f 3ad80892');
                        return new Curve({
                            p: p,
                            a: a,
                            b: b,
                            Gx: Gx,
                            Gy: Gy,
                            n: n,
                            oid: OIDS.brainpool_p512
                        });
                    };

                    exports.cv25519 = cv25519 = function() {
                        return new Curve25519({
                            oid: OIDS.cv25519
                        });
                    };

                    OIDS = {
                        nist_p256: new Buffer([0x2a, 0x86, 0x48, 0xce, 0x3d, 0x03, 0x01, 0x07]),
                        nist_p384: new Buffer([0x2b, 0x81, 0x04, 0x00, 0x22]),
                        nist_p521: new Buffer([0x2b, 0x81, 0x04, 0x00, 0x23]),
                        brainpool_p256: new Buffer([0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01, 0x07]),
                        brainpool_p384: new Buffer([0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01, 0x0B]),
                        brainpool_p512: new Buffer([0x2b, 0x24, 0x03, 0x03, 0x02, 0x08, 0x01, 0x01, 0x0D]),
                        cv25519: new Buffer([0x2b, 0x06, 0x01, 0x04, 0x01, 0x97, 0x55, 0x01, 0x05, 0x01])
                    };

                    OID_LOOKUP = {};

                    for (k in OIDS) {
                        v = OIDS[k];
                        OID_LOOKUP[v.toString('hex')] = exports[k];
                    }

                    OID_NAMES = {
                        'Curve25519': cv25519,
                        'NIST P-256': nist_p256,
                        'NIST P-384': nist_p384,
                        'brainpoolP256r1': brainpool_p256,
                        'brainpoolP384r1': brainpool_p384,
                        'brainpoolP512r1': brainpool_p512
                    };

                    for (k in OIDS) {
                        OID_NAMES[k] = exports[k];
                    }

                    exports.alloc_by_oid = function(oid) {
                        var curve, err, f;
                        if (Buffer.isBuffer(oid)) {
                            oid = oid.toString('hex');
                        }
                        err = curve = null;
                        if ((f = OID_LOOKUP[oid.toLowerCase()]) != null) {
                            curve = f();
                        } else {
                            err = new Error("Unknown curve OID: " + oid);
                        }
                        return [err, curve];
                    };

                    exports.alloc_by_nbits = function(nbits) {
                        var err, f, ret;
                        ret = err = null;
                        nbits || (nbits = 256);
                        f = (function() {
                            switch (nbits) {
                                case 256:
                                    return nist_p256;
                                case 384:
                                    return nist_p384;
                                case 521:
                                    return nist_p521;
                                default:
                                    return null;
                            }
                        })();
                        if (f != null) {
                            ret = f();
                        } else {
                            err = new Error("No curve for " + nbits + " bits");
                        }
                        return [err, ret];
                    };

                    exports.alloc_by_name = function(name) {
                        var a, curve, err;
                        err = curve = null;
                        if ((a = OID_NAMES[name]) != null) {
                            curve = a();
                        } else {
                            err = new Error("Unknown curve name: " + name);
                        }
                        return [err, curve];
                    };

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../bn": 4,
            "../openpgp/buffer": 37,
            "../rand": 67,
            "../util": 72,
            "buffer": 126,
            "iced-runtime": 183,
            "keybase-ecurve": 192,
            "keybase-nacl": 196
        }],
        9: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var ASP, BaseEccKey, BaseKey, BaseKeyPair, Const, Output, Pair, Priv, Pub, SlicerBuffer, bufeq_secure, ecc_pkcs5_pad_data, generate, hashmod, iced, konst, make_esc, sym, uint_to_buffer, unwrap, wrap, __iced_k, __iced_k_noop, _ref, _ref1, _ref2, _ref3,
                        __hasProp = {}.hasOwnProperty,
                        __extends = function(child, parent) {
                            for (var key in parent) {
                                if (__hasProp.call(parent, key)) child[key] = parent[key];
                            }

                            function ctor() {
                                this.constructor = child;
                            }
                            ctor.prototype = parent.prototype;
                            child.prototype = new ctor();
                            child.__super__ = parent.prototype;
                            return child;
                        };

                    iced = require('iced-runtime');
                    __iced_k = __iced_k_noop = function() {};

                    _ref = require('../util'), uint_to_buffer = _ref.uint_to_buffer, bufeq_secure = _ref.bufeq_secure, ASP = _ref.ASP;

                    make_esc = require('iced-error').make_esc;

                    konst = require('../const');

                    Const = konst.openpgp;

                    _ref1 = require('../basekeypair'), BaseKeyPair = _ref1.BaseKeyPair, BaseKey = _ref1.BaseKey;

                    ecc_pkcs5_pad_data = require('../pad').ecc_pkcs5_pad_data;

                    _ref2 = require('./base'), generate = _ref2.generate, BaseEccKey = _ref2.BaseEccKey;

                    hashmod = require('../hash');

                    sym = require('../symmetric');

                    SlicerBuffer = require('../openpgp/buffer').SlicerBuffer;

                    _ref3 = require('../rfc3394'), wrap = _ref3.wrap, unwrap = _ref3.unwrap;

                    Pub = (function(_super) {
                        __extends(Pub, _super);

                        function Pub() {
                            return Pub.__super__.constructor.apply(this, arguments);
                        }

                        Pub.type = Const.public_key_algorithms.ECDH;

                        Pub.prototype.type = Pub.type;

                        Pub.prototype.apply_defaults = function() {
                            this.cipher || (this.cipher = sym.get_cipher());
                            return this.hasher || (this.hasher = hashmod.SHA512);
                        };

                        Pub.prototype.read_params = function(sb) {
                            var n, size, v, val;
                            if ((size = sb.read_uint8()) < (n = Const.ecdh.param_bytes)) {
                                throw new Error("Need at least " + n + " bytes of params; got " + size);
                            }
                            if ((val = sb.read_uint8()) !== (v = Const.ecdh.version)) {
                                throw new Error("Cannot deal with future extensions, byte=" + val + "; wanted " + v);
                            }
                            this.hasher = hashmod.alloc_or_throw(sb.read_uint8());
                            this.cipher = sym.get_cipher(sb.read_uint8());
                            return sb.advance(size - 3);
                        };

                        Pub.alloc = function(raw) {
                            return BaseEccKey.alloc(Pub, raw);
                        };

                        Pub.prototype.serialize_params = function() {
                            return Buffer.concat([uint_to_buffer(8, Const.ecdh.param_bytes), uint_to_buffer(8, Const.ecdh.version), uint_to_buffer(8, this.hasher.type), uint_to_buffer(8, this.cipher.type)]);
                        };

                        Pub.prototype.serialize = function() {
                            return Buffer.concat([Pub.__super__.serialize.call(this), this.serialize_params()]);
                        };

                        Pub.prototype.format_params = function(_arg) {
                            var fingerprint;
                            fingerprint = _arg.fingerprint;
                            return Buffer.concat([uint_to_buffer(8, this.curve.oid.length), this.curve.oid, uint_to_buffer(8, this.type), this.serialize_params(), new Buffer("Anonymous Sender    ", "utf8"), fingerprint]);
                        };

                        Pub.prototype.kdf = function(_arg) {
                            var X, X_compact, buf, hash, o_bytes, params;
                            X = _arg.X, params = _arg.params;
                            o_bytes = this.cipher.key_size;
                            X_compact = this.curve.point_to_mpi_buffer_compact(X);
                            buf = Buffer.concat([new Buffer([0, 0, 0, 1]), X_compact, params]);
                            hash = this.hasher(buf);
                            return hash.slice(0, o_bytes);
                        };

                        Pub.prototype.encrypt = function(m, _arg, cb) {
                            var C, S, V, fingerprint, key, params, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            fingerprint = _arg.fingerprint;
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/ecc/ecdh.iced",
                                        funcname: "Pub.encrypt"
                                    });
                                    _this.curve.encrypt(_this.R, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                V = arguments[0].V;
                                                return S = arguments[0].S;
                                            };
                                        })(),
                                        lineno: 97
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    params = _this.format_params({
                                        fingerprint: fingerprint
                                    });
                                    key = _this.kdf({
                                        X: S,
                                        params: params
                                    });
                                    C = wrap({
                                        key: key,
                                        plaintext: m,
                                        cipher: _this.cipher
                                    });
                                    return cb({
                                        V: V,
                                        C: C
                                    });
                                };
                            })(this));
                        };

                        return Pub;

                    })(BaseEccKey);

                    Priv = (function(_super) {
                        __extends(Priv, _super);

                        Priv.ORDER = ['x'];

                        Priv.prototype.ORDER = Priv.ORDER;

                        function Priv(_arg) {
                            this.x = _arg.x, this.pub = _arg.pub;
                        }

                        Priv.prototype.serialize = function() {
                            var curve;
                            curve = this.pub.curve;
                            return curve.coord_to_mpi_buffer(this.x);
                        };

                        Priv.alloc = function(raw, pub) {
                            var curve, d, err, o, orig_len, _i, _len, _ref4, _ref5;
                            orig_len = raw.length;
                            err = null;
                            curve = pub.curve;
                            d = {
                                pub: pub
                            };
                            _ref4 = Priv.ORDER;
                            for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
                                o = _ref4[_i];
                                if (err == null) {
                                    _ref5 = curve.mpi_from_buffer(raw), err = _ref5[0], d[o] = _ref5[1], raw = _ref5[2];
                                }
                            }
                            if (err) {
                                return [err, null];
                            } else {
                                return [null, new Priv(d), orig_len - raw.length];
                            }
                        };

                        Priv.prototype.decrypt = function(c, _arg, cb) {
                            var S, V, curve, err, esc, fingerprint, key, params, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            fingerprint = _arg.fingerprint;
                            esc = make_esc(cb, "Priv::decrypt");
                            curve = this.pub.curve;
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/ecc/ecdh.iced",
                                        funcname: "Priv.decrypt"
                                    });
                                    c.load_V(curve, esc(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return V = arguments[0];
                                            };
                                        })(),
                                        lineno: 144
                                    })));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    var _ref4;
                                    S = curve.decrypt(_this.x, V);
                                    params = _this.pub.format_params({
                                        fingerprint: fingerprint
                                    });
                                    key = _this.pub.kdf({
                                        X: S,
                                        params: params
                                    });
                                    _ref4 = unwrap({
                                        key: key,
                                        ciphertext: c.C,
                                        cipher: _this.pub.cipher
                                    }), err = _ref4[0], ret = _ref4[1];
                                    return cb(err, ret);
                                };
                            })(this));
                        };

                        return Priv;

                    })(BaseKey);

                    Pair = (function(_super) {
                        __extends(Pair, _super);

                        function Pair() {
                            return Pair.__super__.constructor.apply(this, arguments);
                        }

                        Pair.Pub = Pub;

                        Pair.prototype.Pub = Pub;

                        Pair.Priv = Priv;

                        Pair.prototype.Priv = Priv;

                        Pair.type = Const.public_key_algorithms.ECDH;

                        Pair.prototype.type = Pair.type;

                        Pair.klass_name = "ECDH";

                        Pair.prototype.get_type = function() {
                            return this.type;
                        };

                        Pair.prototype.fulfills_flags = function(flags) {
                            var good_for;
                            good_for = Const.key_flags.encrypt_comm | Const.key_flags.encrypt_storage;
                            return (flags & good_for) === flags;
                        };

                        Pair.prototype.can_sign = function() {
                            return false;
                        };

                        Pair.parse = function(pub_raw) {
                            var ret;
                            ret = BaseKeyPair.parse(Pair, pub_raw);
                            return ret;
                        };

                        Pair.prototype.max_value = function() {
                            return this.pub.p;
                        };

                        Pair.prototype.pad_and_encrypt = function(data, _arg, cb) {
                            var C, V, err, fingerprint, m, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref4;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            fingerprint = _arg.fingerprint;
                            err = ret = null;
                            _ref4 = ecc_pkcs5_pad_data(data), err = _ref4[0], m = _ref4[1];
                            (function(_this) {
                                return (function(__iced_k) {
                                    if (err == null) {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/Users/max/src/keybase/kbpgp/src/ecc/ecdh.iced",
                                                funcname: "Pair.pad_and_encrypt"
                                            });
                                            _this.pub.encrypt(m, {
                                                fingerprint: fingerprint
                                            }, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        C = arguments[0].C;
                                                        return V = arguments[0].V;
                                                    };
                                                })(),
                                                lineno: 199
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(function() {
                                            return __iced_k(ret = _this.export_output({
                                                C: C,
                                                V: V,
                                                curve: _this.pub.curve
                                            }));
                                        });
                                    } else {
                                        return __iced_k();
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err, ret);
                                };
                            })(this));
                        };

                        Pair.prototype.decrypt_and_unpad = function(ciphertext, _arg, cb) {
                            var err, fingerprint, m, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            fingerprint = _arg.fingerprint;
                            err = ret = null;
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/ecc/ecdh.iced",
                                        funcname: "Pair.decrypt_and_unpad"
                                    });
                                    _this.priv.decrypt(ciphertext, {
                                        fingerprint: fingerprint
                                    }, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                err = arguments[0];
                                                return m = arguments[1];
                                            };
                                        })(),
                                        lineno: 207
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err, m, true);
                                };
                            })(this));
                        };

                        Pair.parse_output = function(buf) {
                            return Output.parse(buf);
                        };

                        Pair.prototype.export_output = function(args) {
                            return new Output(args);
                        };

                        Pair.generate = function(_arg, cb) {
                            var asp, curve_name, err, nbits, pair, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            nbits = _arg.nbits, curve_name = _arg.curve_name, asp = _arg.asp;
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/ecc/ecdh.iced",
                                        funcname: "Pair.generate"
                                    });
                                    generate({
                                        nbits: nbits,
                                        asp: asp,
                                        curve_name: curve_name,
                                        Pair: Pair
                                    }, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                err = arguments[0];
                                                return pair = arguments[1];
                                            };
                                        })(),
                                        lineno: 218
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    if (typeof err === "undefined" || err === null) {
                                        pair.pub.apply_defaults();
                                    }
                                    return cb(err, pair);
                                };
                            })(this));
                        };

                        return Pair;

                    })(BaseKeyPair);

                    Output = (function() {
                        function Output(_arg) {
                            this.V_buf = _arg.V_buf, this.C = _arg.C, this.V = _arg.V, this.curve = _arg.curve;
                        }

                        Output.prototype.load_V = function(curve, cb) {
                            var err, _ref4;
                            this.curve = curve;
                            _ref4 = curve.mpi_point_from_buffer(this.V_buf), err = _ref4[0], this.V = _ref4[1];
                            return cb(err, this.V);
                        };

                        Output.parse = function(buf) {
                            var C, V_buf, a, n_bits, n_bytes, ret, sb;
                            sb = new SlicerBuffer(buf);
                            n_bits = sb.read_uint16();
                            n_bytes = Math.ceil(n_bits / 8);
                            V_buf = Buffer.concat([buf.slice(0, 2), sb.read_buffer(n_bytes)]);
                            n_bytes = sb.read_uint8();
                            C = sb.consume_rest_to_buffer();
                            if ((a = C.length) !== n_bytes) {
                                throw new Error("bad C input: wanted " + n_bytes + " bytes, but got " + a);
                            }
                            ret = new Output({
                                V_buf: V_buf,
                                C: C
                            });
                            return ret;
                        };

                        Output.prototype.get_V_buf = function() {
                            if (this.V_buf == null) {
                                this.V_buf = this.curve.point_to_mpi_buffer(this.V);
                            }
                            return this.V_buf;
                        };

                        Output.prototype.hide = function(_arg, cb) {
                            var key, max, slosh;
                            key = _arg.key, max = _arg.max, slosh = _arg.slosh;
                            return cb(null);
                        };

                        Output.prototype.find = function(_arg) {
                            var key;
                            key = _arg.key;
                        };

                        Output.prototype.good_for_flags = function() {
                            return C.key_flags.encrypt_comm | C.key_flags.encrypt_storage;
                        };

                        Output.prototype.output = function() {
                            return Buffer.concat([this.get_V_buf(), uint_to_buffer(8, this.C.length), this.C]);
                        };

                        return Output;

                    })();

                    exports.ECDH = exports.Pair = Pair;

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../basekeypair": 2,
            "../const": 5,
            "../hash": 16,
            "../openpgp/buffer": 37,
            "../pad": 64,
            "../rfc3394": 68,
            "../symmetric": 70,
            "../util": 72,
            "./base": 7,
            "buffer": 126,
            "iced-error": 179,
            "iced-runtime": 183
        }],
        10: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var ASP, BaseEccKey, BaseKey, BaseKeyPair, BigInteger, C, ECDH, K, Pair, Priv, Pub, bn, bufeq_secure, generate, iced, konst, make_esc, nbits, nbv, uint_to_buffer, __iced_k, __iced_k_noop, _ref, _ref1, _ref2,
                        __hasProp = {}.hasOwnProperty,
                        __extends = function(child, parent) {
                            for (var key in parent) {
                                if (__hasProp.call(parent, key)) child[key] = parent[key];
                            }

                            function ctor() {
                                this.constructor = child;
                            }
                            ctor.prototype = parent.prototype;
                            child.prototype = new ctor();
                            child.__super__ = parent.prototype;
                            return child;
                        };

                    iced = require('iced-runtime');
                    __iced_k = __iced_k_noop = function() {};

                    bn = require('../bn');

                    nbits = bn.nbits, nbv = bn.nbv, BigInteger = bn.BigInteger;

                    _ref = require('../util'), uint_to_buffer = _ref.uint_to_buffer, bufeq_secure = _ref.bufeq_secure, ASP = _ref.ASP;

                    make_esc = require('iced-error').make_esc;

                    konst = require('../const');

                    C = konst.openpgp;

                    K = konst.kb;

                    _ref1 = require('../basekeypair'), BaseKeyPair = _ref1.BaseKeyPair, BaseKey = _ref1.BaseKey;

                    _ref2 = require('./base'), generate = _ref2.generate, BaseEccKey = _ref2.BaseEccKey;

                    ECDH = require('./ecdh').ECDH;

                    Pub = (function(_super) {
                        __extends(Pub, _super);

                        function Pub() {
                            return Pub.__super__.constructor.apply(this, arguments);
                        }

                        Pub.type = C.public_key_algorithms.ECDSA;

                        Pub.prototype.type = Pub.type;

                        Pub.prototype.nbits = function() {
                            return this.curve.nbits();
                        };

                        Pub.prototype.read_params = function(sb) {};

                        Pub.prototype.trunc_hash = function(h) {
                            return bn.bn_from_left_n_bits(h, this.nbits());
                        };

                        Pub.alloc = function(raw) {
                            return BaseEccKey.alloc(Pub, raw);
                        };

                        Pub.prototype.verify = function(_arg, h, cb) {
                            var err, hi, n, p, r, s, u1, u2, v, w;
                            r = _arg[0], s = _arg[1];
                            err = null;
                            hi = this.trunc_hash(h);
                            if ((r.signum() <= 0) || (r.compareTo(this.curve.p) > 0)) {
                                err = new Error("bad r");
                            } else if ((r.signum() <= 0) || (s.compareTo(this.curve.p) > 0)) {
                                err = new Error("bad s");
                            } else {
                                n = this.curve.n;
                                w = s.modInverse(n);
                                u1 = hi.multiply(w).mod(n);
                                u2 = r.multiply(w).mod(n);
                                p = this.curve.G.multiplyTwo(u1, this.R, u2);
                                v = p.affineX.mod(n);
                                if (!v.equals(r)) {
                                    err = new Error("verification failed");
                                }
                            }
                            return cb(err);
                        };

                        return Pub;

                    })(BaseEccKey);

                    Priv = (function(_super) {
                        __extends(Priv, _super);

                        Priv.ORDER = ['x'];

                        Priv.prototype.ORDER = Priv.ORDER;

                        function Priv(_arg) {
                            this.x = _arg.x, this.pub = _arg.pub;
                        }

                        Priv.alloc = function(raw, pub) {
                            return BaseKey.alloc(Priv, raw, {
                                pub: pub
                            });
                        };

                        Priv.prototype.sign = function(h, cb) {
                            var G, Q, err, hi, k, n, r, s, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref3;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            err = null;
                            _ref3 = this.pub.curve, n = _ref3.n, G = _ref3.G;
                            hi = this.pub.trunc_hash(h);
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/ecc/ecdsa.iced",
                                        funcname: "Priv.sign"
                                    });
                                    _this.pub.curve.random_scalar(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return k = arguments[0];
                                            };
                                        })(),
                                        lineno: 79
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    Q = G.multiply(k);
                                    r = Q.affineX.mod(n);
                                    if (r.signum() === 0) {
                                        throw new Error("invalid r-value");
                                    }
                                    s = k.modInverse(n).multiply(hi.add(_this.x.multiply(r))).mod(n);
                                    return cb([r, s]);
                                };
                            })(this));
                        };

                        return Priv;

                    })(BaseKey);

                    Pair = (function(_super) {
                        __extends(Pair, _super);

                        Pair.Pub = Pub;

                        Pair.prototype.Pub = Pub;

                        Pair.Priv = Priv;

                        Pair.prototype.Priv = Priv;

                        Pair.type = C.public_key_algorithms.ECDSA;

                        Pair.prototype.type = Pair.type;

                        Pair.klass_name = "ECDSA";

                        Pair.prototype.get_type = function() {
                            return this.type;
                        };

                        function Pair(_arg) {
                            var priv, pub;
                            pub = _arg.pub, priv = _arg.priv;
                            Pair.__super__.constructor.call(this, {
                                pub: pub,
                                priv: priv
                            });
                        }

                        Pair.parse = function(pub_raw) {
                            return BaseKeyPair.parse(Pair, pub_raw);
                        };

                        Pair.prototype.can_encrypt = function() {
                            return false;
                        };

                        Pair.subkey_algo = function(flags) {
                            if (flags & (C.key_flags.certify_keys | C.key_flags.sign_data)) {
                                return Pair;
                            } else {
                                return ECDH;
                            }
                        };

                        Pair.prototype.fulfills_flags = function(flags) {
                            var good_for;
                            good_for = C.key_flags.certify_keys | C.key_flags.sign_data;
                            return (flags & good_for) === flags;
                        };

                        Pair.prototype.verify_unpad_and_check_hash = function(_arg, cb) {
                            var data, hash, hasher, sig;
                            sig = _arg.sig, data = _arg.data, hasher = _arg.hasher, hash = _arg.hash;
                            return this._dsa_verify_update_and_check_hash({
                                sig: sig,
                                data: data,
                                hasher: hasher,
                                hash: hash,
                                klass: Pair
                            }, cb);
                        };

                        Pair.prototype.pad_and_sign = function(data, _arg, cb) {
                            var h, hasher, s, sig, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            hasher = _arg.hasher;
                            hasher || (hasher = SHA512);
                            h = hasher(data);
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/ecc/ecdsa.iced",
                                        funcname: "Pair.pad_and_sign"
                                    });
                                    _this.priv.sign(h, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return sig = arguments[0];
                                            };
                                        })(),
                                        lineno: 134
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(null, Buffer.concat((function() {
                                        var _i, _len, _results;
                                        _results = [];
                                        for (_i = 0, _len = sig.length; _i < _len; _i++) {
                                            s = sig[_i];
                                            _results.push(s.to_mpi_buffer());
                                        }
                                        return _results;
                                    })()));
                                };
                            })(this));
                        };

                        Pair.parse_sig = function(slice) {
                            var buf, err, n, ret, _ref3;
                            buf = slice.peek_rest_to_buffer();
                            _ref3 = Pair.read_sig_from_buf(buf), err = _ref3[0], ret = _ref3[1], n = _ref3[2];
                            if (err != null) {
                                throw err;
                            }
                            slice.advance(n);
                            return ret;
                        };

                        Pair.read_sig_from_buf = function(buf) {
                            var err, n, o, order, orig_len, ret, x;
                            orig_len = buf.length;
                            order = ['r', 's'];
                            err = null;
                            ret = (function() {
                                var _i, _len, _ref3, _results;
                                _results = [];
                                for (_i = 0, _len = order.length; _i < _len; _i++) {
                                    o = order[_i];
                                    if (!(err == null)) {
                                        continue;
                                    }
                                    _ref3 = bn.mpi_from_buffer(buf), err = _ref3[0], x = _ref3[1], buf = _ref3[2];
                                    _results.push(x);
                                }
                                return _results;
                            })();
                            n = orig_len - buf.length;
                            return [err, ret, n];
                        };

                        Pair.prototype.good_for_flags = function() {
                            return C.key_flags.certify_keys | C.key_flags.sign_data;
                        };

                        Pair.generate = function(_arg, cb) {
                            var asp, nbits;
                            nbits = _arg.nbits, asp = _arg.asp;
                            return generate({
                                nbits: nbits,
                                asp: asp,
                                Pair: Pair
                            }, cb);
                        };

                        return Pair;

                    })(BaseKeyPair);

                    exports.ECDSA = exports.Pair = Pair;

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../basekeypair": 2,
            "../bn": 4,
            "../const": 5,
            "../util": 72,
            "./base": 7,
            "./ecdh": 9,
            "buffer": 126,
            "iced-error": 179,
            "iced-runtime": 183
        }],
        11: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var BaseKey, BaseKeyPair, C, Pair, Priv, Pub, SRF, SlicerBuffer, iced, kbnacl, konst, uint_to_buffer, util, __iced_k, __iced_k_noop, _ref,
                        __hasProp = {}.hasOwnProperty,
                        __extends = function(child, parent) {
                            for (var key in parent) {
                                if (__hasProp.call(parent, key)) child[key] = parent[key];
                            }

                            function ctor() {
                                this.constructor = child;
                            }
                            ctor.prototype = parent.prototype;
                            child.prototype = new ctor();
                            child.__super__ = parent.prototype;
                            return child;
                        };

                    iced = require('iced-runtime');
                    __iced_k = __iced_k_noop = function() {};

                    kbnacl = require('keybase-nacl');

                    SlicerBuffer = require('../openpgp/buffer').SlicerBuffer;

                    uint_to_buffer = require('../util').uint_to_buffer;

                    _ref = require('../basekeypair'), BaseKeyPair = _ref.BaseKeyPair, BaseKey = _ref.BaseKey;

                    SRF = require('../rand').SRF;

                    util = require('../util');

                    konst = require('../const');

                    C = konst.openpgp;

                    Pub = (function(_super) {
                        __extends(Pub, _super);

                        Pub.type = C.public_key_algorithms.EDDSA;

                        Pub.prototype.type = Pub.type;

                        Pub.OID = new Buffer([0x2B, 0x06, 0x01, 0x04, 0x01, 0xDA, 0x47, 0x0F, 0x01]);

                        Pub.prototype.OID = Pub.OID;

                        Pub.MPI_LENGTH_HEADERS = new Buffer([0x1, 0x7, 0x40]);

                        Pub.prototype.MPI_LENGTH_HEADERS = Pub.MPI_LENGTH_HEADERS;

                        function Pub(_arg) {
                            this.key = _arg.key;
                        }

                        Pub.prototype.nbits = function() {
                            return 255;
                        };

                        Pub.prototype.read_params = function(sb) {};

                        Pub.prototype.trunc_hash = function(h) {
                            return bn.bn_from_left_n_bits(h, this.nbits());
                        };

                        Pub.prototype.serialize = function() {
                            var ret;
                            ret = Buffer.concat([new Buffer([this.OID.length]), this.OID, this.MPI_LENGTH_HEADERS, this.key]);
                            return ret;
                        };

                        Pub._alloc = function(raw) {
                            var expected, key, l, len, mpi_length_headers, oid, pre, pub, sb;
                            sb = new SlicerBuffer(raw);
                            pre = sb.rem();
                            l = sb.read_uint8();
                            oid = sb.read_buffer(l);
                            expected = Pub.OID;
                            if (!util.bufeq_secure(oid, expected)) {
                                throw new Error("Wrong OID in EdDSA key");
                            }
                            mpi_length_headers = sb.read_buffer(Pub.MPI_LENGTH_HEADERS.length);
                            if (!util.bufeq_secure(mpi_length_headers, Pub.MPI_LENGTH_HEADERS)) {
                                throw new Error("Wrong MPI length headers");
                            }
                            key = sb.read_buffer(kbnacl.sign.publicKeyLength);
                            pub = new Pub({
                                key: key
                            });
                            len = pre - sb.rem();
                            return [pub, len];
                        };

                        Pub.alloc = function(raw) {
                            var e, err, len, pub, _ref1;
                            pub = len = err = null;
                            try {
                                _ref1 = Pub._alloc(raw), pub = _ref1[0], len = _ref1[1];
                            } catch (_error) {
                                e = _error;
                                err = e;
                            }
                            return [err, pub, len];
                        };

                        Pub.prototype.verify = function(_arg, payload, cb) {
                            var err, naclw, r, s, sig, _, _ref1;
                            r = _arg[0], s = _arg[1];
                            naclw = kbnacl.alloc({
                                publicKey: this.key
                            });
                            r = util.fit_to_size(kbnacl.sign.signatureLength / 2, r);
                            s = util.fit_to_size(kbnacl.sign.signatureLength / 2, s);
                            sig = Buffer.concat([r, s]);
                            _ref1 = naclw.verify({
                                payload: payload,
                                sig: sig,
                                detached: true
                            }), err = _ref1[0], _ = _ref1[1];
                            return cb(err);
                        };

                        return Pub;

                    })(BaseKey);

                    Priv = (function(_super) {
                        __extends(Priv, _super);

                        function Priv(_arg) {
                            this.seed = _arg.seed, this.key = _arg.key, this.pub = _arg.pub;
                        }

                        Priv._alloc = function(raw, pub) {
                            var key_len, len, m, n, pre, priv, publicKey, sb, secretKey, seed, _ref1;
                            sb = new SlicerBuffer(raw);
                            pre = sb.rem();
                            key_len = Math.ceil(sb.read_uint16() / 8);
                            if ((n = key_len) !== (m = kbnacl.sign.seedLength)) {
                                throw new Error("Expected " + m + " bytes for EDDSA priv key, got " + n + ".");
                            }
                            seed = sb.read_buffer(key_len);
                            _ref1 = kbnacl.alloc({}).genFromSeed({
                                seed: seed
                            }), publicKey = _ref1.publicKey, secretKey = _ref1.secretKey;
                            if (!util.bufeq_secure(pub.key, publicKey)) {
                                throw new Error('Loaded EDDSA private key but it does not match the public key.');
                            }
                            priv = new Priv({
                                seed: seed,
                                key: new Buffer(secretKey),
                                pub: pub
                            });
                            len = pre - sb.rem();
                            return [priv, len];
                        };

                        Priv.alloc = function(raw, pub) {
                            var e, err, len, priv, _ref1;
                            priv = len = err = null;
                            try {
                                _ref1 = Priv._alloc(raw, pub), priv = _ref1[0], len = _ref1[1];
                            } catch (_error) {
                                e = _error;
                                err = e;
                            }
                            return [err, priv, len];
                        };

                        Priv.prototype.sign = function(h, cb) {
                            var len, nacl, ret;
                            nacl = kbnacl.alloc({
                                secretKey: this.key
                            });
                            ret = nacl.sign({
                                payload: h
                            });
                            len = kbnacl.sign.signatureLength / 2;
                            return cb([new Buffer(ret.slice(0, len)), new Buffer(ret.slice(len, len * 2))]);
                        };

                        Priv.prototype.serialize = function() {
                            return Buffer.concat([uint_to_buffer(16, kbnacl.sign.seedLength * 8), this.seed]);
                        };

                        return Priv;

                    })(BaseKey);

                    Pair = (function(_super) {
                        __extends(Pair, _super);

                        Pair.Pub = Pub;

                        Pair.prototype.Pub = Pub;

                        Pair.Priv = Priv;

                        Pair.prototype.Priv = Priv;

                        Pair.type = C.public_key_algorithms.EDDSA;

                        Pair.prototype.type = Pair.type;

                        Pair.klass_name = "EDDSA";

                        Pair.prototype.get_type = function() {
                            return this.type;
                        };

                        function Pair(_arg) {
                            var priv, pub;
                            pub = _arg.pub, priv = _arg.priv;
                            Pair.__super__.constructor.call(this, {
                                pub: pub,
                                priv: priv
                            });
                        }

                        Pair.parse = function(pub_raw) {
                            return BaseKeyPair.parse(Pair, pub_raw);
                        };

                        Pair.prototype.can_encrypt = function() {
                            return false;
                        };

                        Pair.subkey_algo = function(flags) {
                            if (flags & (C.key_flags.certify_keys | C.key_flags.sign_data)) {
                                return Pair;
                            } else {
                                return ECDH;
                            }
                        };

                        Pair.prototype.fulfills_flags = function(flags) {
                            var good_for;
                            good_for = C.key_flags.certify_keys | C.key_flags.sign_data;
                            return (flags & good_for) === flags;
                        };

                        Pair.prototype.verify_unpad_and_check_hash = function(_arg, cb) {
                            var data, hash, hasher, sig;
                            sig = _arg.sig, data = _arg.data, hasher = _arg.hasher, hash = _arg.hash;
                            return this._dsa_verify_update_and_check_hash({
                                sig: sig,
                                data: data,
                                hasher: hasher,
                                hash: hash,
                                klass: Pair
                            }, cb);
                        };

                        Pair.prototype.pad_and_sign = function(data, _arg, cb) {
                            var h, hasher, r, s, sig, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            hasher = _arg.hasher;
                            hasher || (hasher = SHA512);
                            h = hasher(data);
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/ecc/eddsa.iced",
                                        funcname: "Pair.pad_and_sign"
                                    });
                                    _this.priv.sign(h, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return sig = arguments[0];
                                            };
                                        })(),
                                        lineno: 210
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    r = sig[0], s = sig[1];
                                    return cb(null, Buffer.concat([uint_to_buffer(16, r.length * 8), r, uint_to_buffer(16, s.length * 8), s]));
                                };
                            })(this));
                        };

                        Pair.parse_sig = function(slice) {
                            var buf, err, n, ret, _ref1;
                            buf = slice.peek_rest_to_buffer();
                            _ref1 = Pair.read_sig_from_buf(buf), err = _ref1[0], ret = _ref1[1], n = _ref1[2];
                            if (err != null) {
                                throw err;
                            }
                            slice.advance(n);
                            return ret;
                        };

                        Pair.eddsa_value_from_buffer = function(buf) {
                            var bits, bytes_len, err, ret;
                            err = ret = null;
                            if ((bits = buf.readUInt16BE(0)) > 0x100 || bits < (0x100 - 40)) {
                                err = new Error("Got an unexpected number of Bits for an EdDSA value: " + bits);
                            } else {
                                bytes_len = 2 + Math.ceil(bits / 8);
                                ret = buf.slice(2, bytes_len);
                                buf = buf.slice(bytes_len);
                            }
                            return [err, ret, buf];
                        };

                        Pair.read_sig_from_buf = function(buf) {
                            var bufs, err, n, o, order, orig_len, ret, x;
                            orig_len = buf.length;
                            order = ['r', 's'];
                            err = null;
                            bufs = (function() {
                                var _i, _len, _ref1, _results;
                                _results = [];
                                for (_i = 0, _len = order.length; _i < _len; _i++) {
                                    o = order[_i];
                                    if (!(err == null)) {
                                        continue;
                                    }
                                    _ref1 = Pair.eddsa_value_from_buffer(buf), err = _ref1[0], x = _ref1[1], buf = _ref1[2];
                                    _results.push(x);
                                }
                                return _results;
                            })();
                            n = orig_len - buf.length;
                            ret = err != null ? null : bufs;
                            return [err, ret, n];
                        };

                        Pair.alloc = function(klass, raw) {
                            var e, err, len, pub, _ref1;
                            pub = len = err = null;
                            try {
                                _ref1 = Pub.alloc(raw), pub = _ref1[0], len = _ref1[1];
                            } catch (_error) {
                                e = _error;
                                err = e;
                            }
                            return [err, pub, len];
                        };

                        Pair.prototype.good_for_flags = function() {
                            return C.key_flags.certify_keys | C.key_flags.sign_data;
                        };

                        Pair.generate = function(_arg, cb) {
                            var asp, nbits, priv, pub, publicKey, ret, secretKey, seed, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            nbits = _arg.nbits, asp = _arg.asp;
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/ecc/eddsa.iced",
                                        funcname: "Pair.generate"
                                    });
                                    SRF().random_bytes(kbnacl.sign.seedLength, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return seed = arguments[0];
                                            };
                                        })(),
                                        lineno: 282
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    var _ref1;
                                    _ref1 = kbnacl.alloc({}).genFromSeed({
                                        seed: seed
                                    }), publicKey = _ref1.publicKey, secretKey = _ref1.secretKey;
                                    pub = new Pub({
                                        key: new Buffer(publicKey)
                                    });
                                    priv = new Priv({
                                        seed: seed,
                                        key: new Buffer(secretKey),
                                        pub: pub
                                    });
                                    ret = new Pair({
                                        pub: pub,
                                        priv: priv
                                    });
                                    return cb(null, ret);
                                };
                            })(this));
                        };

                        return Pair;

                    })(BaseKeyPair);

                    exports.EDDSA = exports.Pair = Pair;

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../basekeypair": 2,
            "../const": 5,
            "../openpgp/buffer": 37,
            "../rand": 67,
            "../util": 72,
            "buffer": 126,
            "iced-runtime": 183,
            "keybase-nacl": 196
        }],
        12: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                exports.curves = require('./curves');

                exports.ECDSA = require('./ecdsa').ECDSA;

                exports.ECDH = require('./ecdh').ECDH;

                exports.EDDSA = require('./eddsa').EDDSA;

            }).call(this);

        }, {
            "./curves": 8,
            "./ecdh": 9,
            "./ecdsa": 10,
            "./eddsa": 11
        }],
        13: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var ASP, BaseKey, BaseKeyPair, C, K, MRF, Output, Pair, Priv, Pub, SRF, bn, bufeq_secure, eme_pkcs1_decode, eme_pkcs1_encode, iced, konst, make_esc, __iced_k, __iced_k_noop, _ref, _ref1, _ref2, _ref3,
                        __hasProp = {}.hasOwnProperty,
                        __extends = function(child, parent) {
                            for (var key in parent) {
                                if (__hasProp.call(parent, key)) child[key] = parent[key];
                            }

                            function ctor() {
                                this.constructor = child;
                            }
                            ctor.prototype = parent.prototype;
                            child.prototype = new ctor();
                            child.__super__ = parent.prototype;
                            return child;
                        };

                    iced = require('iced-runtime');
                    __iced_k = __iced_k_noop = function() {};

                    bn = require('./bn');

                    _ref = require('./util'), bufeq_secure = _ref.bufeq_secure, ASP = _ref.ASP;

                    make_esc = require('iced-error').make_esc;

                    konst = require('./const');

                    C = konst.openpgp;

                    K = konst.kb;

                    _ref1 = require('./basekeypair'), BaseKeyPair = _ref1.BaseKeyPair, BaseKey = _ref1.BaseKey;

                    _ref2 = require('./rand'), SRF = _ref2.SRF, MRF = _ref2.MRF;

                    _ref3 = require('./pad'), eme_pkcs1_encode = _ref3.eme_pkcs1_encode, eme_pkcs1_decode = _ref3.eme_pkcs1_decode;

                    Pub = (function(_super) {
                        __extends(Pub, _super);

                        Pub.type = C.public_key_algorithms.ELGAMAL;

                        Pub.prototype.type = Pub.type;

                        Pub.ORDER = ['p', 'g', 'y'];

                        Pub.prototype.ORDER = Pub.ORDER;

                        function Pub(_arg) {
                            this.p = _arg.p, this.g = _arg.g, this.y = _arg.y;
                        }

                        Pub.alloc = function(raw) {
                            return BaseKey.alloc(Pub, raw);
                        };

                        Pub.prototype.encrypt = function(m, cb) {
                            var c, k, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/elgamal.iced",
                                        funcname: "Pub.encrypt"
                                    });
                                    SRF().random_zn(_this.p.subtract(bn.nbv(2)), __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return k = arguments[0];
                                            };
                                        })(),
                                        lineno: 35
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    k = k.add(bn.BigInteger.ONE);
                                    c = [_this.g.modPow(k, _this.p), _this.y.modPow(k, _this.p).multiply(m).mod(_this.p)];
                                    return cb(c);
                                };
                            })(this));
                        };

                        return Pub;

                    })(BaseKey);

                    Priv = (function(_super) {
                        __extends(Priv, _super);

                        Priv.ORDER = ['x'];

                        Priv.prototype.ORDER = Priv.ORDER;

                        function Priv(_arg) {
                            this.x = _arg.x, this.pub = _arg.pub;
                        }

                        Priv.prototype.serialize = function() {
                            return this.x.to_mpi_buffer();
                        };

                        Priv.alloc = function(raw, pub) {
                            return BaseKey.alloc(Priv, raw, {
                                pub: pub
                            });
                        };

                        Priv.prototype.decrypt = function(c, cb) {
                            var p, ret;
                            p = this.pub.p;
                            ret = c[0].modPow(this.x, p).modInverse(p).multiply(c[1]).mod(p);
                            return cb(null, ret);
                        };

                        return Priv;

                    })(BaseKey);

                    Pair = (function(_super) {
                        __extends(Pair, _super);

                        Pair.Pub = Pub;

                        Pair.prototype.Pub = Pub;

                        Pair.Priv = Priv;

                        Pair.prototype.Priv = Priv;

                        Pair.type = C.public_key_algorithms.ELGAMAL;

                        Pair.klass_name = "ELGAMAL";

                        Pair.prototype.type = Pair.type;

                        Pair.prototype.get_type = function() {
                            return this.type;
                        };

                        Pair.prototype.fulfills_flags = function(flags) {
                            var good_for;
                            good_for = this.good_for_flags();
                            return (flags & good_for) === flags;
                        };

                        Pair.prototype.good_for_flags = function() {
                            return C.key_flags.encrypt_comm | C.key_flags.encrypt_storage;
                        };

                        function Pair(_arg) {
                            var priv, pub;
                            pub = _arg.pub, priv = _arg.priv;
                            Pair.__super__.constructor.call(this, {
                                pub: pub,
                                priv: priv
                            });
                        }

                        Pair.prototype.can_sign = function() {
                            return false;
                        };

                        Pair.parse = function(pub_raw) {
                            var ret;
                            ret = BaseKeyPair.parse(Pair, pub_raw);
                            return ret;
                        };

                        Pair.prototype.max_value = function() {
                            return this.pub.p;
                        };

                        Pair.prototype.pad_and_encrypt = function(data, params, cb) {
                            var c_mpis, err, m, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            err = ret = null;
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/elgamal.iced",
                                        funcname: "Pair.pad_and_encrypt"
                                    });
                                    eme_pkcs1_encode(data, _this.pub.p.mpi_byte_length(), __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                err = arguments[0];
                                                return m = arguments[1];
                                            };
                                        })(),
                                        lineno: 112
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    (function(__iced_k) {
                                        if (err == null) {
                                            (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral,
                                                    filename: "/Users/max/src/keybase/kbpgp/src/elgamal.iced",
                                                    funcname: "Pair.pad_and_encrypt"
                                                });
                                                _this.pub.encrypt(m, __iced_deferrals.defer({
                                                    assign_fn: (function() {
                                                        return function() {
                                                            return c_mpis = arguments[0];
                                                        };
                                                    })(),
                                                    lineno: 114
                                                }));
                                                __iced_deferrals._fulfill();
                                            })(function() {
                                                return __iced_k(ret = _this.export_output({
                                                    c_mpis: c_mpis
                                                }));
                                            });
                                        } else {
                                            return __iced_k();
                                        }
                                    })(function() {
                                        return cb(err, ret);
                                    });
                                };
                            })(this));
                        };

                        Pair.prototype.decrypt_and_unpad = function(ciphertext, params, cb) {
                            var b, err, m, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            err = ret = null;
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/elgamal.iced",
                                        funcname: "Pair.decrypt_and_unpad"
                                    });
                                    _this.priv.decrypt(ciphertext.c(), __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                err = arguments[0];
                                                return m = arguments[1];
                                            };
                                        })(),
                                        lineno: 122
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    var _ref4;
                                    if (err == null) {
                                        b = m.to_padded_octets(_this.pub.p);
                                        _ref4 = eme_pkcs1_decode(b), err = _ref4[0], ret = _ref4[1];
                                    }
                                    return cb(err, ret);
                                };
                            })(this));
                        };

                        Pair.parse_output = function(buf) {
                            return Output.parse(buf);
                        };

                        Pair.prototype.export_output = function(args) {
                            return new Output(args);
                        };

                        return Pair;

                    })(BaseKeyPair);

                    Output = (function() {
                        function Output(_arg) {
                            this.c_mpis = _arg.c_mpis, this.c_bufs = _arg.c_bufs;
                        }

                        Output.parse = function(buf) {
                            var c_mpis, err, i, n, ret;
                            c_mpis = (function() {
                                var _i, _ref4, _results;
                                _results = [];
                                for (i = _i = 0; _i < 2; i = ++_i) {
                                    _ref4 = bn.mpi_from_buffer(buf), err = _ref4[0], ret = _ref4[1], buf = _ref4[2], n = _ref4[3];
                                    if (err != null) {
                                        throw err;
                                    }
                                    _results.push(ret);
                                }
                                return _results;
                            })();
                            if (buf.length !== 0) {
                                throw new Error("junk at the end of input");
                            }
                            return new Output({
                                c_mpis: c_mpis
                            });
                        };

                        Output.prototype.c = function() {
                            return this.c_mpis;
                        };

                        Output.prototype.hide = function(_arg, cb) {
                            var c_mpi, err, key, max, new_c_mpis, slosh, tmp, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            key = _arg.key, max = _arg.max, slosh = _arg.slosh;
                            max || (max = 4096);
                            slosh || (slosh = 128);
                            err = null;
                            this.c_bufs = null;
                            new_c_mpis = [];
                            (function(_this) {
                                return (function(__iced_k) {
                                    var _i, _len, _ref4, _results, _while;
                                    _ref4 = _this.c_mpis;
                                    _len = _ref4.length;
                                    _i = 0;
                                    _while = function(__iced_k) {
                                        var _break, _continue, _next;
                                        _break = __iced_k;
                                        _continue = function() {
                                            return iced.trampoline(function() {
                                                ++_i;
                                                return _while(__iced_k);
                                            });
                                        };
                                        _next = _continue;
                                        if (!(_i < _len)) {
                                            return _break();
                                        } else {
                                            c_mpi = _ref4[_i];
                                            (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral,
                                                    filename: "/Users/max/src/keybase/kbpgp/src/elgamal.iced",
                                                    funcname: "Output.hide"
                                                });
                                                key.hide({
                                                    i: c_mpi,
                                                    max: max,
                                                    slosh: slosh
                                                }, __iced_deferrals.defer({
                                                    assign_fn: (function() {
                                                        return function() {
                                                            err = arguments[0];
                                                            return tmp = arguments[1];
                                                        };
                                                    })(),
                                                    lineno: 164
                                                }));
                                                __iced_deferrals._fulfill();
                                            })(function() {
                                                new_c_mpis.push(tmp);
                                                (function(__iced_k) {
                                                    if (err != null) {
                                                        (function(__iced_k) {
                                                            _break()
                                                        })(__iced_k);
                                                    } else {
                                                        return __iced_k();
                                                    }
                                                })(_next);
                                            });
                                        }
                                    };
                                    _while(__iced_k);
                                });
                            })(this)((function(_this) {
                                return function() {
                                    if (err == null) {
                                        _this.c_mpis = new_c_mpis;
                                    }
                                    return cb(err);
                                };
                            })(this));
                        };

                        Output.prototype.find = function(_arg) {
                            var j, key;
                            key = _arg.key;
                            return this.c_mpis = (function() {
                                var _i, _len, _ref4, _results;
                                _ref4 = this.c_mpis;
                                _results = [];
                                for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
                                    j = _ref4[_i];
                                    _results.push(key.find(j));
                                }
                                return _results;
                            }).call(this);
                        };

                        Output.prototype.get_c_bufs = function() {
                            var i;
                            if (this.c_bufs != null) {
                                return this.c_bufs;
                            } else {
                                return this.c_bufs = (function() {
                                    var _i, _len, _ref4, _results;
                                    _ref4 = this.c_mpis;
                                    _results = [];
                                    for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
                                        i = _ref4[_i];
                                        _results.push(i.to_mpi_buffer());
                                    }
                                    return _results;
                                }).call(this);
                            }
                        };

                        Output.prototype.output = function() {
                            return Buffer.concat(this.get_c_bufs());
                        };

                        return Output;

                    })();

                    exports.ElGamal = exports.Pair = Pair;

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "./basekeypair": 2,
            "./bn": 4,
            "./const": 5,
            "./pad": 64,
            "./rand": 67,
            "./util": 72,
            "buffer": 126,
            "iced-error": 179,
            "iced-runtime": 183
        }],
        14: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var ASP, BaseKey, BaseKeyPair, C, K, MRF, Pair, Priv, Pub, SRF, bn, bufeq_secure, eme_pkcs1_decode, eme_pkcs1_encode, konst, make_esc, _ref, _ref1, _ref2, _ref3,
                    __hasProp = {}.hasOwnProperty,
                    __extends = function(child, parent) {
                        for (var key in parent) {
                            if (__hasProp.call(parent, key)) child[key] = parent[key];
                        }

                        function ctor() {
                            this.constructor = child;
                        }
                        ctor.prototype = parent.prototype;
                        child.prototype = new ctor();
                        child.__super__ = parent.prototype;
                        return child;
                    };

                bn = require('./bn');

                _ref = require('./util'), bufeq_secure = _ref.bufeq_secure, ASP = _ref.ASP;

                make_esc = require('iced-error').make_esc;

                konst = require('./const');

                C = konst.openpgp;

                K = konst.kb;

                _ref1 = require('./basekeypair'), BaseKeyPair = _ref1.BaseKeyPair, BaseKey = _ref1.BaseKey;

                _ref2 = require('./rand'), SRF = _ref2.SRF, MRF = _ref2.MRF;

                _ref3 = require('./pad'), eme_pkcs1_encode = _ref3.eme_pkcs1_encode, eme_pkcs1_decode = _ref3.eme_pkcs1_decode;

                Pub = (function(_super) {
                    __extends(Pub, _super);

                    Pub.type = C.public_key_algorithms.ELGAMAL_SIGN_AND_ENCRYPT;

                    Pub.prototype.type = Pub.type;

                    Pub.ORDER = [];

                    Pub.prototype.ORDER = Pub.ORDER;

                    function Pub(raw) {
                        this.raw = raw;
                    }

                    Pub.alloc = function(raw) {
                        return BaseKey.alloc(Pub, raw);
                    };

                    Pub.prototype.encrypt = function(m, cb) {
                        return cb(null);
                    };

                    return Pub;

                })(BaseKey);

                Priv = (function(_super) {
                    __extends(Priv, _super);

                    Priv.ORDER = [];

                    Priv.prototype.ORDER = Priv.ORDER;

                    function Priv(raw) {
                        this.raw = raw;
                    }

                    Priv.prototype.serialize = function() {
                        return null;
                    };

                    Priv.alloc = function(raw, pub) {
                        return BaseKey.alloc(Priv, raw, {
                            pub: pub
                        });
                    };

                    Priv.prototype.decrypt = function(c, cb) {
                        return cb(null);
                    };

                    return Priv;

                })(BaseKey);

                Pair = (function(_super) {
                    __extends(Pair, _super);

                    Pair.Pub = Pub;

                    Pair.prototype.Pub = Pub;

                    Pair.Priv = Priv;

                    Pair.prototype.Priv = Priv;

                    Pair.type = C.public_key_algorithms.ELGAMAL_SIGN_AND_ENCRYPT;

                    Pair.prototype.type = Pair.type;

                    Pair.prototype.fulfills_flags = function(flags) {
                        return false;
                    };

                    Pair.prototype.is_toxic = function() {
                        return true;
                    };

                    function Pair(_arg) {
                        var priv, pub;
                        pub = _arg.pub, priv = _arg.priv;
                        Pair.__super__.constructor.call(this, {
                            pub: pub,
                            priv: priv
                        });
                    }

                    Pair.prototype.can_sign = function() {
                        return false;
                    };

                    Pair.prototype.can_decrypt = function() {
                        return false;
                    };

                    Pair.prototype.err = function() {
                        return new Error("refusing to use ElGamal Sign+Encrypt");
                    };

                    Pair.parse = function(pub_raw) {
                        var ret;
                        ret = BaseKeyPair.parse(Pair, pub_raw);
                        return ret;
                    };

                    Pair.prototype.pad_and_encrypt = function(data, cb) {
                        return cb(this.err(), null);
                    };

                    Pair.prototype.decrypt_and_unpad = function(ciphertext, params, cb) {
                        return cb(this.err(), null);
                    };

                    Pair.parse_output = function(buf) {
                        return null;
                    };

                    Pair.prototype.export_output = function(args) {
                        return null;
                    };

                    return Pair;

                })(BaseKeyPair);

                exports.ElGamalSignEncrypt = exports.Pair = Pair;

            }).call(this);

        }, {
            "./basekeypair": 2,
            "./bn": 4,
            "./const": 5,
            "./pad": 64,
            "./rand": 67,
            "./util": 72,
            "iced-error": 179
        }],
        15: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var make_errors;

                make_errors = require('iced-error').make_errors;

                exports.errors = make_errors({
                    WRONG_SIGNING_KEY: "wrong signing key specified",
                    REVOKED_KEY: "key is revoked"
                });

            }).call(this);

        }, {
            "iced-error": 179
        }],
        16: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var C, WordArray, algos, alloc, alloc_or_throw, decorate, k, make_hasher, make_streamer, streamers, triplesec, v, _lookup, _ref;

                C = require('./const').openpgp;

                triplesec = require('triplesec');

                WordArray = triplesec.WordArray;

                algos = triplesec.hash;

                decorate = function(f, klass, name, type) {
                    f.type = type;
                    f.algname = name;
                    f.output_length = klass.output_size;
                    f.klass = klass;
                    return f;
                };

                make_hasher = function(klass, name, type) {
                    var f;
                    if (klass != null) {
                        f = function(x) {
                            return (new klass).bufhash(x);
                        };
                        return decorate(f, klass, name, type);
                    } else {
                        return null;
                    }
                };

                make_streamer = function(klass, name, type) {
                    return function() {
                        var obj, ret;
                        obj = new klass;
                        ret = function(buf) {
                            return obj.clone().finalize(buf != null ? WordArray.from_buffer(buf) : null).to_buffer();
                        };
                        ret.update = function(buf) {
                            if (buf != null) {
                                obj.update(WordArray.from_buffer(buf));
                            }
                            return this;
                        };
                        return decorate(ret, klass, name, type);
                    };
                };

                _lookup = {};

                exports.streamers = streamers = {};

                _ref = C.hash_algorithms;
                for (k in _ref) {
                    v = _ref[k];
                    _lookup[v] = k;
                    exports[k] = make_hasher(algos[k], k, v);
                    streamers[k] = make_streamer(algos[k], k, v);
                }

                exports.alloc = alloc = function(typ) {
                    var klass, name, ret;
                    ret = null;
                    name = _lookup[typ];
                    if (name != null) {
                        klass = algos[name];
                    }
                    if (klass != null) {
                        ret = make_hasher(klass, name, typ);
                    }
                    return ret;
                };

                exports.alloc_or_throw = alloc_or_throw = function(typ) {
                    var ret;
                    ret = alloc(typ);
                    if (!ret) {
                        throw new Error("unknown hash type: " + typ);
                    }
                    return ret;
                };

            }).call(this);

        }, {
            "./const": 5,
            "triplesec": 282
        }],
        17: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var C, pjs;

                C = require('./const');

                pjs = require('../package.json');

                exports.header = {
                    version: C.header.version + (" v" + pjs.version),
                    comment: C.header.comment
                };

            }).call(this);

        }, {
            "../package.json": 304,
            "./const": 5
        }],
        18: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var K, SHA256, alloc, bufeq_secure, katch, null_hash, obj_extract, pack, purepack, read_base64, seal, unpack, unseal, _ref, _ref1;

                    K = require('../const').kb;

                    _ref = require('../hash'), alloc = _ref.alloc, SHA256 = _ref.SHA256;

                    purepack = require('purepack');

                    _ref1 = require('../util'), katch = _ref1.katch, obj_extract = _ref1.obj_extract, bufeq_secure = _ref1.bufeq_secure;

                    null_hash = new Buffer(0);

                    pack = function(x) {
                        return purepack.pack(x, {
                            sort_keys: true
                        });
                    };

                    unpack = function(x) {
                        return purepack.unpack(x, {
                            strict: true
                        });
                    };

                    seal = function(_arg) {
                        var dohash, hasher, obj, oo, packed;
                        obj = _arg.obj, dohash = _arg.dohash;
                        hasher = SHA256;
                        oo = {
                            version: K.versions.V1,
                            tag: obj.tag,
                            body: obj.body
                        };
                        if (dohash) {
                            oo.hash = {
                                type: hasher.type,
                                value: null_hash
                            };
                            packed = pack(oo);
                            oo.hash.value = hasher(packed);
                        }
                        return pack(oo);
                    };

                    read_base64 = function(raw) {
                        var parts;
                        parts = (raw.split(/\s+/)).join('');
                        return new Buffer(parts, 'base64');
                    };

                    unseal = function(buf) {
                        var h, hasher, hv, oo, t, _ref2;
                        oo = unpack(buf);
                        if ((hv = oo != null ? (_ref2 = oo.hash) != null ? _ref2.value : void 0 : void 0) != null) {
                            oo.hash.value = null_hash;
                            hasher = alloc((t = oo.hash.type));
                            if (hasher == null) {
                                throw new Error("unknown hash algo: " + t);
                            }
                            h = hasher(pack(oo));
                            if (!bufeq_secure(h, hv)) {
                                throw new Error("hash mismatch");
                            }
                            if (oo.version !== K.versions.V1) {
                                throw new Error("unknown version");
                            }
                        }
                        return obj_extract(oo, ['tag', 'body']);
                    };

                    exports.seal = seal;

                    exports.pack = pack;

                    exports.unseal = unseal;

                    exports.unpack = unpack;

                    exports.read_base64 = read_base64;

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../const": 5,
            "../hash": 16,
            "../util": 72,
            "buffer": 126,
            "purepack": 243
        }],
        19: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var C, DH, EdDSA, EncKeyManager, Encryption, K, KeyManager, KeyManagerInterface, Signature, SignatureEngine, SignatureEngineInterface, akatch, alloc, asyncify, athrow, base64u, box, buffer_xor, bufferify, decode_sig, encode, errors, get_sig_body, iced, konst, make_esc, unbox, unbox_decode, __iced_k, __iced_k_noop, _ref, _ref1,
                        __hasProp = {}.hasOwnProperty,
                        __extends = function(child, parent) {
                            for (var key in parent) {
                                if (__hasProp.call(parent, key)) child[key] = parent[key];
                            }

                            function ctor() {
                                this.constructor = child;
                            }
                            ctor.prototype = parent.prototype;
                            child.prototype = new ctor();
                            child.__super__ = parent.prototype;
                            return child;
                        },
                        __indexOf = [].indexOf || function(item) {
                            for (var i = 0, l = this.length; i < l; i++) {
                                if (i in this && this[i] === item) return i;
                            }
                            return -1;
                        };

                    iced = require('iced-runtime');
                    __iced_k = __iced_k_noop = function() {};

                    _ref = require('../kmi'), SignatureEngineInterface = _ref.SignatureEngineInterface, KeyManagerInterface = _ref.KeyManagerInterface;

                    make_esc = require('iced-error').make_esc;

                    encode = require('./encode');

                    _ref1 = require('../util'), athrow = _ref1.athrow, bufferify = _ref1.bufferify, base64u = _ref1.base64u, buffer_xor = _ref1.buffer_xor, asyncify = _ref1.asyncify, akatch = _ref1.akatch;

                    konst = require('../const');

                    alloc = require('./packet/alloc').alloc;

                    Signature = require('./packet/signature').Signature;

                    Encryption = require('./packet/encryption').Encryption;

                    EdDSA = require('../nacl/eddsa').EdDSA;

                    errors = require('../errors').errors;

                    DH = require('../nacl/dh').DH;

                    K = konst.kb;

                    C = konst.openpgp;

                    KeyManager = (function(_super) {
                        __extends(KeyManager, _super);

                        function KeyManager(_arg) {
                            this.key = _arg.key, this.server_half = _arg.server_half;
                        }

                        KeyManager.generate = function(_arg, cb) {
                            var algo, err, key, klass, seed, server_half, split, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            algo = _arg.algo, seed = _arg.seed, split = _arg.split, server_half = _arg.server_half, klass = _arg.klass;
                            algo || (algo = EdDSA);
                            klass || (klass = KeyManager);
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/keybase/hilev.iced",
                                        funcname: "KeyManager.generate"
                                    });
                                    algo.generate({
                                        split: split,
                                        seed: seed,
                                        server_half: server_half
                                    }, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                err = arguments[0];
                                                key = arguments[1];
                                                return server_half = arguments[2];
                                            };
                                        })(),
                                        lineno: 30
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err, new klass({
                                        key: key,
                                        server_half: server_half
                                    }));
                                };
                            })(this));
                        };

                        KeyManager.prototype.get_mask = function() {
                            return C.key_flags.sign_data | C.key_flags.certify_keys | C.key_flags.auth;
                        };

                        KeyManager.prototype.fetch = function(key_ids, flags, cb) {
                            var err, key, mask, s;
                            s = this.key.ekid().toString('hex');
                            key = null;
                            mask = this.get_mask();
                            if ((__indexOf.call(key_ids, s) >= 0) && (flags & mask) === flags) {
                                key = this.key;
                            } else {
                                err = new Error("Key not found");
                            }
                            return cb(err, key);
                        };

                        KeyManager.prototype.get_keypair = function() {
                            return this.key;
                        };

                        KeyManager.prototype.get_primary_keypair = function() {
                            return this.key;
                        };

                        KeyManager.prototype.can_verify = function() {
                            return true;
                        };

                        KeyManager.prototype.can_sign = function() {
                            var _ref2;
                            return (_ref2 = this.key) != null ? _ref2.can_sign() : void 0;
                        };

                        KeyManager.prototype.eq = function(km2) {
                            return this.key.eq(km2.key);
                        };

                        KeyManager.import_private = function(_arg, cb) {
                            var e, err, hex, key, raw, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            hex = _arg.hex, raw = _arg.raw;
                            err = ret = null;
                            if (hex != null) {
                                try {
                                    raw = new Buffer(hex, 'hex');
                                } catch (_error) {
                                    e = _error;
                                    return cb(e);
                                }
                            }
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/keybase/hilev.iced",
                                        funcname: "KeyManager.import_private"
                                    });
                                    EdDSA.import_private({
                                        raw: raw
                                    }, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                err = arguments[0];
                                                return key = arguments[1];
                                            };
                                        })(),
                                        lineno: 69
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    if (err == null) {
                                        ret = new KeyManager({
                                            key: key
                                        });
                                    }
                                    return cb(err, ret);
                                };
                            })(this));
                        };

                        KeyManager.import_public = function(_arg, cb) {
                            var e, err, hex, key, raw, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref2;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            hex = _arg.hex, raw = _arg.raw;
                            err = ret = null;
                            if (hex != null) {
                                try {
                                    raw = new Buffer(hex, 'hex');
                                } catch (_error) {
                                    e = _error;
                                    return cb(e);
                                }
                            }
                            _ref2 = EdDSA.parse_kb(raw), err = _ref2[0], key = _ref2[1];
                            (function(_this) {
                                return (function(__iced_k) {
                                    if (err != null) {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/Users/max/src/keybase/kbpgp/src/keybase/hilev.iced",
                                                funcname: "KeyManager.import_public"
                                            });
                                            EncKeyManager.import_public({
                                                raw: raw
                                            }, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        err = arguments[0];
                                                        return ret = arguments[1];
                                                    };
                                                })(),
                                                lineno: 84
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(__iced_k);
                                    } else {
                                        return __iced_k(ret = new KeyManager({
                                            key: key
                                        }));
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err, ret);
                                };
                            })(this));
                        };

                        KeyManager.prototype.check_public_eq = function(km2) {
                            return this.eq(km2);
                        };

                        KeyManager.prototype.export_public = function(_arg, cb) {
                            var asp, regen, ret;
                            asp = _arg.asp, regen = _arg.regen;
                            ret = this.key.ekid().toString('hex');
                            return cb(null, ret);
                        };

                        KeyManager.prototype.export_private = function(_arg, cb) {
                            var asp, err, p3skb, passphrase, res, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            asp = _arg.asp, p3skb = _arg.p3skb, passphrase = _arg.passphrase;
                            err = res = null;
                            (function(_this) {
                                return (function(__iced_k) {
                                    if (p3skb) {
                                        return __iced_k(err = new Error("No support yet for P3SKB encrypted secret key exports"));
                                    } else {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/Users/max/src/keybase/kbpgp/src/keybase/hilev.iced",
                                                funcname: "KeyManager.export_private"
                                            });
                                            _this.key.export_secret_key_kb({}, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        err = arguments[0];
                                                        return res = arguments[1];
                                                    };
                                                })(),
                                                lineno: 106
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(__iced_k);
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err, res);
                                };
                            })(this));
                        };

                        KeyManager.prototype.export_server_half = function() {
                            var _ref2;
                            return (_ref2 = this.server_half) != null ? _ref2.toString('hex') : void 0;
                        };

                        KeyManager.prototype.get_ekid = function() {
                            return this.get_keypair().ekid();
                        };

                        KeyManager.prototype.get_fp2 = function() {
                            return this.get_ekid();
                        };

                        KeyManager.prototype.get_fp2_formatted = function() {
                            return base64u.encode(this.get_fp2());
                        };

                        KeyManager.prototype.get_type = function() {
                            return "kb";
                        };

                        KeyManager.prototype.make_sig_eng = function() {
                            return new SignatureEngine({
                                km: this
                            });
                        };

                        return KeyManager;

                    })(KeyManagerInterface);

                    EncKeyManager = (function(_super) {
                        __extends(EncKeyManager, _super);

                        function EncKeyManager() {
                            return EncKeyManager.__super__.constructor.apply(this, arguments);
                        }

                        EncKeyManager.generate = function(params, cb) {
                            params.algo = DH;
                            params.klass = EncKeyManager;
                            return KeyManager.generate(params, cb);
                        };

                        EncKeyManager.prototype.make_sig_eng = function() {
                            return null;
                        };

                        EncKeyManager.prototype.can_sign = function() {
                            return false;
                        };

                        EncKeyManager.prototype.can_verify = function() {
                            return false;
                        };

                        EncKeyManager.prototype.can_encrypt = function() {
                            return true;
                        };

                        EncKeyManager.prototype.can_decrypt = function() {
                            var _ref2;
                            return ((_ref2 = this.key) != null ? _ref2.priv : void 0) != null;
                        };

                        EncKeyManager.import_private = function(_arg, cb) {
                            var e, err, hex, km, raw, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            hex = _arg.hex, raw = _arg.raw;
                            err = ret = null;
                            if (hex != null) {
                                try {
                                    raw = new Buffer(hex, 'hex');
                                } catch (_error) {
                                    e = _error;
                                    return cb(e);
                                }
                            }
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/keybase/hilev.iced",
                                        funcname: "EncKeyManager.import_private"
                                    });
                                    EncKeyManager.generate({
                                        seed: raw
                                    }, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                err = arguments[0];
                                                return km = arguments[1];
                                            };
                                        })(),
                                        lineno: 152
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err, km);
                                };
                            })(this));
                        };

                        EncKeyManager.prototype.get_mask = function() {
                            return C.key_flags.encrypt_comm | C.key_flags.encrypt_storage;
                        };

                        EncKeyManager.import_public = function(_arg, cb) {
                            var e, err, hex, key, raw, ret, _ref2;
                            hex = _arg.hex, raw = _arg.raw;
                            err = ret = null;
                            if (hex != null) {
                                try {
                                    raw = new Buffer(hex, 'hex');
                                } catch (_error) {
                                    e = _error;
                                    return cb(e);
                                }
                            }
                            _ref2 = DH.parse_kb(raw), err = _ref2[0], key = _ref2[1];
                            if (err == null) {
                                ret = new EncKeyManager({
                                    key: key
                                });
                            }
                            return cb(err, ret);
                        };

                        return EncKeyManager;

                    })(KeyManager);

                    unbox_decode = function(_arg) {
                        var armored, binary, e, err, rawobj, ret, _ref2;
                        armored = _arg.armored, binary = _arg.binary, rawobj = _arg.rawobj;
                        err = ret = null;
                        if ((armored == null) && (rawobj == null) && (binary == null)) {
                            err = new Error("need either 'armored' or 'binary' or 'rawobj'");
                            return [err, null];
                        }
                        if (armored != null) {
                            binary = new Buffer(armored, 'base64');
                        }
                        if (binary != null) {
                            try {
                                rawobj = encode.unseal(binary);
                            } catch (_error) {
                                e = _error;
                                return [e, null];
                            }
                        }
                        _ref2 = alloc(rawobj), err = _ref2[0], ret = _ref2[1];
                        return [err, ret, binary];
                    };

                    unbox = function(_arg, cb) {
                        var armored, binary, encrypt_for, esc, packet, rawobj, res, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        armored = _arg.armored, binary = _arg.binary, rawobj = _arg.rawobj, encrypt_for = _arg.encrypt_for;
                        esc = make_esc(cb, "unbox");
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/Users/max/src/keybase/kbpgp/src/keybase/hilev.iced"
                                });
                                asyncify(unbox_decode({
                                    armored: armored,
                                    binary: binary,
                                    rawobj: rawobj
                                }), esc(__iced_deferrals.defer({
                                    assign_fn: (function() {
                                        return function() {
                                            packet = arguments[0];
                                            return binary = arguments[1];
                                        };
                                    })(),
                                    lineno: 195
                                })));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/keybase/hilev.iced"
                                    });
                                    packet.unbox({
                                        encrypt_for: encrypt_for
                                    }, esc(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return res = arguments[0];
                                            };
                                        })(),
                                        lineno: 196
                                    })));
                                    __iced_deferrals._fulfill();
                                })(function() {
                                    if (res.keypair != null) {
                                        res.km = new KeyManager({
                                            key: res.keypair
                                        });
                                    }
                                    if (res.sender_keypair != null) {
                                        res.sender_km = new KeyManager({
                                            key: res.sender_keypair
                                        });
                                    }
                                    if (res.receiver_keypair != null) {
                                        res.receiver_km = new KeyManager({
                                            key: res.receiver_keypair
                                        });
                                    }
                                    return cb(null, res, binary);
                                });
                            };
                        })(this));
                    };

                    box = function(_arg, cb) {
                        var anonymous, armored, encrypt_for, esc, msg, nonce, packed, packet, sealed, sign_with, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        msg = _arg.msg, sign_with = _arg.sign_with, encrypt_for = _arg.encrypt_for, anonymous = _arg.anonymous, nonce = _arg.nonce;
                        esc = make_esc(cb, "box");
                        msg = bufferify(msg);
                        (function(_this) {
                            return (function(__iced_k) {
                                if (encrypt_for != null) {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/Users/max/src/keybase/kbpgp/src/keybase/hilev.iced"
                                        });
                                        Encryption.box({
                                            sign_with: sign_with,
                                            encrypt_for: encrypt_for,
                                            plaintext: msg,
                                            anonymous: anonymous,
                                            nonce: nonce
                                        }, esc(__iced_deferrals.defer({
                                            assign_fn: (function() {
                                                return function() {
                                                    return packet = arguments[0];
                                                };
                                            })(),
                                            lineno: 213
                                        })));
                                        __iced_deferrals._fulfill();
                                    })(__iced_k);
                                } else {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/Users/max/src/keybase/kbpgp/src/keybase/hilev.iced"
                                        });
                                        Signature.box({
                                            km: sign_with,
                                            payload: msg
                                        }, esc(__iced_deferrals.defer({
                                            assign_fn: (function() {
                                                return function() {
                                                    return packet = arguments[0];
                                                };
                                            })(),
                                            lineno: 215
                                        })));
                                        __iced_deferrals._fulfill();
                                    })(__iced_k);
                                }
                            });
                        })(this)((function(_this) {
                            return function() {
                                packed = packet.frame_packet();
                                sealed = encode.seal({
                                    obj: packed,
                                    dohash: false
                                });
                                armored = sealed.toString('base64');
                                return cb(null, armored, sealed);
                            };
                        })(this));
                    };

                    get_sig_body = function(_arg) {
                        var armored, decoded, err, _ref2;
                        armored = _arg.armored;
                        _ref2 = decode_sig({
                            armored: armored
                        }), err = _ref2[0], decoded = _ref2[1];
                        return [err, decoded != null ? decoded.body : void 0];
                    };

                    decode_sig = function(_arg) {
                        var armored, decoded;
                        armored = _arg.armored;
                        decoded = {
                            body: new Buffer(armored, 'base64'),
                            type: C.message_types.generic,
                            payload: armored
                        };
                        return [null, decoded];
                    };

                    SignatureEngine = (function(_super) {
                        __extends(SignatureEngine, _super);

                        function SignatureEngine(_arg) {
                            this.km = _arg.km;
                        }

                        SignatureEngine.prototype.get_km = function() {
                            return this.km;
                        };

                        SignatureEngine.prototype.get_unverified_payload_from_raw_sig_body = function(_arg, cb) {
                            var body, esc, packet, rawobj, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            body = _arg.body;
                            esc = make_esc(cb, "get_payload_from_raw_sig_body");
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/keybase/hilev.iced",
                                        funcname: "SignatureEngine.get_unverified_payload_from_raw_sig_body"
                                    });
                                    akatch((function() {
                                        return encode.unseal(body);
                                    }), esc(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return rawobj = arguments[0];
                                            };
                                        })(),
                                        lineno: 250
                                    })));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/Users/max/src/keybase/kbpgp/src/keybase/hilev.iced",
                                            funcname: "SignatureEngine.get_unverified_payload_from_raw_sig_body"
                                        });
                                        asyncify(alloc(rawobj), esc(__iced_deferrals.defer({
                                            assign_fn: (function() {
                                                return function() {
                                                    return packet = arguments[0];
                                                };
                                            })(),
                                            lineno: 251
                                        })));
                                        __iced_deferrals._fulfill();
                                    })(function() {
                                        return cb(null, packet.payload);
                                    });
                                };
                            })(this));
                        };

                        SignatureEngine.prototype.get_body = function(args, cb) {
                            var err, res, _ref2;
                            _ref2 = get_sig_body(args, cb), err = _ref2[0], res = _ref2[1];
                            return cb(err, res);
                        };

                        SignatureEngine.prototype.box = function(msg, cb) {
                            var armored, esc, out, raw, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            esc = make_esc(cb, "SignatureEngine::box");
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/keybase/hilev.iced",
                                        funcname: "SignatureEngine.box"
                                    });
                                    box({
                                        msg: msg,
                                        sign_with: _this.km
                                    }, esc(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                armored = arguments[0];
                                                return raw = arguments[1];
                                            };
                                        })(),
                                        lineno: 264
                                    })));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    out = {
                                        type: "kb",
                                        armored: armored,
                                        kb: armored,
                                        raw: raw
                                    };
                                    return cb(null, out);
                                };
                            })(this));
                        };

                        SignatureEngine.prototype.unbox = function(msg, cb, opts) {
                            var a, arg, b, binary, err, esc, payload, res, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            if (opts == null) {
                                opts = {};
                            }
                            esc = make_esc(cb, "SignatureEngine::unbox");
                            err = payload = null;
                            arg = Buffer.isBuffer(msg) ? {
                                binary: msg
                            } : {
                                armored: msg
                            };
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/keybase/hilev.iced",
                                        funcname: "SignatureEngine.unbox"
                                    });
                                    unbox(arg, esc(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                res = arguments[0];
                                                return binary = arguments[1];
                                            };
                                        })(),
                                        lineno: 275
                                    })));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    if (!res.km.eq(_this.km)) {
                                        a = res.km.get_ekid().toString('hex');
                                        b = _this.km.get_ekid().toString('hex');
                                        err = new errors.WrongSigningKeyError("Got wrong signing key");
                                    } else {
                                        payload = res.payload;
                                    }
                                    return cb(err, payload, binary);
                                };
                            })(this));
                        };

                        return SignatureEngine;

                    })(SignatureEngineInterface);

                    module.exports = {
                        box: box,
                        unbox: unbox,
                        unbox_decode: unbox_decode,
                        KeyManager: KeyManager,
                        EncKeyManager: EncKeyManager,
                        decode_sig: decode_sig,
                        get_sig_body: get_sig_body
                    };

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../const": 5,
            "../errors": 15,
            "../kmi": 29,
            "../nacl/dh": 32,
            "../nacl/eddsa": 33,
            "../util": 72,
            "./encode": 18,
            "./packet/alloc": 20,
            "./packet/encryption": 22,
            "./packet/signature": 24,
            "buffer": 126,
            "iced-error": 179,
            "iced-runtime": 183
        }],
        20: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var Encryption, K, P3SKB, Signature;

                K = require('../../const').kb;

                P3SKB = require('./p3skb').P3SKB;

                Signature = require('./signature').Signature;

                Encryption = require('./encryption').Encryption;

                exports.alloc = function(_arg) {
                    var body, err, ret, tag;
                    tag = _arg.tag, body = _arg.body;
                    ret = err = null;
                    ret = (function() {
                        switch (tag) {
                            case K.packet_tags.p3skb:
                                return P3SKB.alloc({
                                    tag: tag,
                                    body: body
                                });
                            case K.packet_tags.signature:
                                return Signature.alloc({
                                    tag: tag,
                                    body: body
                                });
                            case K.packet_tags.encryption:
                                return Encryption.alloc({
                                    tag: tag,
                                    body: body
                                });
                            default:
                                err = new Error("unknown packet tag: " + tag);
                                return null;
                        }
                    })();
                    return [err, ret];
                };

            }).call(this);

        }, {
            "../../const": 5,
            "./encryption": 22,
            "./p3skb": 23,
            "./signature": 24
        }],
        21: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var K, Packet, seal, util;

                util = require('../../util');

                seal = require('../encode').seal;

                K = require('../../const').kb;

                Packet = (function() {
                    function Packet() {}

                    Packet.prototype.frame_packet = function() {
                        return {
                            tag: this.tag(),
                            body: this.get_packet_body()
                        };
                    };

                    Packet.prototype.frame_packet_armored = function(_arg) {
                        var dohash, obj;
                        dohash = _arg.dohash;
                        obj = this.frame_packet();
                        return seal({
                            obj: obj,
                            dohash: dohash
                        }).toString('base64');
                    };

                    Packet.prototype.is_signature = function() {
                        return false;
                    };

                    Packet.prototype.is_p3skb = function() {
                        return false;
                    };

                    Packet.alloc = function(_arg) {
                        var P3SKB, Signature, body, err, ret, tag;
                        tag = _arg.tag, body = _arg.body;
                        ret = err = null;
                        ret = (function() {
                            switch (tag) {
                                case K.packet_tags.p3skb:
                                    P3SKB = require('./p3skb').P3SKB;
                                    return P3SKB.alloc({
                                        tag: tag,
                                        body: body
                                    });
                                case K.packet_tags.signature:
                                    Signature = require('./signature').Signature;
                                    return Signature.alloc({
                                        tag: tag,
                                        body: body
                                    });
                                default:
                                    err = new Error("unknown packet tag: " + tag);
                                    return null;
                            }
                        })();
                        return [err, ret];
                    };

                    Packet.prototype.unbox = function(params, cb) {
                        return cb(new Error("unbox() unimplemented for tag=" + this.tag));
                    };

                    return Packet;

                })();

                exports.Packet = Packet;

            }).call(this);

        }, {
            "../../const": 5,
            "../../util": 72,
            "../encode": 18,
            "./p3skb": 23,
            "./signature": 24
        }],
        22: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var C, Encryption, K, Packet, dh, iced, konst, make_esc, __iced_k, __iced_k_noop,
                    __hasProp = {}.hasOwnProperty,
                    __extends = function(child, parent) {
                        for (var key in parent) {
                            if (__hasProp.call(parent, key)) child[key] = parent[key];
                        }

                        function ctor() {
                            this.constructor = child;
                        }
                        ctor.prototype = parent.prototype;
                        child.prototype = new ctor();
                        child.__super__ = parent.prototype;
                        return child;
                    };

                iced = require('iced-runtime');
                __iced_k = __iced_k_noop = function() {};

                konst = require('../../const');

                K = konst.kb;

                C = konst.openpgp;

                Packet = require('./base').Packet;

                make_esc = require('iced-error').make_esc;

                dh = require('../../nacl/main').dh;

                Encryption = (function(_super) {
                    __extends(Encryption, _super);

                    Encryption.ENC_TYPE = K.public_key_algorithms.NACL_DH;

                    Encryption.tag = function() {
                        return K.packet_tags.encryption;
                    };

                    Encryption.prototype.tag = function() {
                        return Encryption.tag();
                    };

                    function Encryption(_arg) {
                        this.encrypt_for = _arg.encrypt_for, this.sign_with = _arg.sign_with, this.plaintext = _arg.plaintext, this.ciphertext = _arg.ciphertext, this.sender_key = _arg.sender_key, this.nonce = _arg.nonce, this.anonymous = _arg.anonymous;
                        Encryption.__super__.constructor.call(this);
                        this.ephemeral = false;
                    }

                    Encryption.prototype.get_packet_body = function() {
                        var enc_type;
                        enc_type = Encryption.ENC_TYPE;
                        return {
                            sender_key: this.sender_key,
                            ciphertext: this.ciphertext,
                            nonce: this.nonce,
                            enc_type: enc_type,
                            receiver_key: this.receiver_key
                        };
                    };

                    Encryption.alloc = function(_arg) {
                        var a, b, body, err, ret, tag;
                        tag = _arg.tag, body = _arg.body;
                        ret = null;
                        err = tag !== Encryption.tag() ? new Error("wrong tag found: " + tag) : (a = body.enc_type) !== (b = Encryption.ENC_TYPE) ? err = new Error("Expected Curve25519 DH (type " + b + "); got " + a) : (ret = new Encryption(body), null);
                        if (err != null) {
                            throw err;
                        }
                        return ret;
                    };

                    Encryption.prototype.is_signature = function() {
                        return false;
                    };

                    Encryption.prototype.get_sender_keypair = function(_arg, cb) {
                        var encrypt, err, ret, sign_with, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        sign_with = _arg.sign_with, encrypt = _arg.encrypt;
                        err = ret = null;
                        (function(_this) {
                            return (function(__iced_k) {
                                if (sign_with != null) {
                                    return __iced_k(ret = sign_with.get_keypair());
                                } else {
                                    (function(__iced_k) {
                                        if (_this.sign_with != null) {
                                            return __iced_k(ret = _this.sign_with.get_keypair());
                                        } else {
                                            (function(__iced_k) {
                                                if (_this.sender_keypair != null) {
                                                    return __iced_k(ret = _this.sender_keypair);
                                                } else {
                                                    (function(__iced_k) {
                                                        var _ref;
                                                        if (encrypt) {
                                                            (function(__iced_k) {
                                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                                    parent: ___iced_passed_deferral,
                                                                    filename: "/Users/max/src/keybase/kbpgp/src/keybase/packet/encryption.iced",
                                                                    funcname: "Encryption.get_sender_keypair"
                                                                });
                                                                dh.Pair.generate({}, __iced_deferrals.defer({
                                                                    assign_fn: (function(__slot_1) {
                                                                        return function() {
                                                                            err = arguments[0];
                                                                            return __slot_1.sender_keypair = arguments[1];
                                                                        };
                                                                    })(_this),
                                                                    lineno: 56
                                                                }));
                                                                __iced_deferrals._fulfill();
                                                            })(function() {
                                                                ret = _this.sender_keypair;
                                                                return __iced_k(_this.ephemeral = true);
                                                            });
                                                        } else {
                                                            return __iced_k(_this.sender_key != null ? ((_ref = dh.Pair.parse_kb(_this.sender_key), err = _ref[0], _this.sender_keypair = _ref[1], _ref), err == null ? ret = _this.sender_keypair : void 0) : err = new Error("Cannot encrypt without a sender keypair"));
                                                        }
                                                    })(__iced_k);
                                                }
                                            })(__iced_k);
                                        }
                                    })(__iced_k);
                                }
                            });
                        })(this)((function(_this) {
                            return function() {
                                return cb(err, ret);
                            };
                        })(this));
                    };

                    Encryption.prototype.encrypt = function(params, cb) {
                        var esc, recvr, sender, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        esc = make_esc(cb, "encrypt");
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/Users/max/src/keybase/kbpgp/src/keybase/packet/encryption.iced",
                                    funcname: "Encryption.encrypt"
                                });
                                _this.get_sender_keypair({
                                    encrypt: true
                                }, esc(__iced_deferrals.defer({
                                    assign_fn: (function() {
                                        return function() {
                                            return sender = arguments[0];
                                        };
                                    })(),
                                    lineno: 71
                                })));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                recvr = _this.encrypt_for.get_keypair();
                                (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/keybase/packet/encryption.iced",
                                        funcname: "Encryption.encrypt"
                                    });
                                    recvr.encrypt_kb({
                                        plaintext: _this.plaintext,
                                        sender: sender,
                                        nonce: _this.nonce
                                    }, esc(__iced_deferrals.defer({
                                        assign_fn: (function(__slot_1, __slot_2) {
                                            return function() {
                                                __slot_1.ciphertext = arguments[0].ciphertext;
                                                return __slot_2.nonce = arguments[0].nonce;
                                            };
                                        })(_this, _this),
                                        lineno: 73
                                    })));
                                    __iced_deferrals._fulfill();
                                })(function() {
                                    if (!(_this.anonymous && !_this.ephemeral)) {
                                        _this.sender_key = sender.ekid();
                                    }
                                    if (!_this.anonymous) {
                                        _this.receiver_key = recvr.ekid();
                                    }
                                    return cb(null);
                                });
                            };
                        })(this));
                    };

                    Encryption.prototype.decrypt = function(_arg, cb) {
                        var args, encrypt_for, esc, recvr, sender, sign_with, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        sign_with = _arg.sign_with, encrypt_for = _arg.encrypt_for;
                        esc = make_esc(cb, "decrypt");
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/Users/max/src/keybase/kbpgp/src/keybase/packet/encryption.iced",
                                    funcname: "Encryption.decrypt"
                                });
                                _this.get_sender_keypair({
                                    sign_with: sign_with
                                }, esc(__iced_deferrals.defer({
                                    assign_fn: (function() {
                                        return function() {
                                            return sender = arguments[0];
                                        };
                                    })(),
                                    lineno: 82
                                })));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                args = {
                                    ciphertext: _this.ciphertext,
                                    nonce: _this.nonce,
                                    sender: sender
                                };
                                recvr = encrypt_for.get_keypair();
                                (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/keybase/packet/encryption.iced",
                                        funcname: "Encryption.decrypt"
                                    });
                                    recvr.decrypt_kb(args, esc(__iced_deferrals.defer({
                                        assign_fn: (function(__slot_1) {
                                            return function() {
                                                return __slot_1.plaintext = arguments[0];
                                            };
                                        })(_this),
                                        lineno: 85
                                    })));
                                    __iced_deferrals._fulfill();
                                })(function() {
                                    return cb(null, {
                                        sender_keypair: sender,
                                        plaintext: _this.plaintext,
                                        receiver_keypair: recvr
                                    });
                                });
                            };
                        })(this));
                    };

                    Encryption.prototype.unbox = function(_arg, cb) {
                        var encrypt_for, err, res, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        encrypt_for = _arg.encrypt_for;
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/Users/max/src/keybase/kbpgp/src/keybase/packet/encryption.iced",
                                    funcname: "Encryption.unbox"
                                });
                                _this.decrypt({
                                    encrypt_for: encrypt_for
                                }, __iced_deferrals.defer({
                                    assign_fn: (function() {
                                        return function() {
                                            err = arguments[0];
                                            return res = arguments[1];
                                        };
                                    })(),
                                    lineno: 91
                                }));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                return cb(err, res);
                            };
                        })(this));
                    };

                    Encryption.box = function(_arg, cb) {
                        var anonymous, encrypt_for, err, nonce, packet, plaintext, sign_with, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        sign_with = _arg.sign_with, encrypt_for = _arg.encrypt_for, plaintext = _arg.plaintext, anonymous = _arg.anonymous, nonce = _arg.nonce;
                        packet = new Encryption({
                            sign_with: sign_with,
                            encrypt_for: encrypt_for,
                            plaintext: plaintext,
                            anonymous: anonymous,
                            nonce: nonce
                        });
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/Users/max/src/keybase/kbpgp/src/keybase/packet/encryption.iced",
                                    funcname: "Encryption.box"
                                });
                                packet.encrypt({}, __iced_deferrals.defer({
                                    assign_fn: (function() {
                                        return function() {
                                            return err = arguments[0];
                                        };
                                    })(),
                                    lineno: 98
                                }));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                if (typeof err !== "undefined" && err !== null) {
                                    packet = null;
                                }
                                return cb(err, packet);
                            };
                        })(this));
                    };

                    return Encryption;

                })(Packet);

                exports.Encryption = Encryption;

            }).call(this);

        }, {
            "../../const": 5,
            "../../nacl/main": 34,
            "./base": 21,
            "iced-error": 179,
            "iced-runtime": 183
        }],
        23: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var Decryptor, K, P3SKB, Packet, SHA512, box, bufeq_secure, bufferify, iced, make_esc, native_rng, pack, rsa, triplesec, __iced_k, __iced_k_noop, _ref, _ref1,
                    __hasProp = {}.hasOwnProperty,
                    __extends = function(child, parent) {
                        for (var key in parent) {
                            if (__hasProp.call(parent, key)) child[key] = parent[key];
                        }

                        function ctor() {
                            this.constructor = child;
                        }
                        ctor.prototype = parent.prototype;
                        child.prototype = new ctor();
                        child.__super__ = parent.prototype;
                        return child;
                    };

                iced = require('iced-runtime');
                __iced_k = __iced_k_noop = function() {};

                K = require('../../const').kb;

                triplesec = require('triplesec');

                SHA512 = require('../../hash').SHA512;

                Decryptor = triplesec.Decryptor;

                native_rng = triplesec.prng.native_rng;

                Packet = require('./base').Packet;

                _ref = require('../encode'), pack = _ref.pack, box = _ref.box;

                make_esc = require('iced-error').make_esc;

                rsa = require('../../rsa');

                _ref1 = require('../../util'), bufeq_secure = _ref1.bufeq_secure, bufferify = _ref1.bufferify;

                P3SKB = (function(_super) {
                    __extends(P3SKB, _super);

                    P3SKB.tag = function() {
                        return K.packet_tags.p3skb;
                    };

                    P3SKB.prototype.tag = function() {
                        return P3SKB.tag();
                    };

                    function P3SKB(_arg) {
                        var priv, priv_clear;
                        this.pub = _arg.pub, priv_clear = _arg.priv_clear, priv = _arg.priv, this.type = _arg.type;
                        P3SKB.__super__.constructor.call(this);
                        this.priv = priv != null ? priv : priv_clear != null ? {
                            data: priv_clear,
                            encryption: K.key_encryption.none
                        } : void 0;
                    }

                    P3SKB.prototype.get_packet_body = function() {
                        var ret;
                        ret = {
                            pub: this.pub,
                            priv: this.priv
                        };
                        if (this.type != null) {
                            ret.type = this.type;
                        }
                        return ret;
                    };

                    P3SKB.prototype.lock = function(_arg, cb) {
                        var asp, ct, err, passphrase_generation, tsenc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        asp = _arg.asp, tsenc = _arg.tsenc, passphrase_generation = _arg.passphrase_generation;
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/Users/max/src/keybase/kbpgp/src/keybase/packet/p3skb.iced",
                                    funcname: "P3SKB.lock"
                                });
                                tsenc.run({
                                    data: _this.priv.data,
                                    progress_hook: asp != null ? asp.progress_hook() : void 0
                                }, __iced_deferrals.defer({
                                    assign_fn: (function() {
                                        return function() {
                                            err = arguments[0];
                                            return ct = arguments[1];
                                        };
                                    })(),
                                    lineno: 30
                                }));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                if (typeof err === "undefined" || err === null) {
                                    _this.priv.data = ct;
                                    _this.priv.encryption = K.key_encryption.triplesec_v3;
                                    if (passphrase_generation != null) {
                                        _this.priv.passphrase_generation = passphrase_generation;
                                    }
                                }
                                return cb(err);
                            };
                        })(this));
                    };

                    P3SKB.prototype.unlock = function(_arg, cb) {
                        var a, asp, b, dec, err, passphrase_generation, progress_hook, raw, tsenc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        asp = _arg.asp, tsenc = _arg.tsenc, passphrase_generation = _arg.passphrase_generation;
                        (function(_this) {
                            return (function(__iced_k) {
                                switch (_this.priv.encryption) {
                                    case K.key_encryption.triplesec_v3:
                                    case K.key_encryption.triplesec_v2:
                                    case K.key_encryption.triplesec_v1:
                                        dec = new Decryptor({
                                            enc: tsenc
                                        });
                                        progress_hook = asp != null ? asp.progress_hook() : void 0;
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/Users/max/src/keybase/kbpgp/src/keybase/packet/p3skb.iced",
                                                funcname: "P3SKB.unlock"
                                            });
                                            dec.run({
                                                data: _this.priv.data,
                                                progress_hook: progress_hook
                                            }, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        err = arguments[0];
                                                        return raw = arguments[1];
                                                    };
                                                })(),
                                                lineno: 42
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(function() {
                                            dec.scrub();
                                            return __iced_k(typeof err === "undefined" || err === null ? (_this.priv.data = raw, _this.priv.encryption = K.key_encryption.none) : ((a = passphrase_generation) != null) && ((b = _this.priv.passphrase_generation) != null) && (a !== b) ? err = new Error("Decryption failed, likely due to old passphrase (wanted v" + a + " but got v" + b + ") [" + (err.toString()) + "]") : void 0);
                                        });
                                        break;
                                    case K.key_encryption.none:
                                        return __iced_k();
                                    default:
                                        return __iced_k(err = new Error("Unknown key encryption type: " + k.encryption));
                                }
                            });
                        })(this)((function(_this) {
                            return function() {
                                return cb(err);
                            };
                        })(this));
                    };

                    P3SKB.alloc = function(_arg) {
                        var body, tag;
                        tag = _arg.tag, body = _arg.body;
                        if (tag === P3SKB.tag()) {
                            return new P3SKB(body);
                        } else {
                            throw new Error("wrong tag found: " + tag);
                        }
                    };

                    P3SKB.prototype.has_private = function() {
                        return this.priv != null;
                    };

                    P3SKB.prototype.is_locked = function() {
                        return this.priv.encryption !== K.key_encryption.none;
                    };

                    P3SKB.prototype.get_private_data = function() {
                        var _ref2;
                        return (_ref2 = this.priv) != null ? _ref2.data : void 0;
                    };

                    P3SKB.prototype.get_public_data = function() {
                        return this.pub;
                    };

                    P3SKB.prototype.get_key_type = function() {
                        return this.type;
                    };

                    P3SKB.prototype.is_p3skb = function() {
                        return true;
                    };

                    return P3SKB;

                })(Packet);

                exports.P3SKB = P3SKB;

            }).call(this);

        }, {
            "../../const": 5,
            "../../hash": 16,
            "../../rsa": 69,
            "../../util": 72,
            "../encode": 18,
            "./base": 21,
            "iced-error": 179,
            "iced-runtime": 183,
            "triplesec": 282
        }],
        24: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var C, K, Packet, Signature, eddsa, iced, konst, make_esc, __iced_k, __iced_k_noop,
                    __hasProp = {}.hasOwnProperty,
                    __extends = function(child, parent) {
                        for (var key in parent) {
                            if (__hasProp.call(parent, key)) child[key] = parent[key];
                        }

                        function ctor() {
                            this.constructor = child;
                        }
                        ctor.prototype = parent.prototype;
                        child.prototype = new ctor();
                        child.__super__ = parent.prototype;
                        return child;
                    };

                iced = require('iced-runtime');
                __iced_k = __iced_k_noop = function() {};

                konst = require('../../const');

                K = konst.kb;

                C = konst.openpgp;

                Packet = require('./base').Packet;

                make_esc = require('iced-error').make_esc;

                eddsa = require('../../nacl/main').eddsa;

                Signature = (function(_super) {
                    __extends(Signature, _super);

                    Signature.SIG_TYPE = K.public_key_algorithms.NACL_EDDSA;

                    Signature.HASH_TYPE = C.hash_algorithms.SHA512;

                    Signature.tag = function() {
                        return K.packet_tags.signature;
                    };

                    Signature.prototype.tag = function() {
                        return Signature.tag();
                    };

                    function Signature(_arg) {
                        this.key = _arg.key, this.payload = _arg.payload, this.sig = _arg.sig, this.detached = _arg.detached;
                        Signature.__super__.constructor.call(this);
                    }

                    Signature.prototype.get_packet_body = function() {
                        var hash_type, sig_type;
                        sig_type = Signature.SIG_TYPE;
                        hash_type = Signature.HASH_TYPE;
                        return {
                            key: this.key,
                            payload: this.payload,
                            sig: this.sig,
                            detached: this.detached,
                            sig_type: sig_type,
                            hash_type: hash_type
                        };
                    };

                    Signature.alloc = function(_arg) {
                        var a, b, body, err, ret, tag;
                        tag = _arg.tag, body = _arg.body;
                        ret = null;
                        err = tag !== Signature.tag() ? new Error("wrong tag found: " + tag) : (a = body.hash_type) !== (b = Signature.HASH_TYPE) ? new Error("Expected SHA512 (type " + b + "); got " + a) : (a = body.sig_type) !== (b = Signature.SIG_TYPE) ? err = new Error("Expected EDDSA (type " + b + "); got " + a) : (ret = new Signature(body), null);
                        if (err != null) {
                            throw err;
                        }
                        return ret;
                    };

                    Signature.prototype.is_signature = function() {
                        return true;
                    };

                    Signature.prototype.verify = function(cb) {
                        var err, esc, km, pair, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        esc = make_esc(cb, "verify");
                        err = km = null;
                        _ref = eddsa.Pair.parse_kb(this.key), err = _ref[0], pair = _ref[1];
                        (function(_this) {
                            return (function(__iced_k) {
                                if (err == null) {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/Users/max/src/keybase/kbpgp/src/keybase/packet/signature.iced",
                                            funcname: "Signature.verify"
                                        });
                                        pair.verify_kb(_this, esc(__iced_deferrals.defer({
                                            lineno: 58
                                        })));
                                        __iced_deferrals._fulfill();
                                    })(__iced_k);
                                } else {
                                    return __iced_k();
                                }
                            });
                        })(this)((function(_this) {
                            return function() {
                                return cb(err, {
                                    keypair: pair,
                                    payload: _this.payload
                                });
                            };
                        })(this));
                    };

                    Signature.prototype.unbox = function(params, cb) {
                        var err, res, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/Users/max/src/keybase/kbpgp/src/keybase/packet/signature.iced",
                                    funcname: "Signature.unbox"
                                });
                                _this.verify(__iced_deferrals.defer({
                                    assign_fn: (function() {
                                        return function() {
                                            err = arguments[0];
                                            return res = arguments[1];
                                        };
                                    })(),
                                    lineno: 64
                                }));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                return cb(err, res);
                            };
                        })(this));
                    };

                    Signature.box = function(_arg, cb) {
                        var detached, esc, km, packet, pair, payload, sig, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        km = _arg.km, payload = _arg.payload;
                        esc = make_esc(cb, "@sign");
                        pair = km.get_keypair();
                        detached = true;
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/Users/max/src/keybase/kbpgp/src/keybase/packet/signature.iced",
                                    funcname: "Signature.box"
                                });
                                pair.sign_kb({
                                    payload: payload,
                                    detached: detached
                                }, esc(__iced_deferrals.defer({
                                    assign_fn: (function() {
                                        return function() {
                                            return sig = arguments[0];
                                        };
                                    })(),
                                    lineno: 73
                                })));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                packet = new Signature({
                                    key: pair.ekid(),
                                    payload: payload,
                                    sig: sig,
                                    detached: detached
                                });
                                return cb(null, packet);
                            };
                        })(this));
                    };

                    return Signature;

                })(Packet);

                exports.Signature = Signature;

                exports.sign = Signature.sign;

            }).call(this);

        }, {
            "../../const": 5,
            "../../nacl/main": 34,
            "./base": 21,
            "iced-error": 179,
            "iced-runtime": 183
        }],
        25: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var SRF, bufxor, genseed, iced, __iced_k, __iced_k_noop;

                    iced = require('iced-runtime');
                    __iced_k = __iced_k_noop = function() {};

                    SRF = require('../rand').SRF;

                    exports.bufxor = bufxor = function(b1, b2) {
                        var arr, c, i;
                        arr = (function() {
                            var _i, _len, _results;
                            _results = [];
                            for (i = _i = 0, _len = b1.length; _i < _len; i = ++_i) {
                                c = b1[i];
                                _results.push(c ^ b2[i]);
                            }
                            return _results;
                        })();
                        return new Buffer(arr);
                    };

                    exports.genseed = genseed = function(_arg, cb) {
                        var err, len, rseed, seed, server_half, split, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        seed = _arg.seed, split = _arg.split, len = _arg.len, server_half = _arg.server_half;
                        err = rseed = null;
                        if (server_half == null) {
                            server_half = null;
                        }
                        (function(_this) {
                            return (function(__iced_k) {
                                if ((seed == null) || (split && (server_half == null))) {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/Users/max/src/keybase/kbpgp/src/keybase/util.iced"
                                        });
                                        SRF().random_bytes(len, __iced_deferrals.defer({
                                            assign_fn: (function() {
                                                return function() {
                                                    return rseed = arguments[0];
                                                };
                                            })(),
                                            lineno: 16
                                        }));
                                        __iced_deferrals._fulfill();
                                    })(__iced_k);
                                } else {
                                    return __iced_k();
                                }
                            });
                        })(this)((function(_this) {
                            return function() {
                                if ((seed != null) && seed.length !== len) {
                                    err = new Error("Wrong seed length; need " + len + " bytes; got " + seed.length);
                                } else if ((seed != null) && (rseed != null)) {
                                    server_half = rseed;
                                    seed = bufxor(seed, rseed);
                                } else if ((seed != null) && (server_half != null)) {
                                    seed = bufxor(seed, server_half);
                                } else if (seed == null) {
                                    seed = rseed;
                                }
                                return cb(err, {
                                    seed: seed,
                                    server_half: server_half
                                });
                            };
                        })(this));
                    };

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../rand": 67,
            "buffer": 126,
            "iced-runtime": 183
        }],
        26: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var KeyFetcher;

                KeyFetcher = (function() {
                    function KeyFetcher() {}

                    KeyFetcher.prototype.fetch = function(ids, ops, cb) {
                        return cb(new Error("not implemented"));
                    };

                    return KeyFetcher;

                })();

                exports.KeyFetcher = KeyFetcher;

            }).call(this);

        }, {}],
        27: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var KeyFetcher, PgpKeyRing, hexkid,
                    __hasProp = {}.hasOwnProperty,
                    __extends = function(child, parent) {
                        for (var key in parent) {
                            if (__hasProp.call(parent, key)) child[key] = parent[key];
                        }

                        function ctor() {
                            this.constructor = child;
                        }
                        ctor.prototype = parent.prototype;
                        child.prototype = new ctor();
                        child.__super__ = parent.prototype;
                        return child;
                    };

                KeyFetcher = require('./keyfetch').KeyFetcher;

                hexkid = function(k) {
                    return k.toString('hex');
                };

                PgpKeyRing = (function(_super) {
                    __extends(PgpKeyRing, _super);

                    function PgpKeyRing() {
                        this._keys = {};
                        this._kms = {};
                    }

                    PgpKeyRing.prototype.add_key_manager = function(km) {
                        var k, keys, kid, _i, _len, _results;
                        keys = km.export_pgp_keys_to_keyring();
                        _results = [];
                        for (_i = 0, _len = keys.length; _i < _len; _i++) {
                            k = keys[_i];
                            kid = hexkid(k.key_material.get_key_id());
                            this._keys[kid] = k;
                            _results.push(this._kms[kid] = km);
                        }
                        return _results;
                    };

                    PgpKeyRing.prototype.fetch = function(key_ids, ops, cb) {
                        var err, hex_key_ids, i, id, k, key_material, km, obj, ret_i, _i, _len, _ref;
                        key_material = err = obj = null;
                        hex_key_ids = (function() {
                            var _i, _len, _results;
                            _results = [];
                            for (_i = 0, _len = key_ids.length; _i < _len; _i++) {
                                k = key_ids[_i];
                                _results.push(hexkid(k));
                            }
                            return _results;
                        })();
                        km = null;
                        for (i = _i = 0, _len = hex_key_ids.length; _i < _len; i = ++_i) {
                            id = hex_key_ids[i];
                            k = this._keys[id];
                            if (k != null ? (_ref = k.key) != null ? _ref.can_perform(ops) : void 0 : void 0) {
                                ret_i = i;
                                km = this._kms[id];
                                break;
                            }
                        }
                        if (km == null) {
                            err = new Error("key not found: " + (JSON.stringify(hex_key_ids)));
                        }
                        if (km) {
                            return km.fetch(key_ids, ops, cb);
                        } else {
                            return cb(err, km, ret_i);
                        }
                    };

                    PgpKeyRing.prototype.find_best_key = function(_arg, cb) {
                        var err, flags, key, key_id, kid, km;
                        key_id = _arg.key_id, flags = _arg.flags;
                        if ((km = this._kms[(kid = hexkid(key_id))]) == null) {
                            err = new Error("Could not find key for fingerprint " + kid);
                        } else if ((key = km.find_best_pgp_key(flags)) == null) {
                            err = new Error("no matching key for flags: " + flags);
                        }
                        return cb(err, key);
                    };

                    PgpKeyRing.prototype.lookup = function(key_id) {
                        return this._keys[hexkid(key_id)];
                    };

                    return PgpKeyRing;

                })(KeyFetcher);

                exports.PgpKeyRing = PgpKeyRing;

                exports.KeyRing = PgpKeyRing;

            }).call(this);

        }, {
            "./keyfetch": 26
        }],
        28: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var C, KeyWrapper, Lifespan, Primary, Subkey,
                    __hasProp = {}.hasOwnProperty,
                    __extends = function(child, parent) {
                        for (var key in parent) {
                            if (__hasProp.call(parent, key)) child[key] = parent[key];
                        }

                        function ctor() {
                            this.constructor = child;
                        }
                        ctor.prototype = parent.prototype;
                        child.prototype = new ctor();
                        child.__super__ = parent.prototype;
                        return child;
                    };

                C = require('./const');

                Lifespan = (function() {
                    function Lifespan(_arg) {
                        this.generated = _arg.generated, this.expire_in = _arg.expire_in;
                        if (this.expire_in === void 0) {
                            this.expire_in = C.default_key_expire_in;
                        }
                    }

                    Lifespan.prototype.expires_earlier_than = function(l2) {
                        if (!l2.expire_in && this.expire_in) {
                            return true;
                        } else if (this.expire_in && !l2.expire_in) {
                            return false;
                        } else if (!this.expire_in && !l2.expire_in) {
                            return false;
                        } else {
                            return (this.generated + this.expire_in) < (l2.generated + l2.expire_in);
                        }
                    };

                    Lifespan.prototype.copy = function() {
                        return new Lifespan({
                            generated: this.generated,
                            expire_in: this.expire_in
                        });
                    };

                    return Lifespan;

                })();

                KeyWrapper = (function() {
                    function KeyWrapper(_arg) {
                        this.key = _arg.key, this.lifespan = _arg.lifespan, this._pgp = _arg._pgp, this._keybase = _arg._keybase, this.flags = _arg.flags;
                    }

                    KeyWrapper.prototype.ekid = function() {
                        return this.key.ekid();
                    };

                    KeyWrapper.prototype.overwrite_with_omitting_revokes = function(kw2) {
                        if (kw2._pgp.is_revoked()) {
                            return;
                        }
                        if (this._pgp.is_revoked() || this.lifespan.expires_earlier_than(kw2.lifespan)) {
                            return this.key = kw2.key, this.lifespan = kw2.lifespan, this._pgp = kw2._pgp, this._keybase = kw2._keybase, this.flags = kw2.flags, kw2;
                        }
                    };

                    return KeyWrapper;

                })();

                Subkey = (function(_super) {
                    __extends(Subkey, _super);

                    function Subkey(_arg) {
                        var flags, key, lifespan, _keybase, _pgp;
                        key = _arg.key, flags = _arg.flags, _pgp = _arg._pgp, _keybase = _arg._keybase, this.desc = _arg.desc, lifespan = _arg.lifespan, this.primary = _arg.primary;
                        Subkey.__super__.constructor.call(this, {
                            key: key,
                            lifespan: lifespan,
                            flags: flags,
                            _pgp: _pgp,
                            _keybase: _keybase
                        });
                    }

                    return Subkey;

                })(KeyWrapper);

                Primary = (function(_super) {
                    __extends(Primary, _super);

                    function Primary(_arg) {
                        var flags, key, lifespan, _keybase, _pgp;
                        key = _arg.key, lifespan = _arg.lifespan, flags = _arg.flags, _pgp = _arg._pgp, _keybase = _arg._keybase;
                        Primary.__super__.constructor.call(this, {
                            key: key,
                            lifespan: lifespan,
                            flags: flags,
                            _pgp: _pgp,
                            _keybase: _keybase
                        });
                    }

                    return Primary;

                })(KeyWrapper);

                exports.Lifespan = Lifespan;

                exports.Subkey = Subkey;

                exports.Primary = Primary;

            }).call(this);

        }, {
            "./const": 5
        }],
        29: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var EUI, KeyFetcher, KeyManagerInterface, SignatureEngineInterface, iced, make_esc, __iced_k, __iced_k_noop,
                    __hasProp = {}.hasOwnProperty,
                    __extends = function(child, parent) {
                        for (var key in parent) {
                            if (__hasProp.call(parent, key)) child[key] = parent[key];
                        }

                        function ctor() {
                            this.constructor = child;
                        }
                        ctor.prototype = parent.prototype;
                        child.prototype = new ctor();
                        child.__super__ = parent.prototype;
                        return child;
                    };

                iced = require('iced-runtime');
                __iced_k = __iced_k_noop = function() {};

                KeyFetcher = require('./keyfetch').KeyFetcher;

                make_esc = require('iced-error').make_esc;

                EUI = new Error("not implemented");

                exports.KeyManagerInterface = KeyManagerInterface = (function(_super) {
                    __extends(KeyManagerInterface, _super);

                    function KeyManagerInterface() {}

                    KeyManagerInterface.prototype.get_pgp_fingerprint = function() {
                        return null;
                    };

                    KeyManagerInterface.prototype.get_ekid = function() {
                        return null;
                    };

                    KeyManagerInterface.prototype.get_fp2 = function() {
                        return null;
                    };

                    KeyManagerInterface.prototype.get_fp2_formatted = function() {
                        return null;
                    };

                    KeyManagerInterface.prototype.get_type = function() {
                        return null;
                    };

                    KeyManagerInterface.prototype.check_public_eq = function(km2) {
                        return this.EUI;
                    };

                    KeyManagerInterface.prototype.get_userids = function() {
                        return [];
                    };

                    KeyManagerInterface.prototype.get_primary_keypair = function() {
                        return null;
                    };

                    KeyManagerInterface.prototype.get_all_pgp_key_materials = function() {
                        return [];
                    };

                    KeyManagerInterface.prototype.get_userids_mark_primary = function() {
                        return [];
                    };

                    KeyManagerInterface.prototype.make_sig_eng = function() {
                        return null;
                    };

                    KeyManagerInterface.prototype.export_pgp_public = function(opts, cb) {
                        return cb(null, null);
                    };

                    KeyManagerInterface.prototype.export_pgp_private = function(opts, cb) {
                        return cb(null, null);
                    };

                    KeyManagerInterface.prototype.export_public = function(_arg, cb) {
                        var asp, regen;
                        asp = _arg.asp, regen = _arg.regen;
                        return cb(EUI, null);
                    };

                    KeyManagerInterface.prototype.export_private = function(_arg, cb) {
                        var asp, p3skb, passphrase;
                        asp = _arg.asp, passphrase = _arg.passphrase, p3skb = _arg.p3skb;
                        return cb(EUI);
                    };

                    KeyManagerInterface.prototype.can_verify = function() {
                        return false;
                    };

                    KeyManagerInterface.prototype.can_sign = function() {
                        return false;
                    };

                    KeyManagerInterface.prototype.can_encrypt = function() {
                        return false;
                    };

                    KeyManagerInterface.prototype.can_decrypt = function() {
                        return false;
                    };

                    KeyManagerInterface.prototype.get_all_pgp_key_ids = function() {
                        return [];
                    };

                    KeyManagerInterface.prototype.pgp_full_hash = function(opts, cb) {
                        return cb(null, null);
                    };

                    return KeyManagerInterface;

                })(KeyFetcher);

                exports.SignatureEngineInterface = SignatureEngineInterface = (function() {
                    function SignatureEngineInterface(_arg) {
                        this.km = _arg.km;
                    }

                    SignatureEngineInterface.prototype.get_km = function() {
                        return this.km;
                    };

                    SignatureEngineInterface.prototype.box = function(msg, cb) {
                        return cb(EUI);
                    };

                    SignatureEngineInterface.prototype.unbox = function(msb, cb) {
                        return cb(EUI);
                    };

                    SignatureEngineInterface.prototype.get_body = function(_arg, cb) {
                        var armored;
                        armored = _arg.armored;
                        return cb(EUI);
                    };

                    SignatureEngineInterface.prototype.get_unverified_payload_from_raw_sig_body = function(_arg, cb) {
                        var body;
                        body = _arg.body;
                        return cb(EUI);
                    };

                    SignatureEngineInterface.prototype.get_body_and_unverified_payload = function(_arg, cb) {
                        var armored, body, esc, payload, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        armored = _arg.armored;
                        esc = make_esc(cb, "get_body_and_unverified_payload");
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/Users/max/src/keybase/kbpgp/src/kmi.iced",
                                    funcname: "SignatureEngineInterface.get_body_and_unverified_payload"
                                });
                                _this.get_body({
                                    armored: armored
                                }, esc(__iced_deferrals.defer({
                                    assign_fn: (function() {
                                        return function() {
                                            return body = arguments[0];
                                        };
                                    })(),
                                    lineno: 96
                                })));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/kmi.iced",
                                        funcname: "SignatureEngineInterface.get_body_and_unverified_payload"
                                    });
                                    _this.get_unverified_payload_from_raw_sig_body({
                                        body: body
                                    }, esc(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return payload = arguments[0];
                                            };
                                        })(),
                                        lineno: 97
                                    })));
                                    __iced_deferrals._fulfill();
                                })(function() {
                                    return cb(null, body, payload);
                                });
                            };
                        })(this));
                    };

                    return SignatureEngineInterface;

                })();

            }).call(this);

        }, {
            "./keyfetch": 26,
            "iced-error": 179,
            "iced-runtime": 183
        }],
        30: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var k, m, mods, util, v, _i, _len;

                    mods = [require("./openpgp/keymanager"), require("./basex"), require("./openpgp/burner"), require("./openpgp/hilev"), require("./keyfetch"), require("./keyring"), require('./errors')];

                    for (_i = 0, _len = mods.length; _i < _len; _i++) {
                        m = mods[_i];
                        for (k in m) {
                            v = m[k];
                            exports[k] = v;
                        }
                    }

                    exports.util = util = require('./util');

                    exports.ASP = util.ASP;

                    exports.rand = require('./rand');

                    exports["const"] = require('./const');

                    exports.processor = require('./openpgp/processor');

                    exports.armor = require('./openpgp/armor');

                    exports.keyring = require('./keyring');

                    exports.parser = require('./openpgp/parser');

                    exports.Buffer = Buffer;

                    exports.triplesec = require('triplesec');

                    exports.hash = require('./hash');

                    exports.ecc = require('./ecc/main');

                    exports.nacl = require('./nacl/main');

                    exports.kb = require('./keybase/hilev');

                    exports.ukm = require('./ukm');

                    exports.asym = require('./asymmetric');

                    exports.bn = require('./bn');

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "./asymmetric": 1,
            "./basex": 3,
            "./bn": 4,
            "./const": 5,
            "./ecc/main": 12,
            "./errors": 15,
            "./hash": 16,
            "./keybase/hilev": 19,
            "./keyfetch": 26,
            "./keyring": 27,
            "./nacl/main": 34,
            "./openpgp/armor": 35,
            "./openpgp/burner": 38,
            "./openpgp/hilev": 43,
            "./openpgp/keymanager": 44,
            "./openpgp/parser": 58,
            "./openpgp/processor": 59,
            "./rand": 67,
            "./ukm": 71,
            "./util": 72,
            "buffer": 126,
            "triplesec": 282
        }],
        31: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var BaseKeyPair, Pair,
                    __hasProp = {}.hasOwnProperty,
                    __extends = function(child, parent) {
                        for (var key in parent) {
                            if (__hasProp.call(parent, key)) child[key] = parent[key];
                        }

                        function ctor() {
                            this.constructor = child;
                        }
                        ctor.prototype = parent.prototype;
                        child.prototype = new ctor();
                        child.__super__ = parent.prototype;
                        return child;
                    };

                BaseKeyPair = require('../basekeypair').BaseKeyPair;

                exports.BaseKeyPair = Pair = (function(_super) {
                    __extends(Pair, _super);

                    function Pair() {
                        return Pair.__super__.constructor.apply(this, arguments);
                    }

                    Pair.prototype.export_secret_key_kb = function(args, cb) {
                        var err, res, _ref;
                        err = res = null;
                        if ((res = (_ref = this.priv) != null ? _ref.key : void 0) == null) {
                            err = new Error("no private key available");
                        }
                        return cb(err, res);
                    };

                    return Pair;

                })(BaseKeyPair);

            }).call(this);

        }, {
            "../basekeypair": 2
        }],
        32: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var BaseKey, BaseKeyPair, K, NaclEddsa, Pair, Priv, Pub, SRF, TYPE, b2u, box, bufeq_fast, genseed, iced, konst, u2b, __iced_k, __iced_k_noop, _ref, _ref1,
                        __hasProp = {}.hasOwnProperty,
                        __extends = function(child, parent) {
                            for (var key in parent) {
                                if (__hasProp.call(parent, key)) child[key] = parent[key];
                            }

                            function ctor() {
                                this.constructor = child;
                            }
                            ctor.prototype = parent.prototype;
                            child.prototype = new ctor();
                            child.__super__ = parent.prototype;
                            return child;
                        };

                    iced = require('iced-runtime');
                    __iced_k = __iced_k_noop = function() {};

                    box = require('tweetnacl').box;

                    SRF = require('../rand').SRF;

                    konst = require('../const');

                    K = konst.kb;

                    _ref = require('../util'), genseed = _ref.genseed, bufeq_fast = _ref.bufeq_fast;

                    BaseKey = require('../basekeypair').BaseKey;

                    BaseKeyPair = require('./base').BaseKeyPair;

                    _ref1 = require('./eddsa'), b2u = _ref1.b2u, u2b = _ref1.u2b;

                    NaclEddsa = require('./eddsa').Pair;

                    TYPE = K.public_key_algorithms.NACL_DH;

                    b2u = function(b) {
                        return new Uint8Array(b);
                    };

                    u2b = function(u) {
                        return new Buffer(u);
                    };

                    Pub = (function() {
                        Pub.HEADER = new Buffer([K.kid.version, TYPE]);

                        Pub.TRAILER = new Buffer([K.kid.trailer]);

                        Pub.LEN = Pub.HEADER.length + Pub.TRAILER.length + box.publicKeyLength;

                        function Pub(key) {
                            this.key = key;
                        }

                        Pub.alloc_kb = function(kid) {
                            var err, key;
                            err = key = null;
                            err = kid.length !== Pub.LEN ? new Error("bad key length") : !bufeq_fast(kid.slice(-1), Pub.TRAILER) ? new Error("bad trailing byte") : !bufeq_fast(kid.slice(0, 2), Pub.HEADER) ? new Error("bad header") : (key = new Pub(kid.slice(2, -1)), null);
                            return [err, key];
                        };

                        Pub.prototype.serialize = function() {
                            return this.key;
                        };

                        Pub.prototype.nbits = function() {
                            return 255;
                        };

                        Pub.prototype.read_params = function(sb) {};

                        Pub.prototype.encrypt = function(_arg, cb) {
                            var ciphertext, err, nonce, plaintext, res, ret, sender, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            plaintext = _arg.plaintext, sender = _arg.sender, nonce = _arg.nonce;
                            err = ret = null;
                            (function(_this) {
                                return (function(__iced_k) {
                                    if (nonce == null) {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/Users/max/src/keybase/kbpgp/src/nacl/dh.iced",
                                                funcname: "Pub.encrypt"
                                            });
                                            SRF().random_bytes(box.nonceLength, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        return nonce = arguments[0];
                                                    };
                                                })(),
                                                lineno: 52
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(__iced_k);
                                    } else {
                                        return __iced_k(nonce.length !== box.nonceLength ? err = new Error("bad nonce; wrong length (wanted " + box.nonceLength + ")") : void 0);
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    if (err == null) {
                                        res = box(b2u(plaintext), b2u(nonce), b2u(_this.key), b2u(sender.priv.key));
                                        ciphertext = u2b(res);
                                        ret = {
                                            ciphertext: ciphertext,
                                            nonce: nonce
                                        };
                                    }
                                    return cb(err, ret);
                                };
                            })(this));
                        };

                        return Pub;

                    })();

                    Priv = (function() {
                        function Priv(key) {
                            this.key = key;
                        }

                        Priv.prototype.alloc = function(raw) {
                            var err, key;
                            err = key = null;
                            if (raw.length !== box.secretKeyLength) {
                                err = new Error("Bad secret key length");
                            } else {
                                key = new Priv(raw);
                            }
                            return [err, key];
                        };

                        Priv.prototype.decrypt = function(_arg, cb) {
                            var ciphertext, err, nonce, res, sender;
                            ciphertext = _arg.ciphertext, nonce = _arg.nonce, sender = _arg.sender;
                            err = res = null;
                            res = box.open(b2u(ciphertext), b2u(nonce), b2u(sender.pub.key), b2u(this.key));
                            if (res === false) {
                                err = new Error("decryption failed");
                                res = null;
                            } else {
                                res = u2b(res);
                            }
                            return cb(err, res);
                        };

                        return Priv;

                    })();

                    Pair = (function(_super) {
                        __extends(Pair, _super);

                        Pair.Pub = Pub;

                        Pair.prototype.Pub = Pub;

                        Pair.Priv = Priv;

                        Pair.prototype.Priv = Priv;

                        function Pair(_arg) {
                            var priv, pub;
                            pub = _arg.pub, priv = _arg.priv;
                            Pair.__super__.constructor.call(this, {
                                pub: pub,
                                priv: priv
                            });
                        }

                        Pair.type = K.public_key_algorithms.NACL_DH;

                        Pair.prototype.type = Pair.type;

                        Pair.prototype.get_type = function() {
                            return this.type;
                        };

                        Pair.klass_name = "DH";

                        Pair.prototype.can_encrypt = function() {
                            return true;
                        };

                        Pair.prototype.can_sign = function() {
                            return false;
                        };

                        Pair.prototype.hash = function() {
                            return this.serialize();
                        };

                        Pair.prototype.encrypt_kb = function(_arg, cb) {
                            var nonce, plaintext, sender;
                            plaintext = _arg.plaintext, sender = _arg.sender, nonce = _arg.nonce;
                            return this.pub.encrypt({
                                plaintext: plaintext,
                                sender: sender,
                                nonce: nonce
                            }, cb);
                        };

                        Pair.prototype.decrypt_kb = function(_arg, cb) {
                            var ciphertext, err, nonce, plaintex, plaintext, sender, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            ciphertext = _arg.ciphertext, nonce = _arg.nonce, sender = _arg.sender;
                            err = plaintex = null;
                            (function(_this) {
                                return (function(__iced_k) {
                                    if (_this.priv != null) {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/Users/max/src/keybase/kbpgp/src/nacl/dh.iced",
                                                funcname: "Pair.decrypt_kb"
                                            });
                                            _this.priv.decrypt({
                                                ciphertext: ciphertext,
                                                nonce: nonce,
                                                sender: sender
                                            }, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        err = arguments[0];
                                                        return plaintext = arguments[1];
                                                    };
                                                })(),
                                                lineno: 125
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(__iced_k);
                                    } else {
                                        return __iced_k(err = new Error("no secret key available"));
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err, plaintext);
                                };
                            })(this));
                        };

                        Pair.subkey_algo = function(flags) {
                            if (flags & (C.key_flags.encrypt_comm | C.key_flags.encrypt_storage)) {
                                return Pair;
                            } else {
                                return NaclEddsa;
                            }
                        };

                        Pair.prototype.fulfills_flags = function(flags) {
                            var good_for;
                            good_for = C.key_flags.encrypt_comm | C.key_flags.encrypt_storage;
                            return (flags & good_for) === flags;
                        };

                        Pair.prototype.verify_unpad_and_check_hash = function(_arg, cb) {
                            var data, hash, hasher, sig;
                            sig = _arg.sig, data = _arg.data, hasher = _arg.hasher, hash = _arg.hash;
                            return cb(new Error("verify_unpad_and_check_hash unsupported"));
                        };

                        Pair.prototype.pad_and_sign = function(data, _arg, cb) {
                            var hasher;
                            hasher = _arg.hasher;
                            return cb(new Error("pad_and_sign unsupported"));
                        };

                        Pair.parse_kb = function(pub_raw) {
                            return BaseKeyPair.parse_kb(Pair, pub_raw);
                        };

                        Pair.parse_sig = function(slice) {
                            var err;
                            err = new Error("@parse_sig unsupported");
                            throw err;
                        };

                        Pair.read_sig_from_buf = function(buf) {
                            var err;
                            err = new Error("@read_sig_from_buf unsupported");
                            return [err];
                        };

                        Pair.generate = function(_arg, cb) {
                            var arg, err, priv, pub, publicKey, ret, secretKey, seed, server_half, split, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            server_half = _arg.server_half, seed = _arg.seed, split = _arg.split;
                            arg = {
                                seed: seed,
                                split: split,
                                len: box.secretKeyLength,
                                server_half: server_half
                            };
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/nacl/dh.iced",
                                        funcname: "Pair.generate"
                                    });
                                    genseed(arg, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                err = arguments[0];
                                                server_half = arguments[1].server_half;
                                                return seed = arguments[1].seed;
                                            };
                                        })(),
                                        lineno: 186
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    var _ref2;
                                    ret = null;
                                    if (typeof err === "undefined" || err === null) {
                                        _ref2 = box.keyPair.fromSecretKey(b2u(seed)), secretKey = _ref2.secretKey, publicKey = _ref2.publicKey;
                                        pub = new Pub(u2b(publicKey));
                                        priv = new Priv(u2b(secretKey));
                                        ret = new Pair({
                                            pub: pub,
                                            priv: priv
                                        });
                                    }
                                    return cb(err, ret, server_half);
                                };
                            })(this));
                        };

                        return Pair;

                    })(BaseKeyPair);

                    exports.DH = exports.Pair = Pair;

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../basekeypair": 2,
            "../const": 5,
            "../rand": 67,
            "../util": 72,
            "./base": 31,
            "./eddsa": 33,
            "buffer": 126,
            "iced-runtime": 183,
            "tweetnacl": 298
        }],
        33: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var BaseKey, BaseKeyPair, K, NaclDh, Pair, Priv, Pub, SRF, TYPE, b2u, bufeq_fast, bufeq_secure, genseed, iced, kbnacl, konst, u2b, __iced_k, __iced_k_noop, _ref,
                        __hasProp = {}.hasOwnProperty,
                        __extends = function(child, parent) {
                            for (var key in parent) {
                                if (__hasProp.call(parent, key)) child[key] = parent[key];
                            }

                            function ctor() {
                                this.constructor = child;
                            }
                            ctor.prototype = parent.prototype;
                            child.prototype = new ctor();
                            child.__super__ = parent.prototype;
                            return child;
                        };

                    iced = require('iced-runtime');
                    __iced_k = __iced_k_noop = function() {};

                    kbnacl = require('keybase-nacl');

                    SRF = require('../rand').SRF;

                    konst = require('../const');

                    K = konst.kb;

                    _ref = require('../util'), genseed = _ref.genseed, bufeq_secure = _ref.bufeq_secure, bufeq_fast = _ref.bufeq_fast;

                    BaseKey = require('../basekeypair').BaseKey;

                    BaseKeyPair = require('./base').BaseKeyPair;

                    NaclDh = require('./dh').Pair;

                    TYPE = K.public_key_algorithms.NACL_EDDSA;

                    exports.b2u = b2u = function(b) {
                        return new Uint8Array(b);
                    };

                    exports.u2b = u2b = function(u) {
                        return new Buffer(u);
                    };

                    Pub = (function() {
                        Pub.HEADER = new Buffer([K.kid.version, TYPE]);

                        Pub.TRAILER = new Buffer([K.kid.trailer]);

                        Pub.LEN = Pub.HEADER.length + Pub.TRAILER.length + kbnacl.sign.publicKeyLength;

                        function Pub(key) {
                            this.key = key;
                        }

                        Pub.alloc_kb = function(kid) {
                            var err, key;
                            err = key = null;
                            err = kid.length !== Pub.LEN ? new Error("bad key length") : !bufeq_fast(kid.slice(-1), Pub.TRAILER) ? new Error("bad trailing byte") : !bufeq_fast(kid.slice(0, 2), Pub.HEADER) ? new Error("bad header") : (key = new Pub(kid.slice(2, -1)), null);
                            return [err, key];
                        };

                        Pub.prototype.serialize = function() {
                            return this.key;
                        };

                        Pub.prototype.nbits = function() {
                            return 255;
                        };

                        Pub.prototype.read_params = function(sb) {};

                        Pub.prototype.verify = function(_arg, cb) {
                            var detached, err, naclw, payload, sig, _ref1;
                            payload = _arg.payload, sig = _arg.sig, detached = _arg.detached;
                            naclw = kbnacl.alloc({
                                publicKey: this.key
                            });
                            _ref1 = naclw.verify({
                                payload: payload,
                                sig: sig,
                                detached: detached
                            }), err = _ref1[0], payload = _ref1[1];
                            return cb(err, payload);
                        };

                        return Pub;

                    })();

                    Priv = (function() {
                        function Priv(key) {
                            this.key = key;
                        }

                        Priv.prototype.alloc = function(raw) {
                            var err, key;
                            err = key = null;
                            if (raw.length !== sign.secretKeyLength) {
                                err = new Error("Bad secret key length");
                            } else {
                                key = new Priv(raw);
                            }
                            return [err, key];
                        };

                        Priv.prototype.sign = function(_arg, cb) {
                            var detached, naclw, payload, sig;
                            payload = _arg.payload, detached = _arg.detached;
                            naclw = kbnacl.alloc({
                                secretKey: this.key
                            });
                            sig = naclw.sign({
                                payload: payload,
                                detached: detached
                            });
                            return cb(sig);
                        };

                        return Priv;

                    })();

                    Pair = (function(_super) {
                        __extends(Pair, _super);

                        Pair.Pub = Pub;

                        Pair.prototype.Pub = Pub;

                        Pair.Priv = Priv;

                        Pair.prototype.Priv = Priv;

                        Pair.type = K.public_key_algorithms.NACL_EDDSA;

                        Pair.prototype.type = Pair.type;

                        Pair.prototype.get_type = function() {
                            return this.type;
                        };

                        Pair.klass_name = "EDDSA";

                        function Pair(_arg) {
                            var priv, pub;
                            pub = _arg.pub, priv = _arg.priv;
                            Pair.__super__.constructor.call(this, {
                                pub: pub,
                                priv: priv
                            });
                        }

                        Pair.prototype.can_encrypt = function() {
                            return false;
                        };

                        Pair.prototype.hash = function() {
                            return this.serialize();
                        };

                        Pair.prototype.sign_kb = function(_arg, cb) {
                            var detached, err, payload, sig, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            payload = _arg.payload, detached = _arg.detached;
                            err = sig = null;
                            (function(_this) {
                                return (function(__iced_k) {
                                    if (_this.priv != null) {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/Users/max/src/keybase/kbpgp/src/nacl/eddsa.iced",
                                                funcname: "Pair.sign_kb"
                                            });
                                            _this.priv.sign({
                                                payload: payload,
                                                detached: detached
                                            }, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        return sig = arguments[0];
                                                    };
                                                })(),
                                                lineno: 108
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(__iced_k);
                                    } else {
                                        return __iced_k(err = new Error("no secret key available"));
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err, sig);
                                };
                            })(this));
                        };

                        Pair.prototype.verify_kb = function(_arg, cb) {
                            var detached, payload, sig;
                            payload = _arg.payload, sig = _arg.sig, detached = _arg.detached;
                            return this.pub.verify({
                                payload: payload,
                                sig: sig,
                                detached: detached
                            }, cb);
                        };

                        Pair.subkey_algo = function(flags) {
                            if (flags & (C.key_flags.certify_keys | C.key_flags.sign_data)) {
                                return Pair;
                            } else {
                                return NaclDh;
                            }
                        };

                        Pair.prototype.fulfills_flags = function(flags) {
                            var good_for;
                            good_for = C.key_flags.certify_keys | C.key_flags.sign_data;
                            return (flags & good_for) === flags;
                        };

                        Pair.prototype.verify_unpad_and_check_hash = function(_arg, cb) {
                            var data, hash, hasher, sig;
                            sig = _arg.sig, data = _arg.data, hasher = _arg.hasher, hash = _arg.hash;
                            return cb(new Error("verify_unpad_and_check_hash unsupported"));
                        };

                        Pair.prototype.pad_and_sign = function(data, _arg, cb) {
                            var hasher;
                            hasher = _arg.hasher;
                            return cb(new Error("pad_and_sign unsupported"));
                        };

                        Pair.parse_kb = function(pub_raw) {
                            return BaseKeyPair.parse_kb(Pair, pub_raw);
                        };

                        Pair.parse_sig = function(slice) {
                            var err;
                            err = new Error("@parse_sig unsupported");
                            throw err;
                        };

                        Pair.read_sig_from_buf = function(buf) {
                            var err;
                            err = new Error("@read_sig_from_buf unsupported");
                            return [err];
                        };

                        Pair.import_private = function(_arg, cb) {
                            var a, b, err, priv, pub, raw, ret;
                            raw = _arg.raw;
                            if ((a = raw.length) !== (b = kbnacl.sign.secretKeyLength)) {
                                err = new Error("Bad length: expected " + b + "} bytes, but got " + a);
                            } else {
                                pub = new Pub(raw.slice(-kbnacl.sign.publicKeyLength));
                                priv = new Priv(raw);
                                ret = new Pair({
                                    priv: priv,
                                    pub: pub
                                });
                            }
                            return cb(err, ret);
                        };

                        Pair.generate = function(_arg, cb) {
                            var arg, err, naclw, priv, pub, publicKey, ret, secretKey, seed, server_half, split, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            seed = _arg.seed, split = _arg.split, server_half = _arg.server_half;
                            arg = {
                                seed: seed,
                                split: split,
                                len: kbnacl.sign.seedLength,
                                server_half: server_half
                            };
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/nacl/eddsa.iced",
                                        funcname: "Pair.generate"
                                    });
                                    genseed(arg, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                err = arguments[0];
                                                server_half = arguments[1].server_half;
                                                return seed = arguments[1].seed;
                                            };
                                        })(),
                                        lineno: 185
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    var _ref1;
                                    ret = null;
                                    if (typeof err === "undefined" || err === null) {
                                        naclw = kbnacl.alloc({});
                                        _ref1 = naclw.genFromSeed({
                                            seed: seed
                                        }), secretKey = _ref1.secretKey, publicKey = _ref1.publicKey;
                                        pub = new Pub(publicKey);
                                        priv = new Priv(secretKey);
                                        ret = new Pair({
                                            pub: pub,
                                            priv: priv
                                        });
                                    }
                                    return cb(err, ret, server_half);
                                };
                            })(this));
                        };

                        return Pair;

                    })(BaseKeyPair);

                    exports.EdDSA = exports.Pair = Pair;

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../basekeypair": 2,
            "../const": 5,
            "../rand": 67,
            "../util": 72,
            "./base": 31,
            "./dh": 32,
            "buffer": 126,
            "iced-runtime": 183,
            "keybase-nacl": 196
        }],
        34: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                exports.eddsa = require('./eddsa');

                exports.dh = require('./dh');

            }).call(this);

        }, {
            "./dh": 32,
            "./eddsa": 33
        }],
        35: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var C, Ch, Parser, armor, bufeq_fast, decode, decode_strict, katch, mdecode, uint_to_buffer, _ref,
                    __hasProp = {}.hasOwnProperty,
                    __extends = function(child, parent) {
                        for (var key in parent) {
                            if (__hasProp.call(parent, key)) child[key] = parent[key];
                        }

                        function ctor() {
                            this.constructor = child;
                        }
                        ctor.prototype = parent.prototype;
                        child.prototype = new ctor();
                        child.__super__ = parent.prototype;
                        return child;
                    };

                _ref = require('../util'), katch = _ref.katch, bufeq_fast = _ref.bufeq_fast, uint_to_buffer = _ref.uint_to_buffer;

                C = require('../const');

                Ch = require('../header');

                armor = require('pgp-utils').armor;

                exports.encode = function(type, data) {
                    var mt;
                    mt = C.openpgp.message_types;
                    type = (function() {
                        switch (type) {
                            case mt.public_key:
                                return "PUBLIC KEY BLOCK";
                            case mt.private_key:
                                return "PRIVATE KEY BLOCK";
                            case mt.signature:
                                return "SIGNATURE";
                            case mt.generic:
                                return "MESSAGE";
                            default:
                                throw new Error("Cannot encode tag type " + type);
                        }
                    })();
                    return armor.encode(Ch, type, data);
                };

                Parser = (function(_super) {
                    __extends(Parser, _super);

                    function Parser() {
                        return Parser.__super__.constructor.apply(this, arguments);
                    }

                    Parser.prototype.parse_type = function() {
                        var mt;
                        mt = C.openpgp.message_types;
                        this.ret.type = (function() {
                            switch (this.type) {
                                case "PUBLIC KEY BLOCK":
                                    return mt.public_key;
                                case "PRIVATE KEY BLOCK":
                                    return mt.private_key;
                                case "SIGNED MESSAGE":
                                    if (this.ret.clearsign) {
                                        return mt.clearsign;
                                    } else {
                                        throw new Error("Signed message, but not clear-signed");
                                    }
                                    break;
                                case "SIGNATURE":
                                    return mt.signature;
                                case "MESSAGE":
                                    return mt.generic;
                                default:
                                    throw new Error("Unknown message type: " + this.type);
                            }
                        }).call(this);
                        return this.ret.fields.type = this.type;
                    };

                    return Parser;

                })(armor.Parser);

                exports.Message = armor.Message;

                exports.decode = decode = function(data) {
                    return katch(function() {
                        return (new Parser(data)).parse();
                    });
                };

                exports.mdecode = mdecode = function(data) {
                    return katch(function() {
                        return (new Parser(data)).mparse();
                    });
                };

                exports.decode_strict = decode_strict = function(data) {
                    return katch(function() {
                        return (new Parser(data, {
                            strict: true
                        })).parse();
                    });
                };

            }).call(this);

        }, {
            "../const": 5,
            "../header": 17,
            "../util": 72,
            "pgp-utils": 229
        }],
        36: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var ASP, BaseBurner, iced, make_esc, __iced_k, __iced_k_noop,
                    __slice = [].slice;

                iced = require('iced-runtime');
                __iced_k = __iced_k_noop = function() {};

                make_esc = require('iced-error').make_esc;

                ASP = require('pgp-utils').util.ASP;

                exports.BaseBurner = BaseBurner = (function() {
                    function BaseBurner(_arg) {
                        this.sign_with = _arg.sign_with, this.encrypt_for = _arg.encrypt_for, this.signing_key = _arg.signing_key, this.encryption_key = _arg.encryption_key, this.asp = _arg.asp;
                        this.asp = ASP.make(this.asp);
                    }

                    BaseBurner.prototype._find_keys = function(cb) {
                        var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        esc = make_esc(cb, "find_keys");
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/Users/max/src/keybase/kbpgp/src/openpgp/baseburner.iced",
                                    funcname: "BaseBurner._find_keys"
                                });
                                _this._find_signing_key(esc(__iced_deferrals.defer({
                                    lineno: 17
                                })));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/openpgp/baseburner.iced",
                                        funcname: "BaseBurner._find_keys"
                                    });
                                    _this._find_encryption_key(esc(__iced_deferrals.defer({
                                        lineno: 18
                                    })));
                                    __iced_deferrals._fulfill();
                                })(function() {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/Users/max/src/keybase/kbpgp/src/openpgp/baseburner.iced",
                                            funcname: "BaseBurner._find_keys"
                                        });
                                        _this._assert_one(esc(__iced_deferrals.defer({
                                            lineno: 19
                                        })));
                                        __iced_deferrals._fulfill();
                                    })(function() {
                                        return cb(null);
                                    });
                                });
                            };
                        })(this));
                    };

                    BaseBurner.prototype._assert_one = function(cb) {
                        var err;
                        err = null;
                        if (!(this.signing_key != null) && !(this.encryption_keys != null)) {
                            err = new Error("need either an encryption or signing key, or both");
                        }
                        return cb(err);
                    };

                    BaseBurner.prototype._find_signing_key = function(cb) {
                        var err;
                        err = null;
                        if ((this.sign_with != null) && (this.signing_key != null)) {
                            err = new Error("specify either `sign_with` or `signing_key` but not both");
                        } else if ((this.sign_with != null) && ((this.signing_key = this.sign_with.find_signing_pgp_key()) == null)) {
                            err = new Error("cannot sign with the given KeyManager");
                        }
                        return cb(err);
                    };

                    BaseBurner.prototype._find_encryption_key = function(cb) {
                        var arrayize, count_true, err, f, i, k, _i, _len, _ref;
                        err = null;
                        count_true = function() {
                            var e, i, v, _i, _len;
                            v = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
                            i = 0;
                            for (_i = 0, _len = v.length; _i < _len; _i++) {
                                e = v[_i];
                                if (e) {
                                    i++;
                                }
                            }
                            return i;
                        };
                        arrayize = function(e) {
                            if (e == null) {
                                return [];
                            } else if (typeof e === 'object' && Array.isArray(e)) {
                                return e;
                            } else {
                                return [e];
                            }
                        };
                        if (count_true(this.encrypt_for != null, this.encryption_key != null, this.encryption_keys != null) > 1) {
                            err = new Error("specify only one of `encrypt_for`, `encryption_keys` and `encryption_key`");
                        } else if (this.encrypt_for != null) {
                            this.encryption_keys = [];
                            _ref = (this.encrypt_for = arrayize(this.encrypt_for));
                            for (i = _i = 0, _len = _ref.length; _i < _len; i = ++_i) {
                                f = _ref[i];
                                if ((k = f.find_crypt_pgp_key()) != null) {
                                    this.encryption_keys.push(k);
                                } else {
                                    err = new Error("cannot encrypt with the given KeyManager (i=" + i + ")");
                                    break;
                                }
                            }
                        } else if (this.encryption_key != null) {
                            this.encryption_keys = [this.encryption_key];
                        } else if (this.encryption_keys != null) {
                            this.encryption_keys = arrayize(this.encryption_keys);
                        }
                        return cb(err);
                    };

                    return BaseBurner;

                })();

            }).call(this);

        }, {
            "iced-error": 179,
            "iced-runtime": 183,
            "pgp-utils": 229
        }],
        37: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var SlicerBuffer;

                    SlicerBuffer = (function() {
                        function SlicerBuffer(buf, start) {
                            this.buf = buf;
                            this.start = start != null ? start : 0;
                            if (!Buffer.isBuffer(this.buf)) {
                                throw new Error('need a Buffer!');
                            }
                            this.i = this.start;
                            this._end = null;
                        }

                        SlicerBuffer.prototype.clamp = function(len) {
                            var ret;
                            ret = this._end;
                            this._end = this.i + len;
                            return ret;
                        };

                        SlicerBuffer.prototype.unclamp = function(e) {
                            this.start = this.i;
                            return this._end = e;
                        };

                        SlicerBuffer.prototype.len = function() {
                            return this.buf.length - this.start;
                        };

                        SlicerBuffer.prototype.rem = function() {
                            return this.buf.length - this.i;
                        };

                        SlicerBuffer.prototype.offset = function() {
                            return this.i - this.start;
                        };

                        SlicerBuffer.prototype.check = function() {
                            if ((this._end && this.i > this._end) || (this.i > this.buf.length)) {
                                throw new Error("read off the end of the packet @" + this.i + "/" + this.buf.length + "/" + this._end);
                            }
                        };

                        SlicerBuffer.prototype.read_uint8 = function() {
                            var ret;
                            ret = this.buf.readUInt8(this.i++);
                            this.check();
                            return ret;
                        };

                        SlicerBuffer.prototype.read_uint16 = function() {
                            var ret;
                            ret = this.buf.readUInt16BE(this.i);
                            this.i += 2;
                            this.check();
                            return ret;
                        };

                        SlicerBuffer.prototype.read_uint32 = function() {
                            var ret;
                            ret = this.buf.readUInt32BE(this.i);
                            this.i += 4;
                            this.check();
                            return ret;
                        };

                        SlicerBuffer.prototype.read_buffer_at_most = function(l) {
                            return this.read_buffer(Math.min(l, this.rem()));
                        };

                        SlicerBuffer.prototype.read_buffer = function(l) {
                            var ret;
                            ret = this.buf.slice(this.i, this.i + l);
                            this.i += l;
                            this.check();
                            return ret;
                        };

                        SlicerBuffer.prototype.end = function() {
                            return this._end || this.buf.length;
                        };

                        SlicerBuffer.prototype.peek_rest_to_buffer = function() {
                            return this.buf.slice(this.i, this.end());
                        };

                        SlicerBuffer.prototype.consume_rest_to_buffer = function() {
                            var ret;
                            ret = this.peek_rest_to_buffer();
                            this.i = this.end();
                            return ret;
                        };

                        SlicerBuffer.prototype.advance = function(i) {
                            if (i == null) {
                                i = 1;
                            }
                            return this.i += i;
                        };

                        SlicerBuffer.prototype.peek_to_buffer = function(len) {
                            return this.buf.slice(this.i, this.i + len);
                        };

                        SlicerBuffer.prototype.peek_uint8 = function() {
                            return this.buf.readUInt8(this.i);
                        };

                        SlicerBuffer.prototype.peek_uint16 = function() {
                            return this.buf.readUInt16BE(this.i);
                        };

                        SlicerBuffer.prototype.read_string = function() {
                            return this.read_buffer(this.read_uint8());
                        };

                        SlicerBuffer.prototype.read_v4_length = function() {
                            var five_byte, len, p;
                            p = this.peek_uint8();
                            five_byte = false;
                            len = p < 192 ? (this.advance(1), p) : p < 224 ? this.read_uint16() - (192 << 8) + 192 : p < 0xff ? (this.advance(1), 1 << (p & 0x1f)) : (this.advance(1), five_byte = true, this.read_uint32());
                            return [len, five_byte];
                        };

                        return SlicerBuffer;

                    })();

                    exports.SlicerBuffer = SlicerBuffer;

                }).call(this);

            }).call(this, {
                "isBuffer": require("../../node_modules/is-buffer/index.js")
            })
        }, {
            "../../node_modules/is-buffer/index.js": 188
        }],
        38: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var BaseBurner, Burner, C, Compressed, CreationTime, Issuer, Literal, OnePassSignature, PKESK, SEIPD, SHA512, SRF, Signature, WordArray, clearsign, detachsign, dummy_key_id, encode, export_key_pgp, get_cipher, iced, make_esc, make_simple_literals, scrub_buffer, triplesec, unix_time, __iced_k, __iced_k_noop, _ref, _ref1, _ref2,
                        __hasProp = {}.hasOwnProperty,
                        __extends = function(child, parent) {
                            for (var key in parent) {
                                if (__hasProp.call(parent, key)) child[key] = parent[key];
                            }

                            function ctor() {
                                this.constructor = child;
                            }
                            ctor.prototype = parent.prototype;
                            child.prototype = new ctor();
                            child.__super__ = parent.prototype;
                            return child;
                        };

                    iced = require('iced-runtime');
                    __iced_k = __iced_k_noop = function() {};

                    make_esc = require('iced-error').make_esc;

                    OnePassSignature = require('./packet/one_pass_sig').OnePassSignature;

                    _ref = require('./packet/signature'), Signature = _ref.Signature, CreationTime = _ref.CreationTime, Issuer = _ref.Issuer;

                    Compressed = require('./packet/compressed').Compressed;

                    Literal = require('./packet/literal').Literal;

                    unix_time = require('../util').unix_time;

                    SRF = require('../rand').SRF;

                    triplesec = require('triplesec');

                    _ref1 = require('../symmetric'), export_key_pgp = _ref1.export_key_pgp, get_cipher = _ref1.get_cipher;

                    scrub_buffer = triplesec.util.scrub_buffer;

                    WordArray = triplesec.WordArray;

                    _ref2 = require('./packet/sess'), SEIPD = _ref2.SEIPD, PKESK = _ref2.PKESK;

                    C = require('../const').openpgp;

                    SHA512 = require('../hash').SHA512;

                    encode = require('./armor').encode;

                    clearsign = require('./clearsign');

                    detachsign = require('./detachsign');

                    BaseBurner = require('./baseburner').BaseBurner;

                    dummy_key_id = new Buffer((function() {
                        var _i, _results;
                        _results = [];
                        for (_i = 0; _i < 16; _i++) {
                            _results.push(0);
                        }
                        return _results;
                    })());

                    Burner = (function(_super) {
                        __extends(Burner, _super);

                        function Burner(_arg) {
                            var asp, encrypt_for, encryption_key, sign_with, signing_key;
                            this.literals = _arg.literals, this.opts = _arg.opts, sign_with = _arg.sign_with, encrypt_for = _arg.encrypt_for, signing_key = _arg.signing_key, encryption_key = _arg.encryption_key, asp = _arg.asp;
                            Burner.__super__.constructor.call(this, {
                                sign_with: sign_with,
                                encrypt_for: encrypt_for,
                                signing_key: signing_key,
                                encryption_key: encryption_key,
                                asp: asp
                            });
                            this.packets = [];
                            this.opts || (this.opts = {});
                            this.signed_payload = null;
                        }

                        Burner.prototype._frame_literals = function(cb) {
                            var esc, l, p, sp, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            esc = make_esc(cb, "Burner::_frame_literals");
                            sp = [];
                            (function(_this) {
                                return (function(__iced_k) {
                                    var _i, _len, _ref3, _results, _while;
                                    _ref3 = _this.literals;
                                    _len = _ref3.length;
                                    _i = 0;
                                    _while = function(__iced_k) {
                                        var _break, _continue, _next;
                                        _break = __iced_k;
                                        _continue = function() {
                                            return iced.trampoline(function() {
                                                ++_i;
                                                return _while(__iced_k);
                                            });
                                        };
                                        _next = _continue;
                                        if (!(_i < _len)) {
                                            return _break();
                                        } else {
                                            l = _ref3[_i];
                                            sp.push(l.to_signature_payload());
                                            (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral,
                                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                                    funcname: "Burner._frame_literals"
                                                });
                                                l.write(esc(__iced_deferrals.defer({
                                                    assign_fn: (function() {
                                                        return function() {
                                                            return p = arguments[0];
                                                        };
                                                    })(),
                                                    lineno: 51
                                                })));
                                                __iced_deferrals._fulfill();
                                            })(function() {
                                                return _next(_this.packets.push(p));
                                            });
                                        }
                                    };
                                    _while(__iced_k);
                                });
                            })(this)((function(_this) {
                                return function() {
                                    _this.signed_payload = Buffer.concat(sp);
                                    return cb(null);
                                };
                            })(this));
                        };

                        Burner.prototype._sign = function(cb) {
                            var esc, fp, ops, ops_framed, sig, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            esc = make_esc(cb, "Burner::_sign'");
                            ops = new OnePassSignature({
                                sig_type: C.sig_types.binary_doc,
                                hasher: SHA512,
                                sig_klass: this.signing_key.get_klass(),
                                key_id: this.signing_key.get_key_id(),
                                is_final: 1
                            });
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                        funcname: "Burner._sign"
                                    });
                                    ops.write(esc(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return ops_framed = arguments[0];
                                            };
                                        })(),
                                        lineno: 67
                                    })));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    var _ref3;
                                    sig = new Signature({
                                        type: C.sig_types.binary_doc,
                                        key: _this.signing_key.key,
                                        hashed_subpackets: [new CreationTime(((_ref3 = _this.opts) != null ? _ref3.now : void 0) || unix_time())],
                                        unhashed_subpackets: [new Issuer(_this.signing_key.get_key_id())]
                                    });
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                            funcname: "Burner._sign"
                                        });
                                        _this.asp.progress({
                                            what: 'sign',
                                            i: 0,
                                            total: 1
                                        }, esc(__iced_deferrals.defer({
                                            lineno: 74
                                        })));
                                        __iced_deferrals._fulfill();
                                    })(function() {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                                funcname: "Burner._sign"
                                            });
                                            sig.write(_this.signed_payload, esc(__iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        return fp = arguments[0];
                                                    };
                                                })(),
                                                lineno: 75
                                            })));
                                            __iced_deferrals._fulfill();
                                        })(function() {
                                            (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral,
                                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                                    funcname: "Burner._sign"
                                                });
                                                _this.asp.progress({
                                                    what: 'sign',
                                                    i: 1,
                                                    total: 1
                                                }, esc(__iced_deferrals.defer({
                                                    lineno: 76
                                                })));
                                                __iced_deferrals._fulfill();
                                            })(function() {
                                                _this.packets.unshift(ops_framed);
                                                _this.packets.push(fp);
                                                return cb(null);
                                            });
                                        });
                                    });
                                };
                            })(this));
                        };

                        Burner.prototype.collect_packets = function() {
                            var ret;
                            ret = Buffer.concat(this.packets);
                            this.packets = [];
                            return ret;
                        };

                        Burner.prototype._compress = function(cb) {
                            var esc, inflated, opkt, pkt, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            esc = make_esc(cb, "Burner::_compress");
                            inflated = this.collect_packets();
                            pkt = new Compressed({
                                algo: C.compression.zlib,
                                inflated: inflated
                            });
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                        funcname: "Burner._compress"
                                    });
                                    _this.asp.progress({
                                        what: 'compress',
                                        i: 0,
                                        total: 1
                                    }, esc(__iced_deferrals.defer({
                                        lineno: 94
                                    })));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                            funcname: "Burner._compress"
                                        });
                                        pkt.write(esc(__iced_deferrals.defer({
                                            assign_fn: (function() {
                                                return function() {
                                                    return opkt = arguments[0];
                                                };
                                            })(),
                                            lineno: 95
                                        })));
                                        __iced_deferrals._fulfill();
                                    })(function() {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                                funcname: "Burner._compress"
                                            });
                                            _this.asp.progress({
                                                what: 'compress',
                                                i: 1,
                                                total: 1
                                            }, esc(__iced_deferrals.defer({
                                                lineno: 96
                                            })));
                                            __iced_deferrals._fulfill();
                                        })(function() {
                                            _this.packets.push(opkt);
                                            return cb(null);
                                        });
                                    });
                                };
                            })(this));
                        };

                        Burner.prototype._make_session_key = function(cb) {
                            var ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            this._cipher_algo = C.symmetric_key_algorithms.AES256;
                            this._cipher_info = get_cipher(this._cipher_algo);
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                        funcname: "Burner._make_session_key"
                                    });
                                    SRF().random_bytes(_this._cipher_info.key_size, __iced_deferrals.defer({
                                        assign_fn: (function(__slot_1) {
                                            return function() {
                                                return __slot_1._session_key = arguments[0];
                                            };
                                        })(_this),
                                        lineno: 105
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    _this._cipher = new _this._cipher_info.klass(WordArray.from_buffer(_this._session_key));
                                    return cb(null);
                                };
                            })(this));
                        };

                        Burner.prototype.scrub = function() {
                            if (this._cipher != null) {
                                this._cipher.scrub();
                            }
                            if (this._session_key != null) {
                                return scrub_buffer(this._session_key);
                            }
                        };

                        Burner.prototype._encrypt_session_key_once = function(encryption_key, cb) {
                            var ekey, esc, fingerprint, key_id, payload, pkesk, pkt, pub_k, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            esc = make_esc(cb, "_encrypt_session_key_once");
                            payload = export_key_pgp(this._cipher_algo, this._session_key);
                            pub_k = encryption_key.key;
                            fingerprint = encryption_key.get_fingerprint();
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                        funcname: "Burner._encrypt_session_key_once"
                                    });
                                    _this.asp.progress({
                                        what: 'session key encrypt',
                                        i: 0,
                                        total: 1
                                    }, esc(__iced_deferrals.defer({
                                        lineno: 122
                                    })));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                            funcname: "Burner._encrypt_session_key_once"
                                        });
                                        pub_k.pad_and_encrypt(payload, {
                                            fingerprint: fingerprint
                                        }, esc(__iced_deferrals.defer({
                                            assign_fn: (function() {
                                                return function() {
                                                    return ekey = arguments[0];
                                                };
                                            })(),
                                            lineno: 123
                                        })));
                                        __iced_deferrals._fulfill();
                                    })(function() {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                                funcname: "Burner._encrypt_session_key_once"
                                            });
                                            _this.asp.progress({
                                                what: 'session key encrypt',
                                                i: 1,
                                                total: 1
                                            }, esc(__iced_deferrals.defer({
                                                lineno: 124
                                            })));
                                            __iced_deferrals._fulfill();
                                        })(function() {
                                            (function(__iced_k) {
                                                if (_this.opts.hide) {
                                                    key_id = dummy_key_id;
                                                    (function(__iced_k) {
                                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                            parent: ___iced_passed_deferral,
                                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                                            funcname: "Burner._encrypt_session_key_once"
                                                        });
                                                        _this.asp.progress({
                                                            what: 'hide encryption',
                                                            i: 0,
                                                            total: 1
                                                        }, esc(__iced_deferrals.defer({
                                                            lineno: 127
                                                        })));
                                                        __iced_deferrals._fulfill();
                                                    })(function() {
                                                        (function(__iced_k) {
                                                            var _ref3, _ref4;
                                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                                parent: ___iced_passed_deferral,
                                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                                                funcname: "Burner._encrypt_session_key_once"
                                                            });
                                                            ekey.hide({
                                                                max: (_ref3 = _this.opts.hide) != null ? _ref3.max : void 0,
                                                                slosh: (_ref4 = _this.opts.hide) != null ? _ref4.slosh : void 0,
                                                                key: pub_k
                                                            }, esc(__iced_deferrals.defer({
                                                                lineno: 128
                                                            })));
                                                            __iced_deferrals._fulfill();
                                                        })(function() {
                                                            (function(__iced_k) {
                                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                                    parent: ___iced_passed_deferral,
                                                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                                                    funcname: "Burner._encrypt_session_key_once"
                                                                });
                                                                _this.asp.progress({
                                                                    what: 'hide encryption',
                                                                    i: 1,
                                                                    total: 1
                                                                }, esc(__iced_deferrals.defer({
                                                                    lineno: 129
                                                                })));
                                                                __iced_deferrals._fulfill();
                                                            })(__iced_k);
                                                        });
                                                    });
                                                } else {
                                                    return __iced_k(key_id = encryption_key.get_key_id());
                                                }
                                            })(function() {
                                                pkt = new PKESK({
                                                    crypto_type: pub_k.type,
                                                    key_id: key_id,
                                                    ekey: ekey
                                                });
                                                (function(__iced_k) {
                                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                        parent: ___iced_passed_deferral,
                                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                                        funcname: "Burner._encrypt_session_key_once"
                                                    });
                                                    pkt.write(esc(__iced_deferrals.defer({
                                                        assign_fn: (function() {
                                                            return function() {
                                                                return pkesk = arguments[0];
                                                            };
                                                        })(),
                                                        lineno: 137
                                                    })));
                                                    __iced_deferrals._fulfill();
                                                })(function() {
                                                    return cb(null, pkesk);
                                                });
                                            });
                                        });
                                    });
                                };
                            })(this));
                        };

                        Burner.prototype._encrypt_session_key = function(cb) {
                            var esc, k, pkesk, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            esc = make_esc(cb, "_encrypt_session_key");
                            this._pkesks = [];
                            (function(_this) {
                                return (function(__iced_k) {
                                    var _i, _len, _ref3, _results, _while;
                                    _ref3 = _this.encryption_keys;
                                    _len = _ref3.length;
                                    _i = 0;
                                    _while = function(__iced_k) {
                                        var _break, _continue, _next;
                                        _break = __iced_k;
                                        _continue = function() {
                                            return iced.trampoline(function() {
                                                ++_i;
                                                return _while(__iced_k);
                                            });
                                        };
                                        _next = _continue;
                                        if (!(_i < _len)) {
                                            return _break();
                                        } else {
                                            k = _ref3[_i];
                                            (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral,
                                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                                    funcname: "Burner._encrypt_session_key"
                                                });
                                                _this._encrypt_session_key_once(k, esc(__iced_deferrals.defer({
                                                    assign_fn: (function() {
                                                        return function() {
                                                            return pkesk = arguments[0];
                                                        };
                                                    })(),
                                                    lineno: 146
                                                })));
                                                __iced_deferrals._fulfill();
                                            })(function() {
                                                return _next(_this._pkesks.push(pkesk));
                                            });
                                        }
                                    };
                                    _while(__iced_k);
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(null);
                                };
                            })(this));
                        };

                        Burner.prototype._encrypt_payload = function(cb) {
                            var asp, esc, pkt, plaintext, prefixrandom, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            esc = make_esc(cb, "Burner::_encrypt_payload");
                            plaintext = this.collect_packets();
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                        funcname: "Burner._encrypt_payload"
                                    });
                                    SRF().random_bytes(_this._cipher.blockSize, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return prefixrandom = arguments[0];
                                            };
                                        })(),
                                        lineno: 155
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    pkt = new SEIPD({});
                                    asp = _this.asp.section('encrypt payload');
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                            funcname: "Burner._encrypt_payload"
                                        });
                                        pkt.encrypt({
                                            cipher: _this._cipher,
                                            plaintext: plaintext,
                                            prefixrandom: prefixrandom,
                                            asp: asp
                                        }, esc(__iced_deferrals.defer({
                                            lineno: 158
                                        })));
                                        __iced_deferrals._fulfill();
                                    })(function() {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                                funcname: "Burner._encrypt_payload"
                                            });
                                            pkt.write(esc(__iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        return pkt = arguments[0];
                                                    };
                                                })(),
                                                lineno: 159
                                            })));
                                            __iced_deferrals._fulfill();
                                        })(function() {
                                            scrub_buffer(plaintext);
                                            _this.packets = _this._pkesks.concat([pkt]);
                                            return cb(null);
                                        });
                                    });
                                };
                            })(this));
                        };

                        Burner.prototype._encrypt = function(cb) {
                            var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            esc = make_esc(cb, "Burner::_encrypt");
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                        funcname: "Burner._encrypt"
                                    });
                                    _this._make_session_key(esc(__iced_deferrals.defer({
                                        lineno: 168
                                    })));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                            funcname: "Burner._encrypt"
                                        });
                                        _this._encrypt_session_key(esc(__iced_deferrals.defer({
                                            lineno: 169
                                        })));
                                        __iced_deferrals._fulfill();
                                    })(function() {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                                funcname: "Burner._encrypt"
                                            });
                                            _this._encrypt_payload(esc(__iced_deferrals.defer({
                                                lineno: 170
                                            })));
                                            __iced_deferrals._fulfill();
                                        })(function() {
                                            return cb(null);
                                        });
                                    });
                                };
                            })(this));
                        };

                        Burner.prototype.scrub = function() {};

                        Burner.prototype.burn = function(cb) {
                            var esc, output, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            esc = make_esc(cb, "Burner::burn");
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                        funcname: "Burner.burn"
                                    });
                                    _this._find_keys(esc(__iced_deferrals.defer({
                                        lineno: 181
                                    })));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                            funcname: "Burner.burn"
                                        });
                                        _this._frame_literals(esc(__iced_deferrals.defer({
                                            lineno: 182
                                        })));
                                        __iced_deferrals._fulfill();
                                    })(function() {
                                        (function(__iced_k) {
                                            if (_this.signing_key != null) {
                                                (function(__iced_k) {
                                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                        parent: ___iced_passed_deferral,
                                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                                        funcname: "Burner.burn"
                                                    });
                                                    _this._sign(esc(__iced_deferrals.defer({
                                                        lineno: 184
                                                    })));
                                                    __iced_deferrals._fulfill();
                                                })(__iced_k);
                                            } else {
                                                return __iced_k();
                                            }
                                        })(function() {
                                            (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral,
                                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                                    funcname: "Burner.burn"
                                                });
                                                _this._compress(esc(__iced_deferrals.defer({
                                                    lineno: 185
                                                })));
                                                __iced_deferrals._fulfill();
                                            })(function() {
                                                (function(__iced_k) {
                                                    if (_this.encryption_keys != null) {
                                                        (function(__iced_k) {
                                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                                parent: ___iced_passed_deferral,
                                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                                                funcname: "Burner.burn"
                                                            });
                                                            _this._encrypt(esc(__iced_deferrals.defer({
                                                                lineno: 187
                                                            })));
                                                            __iced_deferrals._fulfill();
                                                        })(__iced_k);
                                                    } else {
                                                        return __iced_k();
                                                    }
                                                })(function() {
                                                    output = Buffer.concat(_this.packets);
                                                    return cb(null, output);
                                                });
                                            });
                                        });
                                    });
                                };
                            })(this));
                        };

                        return Burner;

                    })(BaseBurner);

                    exports.Burner = Burner;

                    exports.make_simple_literals = make_simple_literals = function(msg) {
                        return [
                            new Literal({
                                data: new Buffer(msg),
                                format: C.literal_formats.utf8,
                                date: unix_time()
                            })
                        ];
                    };

                    exports.clearsign = clearsign.sign;

                    exports.detachsign = detachsign.sign;

                    exports.burn = function(_arg, cb) {
                        var aout, asp, b, encrypt_for, encryption_key, err, literals, msg, opts, raw, sign_with, signing_key, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        msg = _arg.msg, literals = _arg.literals, sign_with = _arg.sign_with, encrypt_for = _arg.encrypt_for, signing_key = _arg.signing_key, encryption_key = _arg.encryption_key, asp = _arg.asp, opts = _arg.opts;
                        if ((msg != null) && (literals == null)) {
                            literals = make_simple_literals(msg);
                        }
                        b = new Burner({
                            literals: literals,
                            sign_with: sign_with,
                            encrypt_for: encrypt_for,
                            signing_key: signing_key,
                            encryption_key: encryption_key,
                            asp: asp,
                            opts: opts
                        });
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/burner.iced",
                                    funcname: "burn"
                                });
                                b.burn(__iced_deferrals.defer({
                                    assign_fn: (function() {
                                        return function() {
                                            err = arguments[0];
                                            return raw = arguments[1];
                                        };
                                    })(),
                                    lineno: 247
                                }));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                b.scrub();
                                if ((typeof raw !== "undefined" && raw !== null) && (typeof err === "undefined" || err === null)) {
                                    aout = encode(C.message_types.generic, raw);
                                }
                                return cb(err, aout, raw);
                            };
                        })(this));
                    };

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../const": 5,
            "../hash": 16,
            "../rand": 67,
            "../symmetric": 70,
            "../util": 72,
            "./armor": 35,
            "./baseburner": 36,
            "./clearsign": 41,
            "./detachsign": 42,
            "./packet/compressed": 48,
            "./packet/literal": 51,
            "./packet/one_pass_sig": 52,
            "./packet/sess": 54,
            "./packet/signature": 55,
            "buffer": 126,
            "iced-error": 179,
            "iced-runtime": 183,
            "triplesec": 282
        }],
        39: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var CAST5, G, Global, WordArray, ui32a_to_ui8a, ui8a_to_ui32a, _ref;

                WordArray = require('triplesec').WordArray;

                _ref = require('../util'), ui8a_to_ui32a = _ref.ui8a_to_ui32a, ui32a_to_ui8a = _ref.ui32a_to_ui8a;

                Global = (function() {
                    function Global() {
                        this.init_schedule();
                        this.init_sbox();
                    }

                    Global.prototype.init_schedule = function() {
                        var scheduleA, scheduleB;
                        scheduleA = new Array(4);
                        scheduleA[0] = new Array(4);
                        scheduleA[0][0] = new Uint8Array([4, 0, 0xd, 0xf, 0xc, 0xe, 0x8]);
                        scheduleA[0][1] = new Uint8Array([5, 2, 16 + 0, 16 + 2, 16 + 1, 16 + 3, 0xa]);
                        scheduleA[0][2] = new Uint8Array([6, 3, 16 + 7, 16 + 6, 16 + 5, 16 + 4, 9]);
                        scheduleA[0][3] = new Uint8Array([7, 1, 16 + 0xa, 16 + 9, 16 + 0xb, 16 + 8, 0xb]);
                        scheduleA[1] = new Array(4);
                        scheduleA[1][0] = new Uint8Array([0, 6, 16 + 5, 16 + 7, 16 + 4, 16 + 6, 16 + 0]);
                        scheduleA[1][1] = new Uint8Array([1, 4, 0, 2, 1, 3, 16 + 2]);
                        scheduleA[1][2] = new Uint8Array([2, 5, 7, 6, 5, 4, 16 + 1]);
                        scheduleA[1][3] = new Uint8Array([3, 7, 0xa, 9, 0xb, 8, 16 + 3]);
                        scheduleA[2] = new Array(4);
                        scheduleA[2][0] = new Uint8Array([4, 0, 0xd, 0xf, 0xc, 0xe, 8]);
                        scheduleA[2][1] = new Uint8Array([5, 2, 16 + 0, 16 + 2, 16 + 1, 16 + 3, 0xa]);
                        scheduleA[2][2] = new Uint8Array([6, 3, 16 + 7, 16 + 6, 16 + 5, 16 + 4, 9]);
                        scheduleA[2][3] = new Uint8Array([7, 1, 16 + 0xa, 16 + 9, 16 + 0xb, 16 + 8, 0xb]);
                        scheduleA[3] = new Array(4);
                        scheduleA[3][0] = new Uint8Array([0, 6, 16 + 5, 16 + 7, 16 + 4, 16 + 6, 16 + 0]);
                        scheduleA[3][1] = new Uint8Array([1, 4, 0, 2, 1, 3, 16 + 2]);
                        scheduleA[3][2] = new Uint8Array([2, 5, 7, 6, 5, 4, 16 + 1]);
                        scheduleA[3][3] = new Uint8Array([3, 7, 0xa, 9, 0xb, 8, 16 + 3]);
                        scheduleB = new Array(4);
                        scheduleB[0] = new Array(4);
                        scheduleB[0][0] = new Uint8Array([16 + 8, 16 + 9, 16 + 7, 16 + 6, 16 + 2]);
                        scheduleB[0][1] = new Uint8Array([16 + 0xa, 16 + 0xb, 16 + 5, 16 + 4, 16 + 6]);
                        scheduleB[0][2] = new Uint8Array([16 + 0xc, 16 + 0xd, 16 + 3, 16 + 2, 16 + 9]);
                        scheduleB[0][3] = new Uint8Array([16 + 0xe, 16 + 0xf, 16 + 1, 16 + 0, 16 + 0xc]);
                        scheduleB[1] = new Array(4);
                        scheduleB[1][0] = new Uint8Array([3, 2, 0xc, 0xd, 8]);
                        scheduleB[1][1] = new Uint8Array([1, 0, 0xe, 0xf, 0xd]);
                        scheduleB[1][2] = new Uint8Array([7, 6, 8, 9, 3]);
                        scheduleB[1][3] = new Uint8Array([5, 4, 0xa, 0xb, 7]);
                        scheduleB[2] = new Array(4);
                        scheduleB[2][0] = new Uint8Array([16 + 3, 16 + 2, 16 + 0xc, 16 + 0xd, 16 + 9]);
                        scheduleB[2][1] = new Uint8Array([16 + 1, 16 + 0, 16 + 0xe, 16 + 0xf, 16 + 0xc]);
                        scheduleB[2][2] = new Uint8Array([16 + 7, 16 + 6, 16 + 8, 16 + 9, 16 + 2]);
                        scheduleB[2][3] = new Uint8Array([16 + 5, 16 + 4, 16 + 0xa, 16 + 0xb, 16 + 6]);
                        scheduleB[3] = new Array(4);
                        scheduleB[3][0] = new Uint8Array([8, 9, 7, 6, 3]);
                        scheduleB[3][1] = new Uint8Array([0xa, 0xb, 5, 4, 7]);
                        scheduleB[3][2] = new Uint8Array([0xc, 0xd, 3, 2, 8]);
                        scheduleB[3][3] = new Uint8Array([0xe, 0xf, 1, 0, 0xd]);
                        this.scheduleA = scheduleA;
                        return this.scheduleB = scheduleB;
                    };

                    Global.prototype.init_sbox = function() {
                        var sBox;
                        sBox = new Array(8);
                        sBox[0] = new Uint32Array([0x30fb40d4, 0x9fa0ff0b, 0x6beccd2f, 0x3f258c7a, 0x1e213f2f, 0x9c004dd3, 0x6003e540, 0xcf9fc949, 0xbfd4af27, 0x88bbbdb5, 0xe2034090, 0x98d09675, 0x6e63a0e0, 0x15c361d2, 0xc2e7661d, 0x22d4ff8e, 0x28683b6f, 0xc07fd059, 0xff2379c8, 0x775f50e2, 0x43c340d3, 0xdf2f8656, 0x887ca41a, 0xa2d2bd2d, 0xa1c9e0d6, 0x346c4819, 0x61b76d87, 0x22540f2f, 0x2abe32e1, 0xaa54166b, 0x22568e3a, 0xa2d341d0, 0x66db40c8, 0xa784392f, 0x004dff2f, 0x2db9d2de, 0x97943fac, 0x4a97c1d8, 0x527644b7, 0xb5f437a7, 0xb82cbaef, 0xd751d159, 0x6ff7f0ed, 0x5a097a1f, 0x827b68d0, 0x90ecf52e, 0x22b0c054, 0xbc8e5935, 0x4b6d2f7f, 0x50bb64a2, 0xd2664910, 0xbee5812d, 0xb7332290, 0xe93b159f, 0xb48ee411, 0x4bff345d, 0xfd45c240, 0xad31973f, 0xc4f6d02e, 0x55fc8165, 0xd5b1caad, 0xa1ac2dae, 0xa2d4b76d, 0xc19b0c50, 0x882240f2, 0x0c6e4f38, 0xa4e4bfd7, 0x4f5ba272, 0x564c1d2f, 0xc59c5319, 0xb949e354, 0xb04669fe, 0xb1b6ab8a, 0xc71358dd, 0x6385c545, 0x110f935d, 0x57538ad5, 0x6a390493, 0xe63d37e0, 0x2a54f6b3, 0x3a787d5f, 0x6276a0b5, 0x19a6fcdf, 0x7a42206a, 0x29f9d4d5, 0xf61b1891, 0xbb72275e, 0xaa508167, 0x38901091, 0xc6b505eb, 0x84c7cb8c, 0x2ad75a0f, 0x874a1427, 0xa2d1936b, 0x2ad286af, 0xaa56d291, 0xd7894360, 0x425c750d, 0x93b39e26, 0x187184c9, 0x6c00b32d, 0x73e2bb14, 0xa0bebc3c, 0x54623779, 0x64459eab, 0x3f328b82, 0x7718cf82, 0x59a2cea6, 0x04ee002e, 0x89fe78e6, 0x3fab0950, 0x325ff6c2, 0x81383f05, 0x6963c5c8, 0x76cb5ad6, 0xd49974c9, 0xca180dcf, 0x380782d5, 0xc7fa5cf6, 0x8ac31511, 0x35e79e13, 0x47da91d0, 0xf40f9086, 0xa7e2419e, 0x31366241, 0x051ef495, 0xaa573b04, 0x4a805d8d, 0x548300d0, 0x00322a3c, 0xbf64cddf, 0xba57a68e, 0x75c6372b, 0x50afd341, 0xa7c13275, 0x915a0bf5, 0x6b54bfab, 0x2b0b1426, 0xab4cc9d7, 0x449ccd82, 0xf7fbf265, 0xab85c5f3, 0x1b55db94, 0xaad4e324, 0xcfa4bd3f, 0x2deaa3e2, 0x9e204d02, 0xc8bd25ac, 0xeadf55b3, 0xd5bd9e98, 0xe31231b2, 0x2ad5ad6c, 0x954329de, 0xadbe4528, 0xd8710f69, 0xaa51c90f, 0xaa786bf6, 0x22513f1e, 0xaa51a79b, 0x2ad344cc, 0x7b5a41f0, 0xd37cfbad, 0x1b069505, 0x41ece491, 0xb4c332e6, 0x032268d4, 0xc9600acc, 0xce387e6d, 0xbf6bb16c, 0x6a70fb78, 0x0d03d9c9, 0xd4df39de, 0xe01063da, 0x4736f464, 0x5ad328d8, 0xb347cc96, 0x75bb0fc3, 0x98511bfb, 0x4ffbcc35, 0xb58bcf6a, 0xe11f0abc, 0xbfc5fe4a, 0xa70aec10, 0xac39570a, 0x3f04442f, 0x6188b153, 0xe0397a2e, 0x5727cb79, 0x9ceb418f, 0x1cacd68d, 0x2ad37c96, 0x0175cb9d, 0xc69dff09, 0xc75b65f0, 0xd9db40d8, 0xec0e7779, 0x4744ead4, 0xb11c3274, 0xdd24cb9e, 0x7e1c54bd, 0xf01144f9, 0xd2240eb1, 0x9675b3fd, 0xa3ac3755, 0xd47c27af, 0x51c85f4d, 0x56907596, 0xa5bb15e6, 0x580304f0, 0xca042cf1, 0x011a37ea, 0x8dbfaadb, 0x35ba3e4a, 0x3526ffa0, 0xc37b4d09, 0xbc306ed9, 0x98a52666, 0x5648f725, 0xff5e569d, 0x0ced63d0, 0x7c63b2cf, 0x700b45e1, 0xd5ea50f1, 0x85a92872, 0xaf1fbda7, 0xd4234870, 0xa7870bf3, 0x2d3b4d79, 0x42e04198, 0x0cd0ede7, 0x26470db8, 0xf881814c, 0x474d6ad7, 0x7c0c5e5c, 0xd1231959, 0x381b7298, 0xf5d2f4db, 0xab838653, 0x6e2f1e23, 0x83719c9e, 0xbd91e046, 0x9a56456e, 0xdc39200c, 0x20c8c571, 0x962bda1c, 0xe1e696ff, 0xb141ab08, 0x7cca89b9, 0x1a69e783, 0x02cc4843, 0xa2f7c579, 0x429ef47d, 0x427b169c, 0x5ac9f049, 0xdd8f0f00, 0x5c8165bf]);
                        sBox[1] = new Uint32Array([0x1f201094, 0xef0ba75b, 0x69e3cf7e, 0x393f4380, 0xfe61cf7a, 0xeec5207a, 0x55889c94, 0x72fc0651, 0xada7ef79, 0x4e1d7235, 0xd55a63ce, 0xde0436ba, 0x99c430ef, 0x5f0c0794, 0x18dcdb7d, 0xa1d6eff3, 0xa0b52f7b, 0x59e83605, 0xee15b094, 0xe9ffd909, 0xdc440086, 0xef944459, 0xba83ccb3, 0xe0c3cdfb, 0xd1da4181, 0x3b092ab1, 0xf997f1c1, 0xa5e6cf7b, 0x01420ddb, 0xe4e7ef5b, 0x25a1ff41, 0xe180f806, 0x1fc41080, 0x179bee7a, 0xd37ac6a9, 0xfe5830a4, 0x98de8b7f, 0x77e83f4e, 0x79929269, 0x24fa9f7b, 0xe113c85b, 0xacc40083, 0xd7503525, 0xf7ea615f, 0x62143154, 0x0d554b63, 0x5d681121, 0xc866c359, 0x3d63cf73, 0xcee234c0, 0xd4d87e87, 0x5c672b21, 0x071f6181, 0x39f7627f, 0x361e3084, 0xe4eb573b, 0x602f64a4, 0xd63acd9c, 0x1bbc4635, 0x9e81032d, 0x2701f50c, 0x99847ab4, 0xa0e3df79, 0xba6cf38c, 0x10843094, 0x2537a95e, 0xf46f6ffe, 0xa1ff3b1f, 0x208cfb6a, 0x8f458c74, 0xd9e0a227, 0x4ec73a34, 0xfc884f69, 0x3e4de8df, 0xef0e0088, 0x3559648d, 0x8a45388c, 0x1d804366, 0x721d9bfd, 0xa58684bb, 0xe8256333, 0x844e8212, 0x128d8098, 0xfed33fb4, 0xce280ae1, 0x27e19ba5, 0xd5a6c252, 0xe49754bd, 0xc5d655dd, 0xeb667064, 0x77840b4d, 0xa1b6a801, 0x84db26a9, 0xe0b56714, 0x21f043b7, 0xe5d05860, 0x54f03084, 0x066ff472, 0xa31aa153, 0xdadc4755, 0xb5625dbf, 0x68561be6, 0x83ca6b94, 0x2d6ed23b, 0xeccf01db, 0xa6d3d0ba, 0xb6803d5c, 0xaf77a709, 0x33b4a34c, 0x397bc8d6, 0x5ee22b95, 0x5f0e5304, 0x81ed6f61, 0x20e74364, 0xb45e1378, 0xde18639b, 0x881ca122, 0xb96726d1, 0x8049a7e8, 0x22b7da7b, 0x5e552d25, 0x5272d237, 0x79d2951c, 0xc60d894c, 0x488cb402, 0x1ba4fe5b, 0xa4b09f6b, 0x1ca815cf, 0xa20c3005, 0x8871df63, 0xb9de2fcb, 0x0cc6c9e9, 0x0beeff53, 0xe3214517, 0xb4542835, 0x9f63293c, 0xee41e729, 0x6e1d2d7c, 0x50045286, 0x1e6685f3, 0xf33401c6, 0x30a22c95, 0x31a70850, 0x60930f13, 0x73f98417, 0xa1269859, 0xec645c44, 0x52c877a9, 0xcdff33a6, 0xa02b1741, 0x7cbad9a2, 0x2180036f, 0x50d99c08, 0xcb3f4861, 0xc26bd765, 0x64a3f6ab, 0x80342676, 0x25a75e7b, 0xe4e6d1fc, 0x20c710e6, 0xcdf0b680, 0x17844d3b, 0x31eef84d, 0x7e0824e4, 0x2ccb49eb, 0x846a3bae, 0x8ff77888, 0xee5d60f6, 0x7af75673, 0x2fdd5cdb, 0xa11631c1, 0x30f66f43, 0xb3faec54, 0x157fd7fa, 0xef8579cc, 0xd152de58, 0xdb2ffd5e, 0x8f32ce19, 0x306af97a, 0x02f03ef8, 0x99319ad5, 0xc242fa0f, 0xa7e3ebb0, 0xc68e4906, 0xb8da230c, 0x80823028, 0xdcdef3c8, 0xd35fb171, 0x088a1bc8, 0xbec0c560, 0x61a3c9e8, 0xbca8f54d, 0xc72feffa, 0x22822e99, 0x82c570b4, 0xd8d94e89, 0x8b1c34bc, 0x301e16e6, 0x273be979, 0xb0ffeaa6, 0x61d9b8c6, 0x00b24869, 0xb7ffce3f, 0x08dc283b, 0x43daf65a, 0xf7e19798, 0x7619b72f, 0x8f1c9ba4, 0xdc8637a0, 0x16a7d3b1, 0x9fc393b7, 0xa7136eeb, 0xc6bcc63e, 0x1a513742, 0xef6828bc, 0x520365d6, 0x2d6a77ab, 0x3527ed4b, 0x821fd216, 0x095c6e2e, 0xdb92f2fb, 0x5eea29cb, 0x145892f5, 0x91584f7f, 0x5483697b, 0x2667a8cc, 0x85196048, 0x8c4bacea, 0x833860d4, 0x0d23e0f9, 0x6c387e8a, 0x0ae6d249, 0xb284600c, 0xd835731d, 0xdcb1c647, 0xac4c56ea, 0x3ebd81b3, 0x230eabb0, 0x6438bc87, 0xf0b5b1fa, 0x8f5ea2b3, 0xfc184642, 0x0a036b7a, 0x4fb089bd, 0x649da589, 0xa345415e, 0x5c038323, 0x3e5d3bb9, 0x43d79572, 0x7e6dd07c, 0x06dfdf1e, 0x6c6cc4ef, 0x7160a539, 0x73bfbe70, 0x83877605, 0x4523ecf1]);
                        sBox[2] = new Uint32Array([0x8defc240, 0x25fa5d9f, 0xeb903dbf, 0xe810c907, 0x47607fff, 0x369fe44b, 0x8c1fc644, 0xaececa90, 0xbeb1f9bf, 0xeefbcaea, 0xe8cf1950, 0x51df07ae, 0x920e8806, 0xf0ad0548, 0xe13c8d83, 0x927010d5, 0x11107d9f, 0x07647db9, 0xb2e3e4d4, 0x3d4f285e, 0xb9afa820, 0xfade82e0, 0xa067268b, 0x8272792e, 0x553fb2c0, 0x489ae22b, 0xd4ef9794, 0x125e3fbc, 0x21fffcee, 0x825b1bfd, 0x9255c5ed, 0x1257a240, 0x4e1a8302, 0xbae07fff, 0x528246e7, 0x8e57140e, 0x3373f7bf, 0x8c9f8188, 0xa6fc4ee8, 0xc982b5a5, 0xa8c01db7, 0x579fc264, 0x67094f31, 0xf2bd3f5f, 0x40fff7c1, 0x1fb78dfc, 0x8e6bd2c1, 0x437be59b, 0x99b03dbf, 0xb5dbc64b, 0x638dc0e6, 0x55819d99, 0xa197c81c, 0x4a012d6e, 0xc5884a28, 0xccc36f71, 0xb843c213, 0x6c0743f1, 0x8309893c, 0x0feddd5f, 0x2f7fe850, 0xd7c07f7e, 0x02507fbf, 0x5afb9a04, 0xa747d2d0, 0x1651192e, 0xaf70bf3e, 0x58c31380, 0x5f98302e, 0x727cc3c4, 0x0a0fb402, 0x0f7fef82, 0x8c96fdad, 0x5d2c2aae, 0x8ee99a49, 0x50da88b8, 0x8427f4a0, 0x1eac5790, 0x796fb449, 0x8252dc15, 0xefbd7d9b, 0xa672597d, 0xada840d8, 0x45f54504, 0xfa5d7403, 0xe83ec305, 0x4f91751a, 0x925669c2, 0x23efe941, 0xa903f12e, 0x60270df2, 0x0276e4b6, 0x94fd6574, 0x927985b2, 0x8276dbcb, 0x02778176, 0xf8af918d, 0x4e48f79e, 0x8f616ddf, 0xe29d840e, 0x842f7d83, 0x340ce5c8, 0x96bbb682, 0x93b4b148, 0xef303cab, 0x984faf28, 0x779faf9b, 0x92dc560d, 0x224d1e20, 0x8437aa88, 0x7d29dc96, 0x2756d3dc, 0x8b907cee, 0xb51fd240, 0xe7c07ce3, 0xe566b4a1, 0xc3e9615e, 0x3cf8209d, 0x6094d1e3, 0xcd9ca341, 0x5c76460e, 0x00ea983b, 0xd4d67881, 0xfd47572c, 0xf76cedd9, 0xbda8229c, 0x127dadaa, 0x438a074e, 0x1f97c090, 0x081bdb8a, 0x93a07ebe, 0xb938ca15, 0x97b03cff, 0x3dc2c0f8, 0x8d1ab2ec, 0x64380e51, 0x68cc7bfb, 0xd90f2788, 0x12490181, 0x5de5ffd4, 0xdd7ef86a, 0x76a2e214, 0xb9a40368, 0x925d958f, 0x4b39fffa, 0xba39aee9, 0xa4ffd30b, 0xfaf7933b, 0x6d498623, 0x193cbcfa, 0x27627545, 0x825cf47a, 0x61bd8ba0, 0xd11e42d1, 0xcead04f4, 0x127ea392, 0x10428db7, 0x8272a972, 0x9270c4a8, 0x127de50b, 0x285ba1c8, 0x3c62f44f, 0x35c0eaa5, 0xe805d231, 0x428929fb, 0xb4fcdf82, 0x4fb66a53, 0x0e7dc15b, 0x1f081fab, 0x108618ae, 0xfcfd086d, 0xf9ff2889, 0x694bcc11, 0x236a5cae, 0x12deca4d, 0x2c3f8cc5, 0xd2d02dfe, 0xf8ef5896, 0xe4cf52da, 0x95155b67, 0x494a488c, 0xb9b6a80c, 0x5c8f82bc, 0x89d36b45, 0x3a609437, 0xec00c9a9, 0x44715253, 0x0a874b49, 0xd773bc40, 0x7c34671c, 0x02717ef6, 0x4feb5536, 0xa2d02fff, 0xd2bf60c4, 0xd43f03c0, 0x50b4ef6d, 0x07478cd1, 0x006e1888, 0xa2e53f55, 0xb9e6d4bc, 0xa2048016, 0x97573833, 0xd7207d67, 0xde0f8f3d, 0x72f87b33, 0xabcc4f33, 0x7688c55d, 0x7b00a6b0, 0x947b0001, 0x570075d2, 0xf9bb88f8, 0x8942019e, 0x4264a5ff, 0x856302e0, 0x72dbd92b, 0xee971b69, 0x6ea22fde, 0x5f08ae2b, 0xaf7a616d, 0xe5c98767, 0xcf1febd2, 0x61efc8c2, 0xf1ac2571, 0xcc8239c2, 0x67214cb8, 0xb1e583d1, 0xb7dc3e62, 0x7f10bdce, 0xf90a5c38, 0x0ff0443d, 0x606e6dc6, 0x60543a49, 0x5727c148, 0x2be98a1d, 0x8ab41738, 0x20e1be24, 0xaf96da0f, 0x68458425, 0x99833be5, 0x600d457d, 0x282f9350, 0x8334b362, 0xd91d1120, 0x2b6d8da0, 0x642b1e31, 0x9c305a00, 0x52bce688, 0x1b03588a, 0xf7baefd5, 0x4142ed9c, 0xa4315c11, 0x83323ec5, 0xdfef4636, 0xa133c501, 0xe9d3531c, 0xee353783]);
                        sBox[3] = new Uint32Array([0x9db30420, 0x1fb6e9de, 0xa7be7bef, 0xd273a298, 0x4a4f7bdb, 0x64ad8c57, 0x85510443, 0xfa020ed1, 0x7e287aff, 0xe60fb663, 0x095f35a1, 0x79ebf120, 0xfd059d43, 0x6497b7b1, 0xf3641f63, 0x241e4adf, 0x28147f5f, 0x4fa2b8cd, 0xc9430040, 0x0cc32220, 0xfdd30b30, 0xc0a5374f, 0x1d2d00d9, 0x24147b15, 0xee4d111a, 0x0fca5167, 0x71ff904c, 0x2d195ffe, 0x1a05645f, 0x0c13fefe, 0x081b08ca, 0x05170121, 0x80530100, 0xe83e5efe, 0xac9af4f8, 0x7fe72701, 0xd2b8ee5f, 0x06df4261, 0xbb9e9b8a, 0x7293ea25, 0xce84ffdf, 0xf5718801, 0x3dd64b04, 0xa26f263b, 0x7ed48400, 0x547eebe6, 0x446d4ca0, 0x6cf3d6f5, 0x2649abdf, 0xaea0c7f5, 0x36338cc1, 0x503f7e93, 0xd3772061, 0x11b638e1, 0x72500e03, 0xf80eb2bb, 0xabe0502e, 0xec8d77de, 0x57971e81, 0xe14f6746, 0xc9335400, 0x6920318f, 0x081dbb99, 0xffc304a5, 0x4d351805, 0x7f3d5ce3, 0xa6c866c6, 0x5d5bcca9, 0xdaec6fea, 0x9f926f91, 0x9f46222f, 0x3991467d, 0xa5bf6d8e, 0x1143c44f, 0x43958302, 0xd0214eeb, 0x022083b8, 0x3fb6180c, 0x18f8931e, 0x281658e6, 0x26486e3e, 0x8bd78a70, 0x7477e4c1, 0xb506e07c, 0xf32d0a25, 0x79098b02, 0xe4eabb81, 0x28123b23, 0x69dead38, 0x1574ca16, 0xdf871b62, 0x211c40b7, 0xa51a9ef9, 0x0014377b, 0x041e8ac8, 0x09114003, 0xbd59e4d2, 0xe3d156d5, 0x4fe876d5, 0x2f91a340, 0x557be8de, 0x00eae4a7, 0x0ce5c2ec, 0x4db4bba6, 0xe756bdff, 0xdd3369ac, 0xec17b035, 0x06572327, 0x99afc8b0, 0x56c8c391, 0x6b65811c, 0x5e146119, 0x6e85cb75, 0xbe07c002, 0xc2325577, 0x893ff4ec, 0x5bbfc92d, 0xd0ec3b25, 0xb7801ab7, 0x8d6d3b24, 0x20c763ef, 0xc366a5fc, 0x9c382880, 0x0ace3205, 0xaac9548a, 0xeca1d7c7, 0x041afa32, 0x1d16625a, 0x6701902c, 0x9b757a54, 0x31d477f7, 0x9126b031, 0x36cc6fdb, 0xc70b8b46, 0xd9e66a48, 0x56e55a79, 0x026a4ceb, 0x52437eff, 0x2f8f76b4, 0x0df980a5, 0x8674cde3, 0xedda04eb, 0x17a9be04, 0x2c18f4df, 0xb7747f9d, 0xab2af7b4, 0xefc34d20, 0x2e096b7c, 0x1741a254, 0xe5b6a035, 0x213d42f6, 0x2c1c7c26, 0x61c2f50f, 0x6552daf9, 0xd2c231f8, 0x25130f69, 0xd8167fa2, 0x0418f2c8, 0x001a96a6, 0x0d1526ab, 0x63315c21, 0x5e0a72ec, 0x49bafefd, 0x187908d9, 0x8d0dbd86, 0x311170a7, 0x3e9b640c, 0xcc3e10d7, 0xd5cad3b6, 0x0caec388, 0xf73001e1, 0x6c728aff, 0x71eae2a1, 0x1f9af36e, 0xcfcbd12f, 0xc1de8417, 0xac07be6b, 0xcb44a1d8, 0x8b9b0f56, 0x013988c3, 0xb1c52fca, 0xb4be31cd, 0xd8782806, 0x12a3a4e2, 0x6f7de532, 0x58fd7eb6, 0xd01ee900, 0x24adffc2, 0xf4990fc5, 0x9711aac5, 0x001d7b95, 0x82e5e7d2, 0x109873f6, 0x00613096, 0xc32d9521, 0xada121ff, 0x29908415, 0x7fbb977f, 0xaf9eb3db, 0x29c9ed2a, 0x5ce2a465, 0xa730f32c, 0xd0aa3fe8, 0x8a5cc091, 0xd49e2ce7, 0x0ce454a9, 0xd60acd86, 0x015f1919, 0x77079103, 0xdea03af6, 0x78a8565e, 0xdee356df, 0x21f05cbe, 0x8b75e387, 0xb3c50651, 0xb8a5c3ef, 0xd8eeb6d2, 0xe523be77, 0xc2154529, 0x2f69efdf, 0xafe67afb, 0xf470c4b2, 0xf3e0eb5b, 0xd6cc9876, 0x39e4460c, 0x1fda8538, 0x1987832f, 0xca007367, 0xa99144f8, 0x296b299e, 0x492fc295, 0x9266beab, 0xb5676e69, 0x9bd3ddda, 0xdf7e052f, 0xdb25701c, 0x1b5e51ee, 0xf65324e6, 0x6afce36c, 0x0316cc04, 0x8644213e, 0xb7dc59d0, 0x7965291f, 0xccd6fd43, 0x41823979, 0x932bcdf6, 0xb657c34d, 0x4edfd282, 0x7ae5290c, 0x3cb9536b, 0x851e20fe, 0x9833557e, 0x13ecf0b0, 0xd3ffb372, 0x3f85c5c1, 0x0aef7ed2]);
                        sBox[4] = new Uint32Array([0x7ec90c04, 0x2c6e74b9, 0x9b0e66df, 0xa6337911, 0xb86a7fff, 0x1dd358f5, 0x44dd9d44, 0x1731167f, 0x08fbf1fa, 0xe7f511cc, 0xd2051b00, 0x735aba00, 0x2ab722d8, 0x386381cb, 0xacf6243a, 0x69befd7a, 0xe6a2e77f, 0xf0c720cd, 0xc4494816, 0xccf5c180, 0x38851640, 0x15b0a848, 0xe68b18cb, 0x4caadeff, 0x5f480a01, 0x0412b2aa, 0x259814fc, 0x41d0efe2, 0x4e40b48d, 0x248eb6fb, 0x8dba1cfe, 0x41a99b02, 0x1a550a04, 0xba8f65cb, 0x7251f4e7, 0x95a51725, 0xc106ecd7, 0x97a5980a, 0xc539b9aa, 0x4d79fe6a, 0xf2f3f763, 0x68af8040, 0xed0c9e56, 0x11b4958b, 0xe1eb5a88, 0x8709e6b0, 0xd7e07156, 0x4e29fea7, 0x6366e52d, 0x02d1c000, 0xc4ac8e05, 0x9377f571, 0x0c05372a, 0x578535f2, 0x2261be02, 0xd642a0c9, 0xdf13a280, 0x74b55bd2, 0x682199c0, 0xd421e5ec, 0x53fb3ce8, 0xc8adedb3, 0x28a87fc9, 0x3d959981, 0x5c1ff900, 0xfe38d399, 0x0c4eff0b, 0x062407ea, 0xaa2f4fb1, 0x4fb96976, 0x90c79505, 0xb0a8a774, 0xef55a1ff, 0xe59ca2c2, 0xa6b62d27, 0xe66a4263, 0xdf65001f, 0x0ec50966, 0xdfdd55bc, 0x29de0655, 0x911e739a, 0x17af8975, 0x32c7911c, 0x89f89468, 0x0d01e980, 0x524755f4, 0x03b63cc9, 0x0cc844b2, 0xbcf3f0aa, 0x87ac36e9, 0xe53a7426, 0x01b3d82b, 0x1a9e7449, 0x64ee2d7e, 0xcddbb1da, 0x01c94910, 0xb868bf80, 0x0d26f3fd, 0x9342ede7, 0x04a5c284, 0x636737b6, 0x50f5b616, 0xf24766e3, 0x8eca36c1, 0x136e05db, 0xfef18391, 0xfb887a37, 0xd6e7f7d4, 0xc7fb7dc9, 0x3063fcdf, 0xb6f589de, 0xec2941da, 0x26e46695, 0xb7566419, 0xf654efc5, 0xd08d58b7, 0x48925401, 0xc1bacb7f, 0xe5ff550f, 0xb6083049, 0x5bb5d0e8, 0x87d72e5a, 0xab6a6ee1, 0x223a66ce, 0xc62bf3cd, 0x9e0885f9, 0x68cb3e47, 0x086c010f, 0xa21de820, 0xd18b69de, 0xf3f65777, 0xfa02c3f6, 0x407edac3, 0xcbb3d550, 0x1793084d, 0xb0d70eba, 0x0ab378d5, 0xd951fb0c, 0xded7da56, 0x4124bbe4, 0x94ca0b56, 0x0f5755d1, 0xe0e1e56e, 0x6184b5be, 0x580a249f, 0x94f74bc0, 0xe327888e, 0x9f7b5561, 0xc3dc0280, 0x05687715, 0x646c6bd7, 0x44904db3, 0x66b4f0a3, 0xc0f1648a, 0x697ed5af, 0x49e92ff6, 0x309e374f, 0x2cb6356a, 0x85808573, 0x4991f840, 0x76f0ae02, 0x083be84d, 0x28421c9a, 0x44489406, 0x736e4cb8, 0xc1092910, 0x8bc95fc6, 0x7d869cf4, 0x134f616f, 0x2e77118d, 0xb31b2be1, 0xaa90b472, 0x3ca5d717, 0x7d161bba, 0x9cad9010, 0xaf462ba2, 0x9fe459d2, 0x45d34559, 0xd9f2da13, 0xdbc65487, 0xf3e4f94e, 0x176d486f, 0x097c13ea, 0x631da5c7, 0x445f7382, 0x175683f4, 0xcdc66a97, 0x70be0288, 0xb3cdcf72, 0x6e5dd2f3, 0x20936079, 0x459b80a5, 0xbe60e2db, 0xa9c23101, 0xeba5315c, 0x224e42f2, 0x1c5c1572, 0xf6721b2c, 0x1ad2fff3, 0x8c25404e, 0x324ed72f, 0x4067b7fd, 0x0523138e, 0x5ca3bc78, 0xdc0fd66e, 0x75922283, 0x784d6b17, 0x58ebb16e, 0x44094f85, 0x3f481d87, 0xfcfeae7b, 0x77b5ff76, 0x8c2302bf, 0xaaf47556, 0x5f46b02a, 0x2b092801, 0x3d38f5f7, 0x0ca81f36, 0x52af4a8a, 0x66d5e7c0, 0xdf3b0874, 0x95055110, 0x1b5ad7a8, 0xf61ed5ad, 0x6cf6e479, 0x20758184, 0xd0cefa65, 0x88f7be58, 0x4a046826, 0x0ff6f8f3, 0xa09c7f70, 0x5346aba0, 0x5ce96c28, 0xe176eda3, 0x6bac307f, 0x376829d2, 0x85360fa9, 0x17e3fe2a, 0x24b79767, 0xf5a96b20, 0xd6cd2595, 0x68ff1ebf, 0x7555442c, 0xf19f06be, 0xf9e0659a, 0xeeb9491d, 0x34010718, 0xbb30cab8, 0xe822fe15, 0x88570983, 0x750e6249, 0xda627e55, 0x5e76ffa8, 0xb1534546, 0x6d47de08, 0xefe9e7d4]);
                        sBox[5] = new Uint32Array([0xf6fa8f9d, 0x2cac6ce1, 0x4ca34867, 0xe2337f7c, 0x95db08e7, 0x016843b4, 0xeced5cbc, 0x325553ac, 0xbf9f0960, 0xdfa1e2ed, 0x83f0579d, 0x63ed86b9, 0x1ab6a6b8, 0xde5ebe39, 0xf38ff732, 0x8989b138, 0x33f14961, 0xc01937bd, 0xf506c6da, 0xe4625e7e, 0xa308ea99, 0x4e23e33c, 0x79cbd7cc, 0x48a14367, 0xa3149619, 0xfec94bd5, 0xa114174a, 0xeaa01866, 0xa084db2d, 0x09a8486f, 0xa888614a, 0x2900af98, 0x01665991, 0xe1992863, 0xc8f30c60, 0x2e78ef3c, 0xd0d51932, 0xcf0fec14, 0xf7ca07d2, 0xd0a82072, 0xfd41197e, 0x9305a6b0, 0xe86be3da, 0x74bed3cd, 0x372da53c, 0x4c7f4448, 0xdab5d440, 0x6dba0ec3, 0x083919a7, 0x9fbaeed9, 0x49dbcfb0, 0x4e670c53, 0x5c3d9c01, 0x64bdb941, 0x2c0e636a, 0xba7dd9cd, 0xea6f7388, 0xe70bc762, 0x35f29adb, 0x5c4cdd8d, 0xf0d48d8c, 0xb88153e2, 0x08a19866, 0x1ae2eac8, 0x284caf89, 0xaa928223, 0x9334be53, 0x3b3a21bf, 0x16434be3, 0x9aea3906, 0xefe8c36e, 0xf890cdd9, 0x80226dae, 0xc340a4a3, 0xdf7e9c09, 0xa694a807, 0x5b7c5ecc, 0x221db3a6, 0x9a69a02f, 0x68818a54, 0xceb2296f, 0x53c0843a, 0xfe893655, 0x25bfe68a, 0xb4628abc, 0xcf222ebf, 0x25ac6f48, 0xa9a99387, 0x53bddb65, 0xe76ffbe7, 0xe967fd78, 0x0ba93563, 0x8e342bc1, 0xe8a11be9, 0x4980740d, 0xc8087dfc, 0x8de4bf99, 0xa11101a0, 0x7fd37975, 0xda5a26c0, 0xe81f994f, 0x9528cd89, 0xfd339fed, 0xb87834bf, 0x5f04456d, 0x22258698, 0xc9c4c83b, 0x2dc156be, 0x4f628daa, 0x57f55ec5, 0xe2220abe, 0xd2916ebf, 0x4ec75b95, 0x24f2c3c0, 0x42d15d99, 0xcd0d7fa0, 0x7b6e27ff, 0xa8dc8af0, 0x7345c106, 0xf41e232f, 0x35162386, 0xe6ea8926, 0x3333b094, 0x157ec6f2, 0x372b74af, 0x692573e4, 0xe9a9d848, 0xf3160289, 0x3a62ef1d, 0xa787e238, 0xf3a5f676, 0x74364853, 0x20951063, 0x4576698d, 0xb6fad407, 0x592af950, 0x36f73523, 0x4cfb6e87, 0x7da4cec0, 0x6c152daa, 0xcb0396a8, 0xc50dfe5d, 0xfcd707ab, 0x0921c42f, 0x89dff0bb, 0x5fe2be78, 0x448f4f33, 0x754613c9, 0x2b05d08d, 0x48b9d585, 0xdc049441, 0xc8098f9b, 0x7dede786, 0xc39a3373, 0x42410005, 0x6a091751, 0x0ef3c8a6, 0x890072d6, 0x28207682, 0xa9a9f7be, 0xbf32679d, 0xd45b5b75, 0xb353fd00, 0xcbb0e358, 0x830f220a, 0x1f8fb214, 0xd372cf08, 0xcc3c4a13, 0x8cf63166, 0x061c87be, 0x88c98f88, 0x6062e397, 0x47cf8e7a, 0xb6c85283, 0x3cc2acfb, 0x3fc06976, 0x4e8f0252, 0x64d8314d, 0xda3870e3, 0x1e665459, 0xc10908f0, 0x513021a5, 0x6c5b68b7, 0x822f8aa0, 0x3007cd3e, 0x74719eef, 0xdc872681, 0x073340d4, 0x7e432fd9, 0x0c5ec241, 0x8809286c, 0xf592d891, 0x08a930f6, 0x957ef305, 0xb7fbffbd, 0xc266e96f, 0x6fe4ac98, 0xb173ecc0, 0xbc60b42a, 0x953498da, 0xfba1ae12, 0x2d4bd736, 0x0f25faab, 0xa4f3fceb, 0xe2969123, 0x257f0c3d, 0x9348af49, 0x361400bc, 0xe8816f4a, 0x3814f200, 0xa3f94043, 0x9c7a54c2, 0xbc704f57, 0xda41e7f9, 0xc25ad33a, 0x54f4a084, 0xb17f5505, 0x59357cbe, 0xedbd15c8, 0x7f97c5ab, 0xba5ac7b5, 0xb6f6deaf, 0x3a479c3a, 0x5302da25, 0x653d7e6a, 0x54268d49, 0x51a477ea, 0x5017d55b, 0xd7d25d88, 0x44136c76, 0x0404a8c8, 0xb8e5a121, 0xb81a928a, 0x60ed5869, 0x97c55b96, 0xeaec991b, 0x29935913, 0x01fdb7f1, 0x088e8dfa, 0x9ab6f6f5, 0x3b4cbf9f, 0x4a5de3ab, 0xe6051d35, 0xa0e1d855, 0xd36b4cf1, 0xf544edeb, 0xb0e93524, 0xbebb8fbd, 0xa2d762cf, 0x49c92f54, 0x38b5f331, 0x7128a454, 0x48392905, 0xa65b1db8, 0x851c97bd, 0xd675cf2f]);
                        sBox[6] = new Uint32Array([0x85e04019, 0x332bf567, 0x662dbfff, 0xcfc65693, 0x2a8d7f6f, 0xab9bc912, 0xde6008a1, 0x2028da1f, 0x0227bce7, 0x4d642916, 0x18fac300, 0x50f18b82, 0x2cb2cb11, 0xb232e75c, 0x4b3695f2, 0xb28707de, 0xa05fbcf6, 0xcd4181e9, 0xe150210c, 0xe24ef1bd, 0xb168c381, 0xfde4e789, 0x5c79b0d8, 0x1e8bfd43, 0x4d495001, 0x38be4341, 0x913cee1d, 0x92a79c3f, 0x089766be, 0xbaeeadf4, 0x1286becf, 0xb6eacb19, 0x2660c200, 0x7565bde4, 0x64241f7a, 0x8248dca9, 0xc3b3ad66, 0x28136086, 0x0bd8dfa8, 0x356d1cf2, 0x107789be, 0xb3b2e9ce, 0x0502aa8f, 0x0bc0351e, 0x166bf52a, 0xeb12ff82, 0xe3486911, 0xd34d7516, 0x4e7b3aff, 0x5f43671b, 0x9cf6e037, 0x4981ac83, 0x334266ce, 0x8c9341b7, 0xd0d854c0, 0xcb3a6c88, 0x47bc2829, 0x4725ba37, 0xa66ad22b, 0x7ad61f1e, 0x0c5cbafa, 0x4437f107, 0xb6e79962, 0x42d2d816, 0x0a961288, 0xe1a5c06e, 0x13749e67, 0x72fc081a, 0xb1d139f7, 0xf9583745, 0xcf19df58, 0xbec3f756, 0xc06eba30, 0x07211b24, 0x45c28829, 0xc95e317f, 0xbc8ec511, 0x38bc46e9, 0xc6e6fa14, 0xbae8584a, 0xad4ebc46, 0x468f508b, 0x7829435f, 0xf124183b, 0x821dba9f, 0xaff60ff4, 0xea2c4e6d, 0x16e39264, 0x92544a8b, 0x009b4fc3, 0xaba68ced, 0x9ac96f78, 0x06a5b79a, 0xb2856e6e, 0x1aec3ca9, 0xbe838688, 0x0e0804e9, 0x55f1be56, 0xe7e5363b, 0xb3a1f25d, 0xf7debb85, 0x61fe033c, 0x16746233, 0x3c034c28, 0xda6d0c74, 0x79aac56c, 0x3ce4e1ad, 0x51f0c802, 0x98f8f35a, 0x1626a49f, 0xeed82b29, 0x1d382fe3, 0x0c4fb99a, 0xbb325778, 0x3ec6d97b, 0x6e77a6a9, 0xcb658b5c, 0xd45230c7, 0x2bd1408b, 0x60c03eb7, 0xb9068d78, 0xa33754f4, 0xf430c87d, 0xc8a71302, 0xb96d8c32, 0xebd4e7be, 0xbe8b9d2d, 0x7979fb06, 0xe7225308, 0x8b75cf77, 0x11ef8da4, 0xe083c858, 0x8d6b786f, 0x5a6317a6, 0xfa5cf7a0, 0x5dda0033, 0xf28ebfb0, 0xf5b9c310, 0xa0eac280, 0x08b9767a, 0xa3d9d2b0, 0x79d34217, 0x021a718d, 0x9ac6336a, 0x2711fd60, 0x438050e3, 0x069908a8, 0x3d7fedc4, 0x826d2bef, 0x4eeb8476, 0x488dcf25, 0x36c9d566, 0x28e74e41, 0xc2610aca, 0x3d49a9cf, 0xbae3b9df, 0xb65f8de6, 0x92aeaf64, 0x3ac7d5e6, 0x9ea80509, 0xf22b017d, 0xa4173f70, 0xdd1e16c3, 0x15e0d7f9, 0x50b1b887, 0x2b9f4fd5, 0x625aba82, 0x6a017962, 0x2ec01b9c, 0x15488aa9, 0xd716e740, 0x40055a2c, 0x93d29a22, 0xe32dbf9a, 0x058745b9, 0x3453dc1e, 0xd699296e, 0x496cff6f, 0x1c9f4986, 0xdfe2ed07, 0xb87242d1, 0x19de7eae, 0x053e561a, 0x15ad6f8c, 0x66626c1c, 0x7154c24c, 0xea082b2a, 0x93eb2939, 0x17dcb0f0, 0x58d4f2ae, 0x9ea294fb, 0x52cf564c, 0x9883fe66, 0x2ec40581, 0x763953c3, 0x01d6692e, 0xd3a0c108, 0xa1e7160e, 0xe4f2dfa6, 0x693ed285, 0x74904698, 0x4c2b0edd, 0x4f757656, 0x5d393378, 0xa132234f, 0x3d321c5d, 0xc3f5e194, 0x4b269301, 0xc79f022f, 0x3c997e7e, 0x5e4f9504, 0x3ffafbbd, 0x76f7ad0e, 0x296693f4, 0x3d1fce6f, 0xc61e45be, 0xd3b5ab34, 0xf72bf9b7, 0x1b0434c0, 0x4e72b567, 0x5592a33d, 0xb5229301, 0xcfd2a87f, 0x60aeb767, 0x1814386b, 0x30bcc33d, 0x38a0c07d, 0xfd1606f2, 0xc363519b, 0x589dd390, 0x5479f8e6, 0x1cb8d647, 0x97fd61a9, 0xea7759f4, 0x2d57539d, 0x569a58cf, 0xe84e63ad, 0x462e1b78, 0x6580f87e, 0xf3817914, 0x91da55f4, 0x40a230f3, 0xd1988f35, 0xb6e318d2, 0x3ffa50bc, 0x3d40f021, 0xc3c0bdae, 0x4958c24c, 0x518f36b2, 0x84b1d370, 0x0fedce83, 0x878ddada, 0xf2a279c7, 0x94e01be8, 0x90716f4b, 0x954b8aa3]);
                        sBox[7] = new Uint32Array([0xe216300d, 0xbbddfffc, 0xa7ebdabd, 0x35648095, 0x7789f8b7, 0xe6c1121b, 0x0e241600, 0x052ce8b5, 0x11a9cfb0, 0xe5952f11, 0xece7990a, 0x9386d174, 0x2a42931c, 0x76e38111, 0xb12def3a, 0x37ddddfc, 0xde9adeb1, 0x0a0cc32c, 0xbe197029, 0x84a00940, 0xbb243a0f, 0xb4d137cf, 0xb44e79f0, 0x049eedfd, 0x0b15a15d, 0x480d3168, 0x8bbbde5a, 0x669ded42, 0xc7ece831, 0x3f8f95e7, 0x72df191b, 0x7580330d, 0x94074251, 0x5c7dcdfa, 0xabbe6d63, 0xaa402164, 0xb301d40a, 0x02e7d1ca, 0x53571dae, 0x7a3182a2, 0x12a8ddec, 0xfdaa335d, 0x176f43e8, 0x71fb46d4, 0x38129022, 0xce949ad4, 0xb84769ad, 0x965bd862, 0x82f3d055, 0x66fb9767, 0x15b80b4e, 0x1d5b47a0, 0x4cfde06f, 0xc28ec4b8, 0x57e8726e, 0x647a78fc, 0x99865d44, 0x608bd593, 0x6c200e03, 0x39dc5ff6, 0x5d0b00a3, 0xae63aff2, 0x7e8bd632, 0x70108c0c, 0xbbd35049, 0x2998df04, 0x980cf42a, 0x9b6df491, 0x9e7edd53, 0x06918548, 0x58cb7e07, 0x3b74ef2e, 0x522fffb1, 0xd24708cc, 0x1c7e27cd, 0xa4eb215b, 0x3cf1d2e2, 0x19b47a38, 0x424f7618, 0x35856039, 0x9d17dee7, 0x27eb35e6, 0xc9aff67b, 0x36baf5b8, 0x09c467cd, 0xc18910b1, 0xe11dbf7b, 0x06cd1af8, 0x7170c608, 0x2d5e3354, 0xd4de495a, 0x64c6d006, 0xbcc0c62c, 0x3dd00db3, 0x708f8f34, 0x77d51b42, 0x264f620f, 0x24b8d2bf, 0x15c1b79e, 0x46a52564, 0xf8d7e54e, 0x3e378160, 0x7895cda5, 0x859c15a5, 0xe6459788, 0xc37bc75f, 0xdb07ba0c, 0x0676a3ab, 0x7f229b1e, 0x31842e7b, 0x24259fd7, 0xf8bef472, 0x835ffcb8, 0x6df4c1f2, 0x96f5b195, 0xfd0af0fc, 0xb0fe134c, 0xe2506d3d, 0x4f9b12ea, 0xf215f225, 0xa223736f, 0x9fb4c428, 0x25d04979, 0x34c713f8, 0xc4618187, 0xea7a6e98, 0x7cd16efc, 0x1436876c, 0xf1544107, 0xbedeee14, 0x56e9af27, 0xa04aa441, 0x3cf7c899, 0x92ecbae6, 0xdd67016d, 0x151682eb, 0xa842eedf, 0xfdba60b4, 0xf1907b75, 0x20e3030f, 0x24d8c29e, 0xe139673b, 0xefa63fb8, 0x71873054, 0xb6f2cf3b, 0x9f326442, 0xcb15a4cc, 0xb01a4504, 0xf1e47d8d, 0x844a1be5, 0xbae7dfdc, 0x42cbda70, 0xcd7dae0a, 0x57e85b7a, 0xd53f5af6, 0x20cf4d8c, 0xcea4d428, 0x79d130a4, 0x3486ebfb, 0x33d3cddc, 0x77853b53, 0x37effcb5, 0xc5068778, 0xe580b3e6, 0x4e68b8f4, 0xc5c8b37e, 0x0d809ea2, 0x398feb7c, 0x132a4f94, 0x43b7950e, 0x2fee7d1c, 0x223613bd, 0xdd06caa2, 0x37df932b, 0xc4248289, 0xacf3ebc3, 0x5715f6b7, 0xef3478dd, 0xf267616f, 0xc148cbe4, 0x9052815e, 0x5e410fab, 0xb48a2465, 0x2eda7fa4, 0xe87b40e4, 0xe98ea084, 0x5889e9e1, 0xefd390fc, 0xdd07d35b, 0xdb485694, 0x38d7e5b2, 0x57720101, 0x730edebc, 0x5b643113, 0x94917e4f, 0x503c2fba, 0x646f1282, 0x7523d24a, 0xe0779695, 0xf9c17a8f, 0x7a5b2121, 0xd187b896, 0x29263a4d, 0xba510cdf, 0x81f47c9f, 0xad1163ed, 0xea7b5965, 0x1a00726e, 0x11403092, 0x00da6d77, 0x4a0cdd61, 0xad1f4603, 0x605bdfb0, 0x9eedc364, 0x22ebe6a8, 0xcee7d28a, 0xa0e736a0, 0x5564a6b9, 0x10853209, 0xc7eb8f37, 0x2de705ca, 0x8951570f, 0xdf09822b, 0xbd691a6c, 0xaa12e4f2, 0x87451c0f, 0xe0f6a27a, 0x3ada4819, 0x4cf1764f, 0x0d771c2b, 0x67cdb156, 0x350d8384, 0x5938fa0f, 0x42399ef3, 0x36997b07, 0x0e84093d, 0x4aa93e61, 0x8360d87b, 0x1fa98b0c, 0x1149382c, 0xe97625a5, 0x0614d1b7, 0x0e25244b, 0x0c768347, 0x589e8d82, 0x0d2059d1, 0xa466bb1e, 0xf8da0a82, 0x04f19130, 0xba6e4ec0, 0x99265164, 0x1ee7230d, 0x50b2ad80, 0xeaee6801, 0x8db2a283, 0xea8bf59e]);
                        return this.sBox = sBox;
                    };

                    return Global;

                })();

                G = new Global();

                CAST5 = (function() {
                    CAST5.blockSize = 8;

                    CAST5.prototype.blockSize = CAST5.blockSize;

                    CAST5.keySize = 16;

                    CAST5.prototype.keySize = CAST5.keySize;

                    function CAST5(key) {
                        var n;
                        this.masking = new Array(16);
                        this.rotate = new Array(16);
                        this.reset();
                        if (key.sigBytes !== (n = this.keySize)) {
                            throw new Error("key must be " + n + " bytes");
                        }
                        this.keySchedule(key);
                    }

                    CAST5.prototype.reset = function() {
                        var i, _i, _results;
                        _results = [];
                        for (i = _i = 0; _i < 16; i = ++_i) {
                            this.masking[i] = 0;
                            _results.push(this.rotate[i] = 0);
                        }
                        return _results;
                    };

                    CAST5.prototype.encryptBlock = function(words, offset) {
                        var bytes, res;
                        if (offset == null) {
                            offset = 0;
                        }
                        bytes = ui32a_to_ui8a(words);
                        res = this._encrypt_ui8a(bytes);
                        return ui8a_to_ui32a(res, words);
                    };

                    CAST5.prototype.decryptBlock = function(words, offset) {
                        var bytes, res;
                        if (offset == null) {
                            offset = 0;
                        }
                        bytes = ui32a_to_ui8a(words);
                        res = this._decrypt_ui8a(bytes);
                        return ui8a_to_ui32a(res, words);
                    };

                    CAST5.prototype._encrypt_ui8a = function(src) {
                        var dst, i, l, len, r, t, _i;
                        len = src.length;
                        dst = new Uint8Array(len);
                        for (i = _i = 0; _i < len; i = _i += 8) {
                            l = src[i] << 24 | src[i + 1] << 16 | src[i + 2] << 8 | src[i + 3];
                            r = src[i + 4] << 24 | src[i + 5] << 16 | src[i + 6] << 8 | src[i + 7];
                            t = r;
                            r = l ^ this.f1(r, this.masking[0], this.rotate[0]);
                            l = t;
                            t = r;
                            r = l ^ this.f2(r, this.masking[1], this.rotate[1]);
                            l = t;
                            t = r;
                            r = l ^ this.f3(r, this.masking[2], this.rotate[2]);
                            l = t;
                            t = r;
                            r = l ^ this.f1(r, this.masking[3], this.rotate[3]);
                            l = t;
                            t = r;
                            r = l ^ this.f2(r, this.masking[4], this.rotate[4]);
                            l = t;
                            t = r;
                            r = l ^ this.f3(r, this.masking[5], this.rotate[5]);
                            l = t;
                            t = r;
                            r = l ^ this.f1(r, this.masking[6], this.rotate[6]);
                            l = t;
                            t = r;
                            r = l ^ this.f2(r, this.masking[7], this.rotate[7]);
                            l = t;
                            t = r;
                            r = l ^ this.f3(r, this.masking[8], this.rotate[8]);
                            l = t;
                            t = r;
                            r = l ^ this.f1(r, this.masking[9], this.rotate[9]);
                            l = t;
                            t = r;
                            r = l ^ this.f2(r, this.masking[10], this.rotate[10]);
                            l = t;
                            t = r;
                            r = l ^ this.f3(r, this.masking[11], this.rotate[11]);
                            l = t;
                            t = r;
                            r = l ^ this.f1(r, this.masking[12], this.rotate[12]);
                            l = t;
                            t = r;
                            r = l ^ this.f2(r, this.masking[13], this.rotate[13]);
                            l = t;
                            t = r;
                            r = l ^ this.f3(r, this.masking[14], this.rotate[14]);
                            l = t;
                            t = r;
                            r = l ^ this.f1(r, this.masking[15], this.rotate[15]);
                            l = t;
                            dst[i] = (r >>> 24) & 255;
                            dst[i + 1] = (r >>> 16) & 255;
                            dst[i + 2] = (r >>> 8) & 255;
                            dst[i + 3] = r & 255;
                            dst[i + 4] = (l >>> 24) & 255;
                            dst[i + 5] = (l >>> 16) & 255;
                            dst[i + 6] = (l >>> 8) & 255;
                            dst[i + 7] = l & 255;
                        }
                        return dst;
                    };

                    CAST5.prototype._decrypt_ui8a = function(src) {
                        var dst, i, l, len, r, t, _i;
                        len = src.length;
                        dst = new Uint8Array(len);
                        for (i = _i = 0; _i < len; i = _i += 8) {
                            l = src[i] << 24 | src[i + 1] << 16 | src[i + 2] << 8 | src[i + 3];
                            r = src[i + 4] << 24 | src[i + 5] << 16 | src[i + 6] << 8 | src[i + 7];
                            t = r;
                            r = l ^ this.f1(r, this.masking[15], this.rotate[15]);
                            l = t;
                            t = r;
                            r = l ^ this.f3(r, this.masking[14], this.rotate[14]);
                            l = t;
                            t = r;
                            r = l ^ this.f2(r, this.masking[13], this.rotate[13]);
                            l = t;
                            t = r;
                            r = l ^ this.f1(r, this.masking[12], this.rotate[12]);
                            l = t;
                            t = r;
                            r = l ^ this.f3(r, this.masking[11], this.rotate[11]);
                            l = t;
                            t = r;
                            r = l ^ this.f2(r, this.masking[10], this.rotate[10]);
                            l = t;
                            t = r;
                            r = l ^ this.f1(r, this.masking[9], this.rotate[9]);
                            l = t;
                            t = r;
                            r = l ^ this.f3(r, this.masking[8], this.rotate[8]);
                            l = t;
                            t = r;
                            r = l ^ this.f2(r, this.masking[7], this.rotate[7]);
                            l = t;
                            t = r;
                            r = l ^ this.f1(r, this.masking[6], this.rotate[6]);
                            l = t;
                            t = r;
                            r = l ^ this.f3(r, this.masking[5], this.rotate[5]);
                            l = t;
                            t = r;
                            r = l ^ this.f2(r, this.masking[4], this.rotate[4]);
                            l = t;
                            t = r;
                            r = l ^ this.f1(r, this.masking[3], this.rotate[3]);
                            l = t;
                            t = r;
                            r = l ^ this.f3(r, this.masking[2], this.rotate[2]);
                            l = t;
                            t = r;
                            r = l ^ this.f2(r, this.masking[1], this.rotate[1]);
                            l = t;
                            t = r;
                            r = l ^ this.f1(r, this.masking[0], this.rotate[0]);
                            l = t;
                            dst[i] = (r >>> 24) & 255;
                            dst[i + 1] = (r >>> 16) & 255;
                            dst[i + 2] = (r >>> 8) & 255;
                            dst[i + 3] = r & 255;
                            dst[i + 4] = (l >>> 24) & 255;
                            dst[i + 5] = (l >> 16) & 255;
                            dst[i + 6] = (l >> 8) & 255;
                            dst[i + 7] = l & 255;
                        }
                        return dst;
                    };

                    CAST5.prototype.keySchedule = function(key) {
                        var a, b, half, i, j, k, ki, kw, round, t, w, x, _i, _j, _k, _l, _m, _results;
                        t = (function() {
                            var _i, _len, _ref1, _results;
                            _ref1 = key.words;
                            _results = [];
                            for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                                kw = _ref1[_i];
                                _results.push(kw);
                            }
                            return _results;
                        })();
                        k = new Array(32);
                        x = [6, 7, 4, 5];
                        ki = 0;
                        for (half = _i = 0; _i < 2; half = ++_i) {
                            for (round = _j = 0; _j < 4; round = ++_j) {
                                for (j = _k = 0; _k < 4; j = ++_k) {
                                    a = G.scheduleA[round][j];
                                    w = t[a[1]];
                                    w ^= G.sBox[4][(t[a[2] >>> 2] >>> (24 - 8 * (a[2] & 3))) & 0xff];
                                    w ^= G.sBox[5][(t[a[3] >>> 2] >>> (24 - 8 * (a[3] & 3))) & 0xff];
                                    w ^= G.sBox[6][(t[a[4] >>> 2] >>> (24 - 8 * (a[4] & 3))) & 0xff];
                                    w ^= G.sBox[7][(t[a[5] >>> 2] >>> (24 - 8 * (a[5] & 3))) & 0xff];
                                    w ^= G.sBox[x[j]][(t[a[6] >>> 2] >>> (24 - 8 * (a[6] & 3))) & 0xff];
                                    t[a[0]] = w;
                                }
                                for (j = _l = 0; _l < 4; j = ++_l) {
                                    b = G.scheduleB[round][j];
                                    w = G.sBox[4][(t[b[0] >>> 2] >>> (24 - 8 * (b[0] & 3))) & 0xff];
                                    w ^= G.sBox[5][(t[b[1] >>> 2] >>> (24 - 8 * (b[1] & 3))) & 0xff];
                                    w ^= G.sBox[6][(t[b[2] >>> 2] >>> (24 - 8 * (b[2] & 3))) & 0xff];
                                    w ^= G.sBox[7][(t[b[3] >>> 2] >>> (24 - 8 * (b[3] & 3))) & 0xff];
                                    w ^= G.sBox[4 + j][(t[b[4] >>> 2] >>> (24 - 8 * (b[4] & 3))) & 0xff];
                                    k[ki] = w;
                                    ki++;
                                }
                            }
                        }
                        _results = [];
                        for (i = _m = 0; _m < 16; i = ++_m) {
                            this.masking[i] = k[i];
                            _results.push(this.rotate[i] = k[16 + i] & 0x1f);
                        }
                        return _results;
                    };

                    CAST5.prototype.f1 = function(d, m, r) {
                        var I, t;
                        t = m + d;
                        I = (t << r) | (t >>> (32 - r));
                        return ((G.sBox[0][I >>> 24] ^ G.sBox[1][(I >>> 16) & 255]) - G.sBox[2][(I >>> 8) & 255]) + G.sBox[3][I & 255];
                    };

                    CAST5.prototype.f2 = function(d, m, r) {
                        var I, t;
                        t = m ^ d;
                        I = (t << r) | (t >>> (32 - r));
                        return ((G.sBox[0][I >>> 24] - G.sBox[1][(I >>> 16) & 255]) + G.sBox[2][(I >>> 8) & 255]) ^ G.sBox[3][I & 255];
                    };

                    CAST5.prototype.f3 = function(d, m, r) {
                        var I, t;
                        t = m - d;
                        I = (t << r) | (t >>> (32 - r));
                        return ((G.sBox[0][I >>> 24] + G.sBox[1][(I >>> 16) & 255]) ^ G.sBox[2][(I >>> 8) & 255]) - G.sBox[3][I & 255];
                    };

                    return CAST5;

                })();

                exports.CAST5 = CAST5;

            }).call(this);

        }, {
            "../util": 72,
            "triplesec": 282
        }],
        40: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var AES, WordArray, ciphers, decrypt, encrypt, _ref;

                    _ref = require('triplesec'), ciphers = _ref.ciphers, WordArray = _ref.WordArray;

                    AES = ciphers.AES;

                    encrypt = function(_arg) {
                        var block_cipher_class, block_size, c, cipher, e, iv, key, list, out, plaintext, pos;
                        block_cipher_class = _arg.block_cipher_class, key = _arg.key, cipher = _arg.cipher, plaintext = _arg.plaintext, iv = _arg.iv;
                        block_cipher_class || (block_cipher_class = AES);
                        cipher || (cipher = new block_cipher_class(WordArray.from_buffer(key)));
                        block_size = cipher.blockSize;
                        c = WordArray.from_buffer(iv.slice(0, block_size));
                        pos = 0;
                        list = (function() {
                            var _results;
                            _results = [];
                            while (plaintext.length > pos) {
                                cipher.encryptBlock(c.words, 0);
                                e = c;
                                c = WordArray.from_buffer(plaintext.slice(pos, pos + block_size));
                                e.xor(c, {
                                    n_words: c.words.length
                                });
                                pos += block_size;
                                c = e;
                                _results.push(e.to_buffer());
                            }
                            return _results;
                        })();
                        out = Buffer.concat(list);
                        return out.slice(0, plaintext.length);
                    };

                    decrypt = function(_arg) {
                        var b, block_cipher_class, block_size, cipher, ciphertext, d, i, iv, key, list, out, pos;
                        block_cipher_class = _arg.block_cipher_class, key = _arg.key, cipher = _arg.cipher, ciphertext = _arg.ciphertext, iv = _arg.iv;
                        block_cipher_class || (block_cipher_class = AES);
                        cipher || (cipher = new block_cipher_class(WordArray.from_buffer(key)));
                        block_size = cipher.blockSize;
                        iv || (iv = new Buffer((function() {
                            var _i, _results;
                            _results = [];
                            for (i = _i = 0; 0 <= block_size ? _i < block_size : _i > block_size; i = 0 <= block_size ? ++_i : --_i) {
                                _results.push(0);
                            }
                            return _results;
                        })()));
                        b = WordArray.from_buffer(iv.slice(0, block_size));
                        pos = 0;
                        list = (function() {
                            var _results;
                            _results = [];
                            while (ciphertext.length > pos) {
                                cipher.encryptBlock(b.words, 0);
                                d = b;
                                b = WordArray.from_buffer(ciphertext.slice(pos, pos + block_size));
                                d.xor(b, {});
                                pos += block_size;
                                _results.push(d.to_buffer());
                            }
                            return _results;
                        })();
                        out = Buffer.concat(list);
                        return out.slice(out, ciphertext.length);
                    };

                    exports.encrypt = encrypt;

                    exports.decrypt = decrypt;

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "buffer": 126,
            "triplesec": 282
        }],
        41: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var C, Ch, ClearSigner, CreationTime, Issuer, Literal, SHA512, SRF, Signature, Verifier, VerifierBase, WordArray, bufferify, clearsign_header, clearsign_to_sign, dash_escape, dash_unescape_line, dash_unescape_lines, encode, export_key_pgp, get_cipher, hashmod, iced, input_to_cleartext, input_to_cleartext_display, input_to_cleartext_sign, konst, make_esc, scrub_buffer, triplesec, unix_time, whitespace_strip, __iced_k, __iced_k_noop, _ref, _ref1, _ref2,
                    __hasProp = {}.hasOwnProperty,
                    __extends = function(child, parent) {
                        for (var key in parent) {
                            if (__hasProp.call(parent, key)) child[key] = parent[key];
                        }

                        function ctor() {
                            this.constructor = child;
                        }
                        ctor.prototype = parent.prototype;
                        child.prototype = new ctor();
                        child.__super__ = parent.prototype;
                        return child;
                    };

                iced = require('iced-runtime');
                __iced_k = __iced_k_noop = function() {};

                make_esc = require('iced-error').make_esc;

                _ref = require('./packet/signature'), Signature = _ref.Signature, CreationTime = _ref.CreationTime, Issuer = _ref.Issuer;

                _ref1 = require('../util'), bufferify = _ref1.bufferify, unix_time = _ref1.unix_time;

                SRF = require('../rand').SRF;

                triplesec = require('triplesec');

                _ref2 = require('../symmetric'), export_key_pgp = _ref2.export_key_pgp, get_cipher = _ref2.get_cipher;

                scrub_buffer = triplesec.util.scrub_buffer;

                WordArray = triplesec.WordArray;

                konst = require('../const');

                C = konst.openpgp;

                Ch = require('../header');

                hashmod = require('../hash');

                SHA512 = hashmod.SHA512;

                encode = require('./armor').encode;

                clearsign_header = require('pgp-utils').armor.clearsign_header;

                Literal = require("./packet/literal").Literal;

                VerifierBase = require('./verifier').Base;

                exports.input_to_cleartext = input_to_cleartext = function(raw) {
                    var lines, ret;
                    lines = raw.split(/\n/);
                    ret = {
                        show: bufferify(input_to_cleartext_display(lines)),
                        sign: bufferify(input_to_cleartext_sign(lines))
                    };
                    return ret;
                };

                exports.dash_escape = dash_escape = function(line) {
                    if (line.length >= 1 && line[0] === '-') {
                        return "- " + line;
                    } else {
                        return line;
                    }
                };

                exports.dash_unescape_line = dash_unescape_line = function(line) {
                    var m, out, warn, _ref3;
                    warn = false;
                    out = (m = line.match(/^-( )?(.*?)$/)) != null ? (((_ref3 = m[1]) != null ? _ref3.length : void 0) !== 1 ? warn = true : void 0, m[2]) : line;
                    return [out, warn];
                };

                exports.dash_unescape_lines = dash_unescape_lines = function(lines, warnings) {
                    var i, l, line, ret, warn;
                    if (warnings == null) {
                        warnings = null;
                    }
                    ret = (function() {
                        var _i, _len, _ref3, _results;
                        _results = [];
                        for (i = _i = 0, _len = lines.length; _i < _len; i = ++_i) {
                            line = lines[i];
                            _ref3 = dash_unescape_line(line), l = _ref3[0], warn = _ref3[1];
                            if (warn) {
                                if (warnings != null) {
                                    warnings.push("Bad dash-encoding on line " + (i + 1));
                                }
                            }
                            _results.push(l);
                        }
                        return _results;
                    })();
                    return ret;
                };

                exports.input_to_cleartext_display = input_to_cleartext_display = function(lines) {
                    var line, out;
                    out = (function() {
                        var _i, _len, _results;
                        _results = [];
                        for (_i = 0, _len = lines.length; _i < _len; _i++) {
                            line = lines[_i];
                            _results.push(dash_escape(line));
                        }
                        return _results;
                    })();
                    if (lines.length === 0 || lines.slice(-1)[0] !== '') {
                        out.push('');
                    }
                    return out.join("\n");
                };

                exports.clearsign_to_sign = clearsign_to_sign = function(lines, warnings) {
                    lines = dash_unescape_lines(lines, warnings);
                    return input_to_cleartext_sign(lines);
                };

                exports.input_to_cleartext_sign = input_to_cleartext_sign = function(lines) {
                    var line, num_trailing_newlines, t, tmp, _i;
                    tmp = (function() {
                        var _i, _len, _results;
                        _results = [];
                        for (_i = 0, _len = lines.length; _i < _len; _i++) {
                            line = lines[_i];
                            _results.push(whitespace_strip(line));
                        }
                        return _results;
                    })();
                    num_trailing_newlines = 0;
                    for (_i = tmp.length - 1; _i >= 0; _i += -1) {
                        t = tmp[_i];
                        if (t === '') {
                            num_trailing_newlines++;
                        } else {
                            break;
                        }
                    }
                    if (num_trailing_newlines > 0) {
                        tmp.pop();
                    }
                    return tmp.join("\r\n");
                };

                exports.whitespace_strip = whitespace_strip = function(line) {
                    var m;
                    line = line.replace(/\r/g, '');
                    if ((m = line.match(/^(.*?)([ \t]*)$/))) {
                        return m[1];
                    } else {
                        return line;
                    }
                };

                ClearSigner = (function() {
                    function ClearSigner(_arg) {
                        this.msg = _arg.msg, this.signing_key = _arg.signing_key, this.now = _arg.now;
                    }

                    ClearSigner.prototype._fix_msg = function(cb) {
                        this._cleartext = input_to_cleartext(this.msg.toString('utf8'));
                        return cb(null);
                    };

                    ClearSigner.prototype._sign_msg = function(cb) {
                        var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        this.sig = new Signature({
                            sig_type: C.sig_types.canonical_text,
                            key: this.signing_key.key,
                            hashed_subpackets: [new CreationTime(this.now || unix_time())],
                            unhashed_subpackets: [new Issuer(this.signing_key.get_key_id())]
                        });
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/clearsign.iced",
                                    funcname: "ClearSigner._sign_msg"
                                });
                                _this.sig.write(_this._cleartext.sign, __iced_deferrals.defer({
                                    assign_fn: (function(__slot_1) {
                                        return function() {
                                            err = arguments[0];
                                            return __slot_1._sig_output = arguments[1];
                                        };
                                    })(_this),
                                    lineno: 117
                                }));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                return cb(err, _this._sig_output);
                            };
                        })(this));
                    };

                    ClearSigner.prototype.scrub = function() {};

                    ClearSigner.prototype.hasher_name = function() {
                        return this.sig.hasher.algname;
                    };

                    ClearSigner.prototype._encode = function(cb) {
                        var body, hdr;
                        hdr = clearsign_header(Ch, this._cleartext.show, this.hasher_name());
                        body = encode(C.message_types.signature, this._sig_output);
                        return cb(null, hdr + body);
                    };

                    ClearSigner.prototype.run = function(cb) {
                        var encoded, esc, signature, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        esc = make_esc(cb, "ClearSigner::run");
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/clearsign.iced",
                                    funcname: "ClearSigner.run"
                                });
                                _this._fix_msg(esc(__iced_deferrals.defer({
                                    lineno: 139
                                })));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/clearsign.iced",
                                        funcname: "ClearSigner.run"
                                    });
                                    _this._sign_msg(esc(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return signature = arguments[0];
                                            };
                                        })(),
                                        lineno: 140
                                    })));
                                    __iced_deferrals._fulfill();
                                })(function() {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/clearsign.iced",
                                            funcname: "ClearSigner.run"
                                        });
                                        _this._encode(esc(__iced_deferrals.defer({
                                            assign_fn: (function() {
                                                return function() {
                                                    return encoded = arguments[0];
                                                };
                                            })(),
                                            lineno: 141
                                        })));
                                        __iced_deferrals._fulfill();
                                    })(function() {
                                        return cb(null, encoded, signature);
                                    });
                                });
                            };
                        })(this));
                    };

                    return ClearSigner;

                })();

                Verifier = (function(_super) {
                    __extends(Verifier, _super);

                    function Verifier(_arg) {
                        var keyfetch, packets;
                        packets = _arg.packets, this.clearsign = _arg.clearsign, keyfetch = _arg.keyfetch, this.now = _arg.now;
                        Verifier.__super__.constructor.call(this, {
                            packets: packets,
                            keyfetch: keyfetch
                        });
                    }

                    Verifier.prototype._reformat_text = function(cb) {
                        var data;
                        data = bufferify(clearsign_to_sign(this.clearsign.lines));
                        this._literal = new Literal({
                            data: data,
                            format: C.literal_formats.utf8,
                            date: this.now || unix_time()
                        });
                        return cb(null);
                    };

                    Verifier.prototype._make_hasher = function(cb) {
                        var err, h;
                        err = null;
                        h = (this.clearsign.headers.hash || 'MD5').trim();
                        if ((this._sig.hasher = hashmod[h]) == null) {
                            err = new Error("Unknown hash algorithm: " + h);
                        }
                        return cb(err);
                    };

                    Verifier.prototype._verify = function(cb) {
                        var err, opts, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        opts = {
                            now: this.now
                        };
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/clearsign.iced",
                                    funcname: "Verifier._verify"
                                });
                                _this._sig.verify([_this._literal], __iced_deferrals.defer({
                                    assign_fn: (function() {
                                        return function() {
                                            return err = arguments[0];
                                        };
                                    })(),
                                    lineno: 183
                                }), opts);
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                return cb(err);
                            };
                        })(this));
                    };

                    Verifier.prototype._check_headers = function(cb) {
                        var err, k, v, _ref3;
                        err = null;
                        _ref3 = this.clearsign.headers;
                        for (k in _ref3) {
                            v = _ref3[k];
                            if (k !== 'hash') {
                                err = new Error("Unallowed header: " + k);
                                break;
                            }
                        }
                        return cb(err);
                    };

                    Verifier.prototype.run = function(cb) {
                        var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        esc = make_esc(cb, "Verifier::run");
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/clearsign.iced",
                                    funcname: "Verifier.run"
                                });
                                _this._check_headers(esc(__iced_deferrals.defer({
                                    lineno: 200
                                })));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/clearsign.iced",
                                        funcname: "Verifier.run"
                                    });
                                    _this._find_signature(esc(__iced_deferrals.defer({
                                        lineno: 201
                                    })));
                                    __iced_deferrals._fulfill();
                                })(function() {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/clearsign.iced",
                                            funcname: "Verifier.run"
                                        });
                                        _this._reformat_text(esc(__iced_deferrals.defer({
                                            lineno: 202
                                        })));
                                        __iced_deferrals._fulfill();
                                    })(function() {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/clearsign.iced",
                                                funcname: "Verifier.run"
                                            });
                                            _this._fetch_key(esc(__iced_deferrals.defer({
                                                lineno: 203
                                            })));
                                            __iced_deferrals._fulfill();
                                        })(function() {
                                            (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral,
                                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/clearsign.iced",
                                                    funcname: "Verifier.run"
                                                });
                                                _this._make_hasher(esc(__iced_deferrals.defer({
                                                    lineno: 204
                                                })));
                                                __iced_deferrals._fulfill();
                                            })(function() {
                                                (function(__iced_k) {
                                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                        parent: ___iced_passed_deferral,
                                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/clearsign.iced",
                                                        funcname: "Verifier.run"
                                                    });
                                                    _this._verify(esc(__iced_deferrals.defer({
                                                        lineno: 205
                                                    })));
                                                    __iced_deferrals._fulfill();
                                                })(function() {
                                                    return cb(null, _this._literal);
                                                });
                                            });
                                        });
                                    });
                                });
                            };
                        })(this));
                    };

                    return Verifier;

                })(VerifierBase);

                exports.sign = function(_arg, cb) {
                    var b, encoded, err, msg, now, signature, signing_key, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                    __iced_k = __iced_k_noop;
                    ___iced_passed_deferral = iced.findDeferral(arguments);
                    msg = _arg.msg, signing_key = _arg.signing_key, now = _arg.now;
                    b = new ClearSigner({
                        msg: msg,
                        signing_key: signing_key,
                        now: now
                    });
                    (function(_this) {
                        return (function(__iced_k) {
                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                parent: ___iced_passed_deferral,
                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/clearsign.iced",
                                funcname: "sign"
                            });
                            b.run(__iced_deferrals.defer({
                                assign_fn: (function() {
                                    return function() {
                                        err = arguments[0];
                                        encoded = arguments[1];
                                        return signature = arguments[2];
                                    };
                                })(),
                                lineno: 216
                            }));
                            __iced_deferrals._fulfill();
                        });
                    })(this)((function(_this) {
                        return function() {
                            b.scrub();
                            return cb(err, encoded, signature);
                        };
                    })(this));
                };

                exports.verify = function(_arg, cb) {
                    var clearsign, err, keyfetch, literal, now, packets, v, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                    __iced_k = __iced_k_noop;
                    ___iced_passed_deferral = iced.findDeferral(arguments);
                    packets = _arg.packets, clearsign = _arg.clearsign, keyfetch = _arg.keyfetch, now = _arg.now;
                    v = new Verifier({
                        packets: packets,
                        clearsign: clearsign,
                        keyfetch: keyfetch,
                        now: now
                    });
                    (function(_this) {
                        return (function(__iced_k) {
                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                parent: ___iced_passed_deferral,
                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/clearsign.iced",
                                funcname: "verify"
                            });
                            v.run(__iced_deferrals.defer({
                                assign_fn: (function() {
                                    return function() {
                                        err = arguments[0];
                                        return literal = arguments[1];
                                    };
                                })(),
                                lineno: 224
                            }));
                            __iced_deferrals._fulfill();
                        });
                    })(this)((function(_this) {
                        return function() {
                            return cb(err, literal);
                        };
                    })(this));
                };

            }).call(this);

        }, {
            "../const": 5,
            "../hash": 16,
            "../header": 17,
            "../rand": 67,
            "../symmetric": 70,
            "../util": 72,
            "./armor": 35,
            "./packet/literal": 51,
            "./packet/signature": 55,
            "./verifier": 63,
            "iced-error": 179,
            "iced-runtime": 183,
            "pgp-utils": 229,
            "triplesec": 282
        }],
        42: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var C, Ch, CreationTime, Issuer, Literal, Signature, Signer, Verifier, VerifierBase, WordArray, encode, hash_obj_to_fn, iced, konst, make_esc, packetsigs, streamers, unix_time, __iced_k, __iced_k_noop, _ref,
                        __hasProp = {}.hasOwnProperty,
                        __extends = function(child, parent) {
                            for (var key in parent) {
                                if (__hasProp.call(parent, key)) child[key] = parent[key];
                            }

                            function ctor() {
                                this.constructor = child;
                            }
                            ctor.prototype = parent.prototype;
                            child.prototype = new ctor();
                            child.__super__ = parent.prototype;
                            return child;
                        };

                    iced = require('iced-runtime');
                    __iced_k = __iced_k_noop = function() {};

                    make_esc = require('iced-error').make_esc;

                    _ref = require('./packet/signature'), Signature = _ref.Signature, CreationTime = _ref.CreationTime, Issuer = _ref.Issuer;

                    unix_time = require('../util').unix_time;

                    WordArray = require('triplesec').WordArray;

                    konst = require('../const');

                    C = konst.openpgp;

                    Ch = require('../header');

                    streamers = require('../hash').streamers;

                    encode = require('./armor').encode;

                    Literal = require("./packet/literal").Literal;

                    VerifierBase = require('./verifier').Base;

                    packetsigs = require('./packet/packetsigs');

                    hash_obj_to_fn = function(obj) {
                        var fn;
                        fn = function(buf) {
                            return obj.finalize(WordArray.from_buffer(buf)).to_buffer();
                        };
                        return fn.algname = buf.algname;
                    };

                    Signer = (function() {
                        function Signer(_arg) {
                            this.data = _arg.data, this.hash_streamer = _arg.hash_streamer, this.signing_key = _arg.signing_key;
                        }

                        Signer.prototype.run = function(cb) {
                            var encoded, esc, signature, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            esc = make_esc(cb, "Signer::run");
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/detachsign.iced",
                                        funcname: "Signer.run"
                                    });
                                    _this._run_hash(esc(__iced_deferrals.defer({
                                        lineno: 39
                                    })));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/detachsign.iced",
                                            funcname: "Signer.run"
                                        });
                                        _this._sign(esc(__iced_deferrals.defer({
                                            assign_fn: (function() {
                                                return function() {
                                                    return signature = arguments[0];
                                                };
                                            })(),
                                            lineno: 40
                                        })));
                                        __iced_deferrals._fulfill();
                                    })(function() {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/detachsign.iced",
                                                funcname: "Signer.run"
                                            });
                                            _this._encode(esc(__iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        return encoded = arguments[0];
                                                    };
                                                })(),
                                                lineno: 41
                                            })));
                                            __iced_deferrals._fulfill();
                                        })(function() {
                                            return cb(null, encoded, signature);
                                        });
                                    });
                                };
                            })(this));
                        };

                        Signer.prototype.scrub = function() {};

                        Signer.prototype._sign = function(cb) {
                            var emptybuf, err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            this.sig = new Signature({
                                sig_type: C.sig_types.canonical_text,
                                key: this.signing_key.key,
                                hashed_subpackets: [new CreationTime(unix_time())],
                                unhashed_subpackets: [new Issuer(this.signing_key.get_key_id())],
                                hasher: this.hash_streamer
                            });
                            emptybuf = new Buffer([]);
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/detachsign.iced",
                                        funcname: "Signer._sign"
                                    });
                                    _this.sig.write(emptybuf, __iced_deferrals.defer({
                                        assign_fn: (function(__slot_1) {
                                            return function() {
                                                err = arguments[0];
                                                return __slot_1._sig_output = arguments[1];
                                            };
                                        })(_this),
                                        lineno: 60
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err, _this._sig_output);
                                };
                            })(this));
                        };

                        Signer.prototype._encode = function(cb) {
                            var err, ret;
                            err = null;
                            ret = encode(C.message_types.signature, this._sig_output);
                            return cb(err, ret);
                        };

                        Signer.prototype._run_hash = function(cb) {
                            var err;
                            err = null;
                            if (this.hash_streamer != null) {

                            } else if (this.data != null) {
                                this.hash_streamer = streamers.SHA512();
                                this.hash_streamer.update(this.data);
                            } else {
                                err = new Error("Need either a hasher or data");
                            }
                            return cb(err);
                        };

                        return Signer;

                    })();

                    Verifier = (function(_super) {
                        __extends(Verifier, _super);

                        function Verifier(_arg) {
                            var keyfetch, packets;
                            packets = _arg.packets, this.data = _arg.data, this.data_fn = _arg.data_fn, keyfetch = _arg.keyfetch, this.now = _arg.now;
                            Verifier.__super__.constructor.call(this, {
                                packets: packets,
                                keyfetch: keyfetch
                            });
                        }

                        Verifier.prototype._consume_data = function(cb) {
                            var buf_hasher, done, err, go, klass, streamer, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            err = null;
                            (function(_this) {
                                return (function(__iced_k) {
                                    if (_this.data_fn != null) {
                                        err = null;
                                        klass = _this._sig.hasher.klass;
                                        streamer = streamers[_this._sig.hasher.algname]();
                                        buf_hasher = function(buf) {
                                            return streamer.update(buf);
                                        };
                                        go = true;
                                        (function(__iced_k) {
                                            var _while;
                                            _while = function(__iced_k) {
                                                var _break, _continue, _next;
                                                _break = __iced_k;
                                                _continue = function() {
                                                    return iced.trampoline(function() {
                                                        return _while(__iced_k);
                                                    });
                                                };
                                                _next = _continue;
                                                if (!go) {
                                                    return _break();
                                                } else {
                                                    (function(__iced_k) {
                                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                            parent: ___iced_passed_deferral,
                                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/detachsign.iced",
                                                            funcname: "Verifier._consume_data"
                                                        });
                                                        _this.data_fn(buf_hasher, __iced_deferrals.defer({
                                                            assign_fn: (function() {
                                                                return function() {
                                                                    err = arguments[0];
                                                                    return done = arguments[1];
                                                                };
                                                            })(),
                                                            lineno: 102
                                                        }));
                                                        __iced_deferrals._fulfill();
                                                    })(function() {
                                                        return _next((err != null) || done ? go = false : void 0);
                                                    });
                                                }
                                            };
                                            _while(__iced_k);
                                        })(function() {
                                            return __iced_k(_this._sig.hasher = streamer);
                                        });
                                    } else {
                                        return __iced_k();
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err);
                                };
                            })(this));
                        };

                        Verifier.prototype._verify = function(cb) {
                            var data, err, opts, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            data = this.data ? [
                                new Literal({
                                    data: this.data
                                })
                            ] : [];
                            this.literals = data;
                            opts = {
                                now: this.now
                            };
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/detachsign.iced",
                                        funcname: "Verifier._verify"
                                    });
                                    _this._sig.verify(data, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return err = arguments[0];
                                            };
                                        })(),
                                        lineno: 114
                                    }), opts);
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err);
                                };
                            })(this));
                        };

                        Verifier.prototype._make_literals = function(cb) {
                            if (!this.literals.length) {
                                this.literals.push(new Literal({
                                    data: new Buffer([])
                                }));
                            }
                            this.literals[0].push_sig(new packetsigs.Data({
                                sig: this._sig
                            }));
                            return cb(null);
                        };

                        Verifier.prototype.run = function(cb) {
                            var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            esc = make_esc(cb, "Verifier::run");
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/detachsign.iced",
                                        funcname: "Verifier.run"
                                    });
                                    _this._find_signature(esc(__iced_deferrals.defer({
                                        lineno: 129
                                    })));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/detachsign.iced",
                                            funcname: "Verifier.run"
                                        });
                                        _this._fetch_key(esc(__iced_deferrals.defer({
                                            lineno: 130
                                        })));
                                        __iced_deferrals._fulfill();
                                    })(function() {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/detachsign.iced",
                                                funcname: "Verifier.run"
                                            });
                                            _this._consume_data(esc(__iced_deferrals.defer({
                                                lineno: 131
                                            })));
                                            __iced_deferrals._fulfill();
                                        })(function() {
                                            (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral,
                                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/detachsign.iced",
                                                    funcname: "Verifier.run"
                                                });
                                                _this._verify(esc(__iced_deferrals.defer({
                                                    lineno: 132
                                                })));
                                                __iced_deferrals._fulfill();
                                            })(function() {
                                                (function(__iced_k) {
                                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                        parent: ___iced_passed_deferral,
                                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/detachsign.iced",
                                                        funcname: "Verifier.run"
                                                    });
                                                    _this._make_literals(esc(__iced_deferrals.defer({
                                                        lineno: 133
                                                    })));
                                                    __iced_deferrals._fulfill();
                                                })(function() {
                                                    return cb(null, _this.literals);
                                                });
                                            });
                                        });
                                    });
                                };
                            })(this));
                        };

                        return Verifier;

                    })(VerifierBase);

                    exports.sign = function(_arg, cb) {
                        var data, encoded, err, hash_streamer, now, s, signature, signing_key, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        data = _arg.data, hash_streamer = _arg.hash_streamer, signing_key = _arg.signing_key, now = _arg.now;
                        s = new Signer({
                            data: data,
                            hash_streamer: hash_streamer,
                            signing_key: signing_key,
                            now: now
                        });
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/detachsign.iced",
                                    funcname: "sign"
                                });
                                s.run(__iced_deferrals.defer({
                                    assign_fn: (function() {
                                        return function() {
                                            err = arguments[0];
                                            encoded = arguments[1];
                                            return signature = arguments[2];
                                        };
                                    })(),
                                    lineno: 140
                                }));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                s.scrub();
                                return cb(err, encoded, signature);
                            };
                        })(this));
                    };

                    exports.verify = function(_arg, cb) {
                        var data, data_fn, err, keyfetch, literals, now, packets, v, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        data = _arg.data, data_fn = _arg.data_fn, packets = _arg.packets, keyfetch = _arg.keyfetch, now = _arg.now;
                        v = new Verifier({
                            data: data,
                            data_fn: data_fn,
                            packets: packets,
                            keyfetch: keyfetch,
                            now: now
                        });
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/detachsign.iced",
                                    funcname: "verify"
                                });
                                v.run(__iced_deferrals.defer({
                                    assign_fn: (function() {
                                        return function() {
                                            err = arguments[0];
                                            return literals = arguments[1];
                                        };
                                    })(),
                                    lineno: 148
                                }));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                return cb(err, literals);
                            };
                        })(this));
                    };

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../const": 5,
            "../hash": 16,
            "../header": 17,
            "../util": 72,
            "./armor": 35,
            "./packet/literal": 51,
            "./packet/packetsigs": 53,
            "./packet/signature": 55,
            "./verifier": 63,
            "buffer": 126,
            "iced-error": 179,
            "iced-runtime": 183,
            "triplesec": 282
        }],
        43: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var SignatureEngine, burn, processor;

                burn = require('./burner').burn;

                processor = require('./processor');

                SignatureEngine = require('./sigeng').SignatureEngine;

                exports.box = burn;

                exports.unbox = processor.do_message;

                exports.SignatureEngine = SignatureEngine;

            }).call(this);

        }, {
            "./burner": 38,
            "./processor": 59,
            "./sigeng": 61
        }],
        44: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var ASP, C, ECDSA, Encryptor, Engine, K, KeyBlock, KeyFetched, KeyFetcher, KeyManager, KeyManagerInterface, Lifespan, Message, P3SKB, PgpEngine, Primary, RSA, SHA256, SignatureEngine, Subkey, assert_no_nulls, athrow, bufeq_secure, bufferify, decode, decode_strict, encode, errors, format_pgp_fingerprint_2, iced, katch, konst, lifespan_from_keywrapper_and_time, make_esc, opkts, ops_to_keyflags, parse, read_base64, unix_time, unseal, __iced_k, __iced_k_noop, _ref, _ref1, _ref2, _ref3, _ref4,
                        __hasProp = {}.hasOwnProperty,
                        __extends = function(child, parent) {
                            for (var key in parent) {
                                if (__hasProp.call(parent, key)) child[key] = parent[key];
                            }

                            function ctor() {
                                this.constructor = child;
                            }
                            ctor.prototype = parent.prototype;
                            child.prototype = new ctor();
                            child.__super__ = parent.prototype;
                            return child;
                        },
                        __slice = [].slice;

                    iced = require('iced-runtime');
                    __iced_k = __iced_k_noop = function() {};

                    RSA = require('../rsa').RSA;

                    ECDSA = require('../ecc/ecdsa').ECDSA;

                    SHA256 = require('../hash').SHA256;

                    konst = require('../const');

                    K = konst.kb;

                    C = konst.openpgp;

                    make_esc = require('iced-error').make_esc;

                    errors = require('../errors').errors;

                    _ref = require('../util'), format_pgp_fingerprint_2 = _ref.format_pgp_fingerprint_2, athrow = _ref.athrow, assert_no_nulls = _ref.assert_no_nulls, ASP = _ref.ASP, katch = _ref.katch, bufeq_secure = _ref.bufeq_secure, unix_time = _ref.unix_time, bufferify = _ref.bufferify;

                    ops_to_keyflags = require('./util').ops_to_keyflags;

                    _ref1 = require('../keywrapper'), Lifespan = _ref1.Lifespan, Subkey = _ref1.Subkey, Primary = _ref1.Primary;

                    _ref2 = require('./armor'), Message = _ref2.Message, encode = _ref2.encode, decode = _ref2.decode, decode_strict = _ref2.decode_strict;

                    parse = require('./parser').parse;

                    KeyBlock = require('./processor').KeyBlock;

                    opkts = require('./packet/all');

                    _ref3 = require('../keybase/encode'), read_base64 = _ref3.read_base64, unseal = _ref3.unseal;

                    P3SKB = require('../keybase/packet/p3skb').P3SKB;

                    _ref4 = require('../keyfetch'), KeyFetcher = _ref4.KeyFetcher, KeyFetched = _ref4.KeyFetched;

                    SignatureEngine = require('./sigeng').SignatureEngine;

                    Encryptor = require('triplesec').Encryptor;

                    KeyManagerInterface = require('../kmi').KeyManagerInterface;

                    Engine = (function() {
                        function Engine(_arg) {
                            var k, _i, _len, _ref5;
                            this.primary = _arg.primary, this.subkeys = _arg.subkeys, this.userids = _arg.userids, this.key_manager = _arg.key_manager;
                            this.packets = [];
                            this.messages = [];
                            this._allocate_key_packets();
                            _ref5 = this.subkeys;
                            for (_i = 0, _len = _ref5.length; _i < _len; _i++) {
                                k = _ref5[_i];
                                k.primary = this.primary;
                            }
                            this._index_keys();
                            true;
                        }

                        Engine.prototype._index_keys = function() {
                            var k, _i, _len, _ref5, _results;
                            this._index = {};
                            _ref5 = this._all_keys();
                            _results = [];
                            for (_i = 0, _len = _ref5.length; _i < _len; _i++) {
                                k = _ref5[_i];
                                _results.push(this._index[this.ekid(k)] = k);
                            }
                            return _results;
                        };

                        Engine.prototype.ekid = function(k) {
                            return this.key(k).ekid();
                        };

                        Engine.prototype._allocate_key_packets = function() {
                            var key, _i, _len, _ref5, _results;
                            this._v_allocate_key_packet(this.primary, {
                                subkey: false
                            });
                            _ref5 = this.subkeys;
                            _results = [];
                            for (_i = 0, _len = _ref5.length; _i < _len; _i++) {
                                key = _ref5[_i];
                                _results.push(this._v_allocate_key_packet(key, {
                                    subkey: true
                                }));
                            }
                            return _results;
                        };

                        Engine.prototype._all_keys = function() {
                            return [this.primary].concat(this.subkeys);
                        };

                        Engine.prototype.self_sign_primary = function(args, cb) {
                            return this._v_self_sign_primary(args, cb);
                        };

                        Engine.prototype.get_all_key_materials = function() {
                            var k;
                            return [
                                [this.key(this.primary), true]
                            ].concat((function() {
                                var _i, _len, _ref5, _results;
                                _ref5 = this.subkeys;
                                _results = [];
                                for (_i = 0, _len = _ref5.length; _i < _len; _i++) {
                                    k = _ref5[_i];
                                    _results.push([this.key(k), false]);
                                }
                                return _results;
                            }).call(this));
                        };

                        Engine.prototype.sign_subkeys = function(_arg, cb) {
                            var asp, err, subkey, time, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            time = _arg.time, asp = _arg.asp;
                            err = null;
                            (function(_this) {
                                return (function(__iced_k) {
                                    var _i, _len, _ref5, _results, _while;
                                    _ref5 = _this.subkeys;
                                    _len = _ref5.length;
                                    _i = 0;
                                    _while = function(__iced_k) {
                                        var _break, _continue, _next;
                                        _break = __iced_k;
                                        _continue = function() {
                                            return iced.trampoline(function() {
                                                ++_i;
                                                return _while(__iced_k);
                                            });
                                        };
                                        _next = _continue;
                                        if (!(_i < _len)) {
                                            return _break();
                                        } else {
                                            subkey = _ref5[_i];
                                            if (err == null) {
                                                (function(__iced_k) {
                                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                        parent: ___iced_passed_deferral,
                                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                                        funcname: "Engine.sign_subkeys"
                                                    });
                                                    _this._v_sign_subkey({
                                                        asp: asp,
                                                        time: time,
                                                        subkey: subkey
                                                    }, __iced_deferrals.defer({
                                                        assign_fn: (function() {
                                                            return function() {
                                                                return err = arguments[0];
                                                            };
                                                        })(),
                                                        lineno: 76
                                                    }));
                                                    __iced_deferrals._fulfill();
                                                })(_next);
                                            } else {
                                                return _continue();
                                            }
                                        }
                                    };
                                    _while(__iced_k);
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err);
                                };
                            })(this));
                        };

                        Engine.prototype.get_subkey_materials = function() {
                            var k, _i, _len, _ref5, _results;
                            _ref5 = this.subkeys;
                            _results = [];
                            for (_i = 0, _len = _ref5.length; _i < _len; _i++) {
                                k = _ref5[_i];
                                _results.push(this.key(k));
                            }
                            return _results;
                        };

                        Engine.prototype.is_locked = function() {
                            var i, k, _i, _len, _ref5;
                            _ref5 = this._all_keys();
                            for (i = _i = 0, _len = _ref5.length; _i < _len; i = ++_i) {
                                k = _ref5[i];
                                if (this.key(k).is_locked()) {
                                    return true;
                                }
                            }
                            return false;
                        };

                        Engine.prototype.has_private = function() {
                            var k, _i, _len, _ref5;
                            _ref5 = this._all_keys();
                            for (_i = 0, _len = _ref5.length; _i < _len; _i++) {
                                k = _ref5[_i];
                                if (this.key(k).has_private()) {
                                    return true;
                                }
                            }
                            return false;
                        };

                        Engine.prototype.sign = function(_arg, cb) {
                            var asp, err, time, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            asp = _arg.asp, time = _arg.time;
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                        funcname: "Engine.sign"
                                    });
                                    _this.self_sign_primary({
                                        asp: asp,
                                        time: time
                                    }, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return err = arguments[0];
                                            };
                                        })(),
                                        lineno: 100
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    (function(__iced_k) {
                                        if (typeof err === "undefined" || err === null) {
                                            (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral,
                                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                                    funcname: "Engine.sign"
                                                });
                                                _this.sign_subkeys({
                                                    asp: asp,
                                                    time: time
                                                }, __iced_deferrals.defer({
                                                    assign_fn: (function() {
                                                        return function() {
                                                            return err = arguments[0];
                                                        };
                                                    })(),
                                                    lineno: 101
                                                }));
                                                __iced_deferrals._fulfill();
                                            })(__iced_k);
                                        } else {
                                            return __iced_k();
                                        }
                                    })(function() {
                                        return cb(err);
                                    });
                                };
                            })(this));
                        };

                        Engine.prototype.check_eq = function(eng2) {
                            var err, i, key, _i, _len, _ref5;
                            err = null;
                            if (!this.primary.key.eq(eng2.primary.key)) {
                                err = new Error("Primary keys don't match");
                            } else if (this.subkeys.length !== eng2.subkeys.length) {
                                err = new Error("different # of subkeys");
                            } else {
                                _ref5 = this.subkeys;
                                for (i = _i = 0, _len = _ref5.length; _i < _len; i = ++_i) {
                                    key = _ref5[i];
                                    if (this.err == null) {
                                        if (!key.key.eq(eng2.subkeys[i].key)) {
                                            err = new Error("subkey " + i + " doesn't match");
                                        }
                                    }
                                }
                            }
                            return err;
                        };

                        Engine.prototype.merge_private = function(eng2) {
                            var err, i, k, _i, _len, _ref5;
                            err = this._merge_private_primary(eng2);
                            if (err == null) {
                                _ref5 = eng2.subkeys;
                                for (i = _i = 0, _len = _ref5.length; _i < _len; i = ++_i) {
                                    k = _ref5[i];
                                    if ((err = this._merge_private_subkey(k, i)) != null) {
                                        break;
                                    }
                                }
                            }
                            return err;
                        };

                        Engine.prototype._merge_private_primary = function(eng2) {
                            var err;
                            err = !this.key(eng2.primary).has_secret_key_material() ? null : this._merge_1_private(this.primary, eng2.primary) ? null : new Error("primary public key doesn't match private key");
                            return err;
                        };

                        Engine.prototype._merge_private_subkey = function(k2, i) {
                            var ekid, err, k;
                            err = !this.key(k2).has_secret_key_material() ? null : (ekid = this.ekid(k2)) == null ? new Error("Subkey " + i + " is malformed") : (k = this._index[ekid]) == null ? new Error("Subkey " + i + " wasn't found in public key") : this._merge_1_private(k, k2) ? null : new Error("subkey " + i + " can't be merged");
                            return err;
                        };

                        Engine.prototype.unlock_keys = function(_arg, cb) {
                            var asp, esc, i, passphrase, subkey, tsenc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            asp = _arg.asp, passphrase = _arg.passphrase, tsenc = _arg.tsenc;
                            esc = make_esc(cb, "Engine::unlock_keys");
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                        funcname: "Engine.unlock_keys"
                                    });
                                    _this.key(_this.primary).unlock({
                                        asp: asp,
                                        tsenc: tsenc,
                                        passphrase: passphrase
                                    }, esc(__iced_deferrals.defer({
                                        lineno: 149
                                    })));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    (function(__iced_k) {
                                        var _i, _len, _ref5, _results, _while;
                                        _ref5 = _this.subkeys;
                                        _len = _ref5.length;
                                        i = 0;
                                        _while = function(__iced_k) {
                                            var _break, _continue, _next;
                                            _break = __iced_k;
                                            _continue = function() {
                                                return iced.trampoline(function() {
                                                    ++i;
                                                    return _while(__iced_k);
                                                });
                                            };
                                            _next = _continue;
                                            if (!(i < _len)) {
                                                return _break();
                                            } else {
                                                subkey = _ref5[i];
                                                if (_this.key(subkey).has_private()) {
                                                    (function(__iced_k) {
                                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                            parent: ___iced_passed_deferral,
                                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                                            funcname: "Engine.unlock_keys"
                                                        });
                                                        _this.key(subkey).unlock({
                                                            asp: asp,
                                                            tsenc: tsenc,
                                                            passphrase: passphrase
                                                        }, esc(__iced_deferrals.defer({
                                                            lineno: 151
                                                        })));
                                                        __iced_deferrals._fulfill();
                                                    })(_next);
                                                } else {
                                                    return _continue();
                                                }
                                            }
                                        };
                                        _while(__iced_k);
                                    })(function() {
                                        return cb(null);
                                    });
                                };
                            })(this));
                        };

                        Engine.prototype.export_keys_to_keyring = function(km) {
                            var k, x;
                            x = (function(_this) {
                                return function(key_wrapper, is_primary) {
                                    return {
                                        km: km,
                                        is_primary: is_primary,
                                        key_wrapper: key_wrapper,
                                        key_material: _this.key(key_wrapper),
                                        key: _this.key(key_wrapper).key
                                    };
                                };
                            })(this);
                            return [x(this.primary, true)].concat((function() {
                                var _i, _len, _ref5, _results;
                                _ref5 = this.subkeys;
                                _results = [];
                                for (_i = 0, _len = _ref5.length; _i < _len; _i++) {
                                    k = _ref5[_i];
                                    _results.push(x(k, false));
                                }
                                return _results;
                            }).call(this));
                        };

                        Engine.prototype._merge_1_private = function(k1, k2) {
                            if (bufeq_secure(this.ekid(k1), this.ekid(k2))) {
                                this.key(k1).merge_private(this.key(k2));
                                return true;
                            } else {
                                return false;
                            }
                        };

                        Engine.prototype.merge_subkey_omitting_revokes = function(k) {
                            var ekid, kw;
                            ekid = k.ekid();
                            if ((kw = this._index[ekid]) != null) {
                                return kw.overwrite_with_omitting_revokes(k);
                            } else {
                                this._index[ekid] = k;
                                return this.subkeys.push(k);
                            }
                        };

                        Engine.prototype.merge_public_omitting_revokes = function(pgpeng2) {
                            this.primary.overwrite_with_omitting_revokes(pgpeng2.primary);
                            return this.merge_all_subkeys_omitting_revokes(pgpeng2);
                        };

                        Engine.prototype.merge_all_subkeys_omitting_revokes = function(pgpeng2) {
                            var subkey, _i, _len, _ref5, _results;
                            _ref5 = pgpeng2.subkeys;
                            _results = [];
                            for (_i = 0, _len = _ref5.length; _i < _len; _i++) {
                                subkey = _ref5[_i];
                                _results.push(this.merge_subkey_omitting_revokes(subkey));
                            }
                            return _results;
                        };

                        Engine.prototype.check_not_expired = function(_arg) {
                            var err, now, subkey_material;
                            subkey_material = _arg.subkey_material, now = _arg.now;
                            now || (now = unix_time());
                            err = this.key(this.primary).check_not_expired({
                                now: now
                            });
                            if (err == null) {
                                err = subkey_material.check_not_expired({
                                    now: now
                                });
                            }
                            return err;
                        };

                        return Engine;

                    })();

                    lifespan_from_keywrapper_and_time = function(_arg) {
                        var key_wrapper, ret, time;
                        key_wrapper = _arg.key_wrapper, time = _arg.time;
                        ret = key_wrapper.lifespan;
                        if (time != null) {
                            ret = ret.copy();
                            ret.generated = time;
                        }
                        return ret;
                    };

                    PgpEngine = (function(_super) {
                        __extends(PgpEngine, _super);

                        function PgpEngine(_arg) {
                            var key_manager, primary, subkeys, userids;
                            primary = _arg.primary, subkeys = _arg.subkeys, userids = _arg.userids, this.user_attributes = _arg.user_attributes, key_manager = _arg.key_manager;
                            PgpEngine.__super__.constructor.call(this, {
                                primary: primary,
                                subkeys: subkeys,
                                userids: userids,
                                key_manager: key_manager
                            });
                        }

                        PgpEngine.prototype.key = function(k) {
                            return k._pgp;
                        };

                        PgpEngine.prototype._v_allocate_key_packet = function(key, opts) {
                            if (key._pgp == null) {
                                return key._pgp = new opkts.KeyMaterial({
                                    key: key.key,
                                    timestamp: key.lifespan.generated,
                                    flags: key.flags,
                                    opts: opts
                                });
                            }
                        };

                        PgpEngine.prototype._v_self_sign_primary = function(_arg, cb) {
                            var asp, err, lifespan, raw_payload, sigs, time, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            time = _arg.time, asp = _arg.asp, raw_payload = _arg.raw_payload;
                            lifespan = lifespan_from_keywrapper_and_time({
                                key_wrapper: this.primary,
                                time: time
                            });
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                        funcname: "PgpEngine._v_self_sign_primary"
                                    });
                                    _this.key(_this.primary).self_sign_key({
                                        lifespan: lifespan,
                                        userids: _this.userids,
                                        raw_payload: raw_payload
                                    }, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                err = arguments[0];
                                                return sigs = arguments[1];
                                            };
                                        })(),
                                        lineno: 241
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err, sigs);
                                };
                            })(this));
                        };

                        PgpEngine.prototype._v_sign_subkey = function(_arg, cb) {
                            var asp, err, lifespan, subkey, time, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            asp = _arg.asp, subkey = _arg.subkey, time = _arg.time;
                            lifespan = lifespan_from_keywrapper_and_time({
                                key_wrapper: subkey,
                                time: time
                            });
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                        funcname: "PgpEngine._v_sign_subkey"
                                    });
                                    _this.key(_this.primary).sign_subkey({
                                        subkey: _this.key(subkey),
                                        lifespan: lifespan
                                    }, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return err = arguments[0];
                                            };
                                        })(),
                                        lineno: 248
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err);
                                };
                            })(this));
                        };

                        PgpEngine.prototype.clear_psc = function() {
                            var s, u, _i, _j, _len, _len1, _ref5, _ref6, _results;
                            this.key(this.primary).clear_psc();
                            _ref5 = this.userids;
                            for (_i = 0, _len = _ref5.length; _i < _len; _i++) {
                                u = _ref5[_i];
                                u.clear_psc();
                            }
                            _ref6 = this.subkeys;
                            _results = [];
                            for (_j = 0, _len1 = _ref6.length; _j < _len1; _j++) {
                                s = _ref6[_j];
                                _results.push(this.key(s).clear_psc());
                            }
                            return _results;
                        };

                        PgpEngine.prototype.set_passphrase = function(pp) {
                            var k, _i, _len, _ref5, _results;
                            this.primary.passphrase = pp;
                            _ref5 = this.subkeys;
                            _results = [];
                            for (_i = 0, _len = _ref5.length; _i < _len; _i++) {
                                k = _ref5[_i];
                                _results.push(k.passphrase = pp);
                            }
                            return _results;
                        };

                        PgpEngine.prototype._export_keys_to_binary = function(opts) {
                            var packets, subkey, userid, _i, _j, _len, _len1, _ref5, _ref6;
                            packets = [this.key(this.primary).export_framed(opts)];
                            _ref5 = this.userids;
                            for (_i = 0, _len = _ref5.length; _i < _len; _i++) {
                                userid = _ref5[_i];
                                packets.push(userid.write(), userid.get_framed_signature_output());
                            }
                            opts.subkey = true;
                            _ref6 = this.subkeys;
                            for (_j = 0, _len1 = _ref6.length; _j < _len1; _j++) {
                                subkey = _ref6[_j];
                                packets.push(this.key(subkey).export_framed(opts), this.key(subkey).get_subkey_binding_signature_output());
                            }
                            assert_no_nulls(packets);
                            return Buffer.concat(packets);
                        };

                        PgpEngine.prototype.export_keys = function(opts) {
                            var msg, mt, type;
                            mt = C.message_types;
                            type = opts["private"] ? mt.private_key : mt.public_key;
                            msg = this._export_keys_to_binary(opts);
                            return encode(type, msg);
                        };

                        PgpEngine.prototype.export_to_p3skb = function() {
                            var priv_clear, pub;
                            pub = this._export_keys_to_binary({
                                "private": false
                            });
                            priv_clear = this._export_keys_to_binary({
                                "private": true
                            });
                            return new P3SKB({
                                pub: pub,
                                priv_clear: priv_clear
                            });
                        };

                        PgpEngine.prototype.find_key = function(key_id) {
                            var k, _i, _len, _ref5;
                            _ref5 = this._all_keys();
                            for (_i = 0, _len = _ref5.length; _i < _len; _i++) {
                                k = _ref5[_i];
                                if (bufeq_secure(this.key(k).get_key_id(), key_id)) {
                                    return k;
                                }
                            }
                            return null;
                        };

                        PgpEngine.prototype.find_key_material = function(key_id) {
                            var key;
                            key = this.find_key(key_id);
                            if (key != null) {
                                return this.key(key);
                            } else {
                                return null;
                            }
                        };

                        PgpEngine.prototype.get_key_id = function() {
                            return this.key(this.primary).get_key_id();
                        };

                        PgpEngine.prototype.get_short_key_id = function() {
                            return this.key(this.primary).get_short_key_id();
                        };

                        PgpEngine.prototype.get_fingerprint = function() {
                            return this.key(this.primary).get_fingerprint();
                        };

                        PgpEngine.prototype.get_ekid = function() {
                            return this.key(this.primary).ekid();
                        };

                        PgpEngine.prototype.get_all_key_ids = function() {
                            var k, _i, _len, _ref5, _results;
                            _ref5 = this._all_keys();
                            _results = [];
                            for (_i = 0, _len = _ref5.length; _i < _len; _i++) {
                                k = _ref5[_i];
                                _results.push(this.key(k).get_key_id());
                            }
                            return _results;
                        };

                        PgpEngine.prototype.get_designated_revocations = function() {
                            return this.key(this.primary).get_designated_revocations();
                        };

                        PgpEngine.prototype.validity_check = function(cb) {
                            var err, k, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            err = null;
                            (function(_this) {
                                return (function(__iced_k) {
                                    var _i, _len, _ref5, _results, _while;
                                    _ref5 = _this._all_keys();
                                    _len = _ref5.length;
                                    _i = 0;
                                    _while = function(__iced_k) {
                                        var _break, _continue, _next;
                                        _break = __iced_k;
                                        _continue = function() {
                                            return iced.trampoline(function() {
                                                ++_i;
                                                return _while(__iced_k);
                                            });
                                        };
                                        _next = _continue;
                                        if (!(_i < _len)) {
                                            return _break();
                                        } else {
                                            k = _ref5[_i];
                                            (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral,
                                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                                    funcname: "PgpEngine.validity_check"
                                                });
                                                _this.key(k).validity_check(__iced_deferrals.defer({
                                                    assign_fn: (function() {
                                                        return function() {
                                                            return err = arguments[0];
                                                        };
                                                    })(),
                                                    lineno: 328
                                                }));
                                                __iced_deferrals._fulfill();
                                            })(function() {
                                                (function(__iced_k) {
                                                    if (err != null) {
                                                        (function(__iced_k) {
                                                            _break()
                                                        })(__iced_k);
                                                    } else {
                                                        return __iced_k();
                                                    }
                                                })(_next);
                                            });
                                        }
                                    };
                                    _while(__iced_k);
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err);
                                };
                            })(this));
                        };

                        PgpEngine.prototype.find_best_key = function(flags, need_priv) {
                            var best, check, k, _i, _len, _ref5;
                            if (need_priv == null) {
                                need_priv = false;
                            }
                            best = null;
                            check = (function(_this) {
                                return function(k) {
                                    var km, ok1, ok2, ok3;
                                    km = _this.key(k);
                                    ok1 = km.fulfills_flags(flags) || ((k.flags & flags) === flags);
                                    ok2 = !need_priv || km.has_private();
                                    ok3 = !km.is_revoked();
                                    return ok1 && ok2 && ok3;
                                };
                            })(this);
                            _ref5 = this.subkeys;
                            for (_i = 0, _len = _ref5.length; _i < _len; _i++) {
                                k = _ref5[_i];
                                if (check(k)) {
                                    if (best == null) {
                                        best = k;
                                    } else if (this.key(k).is_preferable_to(this.key(best))) {
                                        best = k;
                                    }
                                }
                            }
                            if ((best == null) && check(this.primary)) {
                                best = this.primary;
                            }
                            return (best != null ? this.key(best) : null);
                        };

                        PgpEngine.prototype.fetch = function(key_ids, op_mask, cb) {
                            var err, flags, i, key, kid, ret, ret_i, _i, _len, _ref5, _ref6;
                            flags = ops_to_keyflags(op_mask);
                            err = key = ret = null;
                            key = null;
                            ret_i = null;
                            for (i = _i = 0, _len = key_ids.length; _i < _len; i = ++_i) {
                                kid = key_ids[i];
                                if (!(key == null)) {
                                    continue;
                                }
                                key = this.find_key(kid);
                                if (key != null) {
                                    ret_i = i;
                                }
                            }
                            if (key == null) {
                                err = new Error("No keys match the given key IDs");
                            } else if (this.key(key).is_revoked() || this.is_revoked()) {
                                err = new errors.RevokedKeyError;
                                err.km = this;
                            } else if (!this.key(key).fulfills_flags(flags)) {
                                err = new Error("We don't have a key for the requested PGP ops (flags = " + flags + ")");
                            } else if (!((_ref5 = this.key(key)) != null ? (_ref6 = _ref5.key) != null ? _ref6.can_perform(op_mask) : void 0 : void 0)) {
                                err = new Error("can't peform the operation -- maybe no secret key material (op_mask=" + op_mask + ")");
                            } else {
                                ret = this.key(key);
                            }
                            return cb(err, this.key_manager, ret_i);
                        };

                        PgpEngine.prototype.is_revoked = function() {
                            return this.key(this.primary).is_revoked();
                        };

                        return PgpEngine;

                    })(Engine);

                    KeyManager = (function(_super) {
                        __extends(KeyManager, _super);

                        function KeyManager(_arg) {
                            var signed;
                            this.primary = _arg.primary, this.subkeys = _arg.subkeys, this.userids = _arg.userids, this.armored_pgp_public = _arg.armored_pgp_public, this.armored_pgp_private = _arg.armored_pgp_private, this.user_attributes = _arg.user_attributes, signed = _arg.signed;
                            this.pgp = new PgpEngine({
                                primary: this.primary,
                                subkeys: this.subkeys,
                                userids: this.userids,
                                user_attributes: this.user_attributes,
                                key_manager: this
                            });
                            this.engines = [this.pgp];
                            this._signed = signed != null ? signed : false;
                            this.p3skb = null;
                        }

                        KeyManager.generate = function(_arg, cb) {
                            var F, KEY_FLAGS_PRIMARY, KEY_FLAGS_STD, asp, bundle, curve_name, ecc, err, esc, expire_in, flags, gen, generated, i, nbits, nsubs, primary, primary_flags, s, sub_flags, subkey, subkeys, subkeys_out, u, userid, userids, ___iced_passed_deferral, __iced_deferrals, __iced_k, _i, _len;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            asp = _arg.asp, userid = _arg.userid, userids = _arg.userids, primary = _arg.primary, subkeys = _arg.subkeys, ecc = _arg.ecc, sub_flags = _arg.sub_flags, nsubs = _arg.nsubs, primary_flags = _arg.primary_flags, nbits = _arg.nbits, expire_in = _arg.expire_in, generated = _arg.generated, curve_name = _arg.curve_name;
                            asp = ASP.make(asp);
                            F = C.key_flags;
                            KEY_FLAGS_STD = F.sign_data | F.encrypt_comm | F.encrypt_storage | F.auth;
                            KEY_FLAGS_PRIMARY = KEY_FLAGS_STD | F.certify_keys;
                            primary || (primary = {});
                            primary.flags || (primary.flags = primary_flags || KEY_FLAGS_PRIMARY);
                            primary.expire_in || (primary.expire_in = (expire_in != null ? expire_in.primary : void 0) || K.key_defaults.primary.expire_in);
                            primary.algo || (primary.algo = (ecc ? ECDSA : RSA));
                            primary.nbits || (primary.nbits = nbits || K.key_defaults.primary.nbits[primary.algo.klass_name]);
                            if (curve_name) {
                                primary.curve_name = curve_name;
                            }
                            if ((nsubs != null) && (sub_flags == null)) {
                                sub_flags = (function() {
                                    var _i, _results;
                                    _results = [];
                                    for (i = _i = 0; 0 <= nsubs ? _i < nsubs : _i > nsubs; i = 0 <= nsubs ? ++_i : --_i) {
                                        _results.push(KEY_FLAGS_STD);
                                    }
                                    return _results;
                                })();
                            }
                            subkeys || (subkeys = (function() {
                                var _i, _len, _results;
                                _results = [];
                                for (_i = 0, _len = sub_flags.length; _i < _len; _i++) {
                                    flags = sub_flags[_i];
                                    _results.push({
                                        flags: flags
                                    });
                                }
                                return _results;
                            })());
                            for (_i = 0, _len = subkeys.length; _i < _len; _i++) {
                                subkey = subkeys[_i];
                                subkey.expire_in || (subkey.expire_in = (expire_in != null ? expire_in.subkey : void 0) || K.key_defaults.sub.expire_in);
                                subkey.flags || (subkey.flags = KEY_FLAGS_STD);
                                subkey.algo || (subkey.algo = primary.algo.subkey_algo(subkey.flags));
                                subkey.nbits || (subkey.nbits = nbits || K.key_defaults.sub.nbits[subkey.algo.klass_name]);
                            }
                            generated || (generated = unix_time());
                            esc = make_esc(cb, "KeyManager::generate");
                            if (userid != null) {
                                userids = [userid];
                            }
                            (function(_this) {
                                return (function(__iced_k) {
                                    if ((userids != null) && Array.isArray(userids)) {
                                        return __iced_k(userids = (function() {
                                            var _j, _len1, _results;
                                            _results = [];
                                            for (_j = 0, _len1 = userids.length; _j < _len1; _j++) {
                                                u = userids[_j];
                                                _results.push(new opkts.UserID(u));
                                            }
                                            return _results;
                                        })());
                                    } else {
                                        err = new Error("Need either 'userid' or 'userids' specified as an array");
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                                funcname: "KeyManager.generate"
                                            });
                                            athrow(err, esc(__iced_deferrals.defer({
                                                lineno: 474
                                            })));
                                            __iced_deferrals._fulfill();
                                        })(__iced_k);
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    gen = function(_arg1, cb) {
                                        var err, key, klass, lifespan, my_generated, params, primary, section, wrapper, ___iced_passed_deferral1, __iced_deferrals, __iced_k;
                                        __iced_k = __iced_k_noop;
                                        ___iced_passed_deferral1 = iced.findDeferral(arguments);
                                        klass = _arg1.klass, section = _arg1.section, params = _arg1.params, primary = _arg1.primary;
                                        asp.section(section);
                                        (function(_this) {
                                            return (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral1,
                                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced"
                                                });
                                                params.algo.generate({
                                                    asp: asp,
                                                    nbits: params.nbits,
                                                    curve_name: params.curve_name
                                                }, __iced_deferrals.defer({
                                                    assign_fn: (function() {
                                                        return function() {
                                                            err = arguments[0];
                                                            return key = arguments[1];
                                                        };
                                                    })(),
                                                    lineno: 478
                                                }));
                                                __iced_deferrals._fulfill();
                                            });
                                        })(this)((function(_this) {
                                            return function() {
                                                if (typeof err === "undefined" || err === null) {
                                                    my_generated = params.generated || generated;
                                                    lifespan = new Lifespan({
                                                        generated: my_generated,
                                                        expire_in: params.expire_in
                                                    });
                                                    wrapper = new klass({
                                                        key: key,
                                                        lifespan: lifespan,
                                                        flags: params.flags,
                                                        primary: primary
                                                    });
                                                }
                                                return cb(err, wrapper);
                                            };
                                        })(this));
                                    };
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                            funcname: "KeyManager.generate"
                                        });
                                        gen({
                                            klass: Primary,
                                            section: "primary",
                                            params: primary
                                        }, esc(__iced_deferrals.defer({
                                            assign_fn: (function() {
                                                return function() {
                                                    return primary = arguments[0];
                                                };
                                            })(),
                                            lineno: 485
                                        })));
                                        __iced_deferrals._fulfill();
                                    })(function() {
                                        subkeys_out = [];
                                        (function(__iced_k) {
                                            var _j, _len1, _ref5, _results, _while;
                                            _ref5 = subkeys;
                                            _len1 = _ref5.length;
                                            i = 0;
                                            _while = function(__iced_k) {
                                                var _break, _continue, _next;
                                                _break = __iced_k;
                                                _continue = function() {
                                                    return iced.trampoline(function() {
                                                        ++i;
                                                        return _while(__iced_k);
                                                    });
                                                };
                                                _next = _continue;
                                                if (!(i < _len1)) {
                                                    return _break();
                                                } else {
                                                    subkey = _ref5[i];
                                                    (function(__iced_k) {
                                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                            parent: ___iced_passed_deferral,
                                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                                            funcname: "KeyManager.generate"
                                                        });
                                                        gen({
                                                            klass: Subkey,
                                                            section: "subkey " + (i + 1),
                                                            params: subkey,
                                                            primary: primary
                                                        }, esc(__iced_deferrals.defer({
                                                            assign_fn: (function() {
                                                                return function() {
                                                                    return s = arguments[0];
                                                                };
                                                            })(),
                                                            lineno: 488
                                                        })));
                                                        __iced_deferrals._fulfill();
                                                    })(function() {
                                                        return _next(subkeys_out.push(s));
                                                    });
                                                }
                                            };
                                            _while(__iced_k);
                                        })(function() {
                                            bundle = new KeyManager({
                                                primary: primary,
                                                subkeys: subkeys_out,
                                                userids: userids
                                            });
                                            return cb(null, bundle);
                                        });
                                    });
                                };
                            })(this));
                        };

                        KeyManager.generate_rsa = function(_arg, cb) {
                            var F, asp, primary, subkeys, userid, userids;
                            asp = _arg.asp, userid = _arg.userid, userids = _arg.userids;
                            F = C.key_flags;
                            primary = {
                                flags: F.certify_keys,
                                nbits: 4096
                            };
                            subkeys = [{
                                flags: F.encrypt_storage | F.encrypt_comm,
                                nbits: 2048
                            }, {
                                flags: F.sign_data | F.auth,
                                nbits: 2048
                            }];
                            return KeyManager.generate({
                                asp: asp,
                                userid: userid,
                                userids: userids,
                                primary: primary,
                                subkeys: subkeys
                            }, cb);
                        };

                        KeyManager.generate_ecc = function(_arg, cb) {
                            var F, asp, generated, primary, subkeys, userid, userids;
                            asp = _arg.asp, userid = _arg.userid, userids = _arg.userids, generated = _arg.generated;
                            F = C.key_flags;
                            primary = {
                                flags: F.certify_keys,
                                nbits: 384,
                                algo: ECDSA
                            };
                            subkeys = [{
                                flags: F.encrypt_storage | F.encrypt_comm,
                                nbits: 256
                            }, {
                                flags: F.sign_data | F.auth,
                                nbits: 256
                            }];
                            return KeyManager.generate({
                                asp: asp,
                                userid: userid,
                                userids: userids,
                                primary: primary,
                                subkeys: subkeys,
                                generated: generated
                            }, cb);
                        };

                        KeyManager.prototype.set_enc = function(e) {
                            return this.tsenc = e;
                        };

                        KeyManager.import_from_armored_pgp = function(_arg, cb) {
                            var armored, asp, binary, decode_func, err, msg, opts, packets, raw, ret, warnings, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref5, _ref6;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            armored = _arg.armored, raw = _arg.raw, binary = _arg.binary, asp = _arg.asp, opts = _arg.opts;
                            msg = binary;
                            err = null;
                            if (msg == null) {
                                raw || (raw = armored);
                                asp = ASP.make(asp);
                                warnings = null;
                                ret = null;
                                decode_func = (opts != null ? opts.decode_strict : void 0) ? decode_strict : decode;
                                _ref5 = decode_func(raw), err = _ref5[0], msg = _ref5[1];
                                if (err == null) {
                                    if (!((_ref6 = msg.type) === C.message_types.public_key || _ref6 === C.message_types.private_key)) {
                                        err = new Error("Wanted a public or private key; got: " + msg.type);
                                    }
                                }
                            }
                            (function(_this) {
                                return (function(__iced_k) {
                                    if (err == null) {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                                funcname: "KeyManager.import_from_armored_pgp"
                                            });
                                            KeyManager.import_from_pgp_message({
                                                msg: msg,
                                                asp: asp,
                                                opts: opts
                                            }, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        err = arguments[0];
                                                        ret = arguments[1];
                                                        warnings = arguments[2];
                                                        return packets = arguments[3];
                                                    };
                                                })(),
                                                lineno: 567
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(__iced_k);
                                    } else {
                                        return __iced_k();
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    (function(__iced_k) {
                                        if (!(err != null)) {
                                            (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral,
                                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                                    funcname: "KeyManager.import_from_armored_pgp"
                                                });
                                                ret.simple_unlock({}, __iced_deferrals.defer({
                                                    assign_fn: (function() {
                                                        return function() {
                                                            return err = arguments[0];
                                                        };
                                                    })(),
                                                    lineno: 573
                                                }));
                                                __iced_deferrals._fulfill();
                                            })(__iced_k);
                                        } else {
                                            return __iced_k();
                                        }
                                    })(function() {
                                        return cb(err, ret, warnings, packets);
                                    });
                                };
                            })(this));
                        };

                        KeyManager.prototype.simple_unlock = function(opts, cb) {
                            var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            err = null;
                            (function(_this) {
                                return (function(__iced_k) {
                                    if (_this.has_pgp_private() && !_this.is_pgp_locked()) {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                                funcname: "KeyManager.simple_unlock"
                                            });
                                            _this.unlock_pgp({}, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        return err = arguments[0];
                                                    };
                                                })(),
                                                lineno: 585
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(__iced_k);
                                    } else {
                                        return __iced_k();
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err);
                                };
                            })(this));
                        };

                        KeyManager.import_from_p3skb = function(_arg, cb) {
                            var armored, asp, err, km, msg, no_check_keys, now, opts, p3skb, raw, time_travel, warnings, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref5;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            raw = _arg.raw, armored = _arg.armored, asp = _arg.asp, no_check_keys = _arg.no_check_keys, time_travel = _arg.time_travel, now = _arg.now;
                            armored || (armored = raw);
                            asp = ASP.make(asp);
                            km = null;
                            warnings = null;
                            _ref5 = katch(function() {
                                return P3SKB.alloc(unseal(read_base64(armored)));
                            }), err = _ref5[0], p3skb = _ref5[1];
                            (function(_this) {
                                return (function(__iced_k) {
                                    if (err == null) {
                                        msg = new Message({
                                            body: p3skb.pub,
                                            type: C.message_types.public_key
                                        });
                                        opts = {
                                            no_check_keys: no_check_keys,
                                            time_travel: time_travel,
                                            now: now
                                        };
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                                funcname: "KeyManager.import_from_p3skb"
                                            });
                                            KeyManager.import_from_pgp_message({
                                                msg: msg,
                                                asp: asp,
                                                opts: opts
                                            }, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        err = arguments[0];
                                                        km = arguments[1];
                                                        return warnings = arguments[2];
                                                    };
                                                })(),
                                                lineno: 601
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(function() {
                                            return __iced_k(km != null ? km.p3skb = p3skb : void 0);
                                        });
                                    } else {
                                        return __iced_k();
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err, km, warnings);
                                };
                            })(this));
                        };

                        KeyManager.prototype.unlock_p3skb = function(_arg, cb) {
                            var asp, err, km, msg, no_check_keys, now, opts, passphrase, passphrase_generation, time_travel, tsenc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            asp = _arg.asp, tsenc = _arg.tsenc, passphrase = _arg.passphrase, passphrase_generation = _arg.passphrase_generation, no_check_keys = _arg.no_check_keys, time_travel = _arg.time_travel, now = _arg.now;
                            asp = ASP.make(asp);
                            if ((tsenc == null) && (passphrase != null)) {
                                tsenc = new Encryptor({
                                    key: bufferify(passphrase)
                                });
                            }
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                        funcname: "KeyManager.unlock_p3skb"
                                    });
                                    _this.p3skb.unlock({
                                        tsenc: tsenc,
                                        asp: asp,
                                        passphrase_generation: passphrase_generation
                                    }, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return err = arguments[0];
                                            };
                                        })(),
                                        lineno: 611
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    (function(__iced_k) {
                                        if (err == null) {
                                            msg = new Message({
                                                body: _this.p3skb.priv.data,
                                                type: C.message_types.private_key
                                            });
                                            opts = {
                                                no_check_keys: no_check_keys,
                                                time_travel: time_travel,
                                                now: now
                                            };
                                            (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral,
                                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                                    funcname: "KeyManager.unlock_p3skb"
                                                });
                                                KeyManager.import_from_pgp_message({
                                                    msg: msg,
                                                    asp: asp,
                                                    opts: opts
                                                }, __iced_deferrals.defer({
                                                    assign_fn: (function() {
                                                        return function() {
                                                            err = arguments[0];
                                                            return km = arguments[1];
                                                        };
                                                    })(),
                                                    lineno: 615
                                                }));
                                                __iced_deferrals._fulfill();
                                            })(__iced_k);
                                        } else {
                                            return __iced_k();
                                        }
                                    })(function() {
                                        if (typeof err === "undefined" || err === null) {
                                            err = _this.pgp.merge_private(km.pgp);
                                        }
                                        (function(__iced_k) {
                                            if (err == null) {
                                                passphrase = new Buffer([]);
                                                (function(__iced_k) {
                                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                        parent: ___iced_passed_deferral,
                                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                                        funcname: "KeyManager.unlock_p3skb"
                                                    });
                                                    _this.unlock_pgp({
                                                        passphrase: passphrase
                                                    }, __iced_deferrals.defer({
                                                        assign_fn: (function() {
                                                            return function() {
                                                                return err = arguments[0];
                                                            };
                                                        })(),
                                                        lineno: 624
                                                    }));
                                                    __iced_deferrals._fulfill();
                                                })(__iced_k);
                                            } else {
                                                return __iced_k();
                                            }
                                        })(function() {
                                            return cb(err);
                                        });
                                    });
                                };
                            })(this));
                        };

                        KeyManager.import_from_pgp_message = function(_arg, cb) {
                            var asp, bundle, err, k, kb, msg, opts, packets, warnings, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref5;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            msg = _arg.msg, asp = _arg.asp, opts = _arg.opts;
                            asp = ASP.make(asp);
                            bundle = null;
                            warnings = null;
                            if (typeof err === "undefined" || err === null) {
                                _ref5 = parse(msg.body), err = _ref5[0], packets = _ref5[1];
                            }
                            (function(_this) {
                                return (function(__iced_k) {
                                    if (err == null) {
                                        kb = new KeyBlock(packets, opts);
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                                funcname: "KeyManager.import_from_pgp_message"
                                            });
                                            kb.process(__iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        return err = arguments[0];
                                                    };
                                                })(),
                                                lineno: 639
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(function() {
                                            return __iced_k(warnings = kb.warnings);
                                        });
                                    } else {
                                        return __iced_k();
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    if (err == null) {
                                        bundle = new KeyManager({
                                            primary: KeyManager._wrap_pgp(Primary, kb.primary),
                                            subkeys: (function() {
                                                var _i, _len, _ref6, _results;
                                                _ref6 = kb.subkeys;
                                                _results = [];
                                                for (_i = 0, _len = _ref6.length; _i < _len; _i++) {
                                                    k = _ref6[_i];
                                                    _results.push(KeyManager._wrap_pgp(Subkey, k));
                                                }
                                                return _results;
                                            })(),
                                            user_attributes: kb.user_attributes,
                                            userids: kb.userids,
                                            signed: true
                                        });
                                        if (bundle.has_pgp_private()) {
                                            bundle.armored_pgp_private = msg.raw();
                                        } else {
                                            bundle.armored_pgp_public = msg.raw();
                                        }
                                    }
                                    (function(__iced_k) {
                                        if (err == null) {
                                            (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral,
                                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                                    funcname: "KeyManager.import_from_pgp_message"
                                                });
                                                bundle.check_pgp_validity(__iced_deferrals.defer({
                                                    assign_fn: (function() {
                                                        return function() {
                                                            return err = arguments[0];
                                                        };
                                                    })(),
                                                    lineno: 657
                                                }));
                                                __iced_deferrals._fulfill();
                                            })(__iced_k);
                                        } else {
                                            return __iced_k();
                                        }
                                    })(function() {
                                        return cb(err, bundle, warnings, packets);
                                    });
                                };
                            })(this));
                        };

                        KeyManager.prototype.merge_pgp_private = function(_arg, cb) {
                            var armored, asp, b2, err, esc, import_opts, raw, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            armored = _arg.armored, raw = _arg.raw, asp = _arg.asp, import_opts = _arg.import_opts;
                            asp = ASP.make(asp);
                            esc = make_esc(cb, "merge_pgp_private");
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                        funcname: "KeyManager.merge_pgp_private"
                                    });
                                    KeyManager.import_from_armored_pgp({
                                        armored: armored,
                                        raw: raw,
                                        asp: asp,
                                        opts: import_opts
                                    }, esc(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return b2 = arguments[0];
                                            };
                                        })(),
                                        lineno: 668
                                    })));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    err = _this.pgp.merge_private(b2.pgp);
                                    (function(__iced_k) {
                                        if (err != null) {
                                            return __iced_k();
                                        } else {
                                            (function(__iced_k) {
                                                if (!_this.has_pgp_private()) {
                                                    return __iced_k(err = new Error("no private key material found after merge"));
                                                } else {
                                                    (function(__iced_k) {
                                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                            parent: ___iced_passed_deferral,
                                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                                            funcname: "KeyManager.merge_pgp_private"
                                                        });
                                                        _this.simple_unlock({}, esc(__iced_deferrals.defer({
                                                            lineno: 675
                                                        })));
                                                        __iced_deferrals._fulfill();
                                                    })(__iced_k);
                                                }
                                            })(__iced_k);
                                        }
                                    })(function() {
                                        return cb(err);
                                    });
                                };
                            })(this));
                        };

                        KeyManager.prototype.check_pgp_public_eq = function(km2) {
                            return this.pgp.check_eq(km2.pgp);
                        };

                        KeyManager.prototype.unlock_pgp = function(_arg, cb) {
                            var err, passphrase, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            passphrase = _arg.passphrase;
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                        funcname: "KeyManager.unlock_pgp"
                                    });
                                    _this.pgp.unlock_keys({
                                        passphrase: passphrase
                                    }, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return err = arguments[0];
                                            };
                                        })(),
                                        lineno: 688
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err);
                                };
                            })(this));
                        };

                        KeyManager.prototype.is_pgp_locked = function() {
                            return this.pgp.is_locked();
                        };

                        KeyManager.prototype.is_keybase_locked = function() {
                            return this.keybase.is_locked();
                        };

                        KeyManager.prototype.has_pgp_private = function() {
                            return this.pgp.has_private();
                        };

                        KeyManager.prototype.has_p3skb_private = function() {
                            var _ref5;
                            return (_ref5 = this.p3skb) != null ? _ref5.has_private() : void 0;
                        };

                        KeyManager.prototype.has_keybase_private = function() {
                            return this.keybase.has_private();
                        };

                        KeyManager.prototype.is_p3skb_locked = function() {
                            var _ref5;
                            return (_ref5 = this.p3skb) != null ? _ref5.is_locked() : void 0;
                        };

                        KeyManager.prototype.unlock_keybase = function(_arg, cb) {
                            var asp, err, tsenc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            tsenc = _arg.tsenc, asp = _arg.asp;
                            asp = ASP.make(asp);
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                        funcname: "KeyManager.unlock_keybase"
                                    });
                                    _this.keybase.unlock_keys({
                                        tsenc: tsenc,
                                        asp: asp
                                    }, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return err = arguments[0];
                                            };
                                        })(),
                                        lineno: 706
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err);
                                };
                            })(this));
                        };

                        KeyManager.prototype.export_private_to_server = function(_arg, cb) {
                            var asp, err, p3skb, passphrase_generation, ret, tsenc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            tsenc = _arg.tsenc, asp = _arg.asp, passphrase_generation = _arg.passphrase_generation;
                            asp = ASP.make(asp);
                            err = ret = null;
                            (function(_this) {
                                return (function(__iced_k) {
                                    if ((err = _this._assert_signed()) == null) {
                                        p3skb = _this.pgp.export_to_p3skb();
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                                funcname: "KeyManager.export_private_to_server"
                                            });
                                            p3skb.lock({
                                                tsenc: tsenc,
                                                asp: asp,
                                                passphrase_generation: passphrase_generation
                                            }, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        return err = arguments[0];
                                                    };
                                                })(),
                                                lineno: 719
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(__iced_k);
                                    } else {
                                        return __iced_k();
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    if (err == null) {
                                        ret = p3skb.frame_packet_armored({
                                            dohash: true
                                        });
                                    }
                                    return cb(err, ret);
                                };
                            })(this));
                        };

                        KeyManager.prototype.export_pgp_private_to_client = function(_arg, cb) {
                            var err, msg, passphrase, regen;
                            passphrase = _arg.passphrase, regen = _arg.regen;
                            err = null;
                            if (passphrase != null) {
                                passphrase = bufferify(passphrase);
                            }
                            if (regen || ((msg = this.armored_pgp_private) == null)) {
                                if ((err = this._assert_signed()) == null) {
                                    this.armored_pgp_private = msg = this.pgp.export_keys({
                                        "private": true,
                                        passphrase: passphrase
                                    });
                                }
                            }
                            return cb(err, msg);
                        };

                        KeyManager.prototype.export_pgp_private = function() {
                            var args;
                            args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
                            return this.export_pgp_private_to_client.apply(this, args);
                        };

                        KeyManager.prototype.export_pgp_public = function(_arg, cb) {
                            var err, msg, regen;
                            regen = _arg.regen;
                            err = null;
                            if (regen || ((msg = this.armored_pgp_public) == null)) {
                                if ((err = this._assert_signed()) == null) {
                                    this.armored_pgp_public = msg = this.pgp.export_keys({
                                        "private": false
                                    });
                                }
                            }
                            return cb(err, msg);
                        };

                        KeyManager.prototype.export_public = function(_arg, cb) {
                            var asp, err, msg, regen, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref5;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            _ref5 = _arg != null ? _arg : {}, asp = _ref5.asp, regen = _ref5.regen;
                            if (cb == null) {
                                cb = null;
                            }
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                        funcname: "KeyManager.export_public"
                                    });
                                    _this.export_pgp_public({
                                        asp: asp,
                                        regen: regen
                                    }, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                err = arguments[0];
                                                return msg = arguments[1];
                                            };
                                        })(),
                                        lineno: 753
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err, msg);
                                };
                            })(this));
                        };

                        KeyManager.prototype.export_private = function(_arg, cb) {
                            var asp, err, p3skb, passphrase, passphrase_generation, regen, res, tsenc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            passphrase = _arg.passphrase, p3skb = _arg.p3skb, asp = _arg.asp, regen = _arg.regen, passphrase_generation = _arg.passphrase_generation;
                            (function(_this) {
                                return (function(__iced_k) {
                                    if (p3skb) {
                                        tsenc = new Encryptor({
                                            key: bufferify(passphrase)
                                        });
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                                funcname: "KeyManager.export_private"
                                            });
                                            _this.export_private_to_server({
                                                tsenc: tsenc,
                                                asp: asp,
                                                passphrase_generation: passphrase_generation
                                            }, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        err = arguments[0];
                                                        return res = arguments[1];
                                                    };
                                                })(),
                                                lineno: 761
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(__iced_k);
                                    } else {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                                funcname: "KeyManager.export_private"
                                            });
                                            _this.export_pgp_private_to_client({
                                                passphrase: passphrase,
                                                asp: asp,
                                                regen: regen
                                            }, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        err = arguments[0];
                                                        return res = arguments[1];
                                                    };
                                                })(),
                                                lineno: 763
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(__iced_k);
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err, res);
                                };
                            })(this));
                        };

                        KeyManager.prototype.pgp_full_hash = function(opts, cb) {
                            var armored, esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            esc = make_esc(cb, "get_pgp_full_hash");
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                        funcname: "KeyManager.pgp_full_hash"
                                    });
                                    _this.export_pgp_public(opts, esc(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return armored = arguments[0];
                                            };
                                        })(),
                                        lineno: 770
                                    })));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(null, (new SHA256(new Buffer(armored.trim()))).toString("hex"));
                                };
                            })(this));
                        };

                        KeyManager.prototype.sign_pgp = function(_arg, cb) {
                            var asp, time;
                            asp = _arg.asp, time = _arg.time;
                            return this.pgp.sign({
                                asp: asp,
                                time: time
                            }, cb);
                        };

                        KeyManager.prototype.sign = function(_arg, cb) {
                            var asp, err, time, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            asp = _arg.asp, time = _arg.time;
                            asp = ASP.make(asp);
                            asp.section("sign");
                            asp.progress({
                                what: "sign PGP",
                                total: 1,
                                i: 0
                            });
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                        funcname: "KeyManager.sign"
                                    });
                                    _this.sign_pgp({
                                        asp: asp,
                                        time: time
                                    }, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return err = arguments[0];
                                            };
                                        })(),
                                        lineno: 783
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    asp.progress({
                                        what: "sign PGP",
                                        total: 1,
                                        i: 1
                                    });
                                    if (typeof err === "undefined" || err === null) {
                                        _this._signed = true;
                                    }
                                    return cb(err);
                                };
                            })(this));
                        };

                        KeyManager.prototype.get_userids = function() {
                            return this.userids;
                        };

                        KeyManager.prototype.get_userids_mark_primary = function() {
                            var do_insert, i, k, max, max_s, mymax, obj, pair, prev, primary_time, ret, s, tab, userid, _i, _len, _ref5;
                            max = null;
                            max_s = null;
                            tab = {};
                            mymax = function(a, b) {
                                if ((a == null) && (b == null)) {
                                    return null;
                                } else if (a == null) {
                                    return b;
                                } else if (b == null) {
                                    return a;
                                } else if (a > b) {
                                    return a;
                                } else {
                                    return b;
                                }
                            };
                            _ref5 = this.userids;
                            for (i = _i = 0, _len = _ref5.length; _i < _len; i = ++_i) {
                                userid = _ref5[i];
                                if (!(userid != null)) {
                                    continue;
                                }
                                s = userid.utf8();
                                pair = userid.time_primary_pair();
                                obj = {
                                    userid: userid,
                                    pair: pair,
                                    i: i
                                };
                                do_insert = false;
                                if ((prev = tab[s]) != null) {
                                    primary_time = mymax(prev.pair[1], pair[1]);
                                    if (!(prev.pair[0] != null) || (pair[0] && prev.pair[0] < pair[0])) {
                                        do_insert = true;
                                    }
                                } else {
                                    primary_time = pair[1];
                                    do_insert = true;
                                }
                                if (do_insert) {
                                    tab[s] = obj;
                                }
                                if ((primary_time != null) && ((max == null) || max < primary_time)) {
                                    max_s = s;
                                    max = primary_time;
                                }
                            }
                            if (max_s != null) {
                                tab[max_s].userid.primary = true;
                            }
                            ret = [];
                            for (k in tab) {
                                obj = tab[k];
                                obj.userid.most_recent_sig = obj.pair[0];
                                ret.push(obj.userid);
                            }
                            return ret;
                        };

                        KeyManager.prototype.fetch = function(key_ids, flags, cb) {
                            return this.pgp.fetch(key_ids, flags, cb);
                        };

                        KeyManager.prototype.find_pgp_key = function(key_id) {
                            return this.pgp.find_key(key_id);
                        };

                        KeyManager.prototype.find_pgp_key_material = function(key_id) {
                            return this.pgp.find_key_material(key_id);
                        };

                        KeyManager.prototype.find_best_pgp_key = function(flags, need_priv) {
                            return this.pgp.find_best_key(flags, need_priv);
                        };

                        KeyManager.prototype.find_signing_pgp_key = function() {
                            return this.find_best_pgp_key(C.key_flags.sign_data, true);
                        };

                        KeyManager.prototype.find_verifying_pgp_key = function() {
                            return this.find_best_pgp_key(C.key_flags.sign_data, false);
                        };

                        KeyManager.prototype.find_crypt_pgp_key = function(need_priv) {
                            if (need_priv == null) {
                                need_priv = false;
                            }
                            return this.find_best_pgp_key(C.key_flags.encrypt_comm, need_priv);
                        };

                        KeyManager.prototype.can_verify = function() {
                            return this.find_verifying_pgp_key() != null;
                        };

                        KeyManager.prototype.can_sign = function() {
                            return this.find_signing_pgp_key() != null;
                        };

                        KeyManager.prototype.can_encrypt = function() {
                            return this.find_crypt_pgp_key(false) != null;
                        };

                        KeyManager.prototype.can_decrypt = function() {
                            return this.find_crypt_pgp_key(true) != null;
                        };

                        KeyManager.prototype.is_pgp_revoked = function() {
                            return this.pgp.is_revoked();
                        };

                        KeyManager.prototype.get_pgp_designated_revocations = function() {
                            return this.pgp.get_designated_revocations();
                        };

                        KeyManager.prototype.get_primary_keypair = function() {
                            return this.primary.key;
                        };

                        KeyManager.prototype.get_all_pgp_key_materials = function() {
                            return this.pgp.get_all_key_materials();
                        };

                        KeyManager.prototype.export_pgp_keys_to_keyring = function() {
                            return this.pgp.export_keys_to_keyring(this);
                        };

                        KeyManager.prototype.get_pgp_key_id = function() {
                            return this.pgp.get_key_id();
                        };

                        KeyManager.prototype.get_pgp_short_key_id = function() {
                            return this.pgp.get_short_key_id();
                        };

                        KeyManager.prototype.get_pgp_fingerprint = function() {
                            return this.pgp.get_fingerprint();
                        };

                        KeyManager.prototype.get_pgp_fingerprint_str = function() {
                            var _ref5;
                            return (_ref5 = this.get_pgp_fingerprint()) != null ? _ref5.toString('hex') : void 0;
                        };

                        KeyManager.prototype.get_ekid = function() {
                            return this.pgp.get_ekid();
                        };

                        KeyManager.prototype.clear_pgp_internal_sigs = function() {
                            return this.pgp.clear_psc();
                        };

                        KeyManager.prototype.get_all_pgp_key_ids = function() {
                            return this.pgp.get_all_key_ids();
                        };

                        KeyManager.prototype.get_ekid_b64_str = function() {
                            var k;
                            if ((k = this.get_ekid()) != null) {
                                return base64u.encode(k);
                            } else {
                                return null;
                            }
                        };

                        KeyManager.prototype.get_fp2 = function() {
                            return this.get_pgp_fingerprint();
                        };

                        KeyManager.prototype.get_fp2_formatted = function(opts) {
                            var p;
                            if ((p = this.get_fp2()) != null) {
                                return format_pgp_fingerprint_2(p, opts);
                            } else {
                                return null;
                            }
                        };

                        KeyManager.prototype.get_type = function() {
                            return "pgp";
                        };

                        KeyManager.prototype.check_pgp_validity = function(cb) {
                            return this.pgp.validity_check(cb);
                        };

                        KeyManager.prototype.make_sig_eng = function() {
                            return new SignatureEngine({
                                km: this
                            });
                        };

                        KeyManager.prototype._apply_to_engines = function(_arg, cb) {
                            var args, e, err, meth, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            args = _arg.args, meth = _arg.meth;
                            err = null;
                            (function(_this) {
                                return (function(__iced_k) {
                                    var _i, _len, _ref5, _results, _while;
                                    _ref5 = _this.engines;
                                    _len = _ref5.length;
                                    _i = 0;
                                    _while = function(__iced_k) {
                                        var _break, _continue, _next;
                                        _break = __iced_k;
                                        _continue = function() {
                                            return iced.trampoline(function() {
                                                ++_i;
                                                return _while(__iced_k);
                                            });
                                        };
                                        _next = _continue;
                                        if (!(_i < _len)) {
                                            return _break();
                                        } else {
                                            e = _ref5[_i];
                                            if (!err) {
                                                (function(__iced_k) {
                                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                        parent: ___iced_passed_deferral,
                                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                                        funcname: "KeyManager._apply_to_engines"
                                                    });
                                                    meth.call(e, args, __iced_deferrals.defer({
                                                        assign_fn: (function() {
                                                            return function() {
                                                                return err = arguments[0];
                                                            };
                                                        })(),
                                                        lineno: 923
                                                    }));
                                                    __iced_deferrals._fulfill();
                                                })(_next);
                                            } else {
                                                return _continue();
                                            }
                                        }
                                    };
                                    _while(__iced_k);
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err);
                                };
                            })(this));
                        };

                        KeyManager.prototype._assert_signed = function() {
                            if (this._signed) {
                                return null;
                            } else {
                                return new Error("need to sign before export");
                            }
                        };

                        KeyManager._wrap_pgp = function(klass, kmp) {
                            var _ref5;
                            return new klass({
                                key: kmp.key,
                                lifespan: new Lifespan({
                                    generated: kmp.timestamp,
                                    expire_in: (_ref5 = kmp.get_expire_time()) != null ? _ref5.expire_in : void 0
                                }),
                                _pgp: kmp
                            });
                        };

                        KeyManager.prototype.merge_all_subkeys_omitting_revokes = function(km2) {
                            if ((this.pgp != null) && (km2.pgp != null)) {
                                return this.pgp.merge_all_subkeys_omitting_revokes(km2.pgp);
                            }
                        };

                        KeyManager.prototype.pgp_check_not_expired = function(_arg) {
                            var now, subkey_material;
                            subkey_material = _arg.subkey_material, now = _arg.now;
                            return this.pgp.check_not_expired({
                                subkey_material: subkey_material,
                                now: now
                            });
                        };

                        KeyManager.prototype.merge_public_omitting_revokes = function(km2) {
                            if ((this.pgp != null) && (km2.pgp != null)) {
                                return this.pgp.merge_public_omitting_revokes(km2.pgp);
                            }
                        };

                        KeyManager.prototype.merge_userids = function(km2) {
                            var candidate_userid, existing_userid, existing_utf8_strings, _i, _j, _len, _len1, _ref5, _ref6, _results;
                            if ((this.pgp == null) || (km2.pgp == null)) {
                                return;
                            }
                            existing_utf8_strings = {};
                            _ref5 = this.userids;
                            for (_i = 0, _len = _ref5.length; _i < _len; _i++) {
                                existing_userid = _ref5[_i];
                                existing_utf8_strings[existing_userid.utf8()] = true;
                            }
                            _ref6 = km2.get_userids_mark_primary();
                            _results = [];
                            for (_j = 0, _len1 = _ref6.length; _j < _len1; _j++) {
                                candidate_userid = _ref6[_j];
                                if (!(candidate_userid.utf8() in existing_utf8_strings)) {
                                    _results.push(this.userids.push(candidate_userid));
                                } else {
                                    _results.push(void 0);
                                }
                            }
                            return _results;
                        };

                        KeyManager.prototype.merge_everything = function(km2) {
                            this.merge_public_omitting_revokes(km2);
                            return this.merge_userids(km2);
                        };

                        KeyManager.prototype.find_verified_designated_revoke = function(fetcher, cb) {
                            var err, i, key_id, keymat, km, sig, sigs, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            if (this.pgp == null) {
                                return cb();
                            }
                            sigs = this.get_pgp_designated_revocations();
                            if ((sigs == null) || sigs.length === 0) {
                                return cb();
                            }
                            (function(_this) {
                                return (function(__iced_k) {
                                    var _i, _len, _ref5, _results, _while;
                                    _ref5 = sigs;
                                    _len = _ref5.length;
                                    _i = 0;
                                    _while = function(__iced_k) {
                                        var _break, _continue, _next;
                                        _break = __iced_k;
                                        _continue = function() {
                                            return iced.trampoline(function() {
                                                ++_i;
                                                return _while(__iced_k);
                                            });
                                        };
                                        _next = _continue;
                                        if (!(_i < _len)) {
                                            return _break();
                                        } else {
                                            sig = _ref5[_i];
                                            key_id = sig.get_issuer_key_id();
                                            (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral,
                                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                                    funcname: "KeyManager.find_verified_designated_revoke"
                                                });
                                                fetcher.fetch([key_id], konst.ops.verify, __iced_deferrals.defer({
                                                    assign_fn: (function() {
                                                        return function() {
                                                            err = arguments[0];
                                                            km = arguments[1];
                                                            return i = arguments[2];
                                                        };
                                                    })(),
                                                    lineno: 995
                                                }));
                                                __iced_deferrals._fulfill();
                                            })(function() {
                                                (function(__iced_k) {
                                                    if (err || (typeof km === "undefined" || km === null) || (km.pgp == null)) {
                                                        (function(__iced_k) {
                                                            _continue()
                                                        })(__iced_k);
                                                    } else {
                                                        return __iced_k();
                                                    }
                                                })(function() {
                                                    keymat = km.find_pgp_key_material(key_id);
                                                    (function(__iced_k) {
                                                        if (keymat == null) {
                                                            (function(__iced_k) {
                                                                _continue()
                                                            })(__iced_k);
                                                        } else {
                                                            return __iced_k();
                                                        }
                                                    })(function() {
                                                        (function(__iced_k) {
                                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                                parent: ___iced_passed_deferral,
                                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/keymanager.iced",
                                                                funcname: "KeyManager.find_verified_designated_revoke"
                                                            });
                                                            sig._third_party_verify(keymat, __iced_deferrals.defer({
                                                                assign_fn: (function() {
                                                                    return function() {
                                                                        return err = arguments[0];
                                                                    };
                                                                })(),
                                                                lineno: 1003
                                                            }));
                                                            __iced_deferrals._fulfill();
                                                        })(function() {
                                                            if (!err) {
                                                                return cb(sig);
                                                            }
                                                            return _next();
                                                        });
                                                    });
                                                });
                                            });
                                        }
                                    };
                                    _while(__iced_k);
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb();
                                };
                            })(this));
                        };

                        return KeyManager;

                    })(KeyManagerInterface);

                    exports.KeyManager = KeyManager;

                    exports.opkts = opkts;

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../const": 5,
            "../ecc/ecdsa": 10,
            "../errors": 15,
            "../hash": 16,
            "../keybase/encode": 18,
            "../keybase/packet/p3skb": 23,
            "../keyfetch": 26,
            "../keywrapper": 28,
            "../kmi": 29,
            "../rsa": 69,
            "../util": 72,
            "./armor": 35,
            "./packet/all": 46,
            "./parser": 58,
            "./processor": 59,
            "./sigeng": 61,
            "./util": 62,
            "buffer": 126,
            "iced-error": 179,
            "iced-runtime": 183,
            "triplesec": 282
        }],
        45: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var AES, ASP, Base, Decryptor, Encryptor, SlicerBuffer, WordArray, decrypt, encrypt, iced, make_esc, repeat, rng, test, triplesec, __iced_k, __iced_k_noop,
                        __hasProp = {}.hasOwnProperty,
                        __extends = function(child, parent) {
                            for (var key in parent) {
                                if (__hasProp.call(parent, key)) child[key] = parent[key];
                            }

                            function ctor() {
                                this.constructor = child;
                            }
                            ctor.prototype = parent.prototype;
                            child.prototype = new ctor();
                            child.__super__ = parent.prototype;
                            return child;
                        };

                    iced = require('iced-runtime');
                    __iced_k = __iced_k_noop = function() {};

                    WordArray = require('triplesec').WordArray;

                    SlicerBuffer = require('./buffer').SlicerBuffer;

                    triplesec = require('triplesec');

                    AES = triplesec.ciphers.AES;

                    ASP = require('pgp-utils').util.ASP;

                    make_esc = require('iced-error').make_esc;

                    repeat = function(b, n) {
                        return Buffer.concat([b, b.slice(b.length - n)]);
                    };

                    Base = (function() {
                        function Base(_arg) {
                            var asp, key;
                            this.block_cipher_class = _arg.block_cipher_class, key = _arg.key, this.cipher = _arg.cipher, this.resync = _arg.resync, asp = _arg.asp;
                            this.block_cipher_class || (this.block_cipher_class = AES);
                            this.cipher || (this.cipher = new this.block_cipher_class(WordArray.from_buffer(key)));
                            this.block_size = this.cipher.blockSize;
                            this.out_bufs = [];
                            this.asp = ASP.make(asp);
                        }

                        Base.prototype.compact = function() {
                            var b;
                            b = Buffer.concat(this.out_bufs);
                            this.out_bufs = [b];
                            return b;
                        };

                        return Base;

                    })();

                    Encryptor = (function(_super) {
                        __extends(Encryptor, _super);

                        function Encryptor(_arg) {
                            var asp, block_cipher_class, cipher, key, prefixrandom, resync;
                            block_cipher_class = _arg.block_cipher_class, key = _arg.key, cipher = _arg.cipher, prefixrandom = _arg.prefixrandom, resync = _arg.resync, asp = _arg.asp;
                            Encryptor.__super__.constructor.call(this, {
                                block_cipher_class: block_cipher_class,
                                key: key,
                                cipher: cipher,
                                resync: resync,
                                asp: asp
                            });
                            this._init(prefixrandom);
                        }

                        Encryptor.prototype._enc = function() {
                            this.FRE = WordArray.from_buffer(this.FR);
                            return this.cipher.encryptBlock(this.FRE.words, 0);
                        };

                        Encryptor.prototype._emit_sb = function(sb) {
                            var buf, deficit, i, pad;
                            buf = (deficit = this.block_size - sb.rem()) > 0 ? (pad = new Buffer((function() {
                                var _i, _results;
                                _results = [];
                                for (i = _i = 0; 0 <= deficit ? _i < deficit : _i > deficit; i = 0 <= deficit ? ++_i : --_i) {
                                    _results.push(0);
                                }
                                return _results;
                            })()), Buffer.concat([sb.consume_rest_to_buffer(), pad])) : sb.read_buffer(this.block_size);
                            return this._emit_buf(buf);
                        };

                        Encryptor.prototype._emit_buf = function(buf) {
                            var wa;
                            wa = WordArray.from_buffer(buf.slice(0, this.block_size));
                            wa.xor(this.FRE, {
                                n_words: Math.min(wa.words.length, this.FRE.words.length)
                            });
                            buf = wa.to_buffer();
                            this.out_bufs.push(buf);
                            return this.FR = new Buffer(buf);
                        };

                        Encryptor.prototype._init = function(prefixrandom) {
                            var b, canary, ct, i, offset;
                            this.FR = new Buffer((function() {
                                var _i, _ref, _results;
                                _results = [];
                                for (i = _i = 0, _ref = this.block_size; 0 <= _ref ? _i < _ref : _i > _ref; i = 0 <= _ref ? ++_i : --_i) {
                                    _results.push(0);
                                }
                                return _results;
                            }).call(this));
                            prefixrandom = repeat(prefixrandom, 2);
                            this._enc();
                            this._emit_buf(prefixrandom);
                            this._enc();
                            b = this.FRE.to_buffer();
                            canary = new Buffer((function() {
                                var _i, _results;
                                _results = [];
                                for (i = _i = 0; _i < 2; i = ++_i) {
                                    _results.push(b.readUInt8(i) ^ prefixrandom.readUInt8(this.block_size + i));
                                }
                                return _results;
                            }).call(this));
                            this.out_bufs.push(canary);
                            offset = this.resync ? 2 : 0;
                            ct = this.compact();
                            ct.copy(this.FR, 0, offset, offset + this.block_size);
                            return this._enc();
                        };

                        Encryptor.prototype.enc = function(plaintext, cb) {
                            var buf, ct, esc, j, n_wanted, ret, sb, total, wa, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            sb = new SlicerBuffer(plaintext);
                            esc = make_esc(cb, "Encryptor::enc");
                            if (this.resync) {
                                this._emit_sb(sb);
                            } else {
                                buf = Buffer.concat([new Buffer([0, 0]), sb.read_buffer(this.block_size - 2)]);
                                wa = WordArray.from_buffer(buf);
                                wa.xor(this.FRE, {});
                                buf = wa.to_buffer().slice(2);
                                this.out_bufs.push(buf);
                                ct = this.compact();
                                ct.copy(this.FR, 0, ct.length - this.block_size, ct.length);
                            }
                            total = sb.rem();
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/openpgp/ocfb.iced",
                                        funcname: "Encryptor.enc"
                                    });
                                    _this.asp.progress({
                                        what: "ofcb encryption",
                                        i: 0,
                                        total: total
                                    }, esc(__iced_deferrals.defer({
                                        lineno: 168
                                    })));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    (function(__iced_k) {
                                        var _while;
                                        _while = function(__iced_k) {
                                            var _break, _continue, _i, _next;
                                            _break = __iced_k;
                                            _continue = function() {
                                                return iced.trampoline(function() {
                                                    return _while(__iced_k);
                                                });
                                            };
                                            _next = _continue;
                                            if (!(j = sb.rem())) {
                                                return _break();
                                            } else {
                                                for (_i = 0; _i < 4096; _i++) {
                                                    _this._enc();
                                                    _this._emit_sb(sb);
                                                    if (!(j = sb.rem())) {
                                                        break;
                                                    }
                                                }
                                                (function(__iced_k) {
                                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                        parent: ___iced_passed_deferral,
                                                        filename: "/Users/max/src/keybase/kbpgp/src/openpgp/ocfb.iced",
                                                        funcname: "Encryptor.enc"
                                                    });
                                                    _this.asp.progress({
                                                        what: "ofcb encryption",
                                                        i: total - j,
                                                        total: total
                                                    }, esc(__iced_deferrals.defer({
                                                        lineno: 177
                                                    })));
                                                    __iced_deferrals._fulfill();
                                                })(_next);
                                            }
                                        };
                                        _while(__iced_k);
                                    })(function() {
                                        ret = _this.compact();
                                        n_wanted = plaintext.length + _this.block_size + 2;
                                        ret = ret.slice(0, n_wanted);
                                        return cb(null, ret);
                                    });
                                };
                            })(this));
                        };

                        return Encryptor;

                    })(Base);

                    Decryptor = (function(_super) {
                        __extends(Decryptor, _super);

                        function Decryptor(_arg) {
                            var asp, block_cipher_class, cipher, key, prefixrandom, resync;
                            block_cipher_class = _arg.block_cipher_class, key = _arg.key, cipher = _arg.cipher, prefixrandom = _arg.prefixrandom, resync = _arg.resync, this.ciphertext = _arg.ciphertext, asp = _arg.asp;
                            Decryptor.__super__.constructor.call(this, {
                                block_cipher_class: block_cipher_class,
                                key: key,
                                cipher: cipher,
                                resync: resync,
                                asp: asp
                            });
                            this._init();
                        }

                        Decryptor.prototype._init = function() {
                            return this.reset();
                        };

                        Decryptor.prototype.reset = function() {
                            return this.sb = new SlicerBuffer(this.ciphertext);
                        };

                        Decryptor.prototype.next_block = function() {
                            return WordArray.from_buffer(this.sb.read_buffer_at_most(this.block_size));
                        };

                        Decryptor.prototype.get_prefix = function() {
                            return this._prefix;
                        };

                        Decryptor.prototype.check = function(cb) {
                            var ablock, err, i, iblock, lhs, rhs;
                            this.reset();
                            iblock = new WordArray((function() {
                                var _i, _ref, _results;
                                _results = [];
                                for (i = _i = 0, _ref = this.block_size / 4; 0 <= _ref ? _i < _ref : _i > _ref; i = 0 <= _ref ? ++_i : --_i) {
                                    _results.push(0);
                                }
                                return _results;
                            }).call(this));
                            this.cipher.encryptBlock(iblock.words, 0);
                            ablock = this.next_block();
                            iblock.xor(ablock, {});
                            this._prefix = iblock.to_buffer();
                            this.cipher.encryptBlock(ablock.words, 0);
                            lhs = iblock.words.slice(-1)[0] & 0xffff;
                            rhs = (ablock.words[0] >>> 16) ^ (this.sb.peek_uint16());
                            err = lhs === rhs ? null : new Error("Canary block mismatch: " + lhs + " != " + rhs);
                            return cb(err);
                        };

                        Decryptor.prototype.dec = function(cb) {
                            var ablock, esc, iblock, j, out, total, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            this.reset();
                            if (this.resync) {
                                this.sb.advance(2);
                            }
                            iblock = this.next_block();
                            esc = make_esc(cb, "Decryption::dec");
                            total = this.sb.rem();
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/openpgp/ocfb.iced",
                                        funcname: "Decryptor.dec"
                                    });
                                    _this.asp.progress({
                                        what: "ofcb decrypt",
                                        i: 0,
                                        total: total
                                    }, esc(__iced_deferrals.defer({
                                        lineno: 239
                                    })));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    (function(__iced_k) {
                                        var _while;
                                        _while = function(__iced_k) {
                                            var _break, _continue, _i, _next;
                                            _break = __iced_k;
                                            _continue = function() {
                                                return iced.trampoline(function() {
                                                    return _while(__iced_k);
                                                });
                                            };
                                            _next = _continue;
                                            if (!(j = _this.sb.rem())) {
                                                return _break();
                                            } else {
                                                for (_i = 0; _i < 4096; _i++) {
                                                    ablock = iblock;
                                                    _this.cipher.encryptBlock(ablock.words, 0);
                                                    iblock = _this.next_block();
                                                    ablock.xor(iblock, {});
                                                    _this.out_bufs.push(ablock.to_buffer().slice(0, iblock.sigBytes));
                                                    if (!(j = _this.sb.rem())) {
                                                        break;
                                                    }
                                                }
                                                (function(__iced_k) {
                                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                        parent: ___iced_passed_deferral,
                                                        filename: "/Users/max/src/keybase/kbpgp/src/openpgp/ocfb.iced",
                                                        funcname: "Decryptor.dec"
                                                    });
                                                    _this.asp.progress({
                                                        what: "ofcb decrypt",
                                                        i: total - j,
                                                        total: total
                                                    }, esc(__iced_deferrals.defer({
                                                        lineno: 251
                                                    })));
                                                    __iced_deferrals._fulfill();
                                                })(_next);
                                            }
                                        };
                                        _while(__iced_k);
                                    })(function() {
                                        out = _this.compact();
                                        if (!_this.resync) {
                                            out = out.slice(2);
                                        }
                                        return cb(null, out);
                                    });
                                };
                            })(this));
                        };

                        return Decryptor;

                    })(Base);

                    encrypt = function(_arg, cb) {
                        var asp, block_cipher_class, cipher, eng, key, plaintext, prefixrandom, resync;
                        block_cipher_class = _arg.block_cipher_class, key = _arg.key, cipher = _arg.cipher, prefixrandom = _arg.prefixrandom, resync = _arg.resync, plaintext = _arg.plaintext, asp = _arg.asp;
                        eng = new Encryptor({
                            block_cipher_class: block_cipher_class,
                            key: key,
                            cipher: cipher,
                            prefixrandom: prefixrandom,
                            resync: resync,
                            asp: asp
                        });
                        return eng.enc(plaintext, cb);
                    };

                    decrypt = function(_arg, cb) {
                        var asp, block_cipher_class, cipher, ciphertext, eng, err, key, pt, resync, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        block_cipher_class = _arg.block_cipher_class, key = _arg.key, cipher = _arg.cipher, resync = _arg.resync, ciphertext = _arg.ciphertext, asp = _arg.asp;
                        eng = new Decryptor({
                            block_cipher_class: block_cipher_class,
                            key: key,
                            cipher: cipher,
                            resync: resync,
                            ciphertext: ciphertext,
                            asp: asp
                        });
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/Users/max/src/keybase/kbpgp/src/openpgp/ocfb.iced"
                                });
                                eng.check(__iced_deferrals.defer({
                                    assign_fn: (function() {
                                        return function() {
                                            return err = arguments[0];
                                        };
                                    })(),
                                    lineno: 267
                                }));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                (function(__iced_k) {
                                    if (typeof err === "undefined" || err === null) {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/Users/max/src/keybase/kbpgp/src/openpgp/ocfb.iced"
                                            });
                                            eng.dec(__iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        err = arguments[0];
                                                        return pt = arguments[1];
                                                    };
                                                })(),
                                                lineno: 268
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(__iced_k);
                                    } else {
                                        return __iced_k();
                                    }
                                })(function() {
                                    return cb(err, pt);
                                });
                            };
                        })(this));
                    };

                    exports.encrypt = encrypt;

                    exports.decrypt = decrypt;

                    exports.Decryptor = Decryptor;

                    rng = require('crypto').rng;

                    test = function() {
                        var block_cipher_class, ct, key, plaintext, prefixrandom, pt;
                        plaintext = new Buffer("a man a plan a canal panama. and you know the rest");
                        key = rng(32);
                        prefixrandom = new Buffer([0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15]);
                        block_cipher_class = AES;
                        ct = encrypt({
                            block_cipher_class: block_cipher_class,
                            key: key,
                            prefixrandom: prefixrandom,
                            plaintext: plaintext
                        });
                        console.log(ct.toString('hex'));
                        pt = decrypt({
                            block_cipher_class: block_cipher_class,
                            key: key,
                            prefixrandom: prefixrandom,
                            ciphertext: ct
                        });
                        return console.log(pt.toString('utf8'));
                    };

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "./buffer": 37,
            "buffer": 126,
            "crypto": 136,
            "iced-error": 179,
            "iced-runtime": 183,
            "pgp-utils": 229,
            "triplesec": 282
        }],
        46: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                exports.KeyMaterial = require('./keymaterial').KeyMaterial;

                exports.Signature = require('./signature').Signature;

                exports.UserID = require('./userid').UserID;

            }).call(this);

        }, {
            "./keymaterial": 50,
            "./signature": 55,
            "./userid": 57
        }],
        47: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var C, Packet, packetsigs, util;

                    util = require('../util');

                    C = require('../../const').openpgp;

                    packetsigs = require('./packetsigs');

                    Packet = (function() {
                        function Packet() {
                            this._psc = new packetsigs.Collection();
                        }

                        Packet.prototype.frame_packet = function(tag, body) {
                            var bufs;
                            bufs = [new Buffer([0xc0 | tag]), util.encode_length(body.length), body];
                            return Buffer.concat(bufs);
                        };

                        Packet.prototype.set = function(d) {
                            var k, v, _results;
                            _results = [];
                            for (k in d) {
                                v = d[k];
                                _results.push(this[k] = v);
                            }
                            return _results;
                        };

                        Packet.prototype.is_signature = function() {
                            return false;
                        };

                        Packet.prototype.is_key_material = function() {
                            return false;
                        };

                        Packet.prototype.is_duplicate_primary = function() {
                            return false;
                        };

                        Packet.prototype.to_userid = function() {
                            return null;
                        };

                        Packet.prototype.to_user_attribute = function() {
                            return null;
                        };

                        Packet.prototype.to_literal = function() {
                            return null;
                        };

                        Packet.prototype.to_esk_packet = function() {
                            return null;
                        };

                        Packet.prototype.to_enc_data_packet = function() {
                            return null;
                        };

                        Packet.prototype.replay = function() {
                            return this.frame_packet(this.tag, this.raw);
                        };

                        Packet.prototype.inflate = function(cb) {
                            return cb(null, null);
                        };

                        Packet.prototype.push_sig = function(packetsig) {
                            return this._psc.push(packetsig);
                        };

                        Packet.prototype.get_psc = function() {
                            return this._psc;
                        };

                        Packet.prototype.clear_psc = function() {
                            return this._psc.clear();
                        };

                        Packet.prototype.get_data_signer = function() {
                            return this.get_psc().get_data_signer();
                        };

                        Packet.prototype.get_data_signers = function() {
                            return this.get_psc().get_data_signers();
                        };

                        Packet.prototype.get_signed_userids = function() {
                            return [];
                        };

                        Packet.prototype.get_subkey_binding = function() {
                            return null;
                        };

                        Packet.prototype.is_self_signed = function() {
                            return false;
                        };

                        return Packet;

                    })();

                    exports.Packet = Packet;

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../../const": 5,
            "../util": 62,
            "./packetsigs": 53,
            "buffer": 126
        }],
        48: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var C, Compressed, CompressionParser, Packet, asymmetric, bzipDeflate, bzip_inflate, fake_zip_inflate, fix_zip_deflate, iced, uint_to_buffer, zlib, __iced_k, __iced_k_noop,
                        __hasProp = {}.hasOwnProperty,
                        __extends = function(child, parent) {
                            for (var key in parent) {
                                if (__hasProp.call(parent, key)) child[key] = parent[key];
                            }

                            function ctor() {
                                this.constructor = child;
                            }
                            ctor.prototype = parent.prototype;
                            child.prototype = new ctor();
                            child.__super__ = parent.prototype;
                            return child;
                        };

                    iced = require('iced-runtime');
                    __iced_k = __iced_k_noop = function() {};

                    Packet = require('./base').Packet;

                    C = require('../../const').openpgp;

                    asymmetric = require('../../asymmetric');

                    zlib = require('zlib');

                    uint_to_buffer = require('../../util').uint_to_buffer;

                    bzipDeflate = require('bzip-deflate');

                    fake_zip_inflate = function(buf, cb) {
                        var bufs, call_end, err, inflater, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        buf = Buffer.concat([new Buffer([0x78, 0x9c]), buf]);
                        inflater = zlib.createInflate({
                            flush: zlib.Z_FULL_FLUSH
                        });
                        bufs = [];
                        call_end = function(err) {
                            var ret, tmp;
                            if ((tmp = cb) != null) {
                                if ((err != null) && err.code === "Z_BUF_ERROR") {
                                    err = null;
                                }
                                cb = null;
                                if (err != null) {
                                    ret = null;
                                } else {
                                    ret = Buffer.concat(bufs);
                                }
                                return tmp(err, ret);
                            }
                        };
                        inflater.on('readable', function() {
                            var read_buf;
                            read_buf = inflater.read();
                            if (read_buf != null) {
                                return bufs.push(read_buf);
                            }
                        });
                        inflater.on('end', function() {
                            return call_end(null);
                        });
                        inflater.on('error', function(e) {
                            return call_end(e);
                        });
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/compressed.iced"
                                });
                                inflater.write(buf, __iced_deferrals.defer({
                                    assign_fn: (function() {
                                        return function() {
                                            return err = arguments[0];
                                        };
                                    })(),
                                    lineno: 53
                                }));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                (function(__iced_k) {
                                    if (typeof err === "undefined" || err === null) {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/compressed.iced"
                                            });
                                            inflater.end(err);
                                            __iced_deferrals._fulfill();
                                        })(__iced_k);
                                    } else {
                                        return __iced_k();
                                    }
                                })(function() {
                                    if (typeof err !== "undefined" && err !== null) {
                                        return call_end(err);
                                    }
                                });
                            };
                        })(this));
                    };

                    fix_zip_deflate = function(buf, cb) {
                        var err, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/compressed.iced"
                                });
                                zlib.deflate(buf, __iced_deferrals.defer({
                                    assign_fn: (function() {
                                        return function() {
                                            err = arguments[0];
                                            return ret = arguments[1];
                                        };
                                    })(),
                                    lineno: 62
                                }));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                return cb(err, ret);
                            };
                        })(this));
                    };

                    bzip_inflate = function(buf, cb) {
                        var e, err, ret;
                        err = null;
                        try {
                            ret = bzipDeflate(buf);
                        } catch (_error) {
                            e = _error;
                            err = e;
                        }
                        return cb(err, ret);
                    };

                    Compressed = (function(_super) {
                        __extends(Compressed, _super);

                        function Compressed(_arg) {
                            this.algo = _arg.algo, this.compressed = _arg.compressed, this.inflated = _arg.inflated;
                        }

                        Compressed.parse = function(slice) {
                            return (new CompressionParser(slice)).parse();
                        };

                        Compressed.prototype.inflate = function(cb) {
                            var err, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            err = ret = null;
                            (function(_this) {
                                return (function(__iced_k) {
                                    switch (_this.algo) {
                                        case C.compression.none:
                                            return __iced_k(ret = _this.compressed);
                                        case C.compression.zlib:
                                            (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral,
                                                    filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/compressed.iced",
                                                    funcname: "Compressed.inflate"
                                                });
                                                zlib.inflate(_this.compressed, __iced_deferrals.defer({
                                                    assign_fn: (function() {
                                                        return function() {
                                                            err = arguments[0];
                                                            return ret = arguments[1];
                                                        };
                                                    })(),
                                                    lineno: 95
                                                }));
                                                __iced_deferrals._fulfill();
                                            })(__iced_k);
                                            break;
                                        case C.compression.zip:
                                            (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral,
                                                    filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/compressed.iced",
                                                    funcname: "Compressed.inflate"
                                                });
                                                fake_zip_inflate(_this.compressed, __iced_deferrals.defer({
                                                    assign_fn: (function() {
                                                        return function() {
                                                            err = arguments[0];
                                                            return ret = arguments[1];
                                                        };
                                                    })(),
                                                    lineno: 97
                                                }));
                                                __iced_deferrals._fulfill();
                                            })(__iced_k);
                                            break;
                                        case C.compression.bzip:
                                            (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral,
                                                    filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/compressed.iced",
                                                    funcname: "Compressed.inflate"
                                                });
                                                bzip_inflate(_this.compressed, __iced_deferrals.defer({
                                                    assign_fn: (function() {
                                                        return function() {
                                                            err = arguments[0];
                                                            return ret = arguments[1];
                                                        };
                                                    })(),
                                                    lineno: 99
                                                }));
                                                __iced_deferrals._fulfill();
                                            })(__iced_k);
                                            break;
                                        default:
                                            return __iced_k(err = new Error("no known inflation -- algo: " + _this.algo));
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err, ret);
                                };
                            })(this));
                        };

                        Compressed.prototype.deflate = function(cb) {
                            var err, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            err = ret = null;
                            (function(_this) {
                                return (function(__iced_k) {
                                    switch (_this.algo) {
                                        case C.compression.none:
                                            return __iced_k(ret = _this.inflated);
                                        case C.compression.zlib:
                                            (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral,
                                                    filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/compressed.iced",
                                                    funcname: "Compressed.deflate"
                                                });
                                                zlib.deflate(_this.inflated, __iced_deferrals.defer({
                                                    assign_fn: (function() {
                                                        return function() {
                                                            err = arguments[0];
                                                            return ret = arguments[1];
                                                        };
                                                    })(),
                                                    lineno: 111
                                                }));
                                                __iced_deferrals._fulfill();
                                            })(__iced_k);
                                            break;
                                        case C.compression.zip:
                                            (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral,
                                                    filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/compressed.iced",
                                                    funcname: "Compressed.deflate"
                                                });
                                                fake_zip_deflate(_this.inflated, __iced_deferrals.defer({
                                                    assign_fn: (function() {
                                                        return function() {
                                                            err = arguments[0];
                                                            return ret = arguments[1];
                                                        };
                                                    })(),
                                                    lineno: 113
                                                }));
                                                __iced_deferrals._fulfill();
                                            })(__iced_k);
                                            break;
                                        default:
                                            return __iced_k(err = new Error("no known deflation -- algo: " + _this.algo));
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err, ret);
                                };
                            })(this));
                        };

                        Compressed.prototype.write_unframed = function(cb) {
                            var bufs, err, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            err = ret = null;
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/compressed.iced",
                                        funcname: "Compressed.write_unframed"
                                    });
                                    _this.deflate(__iced_deferrals.defer({
                                        assign_fn: (function(__slot_1) {
                                            return function() {
                                                err = arguments[0];
                                                return __slot_1.compressed = arguments[1];
                                            };
                                        })(_this),
                                        lineno: 122
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    if (err == null) {
                                        bufs = [uint_to_buffer(8, _this.algo), _this.compressed];
                                        ret = Buffer.concat(bufs);
                                    }
                                    return cb(err, ret);
                                };
                            })(this));
                        };

                        Compressed.prototype.write = function(cb) {
                            var err, ret, unframed, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            err = ret = null;
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/compressed.iced",
                                        funcname: "Compressed.write"
                                    });
                                    _this.write_unframed(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                err = arguments[0];
                                                return unframed = arguments[1];
                                            };
                                        })(),
                                        lineno: 132
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    if (err == null) {
                                        ret = _this.frame_packet(C.packet_tags.compressed, unframed);
                                    }
                                    return cb(err, ret);
                                };
                            })(this));
                        };

                        return Compressed;

                    })(Packet);

                    CompressionParser = (function() {
                        function CompressionParser(slice) {
                            this.slice = slice;
                        }

                        CompressionParser.prototype.parse = function() {
                            var algo, compressed;
                            algo = this.slice.read_uint8();
                            compressed = this.slice.consume_rest_to_buffer();
                            return new Compressed({
                                algo: algo,
                                compressed: compressed
                            });
                        };

                        return CompressionParser;

                    })();

                    exports.Compressed = Compressed;

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../../asymmetric": 1,
            "../../const": 5,
            "../../util": 72,
            "./base": 47,
            "buffer": 126,
            "bzip-deflate": 127,
            "iced-runtime": 183,
            "zlib": 124
        }],
        49: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var Generic, Packet,
                    __hasProp = {}.hasOwnProperty,
                    __extends = function(child, parent) {
                        for (var key in parent) {
                            if (__hasProp.call(parent, key)) child[key] = parent[key];
                        }

                        function ctor() {
                            this.constructor = child;
                        }
                        ctor.prototype = parent.prototype;
                        child.prototype = new ctor();
                        child.__super__ = parent.prototype;
                        return child;
                    };

                Packet = require('./base').Packet;

                Generic = (function(_super) {
                    __extends(Generic, _super);

                    function Generic(type, body) {
                        this.type = type;
                        this.body = body;
                    }

                    return Generic;

                })(Packet);

                exports.Generic = Generic;

            }).call(this);

        }, {
            "./base": 47
        }],
        50: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var AES, C, DSA, ECDH, ECDSA, EDDSA, ElGamal, ElGamalSE, KeyMaterial, Packet, Parser, RSA, S, S2K, SHA1, SHA256, SecretKeyMaterial, Signature, bufeq_secure, bufferify, calc_checksum, decrypt, encode, encrypt, iced, katch, make_time_packet, native_rng, packetsigs, symmetric, triplesec, uint_to_buffer, unix_time, util, __iced_k, __iced_k_noop, _ref, _ref1, _ref2, _ref3,
                        __hasProp = {}.hasOwnProperty,
                        __extends = function(child, parent) {
                            for (var key in parent) {
                                if (__hasProp.call(parent, key)) child[key] = parent[key];
                            }

                            function ctor() {
                                this.constructor = child;
                            }
                            ctor.prototype = parent.prototype;
                            child.prototype = new ctor();
                            child.__super__ = parent.prototype;
                            return child;
                        };

                    iced = require('iced-runtime');
                    __iced_k = __iced_k_noop = function() {};

                    C = require('../../const').openpgp;

                    triplesec = require('triplesec');

                    _ref = triplesec.hash, SHA1 = _ref.SHA1, SHA256 = _ref.SHA256;

                    RSA = require('../../rsa').Pair;

                    DSA = require('../../dsa').Pair;

                    ElGamal = require('../../elgamal').Pair;

                    ElGamalSE = require('../../elgamalse').Pair;

                    ECDSA = require('../../ecc/ecdsa').Pair;

                    ECDH = require('../../ecc/ecdh').Pair;

                    EDDSA = require('../../ecc/eddsa').Pair;

                    AES = triplesec.ciphers.AES;

                    native_rng = triplesec.prng.native_rng;

                    calc_checksum = require('../util').calc_checksum;

                    _ref1 = require('../../util'), bufferify = _ref1.bufferify, unix_time = _ref1.unix_time, bufeq_secure = _ref1.bufeq_secure, katch = _ref1.katch, make_time_packet = _ref1.make_time_packet, uint_to_buffer = _ref1.uint_to_buffer;

                    _ref2 = require('../cfb'), decrypt = _ref2.decrypt, encrypt = _ref2.encrypt;

                    Packet = require('./base').Packet;

                    S = require('./signature');

                    Signature = S.Signature;

                    encode = require('../armor').encode;

                    _ref3 = require('../s2k'), S2K = _ref3.S2K, SecretKeyMaterial = _ref3.SecretKeyMaterial;

                    symmetric = require('../../symmetric');

                    util = require('util');

                    packetsigs = require('./packetsigs');

                    KeyMaterial = (function(_super) {
                        __extends(KeyMaterial, _super);

                        function KeyMaterial(_arg) {
                            this.key = _arg.key, this.timestamp = _arg.timestamp, this.passphrase = _arg.passphrase, this.skm = _arg.skm, this.opts = _arg.opts, this.flags = _arg.flags;
                            this.opts || (this.opts = {});
                            this.flags || (this.flags = 0);
                            this._is_duplicate_primary = false;
                            KeyMaterial.__super__.constructor.call(this);
                        }

                        KeyMaterial.prototype._write_private_enc = function(bufs, priv, pp) {
                            var c, ct, iv, ivlen, k, ks, plaintext, salt, sha1hash;
                            bufs.push(new Buffer([C.s2k_convention.sha1, C.symmetric_key_algorithms.AES256, C.s2k.salt_iter, C.hash_algorithms.SHA256]));
                            sha1hash = (new SHA1).bufhash(priv);
                            salt = native_rng(8);
                            bufs.push(salt);
                            c = 96;
                            bufs.push(new Buffer([c]));
                            ks = AES.keySize;
                            k = (new S2K).write(pp, salt, c, ks);
                            ivlen = AES.blockSize;
                            iv = native_rng(ivlen);
                            bufs.push(iv);
                            plaintext = Buffer.concat([priv, sha1hash]);
                            ct = encrypt({
                                block_cipher_class: AES,
                                key: k,
                                plaintext: plaintext,
                                iv: iv
                            });
                            return bufs.push(ct);
                        };

                        KeyMaterial.prototype._write_private_clear = function(bufs, priv) {
                            return bufs.push(new Buffer([C.s2k_convention.none]), priv, uint_to_buffer(16, calc_checksum(priv)));
                        };

                        KeyMaterial.prototype._write_public = function(bufs) {
                            var pub;
                            pub = this.key.serialize();
                            return bufs.push(new Buffer([C.versions.keymaterial.V4]), uint_to_buffer(32, this.timestamp), new Buffer([this.key.type]), pub);
                        };

                        KeyMaterial.prototype._write_dummy = function(bufs) {
                            return bufs.push(new Buffer([C.s2k_convention.sha1, C.symmetric_key_algorithms.AES256, C.s2k.gnu, 0x2]), new Buffer("GNU", "utf8"), new Buffer([0x1]));
                        };

                        KeyMaterial.prototype.add_flags = function(v) {
                            return this.flags |= v;
                        };

                        KeyMaterial.prototype.private_body = function(opts) {
                            var bufs, p, pp, priv, ret;
                            bufs = [];
                            this._write_public(bufs);
                            priv = (p = this.key.priv) != null ? p.serialize() : null;
                            pp = opts.passphrase || this.passphrase;
                            if (priv == null) {
                                this._write_dummy(bufs);
                            } else if (pp != null) {
                                this._write_private_enc(bufs, priv, pp);
                            } else {
                                this._write_private_clear(bufs, priv);
                            }
                            ret = Buffer.concat(bufs);
                            return ret;
                        };

                        KeyMaterial.prototype.private_framed = function(opts) {
                            var T, body, tag;
                            body = this.private_body(opts);
                            T = C.packet_tags;
                            tag = opts.subkey ? T.secret_subkey : T.secret_key;
                            return this.frame_packet(tag, body);
                        };

                        KeyMaterial.prototype.public_body = function() {
                            var bufs;
                            bufs = [];
                            this._write_public(bufs);
                            return Buffer.concat(bufs);
                        };

                        KeyMaterial.prototype.get_fingerprint = function() {
                            var data;
                            data = this.public_body();
                            return (new SHA1).bufhash(Buffer.concat([new Buffer([C.signatures.key]), uint_to_buffer(16, data.length), data]));
                        };

                        KeyMaterial.prototype.get_key_id = function() {
                            return this.get_fingerprint().slice(12, 20);
                        };

                        KeyMaterial.prototype.get_short_key_id = function() {
                            return this.get_key_id().slice(-4).toString('hex').toUpperCase();
                        };

                        KeyMaterial.prototype.get_klass = function() {
                            return this.key.constructor;
                        };

                        KeyMaterial.prototype.export_framed = function(opts) {
                            if (opts == null) {
                                opts = {};
                            }
                            if (opts["private"]) {
                                return this.private_framed(opts);
                            } else {
                                return this.public_framed(opts);
                            }
                        };

                        KeyMaterial.prototype.public_framed = function(opts) {
                            var T, body, tag;
                            if (opts == null) {
                                opts = {};
                            }
                            body = this.public_body();
                            T = C.packet_tags;
                            tag = opts.subkey ? T.public_subkey : T.public_key;
                            return this.frame_packet(tag, body);
                        };

                        KeyMaterial.prototype.to_signature_payload = function() {
                            var pk;
                            pk = this.public_body();
                            return Buffer.concat([new Buffer([C.signatures.key]), uint_to_buffer(16, pk.length), pk]);
                        };

                        KeyMaterial.prototype.self_sign_key = function(_arg, cb) {
                            var err, lifespan, primary, raw_payload, sig, sigs, userid, userids, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            userids = _arg.userids, lifespan = _arg.lifespan, raw_payload = _arg.raw_payload;
                            err = null;
                            sigs = [];
                            primary = true;
                            (function(_this) {
                                return (function(__iced_k) {
                                    var _i, _len, _ref4, _results, _while;
                                    _ref4 = userids;
                                    _len = _ref4.length;
                                    _i = 0;
                                    _while = function(__iced_k) {
                                        var _break, _continue, _next;
                                        _break = __iced_k;
                                        _continue = function() {
                                            return iced.trampoline(function() {
                                                ++_i;
                                                return _while(__iced_k);
                                            });
                                        };
                                        _next = _continue;
                                        if (!(_i < _len)) {
                                            return _break();
                                        } else {
                                            userid = _ref4[_i];
                                            if (err == null) {
                                                sig = null;
                                                (function(__iced_k) {
                                                    if (_this.key.can_sign() || raw_payload) {
                                                        (function(__iced_k) {
                                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                                parent: ___iced_passed_deferral,
                                                                filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/keymaterial.iced",
                                                                funcname: "KeyMaterial.self_sign_key"
                                                            });
                                                            _this._self_sign_key({
                                                                userid: userid,
                                                                lifespan: lifespan,
                                                                raw_payload: raw_payload,
                                                                primary: primary
                                                            }, __iced_deferrals.defer({
                                                                assign_fn: (function() {
                                                                    return function() {
                                                                        err = arguments[0];
                                                                        return sig = arguments[1];
                                                                    };
                                                                })(),
                                                                lineno: 194
                                                            }));
                                                            __iced_deferrals._fulfill();
                                                        })(__iced_k);
                                                    } else {
                                                        return __iced_k((sig = userid.get_framed_signature_output()) == null ? err = new Error("Cannot sign key --- don't have a private key, and can't replay") : void 0);
                                                    }
                                                })(function() {
                                                    primary = false;
                                                    return _next(sigs.push(sig));
                                                });
                                            } else {
                                                return _continue();
                                            }
                                        }
                                    };
                                    _while(__iced_k);
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err, sig);
                                };
                            })(this));
                        };

                        KeyMaterial.prototype._self_sign_key = function(_arg, cb) {
                            var err, hsp, lifespan, payload, primary, ps, raw_payload, sig, type, userid, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            userid = _arg.userid, lifespan = _arg.lifespan, raw_payload = _arg.raw_payload, primary = _arg.primary;
                            payload = Buffer.concat([this.to_signature_payload(), userid.to_signature_payload()]);
                            type = C.sig_types.positive;
                            hsp = [new S.CreationTime(lifespan.generated), new S.KeyFlags([this.flags]), new S.PreferredSymmetricAlgorithms([C.symmetric_key_algorithms.AES256, C.symmetric_key_algorithms.AES128]), new S.PreferredHashAlgorithms([C.hash_algorithms.SHA512, C.hash_algorithms.SHA256]), new S.Features([C.features.modification_detection]), new S.KeyServerPreferences([C.key_server_preferences.no_modify]), new S.PreferredCompressionAlgorithms([C.compression.zlib, C.compression.zip])];
                            if (primary) {
                                hsp.push(new S.PrimaryUserId(1));
                            }
                            if (lifespan.expire_in) {
                                hsp.push(new S.KeyExpirationTime(lifespan.expire_in));
                            }
                            sig = new Signature({
                                type: type,
                                key: this.key,
                                hashed_subpackets: hsp,
                                unhashed_subpackets: [new S.Issuer(this.get_key_id())]
                            });
                            (function(_this) {
                                return (function(__iced_k) {
                                    if (raw_payload) {
                                        return __iced_k(sig = payload);
                                    } else {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/keymaterial.iced",
                                                funcname: "KeyMaterial._self_sign_key"
                                            });
                                            sig.write(payload, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        return err = arguments[0];
                                                    };
                                                })(),
                                                lineno: 237
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(function() {
                                            ps = new packetsigs.SelfSig({
                                                userid: userid,
                                                type: type,
                                                sig: sig,
                                                options: _this.flags
                                            });
                                            userid.push_sig(ps);
                                            return __iced_k(_this.push_sig(ps));
                                        });
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err, sig);
                                };
                            })(this));
                        };

                        KeyMaterial.prototype.sign_subkey = function(_arg, cb) {
                            var err, lifespan, sig, subkey, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            subkey = _arg.subkey, lifespan = _arg.lifespan;
                            err = sig = null;
                            (function(_this) {
                                return (function(__iced_k) {
                                    var _ref4, _ref5;
                                    if (_this.key.can_sign()) {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/keymaterial.iced",
                                                funcname: "KeyMaterial.sign_subkey"
                                            });
                                            _this._sign_subkey({
                                                subkey: subkey,
                                                lifespan: lifespan
                                            }, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        return err = arguments[0];
                                                    };
                                                })(),
                                                lineno: 250
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(__iced_k);
                                    } else {
                                        return __iced_k(!((_ref4 = subkey.get_subkey_binding()) != null ? (_ref5 = _ref4.sig) != null ? _ref5.get_framed_output() : void 0 : void 0) ? err = new Error("Cannot sign with subkey --- don't have private key and can't replay") : void 0);
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err);
                                };
                            })(this));
                        };

                        KeyMaterial.prototype._sign_subkey = function(_arg, cb) {
                            var SKB, err, lifespan, primary_binding, ps, sig, subkey, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            subkey = _arg.subkey, lifespan = _arg.lifespan;
                            sig = err = primary_binding = null;
                            (function(_this) {
                                return (function(__iced_k) {
                                    if (subkey.can_sign()) {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/keymaterial.iced",
                                                funcname: "KeyMaterial._sign_subkey"
                                            });
                                            subkey._sign_primary_with_subkey({
                                                primary: _this,
                                                lifespan: lifespan
                                            }, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        err = arguments[0];
                                                        return primary_binding = arguments[1];
                                                    };
                                                })(),
                                                lineno: 262
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(__iced_k);
                                    } else {
                                        return __iced_k();
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    (function(__iced_k) {
                                        if (err == null) {
                                            (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral,
                                                    filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/keymaterial.iced",
                                                    funcname: "KeyMaterial._sign_subkey"
                                                });
                                                _this._sign_subkey_with_primary({
                                                    subkey: subkey,
                                                    lifespan: lifespan,
                                                    primary_binding: primary_binding
                                                }, __iced_deferrals.defer({
                                                    assign_fn: (function() {
                                                        return function() {
                                                            err = arguments[0];
                                                            return sig = arguments[1];
                                                        };
                                                    })(),
                                                    lineno: 264
                                                }));
                                                __iced_deferrals._fulfill();
                                            })(__iced_k);
                                        } else {
                                            return __iced_k();
                                        }
                                    })(function() {
                                        if (err == null) {
                                            SKB = packetsigs.SubkeyBinding;
                                            ps = new SKB({
                                                primary: _this,
                                                sig: sig,
                                                direction: SKB.DOWN
                                            });
                                            subkey.push_sig(ps);
                                        }
                                        return cb(err);
                                    });
                                };
                            })(this));
                        };

                        KeyMaterial.prototype._sign_primary_with_subkey = function(_arg, cb) {
                            var err, lifespan, payload, primary, sig, sig_unframed, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            primary = _arg.primary, lifespan = _arg.lifespan;
                            payload = Buffer.concat([primary.to_signature_payload(), this.to_signature_payload()]);
                            sig = new Signature({
                                type: C.sig_types.primary_binding,
                                key: this.key,
                                hashed_subpackets: [new S.CreationTime(lifespan.generated)],
                                unhashed_subpackets: [new S.Issuer(this.get_key_id())]
                            });
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/keymaterial.iced",
                                        funcname: "KeyMaterial._sign_primary_with_subkey"
                                    });
                                    sig.write_unframed(payload, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                err = arguments[0];
                                                return sig_unframed = arguments[1];
                                            };
                                        })(),
                                        lineno: 288
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err, sig_unframed);
                                };
                            })(this));
                        };

                        KeyMaterial.prototype._sign_subkey_with_primary = function(_arg, cb) {
                            var err, lifespan, payload, primary_binding, sig, subkey, unhashed_subpackets, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            subkey = _arg.subkey, lifespan = _arg.lifespan, primary_binding = _arg.primary_binding;
                            payload = Buffer.concat([this.to_signature_payload(), subkey.to_signature_payload()]);
                            unhashed_subpackets = [new S.Issuer(this.get_key_id())];
                            if (primary_binding != null) {
                                unhashed_subpackets.push(new S.EmbeddedSignature({
                                    rawsig: primary_binding
                                }));
                            }
                            sig = new Signature({
                                type: C.sig_types.subkey_binding,
                                key: this.key,
                                hashed_subpackets: [new S.CreationTime(lifespan.generated), new S.KeyExpirationTime(lifespan.expire_in), new S.KeyFlags([subkey.flags])],
                                unhashed_subpackets: unhashed_subpackets
                            });
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/keymaterial.iced",
                                        funcname: "KeyMaterial._sign_subkey_with_primary"
                                    });
                                    sig.write(payload, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return err = arguments[0];
                                            };
                                        })(),
                                        lineno: 312
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err, sig);
                                };
                            })(this));
                        };

                        KeyMaterial.prototype.merge_private = function(k2) {
                            return this.skm = k2.skm;
                        };

                        KeyMaterial.parse_public_key = function(slice, opts) {
                            return (new Parser(slice)).parse_public_key(opts);
                        };

                        KeyMaterial.parse_private_key = function(slice, opts) {
                            return (new Parser(slice)).parse_private_key(opts);
                        };

                        KeyMaterial.prototype.is_key_material = function() {
                            return true;
                        };

                        KeyMaterial.prototype.is_primary = function() {
                            var _ref4;
                            return !((_ref4 = this.opts) != null ? _ref4.subkey : void 0);
                        };

                        KeyMaterial.prototype.is_duplicate_primary = function() {
                            return this._is_duplicate_primary;
                        };

                        KeyMaterial.prototype.set_duplicate_primary = function() {
                            return this._is_duplicate_primary = true;
                        };

                        KeyMaterial.prototype.ekid = function() {
                            return this.key.ekid();
                        };

                        KeyMaterial.prototype.can_sign = function() {
                            return this.key.can_sign();
                        };

                        KeyMaterial.prototype.is_locked = function() {
                            return (!this.key.has_private()) && (this.skm != null) && this.skm.is_locked();
                        };

                        KeyMaterial.prototype.has_private = function() {
                            return this.has_unlocked_private() || this.has_locked_private();
                        };

                        KeyMaterial.prototype.has_locked_private = function() {
                            return this.skm && this.skm.has_private();
                        };

                        KeyMaterial.prototype.has_unlocked_private = function() {
                            return this.key.has_private();
                        };

                        KeyMaterial.prototype.has_secret_key_material = function() {
                            return this.skm != null;
                        };

                        KeyMaterial.prototype.validity_check = function(cb) {
                            var err, msg, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/keymaterial.iced",
                                        funcname: "KeyMaterial.validity_check"
                                    });
                                    _this.key.validity_check(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return err = arguments[0];
                                            };
                                        })(),
                                        lineno: 346
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    if (typeof err !== "undefined" && err !== null) {
                                        msg = "In key " + (_this.get_fingerprint().toString('hex')) + ": " + err.message;
                                        err = new Error(err);
                                    }
                                    return cb(err);
                                };
                            })(this));
                        };

                        KeyMaterial.prototype.is_signed_subkey_of = function(primary, opts) {
                            var need_upwards_sig;
                            if (this.primary_flag) {
                                return false;
                            }
                            need_upwards_sig = (opts != null ? opts.strict : void 0) && this.fulfills_flags(C.key_flags.sign_data);
                            return this.get_psc().is_signed_subkey_of(primary, need_upwards_sig);
                        };

                        KeyMaterial.prototype.get_subkey_binding = function() {
                            if (this.opts.subkey) {
                                return this.get_psc().get_subkey_binding();
                            } else {
                                return null;
                            }
                        };

                        KeyMaterial.prototype.get_subkey_binding_signature_output = function() {
                            var _ref4, _ref5;
                            return (_ref4 = this.get_subkey_binding()) != null ? (_ref5 = _ref4.sig) != null ? _ref5.get_framed_output() : void 0 : void 0;
                        };

                        KeyMaterial.prototype.equal = function(k2) {
                            return bufeq_secure(this.ekid(), k2.ekid());
                        };

                        KeyMaterial.prototype.unlock = function(_arg, cb) {
                            var c1, c2, end, err, h1, h2, key, passphrase, pt;
                            passphrase = _arg.passphrase;
                            if (passphrase != null) {
                                passphrase = bufferify(passphrase);
                            }
                            err = null;
                            if (this.skm == null) {
                                err = new Error("Cannot unlock secret key -- no material!");
                                return cb(err);
                            }
                            pt = this.skm.s2k_convention === C.s2k_convention.none ? this.skm.payload : this.skm.s2k.type === C.s2k.gnu_dummy ? null : passphrase == null ? (err = new Error("Key was locked, but no passphrase given"), null) : (key = this.skm.s2k.produce_key(passphrase, this.skm.cipher.key_size), decrypt({
                                ciphertext: this.skm.payload,
                                block_cipher_class: this.skm.cipher.klass,
                                iv: this.skm.iv,
                                key: key
                            }));
                            if (pt) {
                                switch (this.skm.s2k_convention) {
                                    case C.s2k_convention.sha1:
                                        end = pt.length - SHA1.output_size;
                                        h1 = pt.slice(end);
                                        pt = pt.slice(0, end);
                                        h2 = (new SHA1).bufhash(pt);
                                        if (!bufeq_secure(h1, h2)) {
                                            err = new Error("bad private key passphrase (hash mismatch)");
                                        }
                                        break;
                                    case C.s2k_convention.checksum:
                                    case C.s2k_convention.none:
                                        end = pt.length - 2;
                                        c1 = pt.readUInt16BE(end);
                                        pt = pt.slice(0, end);
                                        c2 = calc_checksum(pt);
                                        if (c1 !== c2) {
                                            err = new Error("bad private key passphrase (checksum mismatch)");
                                        }
                                }
                                if (err == null) {
                                    err = this.key.read_priv(pt);
                                }
                            }
                            return cb(err);
                        };

                        KeyMaterial.prototype.get_all_key_flags = function() {
                            return this._psc.get_all_key_flags();
                        };

                        KeyMaterial.prototype.add_flags = function(v) {
                            return this.flags |= v;
                        };

                        KeyMaterial.prototype.fulfills_flags = function(flags) {
                            var akf, ret;
                            if (this.is_revoked()) {
                                return false;
                            }
                            akf = this.get_all_key_flags();
                            ret = ((akf & flags) === flags) || this.key.fulfills_flags(flags) || (this.is_primary() && (akf === 0) && ((this.key.good_for_flags() & flags) === flags));
                            return ret;
                        };

                        KeyMaterial.prototype.get_signed_userids = function() {
                            return this.get_psc().get_signed_userids();
                        };

                        KeyMaterial.prototype.get_signed_user_attributes = function() {
                            return this.get_psc().get_signed_user_attributes();
                        };

                        KeyMaterial.prototype.is_self_signed = function() {
                            return this.get_psc().is_self_signed();
                        };

                        KeyMaterial.prototype.push_sig = function(packetsig) {
                            this.add_flags(packetsig.sig.get_key_flags());
                            return KeyMaterial.__super__.push_sig.call(this, packetsig);
                        };

                        KeyMaterial.prototype.mark_revoked = function(sig) {
                            return this.revocation = sig;
                        };

                        KeyMaterial.prototype.is_revoked = function() {
                            return this.revocation != null;
                        };

                        KeyMaterial.prototype.check_not_expired = function(_arg) {
                            var e, err, now, _ref4;
                            now = _arg.now;
                            err = null;
                            if ((e = (_ref4 = this.get_expire_time()) != null ? _ref4.expire_at : void 0) && e < now) {
                                err = new Error("PGP key " + (this.get_fingerprint().toString('hex')) + " expired at " + e + " but we checked for time " + now);
                            }
                            return err;
                        };

                        KeyMaterial.prototype.is_preferable_to = function(k2) {
                            var e1, e2, ret;
                            e1 = this.get_expire_time();
                            e2 = k2.get_expire_time();
                            if (e1.expire_at == null) {
                                e1.expire_at = Infinity;
                            }
                            if (e2.expire_at == null) {
                                e2.expire_at = Infinity;
                            }
                            ret = e1.expire_at > e2.expire_at ? true : e1.expire_at < e2.expire_at ? false : e1.generated >= e2.generated ? true : false;
                            return ret;
                        };

                        KeyMaterial.prototype.get_expire_time = function() {
                            var psc;
                            if ((psc = this.get_psc()) == null) {
                                return null;
                            } else if (this.is_primary()) {
                                return this._get_expire_time_on_primary();
                            } else {
                                return this._get_expire_time_on_subkey();
                            }
                        };

                        KeyMaterial.prototype._get_expire_time_on_primary = function() {
                            var expire_in, key_generated, list, packetsig, ret, sig, sig_generated, table, uid, uid_expire_in, uid_winner, winner, _i, _len;
                            table = this.get_psc().lookup.self_sigs_by_uid;
                            winner = null;
                            key_generated = this.timestamp;
                            for (uid in table) {
                                list = table[uid];
                                uid_winner = null;
                                for (_i = 0, _len = list.length; _i < _len; _i++) {
                                    packetsig = list[_i];
                                    if (!((sig = packetsig.sig) != null)) {
                                        continue;
                                    }
                                    expire_in = sig.get_key_expires();
                                    sig_generated = sig.when_generated();
                                    if ((uid_winner == null) || uid_winner.sig_generated < sig_generated) {
                                        uid_winner = {
                                            expire_in: expire_in,
                                            sig_generated: sig_generated
                                        };
                                    }
                                }
                                if (uid_winner != null) {
                                    uid_expire_in = uid_winner.expire_in || 0;
                                    if ((winner == null) || (uid_expire_in === 0) || ((0 < winner && winner < uid_expire_in))) {
                                        winner = uid_expire_in;
                                    }
                                }
                            }
                            ret = {
                                generated: this.timestamp,
                                expire_at: null,
                                expire_in: null
                            };
                            if (winner) {
                                ret.expire_at = this.timestamp + winner;
                                ret.expire_in = winner;
                            }
                            return ret;
                        };

                        KeyMaterial.prototype._get_expire_time_on_subkey = function() {
                            var expire_at, expire_in, generated, list, packetsig, sig, winner, _i, _len;
                            list = this.get_psc().lookup.subkey_binding;
                            if (!(list != null ? list.length : void 0)) {
                                return null;
                            }
                            winner = null;
                            for (_i = 0, _len = list.length; _i < _len; _i++) {
                                packetsig = list[_i];
                                if (!((packetsig.sig != null) && packetsig.is_down())) {
                                    continue;
                                }
                                sig = packetsig.sig;
                                expire_in = sig.get_key_expires();
                                generated = this.timestamp;
                                if (expire_in && generated) {
                                    expire_at = generated + expire_in;
                                    if ((winner == null) || ((winner.expire_at != null) && (winner.expire_at < expire_at))) {
                                        winner = {
                                            expire_at: expire_at,
                                            generated: generated,
                                            expire_in: expire_in
                                        };
                                    }
                                } else if (((expire_in != null) && expire_in === 0) || (expire_in == null)) {
                                    winner = {
                                        generated: generated,
                                        expire_in: null,
                                        expire_at: null
                                    };
                                }
                            }
                            if (winner == null) {
                                winner = {
                                    generated: 0,
                                    expire_at: null,
                                    expire_in: null
                                };
                            }
                            return winner;
                        };

                        KeyMaterial.prototype.add_designee = function(rev_key) {
                            var get_key_id;
                            get_key_id = function(fingerprint) {
                                return fingerprint.slice(12, 20).toString('hex');
                            };
                            return (this.desig_revokers || (this.desig_revokers = {}))[get_key_id(rev_key.fingerprint)] = rev_key;
                        };

                        KeyMaterial.prototype.add_designated_revocation = function(sig) {
                            return (this.unverified_revocations || (this.unverified_revocations = [])).push(sig);
                        };

                        KeyMaterial.prototype.get_designated_revocations = function() {
                            if (!((this.unverified_revocations != null) && (this.desig_revokers != null))) {
                                return [];
                            }
                            return this.unverified_revocations.filter((function(_this) {
                                return function(revocation) {
                                    var keyid;
                                    if ((keyid = revocation.get_issuer_key_id()) != null) {
                                        return keyid.toString('hex') in _this.desig_revokers;
                                    } else {
                                        return false;
                                    }
                                };
                            })(this));
                        };

                        return KeyMaterial;

                    })(Packet);

                    Parser = (function() {
                        function Parser(slice) {
                            this.slice = slice;
                            this.key = null;
                        }

                        Parser.prototype.parse_public_key_v3 = function() {
                            this.timestamp = this.slice.read_uint32();
                            this.expiration = this.slice.read_uint16();
                            return this.parse_public_key_mpis();
                        };

                        Parser.prototype.parse_public_key_v4 = function() {
                            this.timestamp = this.slice.read_uint32();
                            return this.parse_public_key_mpis();
                        };

                        Parser.prototype.parse_public_key_mpis = function() {
                            var A, err, key, klass, len, _ref4;
                            this.algorithm = this.slice.read_uint8();
                            A = C.public_key_algorithms;
                            klass = (function() {
                                switch (this.algorithm) {
                                    case A.RSA:
                                    case A.RSA_ENCRYPT_ONLY:
                                    case A.RSA_SIGN_ONLY:
                                        return RSA;
                                    case A.DSA:
                                        return DSA;
                                    case A.ELGAMAL:
                                        return ElGamal;
                                    case A.ELGAMAL_SIGN_AND_ENCRYPT:
                                        return ElGamalSE;
                                    case A.ECDSA:
                                        return ECDSA;
                                    case A.ECDH:
                                        return ECDH;
                                    case A.EDDSA:
                                        return EDDSA;
                                    default:
                                        throw new Error("Unknown key type: " + this.algorithm);
                                }
                            }).call(this);
                            _ref4 = klass.parse(this.slice.peek_rest_to_buffer()), err = _ref4[0], key = _ref4[1], len = _ref4[2];
                            if (err != null) {
                                throw err;
                            }
                            this.slice.advance(len);
                            return key;
                        };

                        Parser.prototype._parse_public_key = function() {
                            var version;
                            switch ((version = this.slice.read_uint8())) {
                                case C.versions.keymaterial.V3:
                                    return this.parse_public_key_v3();
                                case C.versions.keymaterial.V4:
                                    return this.parse_public_key_v4();
                                default:
                                    throw new Error("Unknown public key version: " + version);
                            }
                        };

                        Parser.prototype.parse_public_key = function(opts) {
                            var key;
                            key = this._parse_public_key();
                            return new KeyMaterial({
                                key: key,
                                timestamp: this.timestamp,
                                opts: opts
                            });
                        };

                        Parser.prototype.parse_private_key = function(opts) {
                            var encrypted_private_key, iv_len, key, skm, sym_enc_alg, _ref4;
                            skm = new SecretKeyMaterial();
                            key = this._parse_public_key();
                            encrypted_private_key = true;
                            sym_enc_alg = null;
                            if ((skm.s2k_convention = this.slice.read_uint8()) === C.s2k_convention.none) {
                                encrypted_private_key = false;
                            } else {
                                if ((_ref4 = skm.s2k_convention) === C.s2k_convention.sha1 || _ref4 === C.s2k_convention.checksum) {
                                    sym_enc_alg = this.slice.read_uint8();
                                    skm.s2k = (new S2K).read(this.slice);
                                } else {
                                    sym_enc_alg = skm.s2k_convention;
                                }
                            }
                            if ((skm.s2k_convention !== C.s2k_convention.none) && (skm.s2k.type === C.s2k.gnu_dummy)) {
                                skm.payload = null;
                            } else {
                                if (sym_enc_alg) {
                                    skm.cipher = symmetric.get_cipher(sym_enc_alg);
                                    iv_len = skm.cipher.klass.blockSize;
                                    skm.iv = this.slice.read_buffer(iv_len);
                                }
                                skm.payload = this.slice.consume_rest_to_buffer();
                            }
                            return new KeyMaterial({
                                key: key,
                                skm: skm,
                                timestamp: this.timestamp,
                                opts: opts
                            });
                        };

                        return Parser;

                    })();

                    exports.KeyMaterial = KeyMaterial;

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../../const": 5,
            "../../dsa": 6,
            "../../ecc/ecdh": 9,
            "../../ecc/ecdsa": 10,
            "../../ecc/eddsa": 11,
            "../../elgamal": 13,
            "../../elgamalse": 14,
            "../../rsa": 69,
            "../../symmetric": 70,
            "../../util": 72,
            "../armor": 35,
            "../cfb": 40,
            "../s2k": 60,
            "../util": 62,
            "./base": 47,
            "./packetsigs": 53,
            "./signature": 55,
            "buffer": 126,
            "iced-runtime": 183,
            "triplesec": 282,
            "util": 302
        }],
        51: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var C, Literal, LiteralParser, Packet, asymmetric, iced, uint_to_buffer, __iced_k, __iced_k_noop,
                        __hasProp = {}.hasOwnProperty,
                        __extends = function(child, parent) {
                            for (var key in parent) {
                                if (__hasProp.call(parent, key)) child[key] = parent[key];
                            }

                            function ctor() {
                                this.constructor = child;
                            }
                            ctor.prototype = parent.prototype;
                            child.prototype = new ctor();
                            child.__super__ = parent.prototype;
                            return child;
                        },
                        __indexOf = [].indexOf || function(item) {
                            for (var i = 0, l = this.length; i < l; i++) {
                                if (i in this && this[i] === item) return i;
                            }
                            return -1;
                        };

                    iced = require('iced-runtime');
                    __iced_k = __iced_k_noop = function() {};

                    Packet = require('./base').Packet;

                    C = require('../../const').openpgp;

                    asymmetric = require('../../asymmetric');

                    uint_to_buffer = require('../../util').uint_to_buffer;

                    Literal = (function(_super) {
                        __extends(Literal, _super);

                        function Literal(_arg) {
                            this.format = _arg.format, this.filename = _arg.filename, this.date = _arg.date, this.data = _arg.data;
                            Literal.__super__.constructor.call(this);
                        }

                        Literal.parse = function(slice) {
                            return (new LiteralParser(slice)).parse();
                        };

                        Literal.prototype.toString = function(encoding) {
                            if (encoding == null) {
                                encoding = null;
                            }
                            return this.data.toString(encoding || this.buffer_format());
                        };

                        Literal.prototype.toBuffer = function() {
                            return this.data;
                        };

                        Literal.prototype.buffer_format = function() {
                            switch (this.format) {
                                case C.literal_formats.text:
                                    return 'ascii';
                                case C.literal_formats.utf8:
                                    return 'utf8';
                                default:
                                    return 'binary';
                            }
                        };

                        Literal.prototype.to_signature_payload = function() {
                            return Buffer.concat([this.data]);
                        };

                        Literal.prototype.write_unframed = function(cb) {
                            var bufs, ret;
                            this.filename || (this.filename = new Buffer([]));
                            bufs = [new Buffer([this.format]), uint_to_buffer(8, this.filename.length), this.filename, uint_to_buffer(32, this.date), this.data];
                            ret = Buffer.concat(bufs);
                            return cb(null, ret);
                        };

                        Literal.prototype.write = function(cb) {
                            var err, raw, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            err = ret = null;
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/literal.iced",
                                        funcname: "Literal.write"
                                    });
                                    _this.write_unframed(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                err = arguments[0];
                                                return raw = arguments[1];
                                            };
                                        })(),
                                        lineno: 41
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    if (err == null) {
                                        ret = _this.frame_packet(C.packet_tags.literal, raw);
                                    }
                                    return cb(err, ret);
                                };
                            })(this));
                        };

                        Literal.prototype.to_literal = function() {
                            return this;
                        };

                        return Literal;

                    })(Packet);

                    LiteralParser = (function() {
                        function LiteralParser(slice) {
                            this.slice = slice;
                        }

                        LiteralParser.prototype.parse = function() {
                            var data, date, filename, format, k, known_formats, v;
                            known_formats = (function() {
                                var _ref, _results;
                                _ref = C.literal_formats;
                                _results = [];
                                for (k in _ref) {
                                    v = _ref[k];
                                    _results.push(v);
                                }
                                return _results;
                            })();
                            format = this.slice.read_uint8();
                            if (__indexOf.call(known_formats, format) < 0) {
                                throw new Error("unknwon format: " + format);
                            }
                            filename = this.slice.read_string();
                            date = this.slice.read_uint32();
                            data = this.slice.consume_rest_to_buffer();
                            return new Literal({
                                format: format,
                                filename: filename,
                                date: date,
                                data: data
                            });
                        };

                        return LiteralParser;

                    })();

                    exports.Literal = Literal;

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../../asymmetric": 1,
            "../../const": 5,
            "../../util": 72,
            "./base": 47,
            "buffer": 126,
            "iced-runtime": 183
        }],
        52: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var C, OPS_Parser, OnePassSignature, Packet, asymmetric, hash, iced, uint_to_buffer, __iced_k, __iced_k_noop,
                        __hasProp = {}.hasOwnProperty,
                        __extends = function(child, parent) {
                            for (var key in parent) {
                                if (__hasProp.call(parent, key)) child[key] = parent[key];
                            }

                            function ctor() {
                                this.constructor = child;
                            }
                            ctor.prototype = parent.prototype;
                            child.prototype = new ctor();
                            child.__super__ = parent.prototype;
                            return child;
                        };

                    iced = require('iced-runtime');
                    __iced_k = __iced_k_noop = function() {};

                    Packet = require('./base').Packet;

                    C = require('../../const').openpgp;

                    asymmetric = require('../../asymmetric');

                    hash = require('../../hash');

                    uint_to_buffer = require('../../util').uint_to_buffer;

                    OnePassSignature = (function(_super) {
                        __extends(OnePassSignature, _super);

                        function OnePassSignature(_arg) {
                            this.sig_type = _arg.sig_type, this.hasher = _arg.hasher, this.sig_klass = _arg.sig_klass, this.key_id = _arg.key_id, this.is_final = _arg.is_final;
                        }

                        OnePassSignature.parse = function(slice) {
                            return (new OPS_Parser(slice)).parse();
                        };

                        OnePassSignature.prototype.write_unframed = function(cb) {
                            var bufs, unframed, vals, x;
                            vals = [C.versions.one_pass_sig, this.sig_type, this.hasher.type, this.sig_klass.type];
                            bufs = (function() {
                                var _i, _len, _results;
                                _results = [];
                                for (_i = 0, _len = vals.length; _i < _len; _i++) {
                                    x = vals[_i];
                                    _results.push(uint_to_buffer(8, x));
                                }
                                return _results;
                            })();
                            bufs.push(this.key_id);
                            bufs.push(uint_to_buffer(8, this.is_final));
                            unframed = Buffer.concat(bufs);
                            return cb(null, unframed);
                        };

                        OnePassSignature.prototype.write = function(cb) {
                            var err, framed, unframed, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/one_pass_sig.iced",
                                        funcname: "OnePassSignature.write"
                                    });
                                    _this.write_unframed(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                err = arguments[0];
                                                return unframed = arguments[1];
                                            };
                                        })(),
                                        lineno: 38
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    framed = _this.frame_packet(C.packet_tags.one_pass_sig, unframed);
                                    return cb(err, framed);
                                };
                            })(this));
                        };

                        return OnePassSignature;

                    })(Packet);

                    OPS_Parser = (function() {
                        function OPS_Parser(slice) {
                            this.slice = slice;
                        }

                        OPS_Parser.prototype.parse = function() {
                            var hasher, is_final, key_id, sig_klass, sig_type, v;
                            if ((v = this.slice.read_uint8()) !== C.versions.one_pass_sig) {
                                throw new Error("Unknown OnePassSignature version " + v);
                            }
                            sig_type = this.slice.read_uint8();
                            hasher = hash.alloc_or_throw(this.slice.read_uint8());
                            sig_klass = asymmetric.get_class(this.slice.read_uint8());
                            key_id = this.slice.read_buffer(8);
                            is_final = this.slice.read_uint8();
                            return new OnePassSignature({
                                sig_type: sig_type,
                                hasher: hasher,
                                sig_klass: sig_klass,
                                key_id: key_id,
                                is_final: is_final
                            });
                        };

                        return OPS_Parser;

                    })();

                    exports.OnePassSignature = OnePassSignature;

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../../asymmetric": 1,
            "../../const": 5,
            "../../hash": 16,
            "../../util": 72,
            "./base": 47,
            "buffer": 126,
            "iced-runtime": 183
        }],
        53: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var Base, Collection, Data, SelfSig, SubkeyBinding,
                    __hasProp = {}.hasOwnProperty,
                    __extends = function(child, parent) {
                        for (var key in parent) {
                            if (__hasProp.call(parent, key)) child[key] = parent[key];
                        }

                        function ctor() {
                            this.constructor = child;
                        }
                        ctor.prototype = parent.prototype;
                        child.prototype = new ctor();
                        child.__super__ = parent.prototype;
                        return child;
                    };

                Base = (function() {
                    function Base(_arg) {
                        this.sig = _arg.sig, this.key_expiration = _arg.key_expiration;
                    }

                    Base.prototype.typ = function() {
                        return "none";
                    };

                    Base.prototype.get_key_flags = function() {
                        return this.sig.get_key_flags();
                    };

                    Base.prototype.push = function(lookup) {
                        return lookup[this.typ()].push(this);
                    };

                    return Base;

                })();

                SelfSig = (function(_super) {
                    __extends(SelfSig, _super);

                    function SelfSig(_arg) {
                        var key_expiration, sig, sig_expiration;
                        this.userid = _arg.userid, this.user_attribute = _arg.user_attribute, this.type = _arg.type, sig = _arg.sig, this.options = _arg.options, key_expiration = _arg.key_expiration, sig_expiration = _arg.sig_expiration;
                        SelfSig.__super__.constructor.call(this, {
                            sig: sig,
                            key_expiration: key_expiration,
                            sig_expiration: sig_expiration
                        });
                    }

                    SelfSig.prototype.typ = function() {
                        return "self_sig";
                    };

                    SelfSig.prototype.push = function(lookup) {
                        var key, v;
                        lookup.self_sig.push(this);
                        key = this.userid != null ? this.userid.utf8() || "" : void 0;
                        if ((v = lookup.self_sigs_by_uid[key]) == null) {
                            v = [];
                            lookup.self_sigs_by_uid[key] = v;
                        }
                        return v.push(this);
                    };

                    return SelfSig;

                })(Base);

                SubkeyBinding = (function(_super) {
                    __extends(SubkeyBinding, _super);

                    SubkeyBinding.UP = 1;

                    SubkeyBinding.DOWN = 2;

                    function SubkeyBinding(_arg) {
                        var key_expiration, sig, sig_expiration;
                        this.primary = _arg.primary, sig = _arg.sig, this.direction = _arg.direction, sig_expiration = _arg.sig_expiration, key_expiration = _arg.key_expiration;
                        SubkeyBinding.__super__.constructor.call(this, {
                            sig: sig,
                            key_expiration: key_expiration,
                            sig_expiration: sig_expiration
                        });
                    }

                    SubkeyBinding.prototype.typ = function() {
                        return "subkey_binding";
                    };

                    SubkeyBinding.prototype.is_down = function() {
                        return this.direction === SubkeyBinding.DOWN;
                    };

                    return SubkeyBinding;

                })(Base);

                Data = (function(_super) {
                    __extends(Data, _super);

                    function Data(_arg) {
                        var key_expiration, sig, sig_expiration;
                        this.key = _arg.key, sig = _arg.sig, key_expiration = _arg.key_expiration, sig_expiration = _arg.sig_expiration;
                        Data.__super__.constructor.call(this, {
                            sig: sig,
                            key_expiration: key_expiration,
                            sig_expiration: sig_expiration
                        });
                    }

                    Data.prototype.typ = function() {
                        return "data";
                    };

                    Data.prototype.get_key_manager = function() {
                        var _ref;
                        return (_ref = this.sig) != null ? _ref.key_manager : void 0;
                    };

                    return Data;

                })(Base);

                Collection = (function() {
                    function Collection() {
                        this.clear();
                    }

                    Collection.prototype.clear = function() {
                        this.all = [];
                        return this.lookup = {
                            self_sig: [],
                            self_sigs_by_uid: {},
                            subkey_binding: [],
                            data: []
                        };
                    };

                    Collection.prototype.push = function(ps) {
                        this.all.push(ps);
                        return ps.push(this.lookup);
                    };

                    Collection.prototype.is_signed_subkey_of = function(primary, need_upwards_sig) {
                        var down, skb, up, _i, _len, _ref;
                        up = down = false;
                        _ref = this.lookup.subkey_binding;
                        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                            skb = _ref[_i];
                            if (skb.primary.equal(primary)) {
                                if (skb.is_down()) {
                                    down = true;
                                } else {
                                    up = true;
                                }
                                if (down && (up || !need_upwards_sig)) {
                                    return true;
                                }
                            }
                        }
                        return false;
                    };

                    Collection.prototype.get_all_key_flags = function() {
                        var p, ret, _i, _len, _ref;
                        ret = 0;
                        _ref = this.all;
                        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                            p = _ref[_i];
                            ret |= p.get_key_flags();
                        }
                        return ret;
                    };

                    Collection.prototype.get_signed_userids = function() {
                        var p, u, _i, _len, _ref, _results;
                        _ref = this.lookup.self_sig;
                        _results = [];
                        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                            p = _ref[_i];
                            if ((u = p.userid) != null) {
                                _results.push(u);
                            }
                        }
                        return _results;
                    };

                    Collection.prototype.get_signed_user_attributes = function() {
                        var p, u, _i, _len, _ref, _results;
                        _ref = this.lookup.self_sig;
                        _results = [];
                        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
                            p = _ref[_i];
                            if ((u = p.user_attribute) != null) {
                                _results.push(u);
                            }
                        }
                        return _results;
                    };

                    Collection.prototype.get_self_sig = function() {
                        if (this.lookup.self_sig.length) {
                            return this.lookup.self_sig[0];
                        } else {
                            return null;
                        }
                    };

                    Collection.prototype.get_self_sigs = function() {
                        return this.lookup.self_sig;
                    };

                    Collection.prototype.is_self_signed = function() {
                        return this.get_signed_userids().length > 0;
                    };

                    Collection.prototype.get_data_signer = function() {
                        if (this.lookup.data.length > 0) {
                            return this.lookup.data[0];
                        } else {
                            return null;
                        }
                    };

                    Collection.prototype.get_data_signers = function() {
                        return this.lookup.data;
                    };

                    Collection.prototype.get_subkey_binding = function() {
                        if (this.lookup.subkey_binding.length) {
                            return this.lookup.subkey_binding[0];
                        } else {
                            return null;
                        }
                    };

                    return Collection;

                })();

                exports.SelfSig = SelfSig;

                exports.SubkeyBinding = SubkeyBinding;

                exports.Data = Data;

                exports.Collection = Collection;

            }).call(this);

        }, {}],
        54: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var ASP, C, Decryptor, MDC, MDC_Parser, PKESK, PKESK_Parser, Packet, SEIPD, SEIPD_Parser, SHA1, asymmetric, bufeq_fast, bufeq_secure, encrypt, iced, make_esc, streamers, uint_to_buffer, __iced_k, __iced_k_noop, _ref, _ref1, _ref2,
                        __hasProp = {}.hasOwnProperty,
                        __extends = function(child, parent) {
                            for (var key in parent) {
                                if (__hasProp.call(parent, key)) child[key] = parent[key];
                            }

                            function ctor() {
                                this.constructor = child;
                            }
                            ctor.prototype = parent.prototype;
                            child.prototype = new ctor();
                            child.__super__ = parent.prototype;
                            return child;
                        };

                    iced = require('iced-runtime');
                    __iced_k = __iced_k_noop = function() {};

                    Packet = require('./base').Packet;

                    C = require('../../const').openpgp;

                    asymmetric = require('../../asymmetric');

                    _ref = require('../../hash'), SHA1 = _ref.SHA1, streamers = _ref.streamers;

                    _ref1 = require('../../util'), uint_to_buffer = _ref1.uint_to_buffer, bufeq_secure = _ref1.bufeq_secure, bufeq_fast = _ref1.bufeq_fast;

                    _ref2 = require('../ocfb'), encrypt = _ref2.encrypt, Decryptor = _ref2.Decryptor;

                    ASP = require('pgp-utils').util.ASP;

                    make_esc = require('iced-error').make_esc;

                    PKESK = (function(_super) {
                        __extends(PKESK, _super);

                        function PKESK(_arg) {
                            this.crypto_type = _arg.crypto_type, this.key_id = _arg.key_id, this.ekey = _arg.ekey;
                        }

                        PKESK.parse = function(slice) {
                            return (new PKESK_Parser(slice)).parse();
                        };

                        PKESK.prototype.to_esk_packet = function() {
                            return this;
                        };

                        PKESK.prototype.get_key_id = function() {
                            return this.key_id;
                        };

                        PKESK.prototype.write_unframed = function(cb) {
                            var bufs, err, ret;
                            bufs = [uint_to_buffer(8, C.versions.PKESK), this.key_id, uint_to_buffer(8, this.crypto_type), this.ekey.output()];
                            ret = Buffer.concat(bufs);
                            err = null;
                            return cb(err, ret);
                        };

                        PKESK.prototype.write = function(cb) {
                            var err, ret, unframed, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            ret = null;
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/sess.iced",
                                        funcname: "PKESK.write"
                                    });
                                    _this.write_unframed(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                err = arguments[0];
                                                return unframed = arguments[1];
                                            };
                                        })(),
                                        lineno: 36
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    if (typeof err === "undefined" || err === null) {
                                        ret = _this.frame_packet(C.packet_tags.PKESK, unframed);
                                    }
                                    return cb(err, ret);
                                };
                            })(this));
                        };

                        return PKESK;

                    })(Packet);

                    SEIPD = (function(_super) {
                        __extends(SEIPD, _super);

                        function SEIPD(_arg) {
                            this.ciphertext = _arg.ciphertext;
                        }

                        SEIPD.parse = function(slice) {
                            return (new SEIPD_Parser(slice)).parse();
                        };

                        SEIPD.prototype.to_enc_data_packet = function() {
                            return this;
                        };

                        SEIPD.prototype.check = function() {};

                        SEIPD.prototype.decrypt = function(_arg, cb) {
                            var asp, cipher, eng, err, esc, mdc, plaintext, prefix, pt, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            cipher = _arg.cipher, asp = _arg.asp;
                            eng = new Decryptor({
                                cipher: cipher,
                                ciphertext: this.ciphertext,
                                asp: asp
                            });
                            esc = make_esc(cb, "SEIPD::decrypt");
                            asp = ASP.make(asp);
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/sess.iced",
                                        funcname: "SEIPD.decrypt"
                                    });
                                    eng.check(esc(__iced_deferrals.defer({
                                        lineno: 63
                                    })));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/sess.iced",
                                            funcname: "SEIPD.decrypt"
                                        });
                                        eng.dec(esc(__iced_deferrals.defer({
                                            assign_fn: (function() {
                                                return function() {
                                                    return pt = arguments[0];
                                                };
                                            })(),
                                            lineno: 64
                                        })));
                                        __iced_deferrals._fulfill();
                                    })(function() {
                                        var _ref3;
                                        _ref3 = MDC.parse(pt), mdc = _ref3[0], plaintext = _ref3[1];
                                        prefix = eng.get_prefix();
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/sess.iced",
                                                funcname: "SEIPD.decrypt"
                                            });
                                            mdc.compute({
                                                prefix: prefix,
                                                plaintext: plaintext,
                                                asp: asp
                                            }, esc(__iced_deferrals.defer({
                                                lineno: 70
                                            })));
                                            __iced_deferrals._fulfill();
                                        })(function() {
                                            err = mdc.check() ? null : new Error("MDC mismatch");
                                            return cb(err, plaintext);
                                        });
                                    });
                                };
                            })(this));
                        };

                        SEIPD.prototype.encrypt = function(_arg, cb) {
                            var asp, cipher, esc, mdc, mdc_buf, plaintext, prefixrandom, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            cipher = _arg.cipher, plaintext = _arg.plaintext, prefixrandom = _arg.prefixrandom, asp = _arg.asp;
                            mdc = new MDC({});
                            esc = make_esc(cb, "SEIPD::encrypt");
                            asp = ASP.make(asp);
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/sess.iced",
                                        funcname: "SEIPD.encrypt"
                                    });
                                    mdc.compute({
                                        plaintext: plaintext,
                                        prefix: prefixrandom,
                                        asp: asp
                                    }, esc(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return mdc_buf = arguments[0];
                                            };
                                        })(),
                                        lineno: 81
                                    })));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    plaintext = Buffer.concat([plaintext, MDC.header, mdc_buf]);
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/sess.iced",
                                            funcname: "SEIPD.encrypt"
                                        });
                                        encrypt({
                                            cipher: cipher,
                                            plaintext: plaintext,
                                            prefixrandom: prefixrandom
                                        }, esc(__iced_deferrals.defer({
                                            assign_fn: (function(__slot_1) {
                                                return function() {
                                                    return __slot_1.ciphertext = arguments[0];
                                                };
                                            })(_this),
                                            lineno: 83
                                        })));
                                        __iced_deferrals._fulfill();
                                    })(function() {
                                        return cb(null);
                                    });
                                };
                            })(this));
                        };

                        SEIPD.prototype.write_unframed = function(cb) {
                            var err, ret;
                            err = ret = null;
                            ret = Buffer.concat([uint_to_buffer(8, C.versions.SEIPD), this.ciphertext]);
                            return cb(err, ret);
                        };

                        SEIPD.prototype.write = function(cb) {
                            var err, ret, unframed, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            ret = err = null;
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/sess.iced",
                                        funcname: "SEIPD.write"
                                    });
                                    _this.write_unframed(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                err = arguments[0];
                                                return unframed = arguments[1];
                                            };
                                        })(),
                                        lineno: 97
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    if (err == null) {
                                        ret = _this.frame_packet(C.packet_tags.SEIPD, unframed);
                                    }
                                    return cb(err, ret);
                                };
                            })(this));
                        };

                        return SEIPD;

                    })(Packet);

                    MDC = (function(_super) {
                        __extends(MDC, _super);

                        MDC.header = new Buffer([0xc0 | C.packet_tags.MDC, SHA1.output_length]);

                        MDC.prototype.header = MDC.header;

                        function MDC(_arg) {
                            this.digest = _arg.digest;
                        }

                        MDC.parse = function(buf) {
                            return (new MDC_Parser(buf)).parse();
                        };

                        MDC.prototype.compute = function(_arg, cb) {
                            var asp, esc, hasher, i, plaintext, prefix, step, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            plaintext = _arg.plaintext, prefix = _arg.prefix, asp = _arg.asp;
                            asp = ASP.make(asp);
                            hasher = streamers.SHA1();
                            hasher.update(Buffer.concat([prefix, prefix.slice(-2)]));
                            esc = make_esc(cb, "MDC::compute");
                            step = 0x100000;
                            (function(_this) {
                                return (function(__iced_k) {
                                    var _begin, _end, _i, _positive, _results, _step, _while;
                                    i = 0;
                                    _begin = 0;
                                    _end = plaintext.length;
                                    _step = step;
                                    _positive = _step > 0;
                                    _while = function(__iced_k) {
                                        var _break, _continue, _next;
                                        _break = __iced_k;
                                        _continue = function() {
                                            return iced.trampoline(function() {
                                                i += _step;
                                                return _while(__iced_k);
                                            });
                                        };
                                        _next = _continue;
                                        if (!!((_positive === true && i >= plaintext.length) || (_positive === false && i <= plaintext.length))) {
                                            return _break();
                                        } else {

                                            hasher.update(plaintext.slice(i, i + step));
                                            (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral,
                                                    filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/sess.iced",
                                                    funcname: "MDC.compute"
                                                });
                                                asp.progress({
                                                    what: "MDC",
                                                    total: plaintext.length,
                                                    i: i
                                                }, esc(__iced_deferrals.defer({
                                                    lineno: 122
                                                })));
                                                __iced_deferrals._fulfill();
                                            })(_next);
                                        }
                                    };
                                    _while(__iced_k);
                                });
                            })(this)((function(_this) {
                                return function() {
                                    hasher.update(_this.header);
                                    _this.computed = hasher();
                                    return cb(null, _this.computed);
                                };
                            })(this));
                        };

                        MDC.prototype.check = function() {
                            return bufeq_secure(this.digest, this.computed);
                        };

                        return MDC;

                    })(Packet);

                    MDC_Parser = (function() {
                        function MDC_Parser(buf) {
                            this.buf = buf;
                        }

                        MDC_Parser.prototype.parse = function() {
                            var chunk, digest, hl, len, rem;
                            hl = MDC.header.length;
                            len = SHA1.output_length + hl;
                            rem = this.buf.slice(0, -len);
                            chunk = this.buf.slice(-len);
                            if (!bufeq_fast(chunk.slice(0, hl), MDC.header)) {
                                throw new Error('Missing MDC header');
                            }
                            digest = chunk.slice(hl);
                            return [
                                new MDC({
                                    digest: digest
                                }), rem
                            ];
                        };

                        return MDC_Parser;

                    })();

                    SEIPD_Parser = (function() {
                        function SEIPD_Parser(slice) {
                            this.slice = slice;
                        }

                        SEIPD_Parser.prototype.payload_split = function(raw) {};

                        SEIPD_Parser.prototype.parse = function() {
                            var ciphertext, v;
                            if ((v = this.slice.read_uint8()) !== C.versions.SEIPD) {
                                throw new Error("Unknown SEIPD version " + v);
                            }
                            ciphertext = this.slice.consume_rest_to_buffer();
                            return new SEIPD({
                                ciphertext: ciphertext
                            });
                        };

                        return SEIPD_Parser;

                    })();

                    PKESK_Parser = (function() {
                        function PKESK_Parser(slice) {
                            this.slice = slice;
                        }

                        PKESK_Parser.prototype.parse = function() {
                            var crypto_type, ekey, key_id, klass, v;
                            if ((v = this.slice.read_uint8()) !== C.versions.PKESK) {
                                throw new Error("Unknown PKESK version: " + v);
                            }
                            key_id = this.slice.read_buffer(8);
                            crypto_type = this.slice.read_uint8();
                            klass = asymmetric.get_class(crypto_type);
                            ekey = klass.parse_output(this.slice.consume_rest_to_buffer());
                            return new PKESK({
                                crypto_type: crypto_type,
                                key_id: key_id,
                                ekey: ekey
                            });
                        };

                        return PKESK_Parser;

                    })();

                    exports.SEIPD = SEIPD;

                    exports.PKESK = PKESK;

                    exports.MDC = MDC;

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../../asymmetric": 1,
            "../../const": 5,
            "../../hash": 16,
            "../../util": 72,
            "../ocfb": 45,
            "./base": 47,
            "buffer": 126,
            "iced-error": 179,
            "iced-runtime": 183,
            "pgp-utils": 229
        }],
        55: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var C, CreationTime, EmbeddedSignature, Experimental, ExpirationTime, Exportable, Features, Issuer, IssuerFingerprint, KeyExpirationTime, KeyFlags, KeyServerPreferences, NotationData, Packet, Parser, PolicyURI, Preference, PreferredCompressionAlgorithms, PreferredHashAlgorithms, PreferredKeyServer, PreferredSymmetricAlgorithms, PrimaryUserId, ReasonForRevocation, RegularExpression, Revocable, RevocationKey, S, SHA1, SHA512, Signature, SignatureTarget, Signature_v2, Signature_v2_or_v3, Signature_v3, SignersUserID, SlicerBuffer, SubPacket, Time, Trust, alloc_or_throw, assert, asymmetric, bufeq_secure, encode_length, iced, make_esc, make_time_packet, packetsigs, uint_to_buffer, unix_time, util, __iced_k, __iced_k_noop, _ref, _ref1, _ref2,
                        __hasProp = {}.hasOwnProperty,
                        __extends = function(child, parent) {
                            for (var key in parent) {
                                if (__hasProp.call(parent, key)) child[key] = parent[key];
                            }

                            function ctor() {
                                this.constructor = child;
                            }
                            ctor.prototype = parent.prototype;
                            child.prototype = new ctor();
                            child.__super__ = parent.prototype;
                            return child;
                        };

                    iced = require('iced-runtime');
                    __iced_k = __iced_k_noop = function() {};

                    Packet = require('./base').Packet;

                    C = require('../../const').openpgp;

                    S = C.sig_subpacket;

                    _ref = require('../util'), encode_length = _ref.encode_length, make_time_packet = _ref.make_time_packet;

                    _ref1 = require('../../util'), unix_time = _ref1.unix_time, uint_to_buffer = _ref1.uint_to_buffer, bufeq_secure = _ref1.bufeq_secure;

                    _ref2 = require('../../hash'), alloc_or_throw = _ref2.alloc_or_throw, SHA512 = _ref2.SHA512, SHA1 = _ref2.SHA1;

                    asymmetric = require('../../asymmetric');

                    util = require('util');

                    packetsigs = require('./packetsigs');

                    assert = require('assert');

                    SlicerBuffer = require('../buffer').SlicerBuffer;

                    make_esc = require('iced-error').make_esc;

                    Signature_v2_or_v3 = (function(_super) {
                        __extends(Signature_v2_or_v3, _super);

                        function Signature_v2_or_v3(_arg) {
                            this.key = _arg.key, this.hasher = _arg.hasher, this.key_id = _arg.key_id, this.sig_data = _arg.sig_data, this.public_key_class = _arg.public_key_class, this.signed_hash_value_hash = _arg.signed_hash_value_hash, this.time = _arg.time, this.sig = _arg.sig, this.type = _arg.type, this.version = _arg.version;
                            if (this.hasher == null) {
                                this.hasher = SHA512;
                            }
                            this._framed_output = null;
                        }

                        Signature_v2_or_v3.prototype.is_signature = function() {
                            return true;
                        };

                        Signature_v2_or_v3.prototype.get_key_id = function() {
                            return this.key_id;
                        };

                        Signature_v2_or_v3.prototype.get_key_flags = function() {
                            return 0;
                        };

                        Signature_v2_or_v3.prototype.get_key_expires = function() {
                            return 0;
                        };

                        Signature_v2_or_v3.prototype.get_issuer_key_id = function() {
                            return this.key_id;
                        };

                        Signature_v2_or_v3.prototype.get_issuer_fingerprint = function() {
                            return null;
                        };

                        Signature_v2_or_v3.prototype.when_generated = function() {
                            return this.time;
                        };

                        Signature_v2_or_v3.prototype.time_of_primary_uid_sig = function() {
                            return null;
                        };

                        Signature_v2_or_v3.prototype.gen_prefix = function() {
                            return Buffer.concat([new Buffer([C.versions.signature.V3, this.type], uint_to_buffer(32, this.time), this.key_id, new Buffer([this.key.type, this.hasher.type]))]);
                        };

                        Signature_v2_or_v3.prototype.prepare_payload = function(data_packets) {
                            var bufs, dp;
                            bufs = (function() {
                                var _i, _len, _results;
                                _results = [];
                                for (_i = 0, _len = data_packets.length; _i < _len; _i++) {
                                    dp = data_packets[_i];
                                    _results.push(dp.to_signature_payload());
                                }
                                return _results;
                            })();
                            bufs.push(new Buffer([this.type]), uint_to_buffer(32, this.time));
                            return Buffer.concat(bufs);
                        };

                        Signature_v2_or_v3.prototype.verify = function(data_packets, cb) {
                            var SKB, T, b, d, err, hash, payload, s, v, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            T = C.sig_types;
                            SKB = packetsigs.SubkeyBinding;
                            if (this.type === T.subkey_binding) {
                                data_packets = [this.primary].concat(data_packets);
                            }
                            payload = this.prepare_payload(data_packets);
                            hash = this.hasher(payload);
                            s = new SlicerBuffer(hash);
                            v = s.read_uint16();
                            (function(_this) {
                                return (function(__iced_k) {
                                    if (v !== (b = _this.signed_hash_value_hash)) {
                                        return __iced_k(err = new Error("quick hash check failed: " + v + " != " + b));
                                    } else {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/signature.iced",
                                                funcname: "Signature_v2_or_v3.verify"
                                            });
                                            _this.key.verify_unpad_and_check_hash({
                                                hash: hash,
                                                hasher: _this.hasher,
                                                sig: _this.sig
                                            }, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        return err = arguments[0];
                                                    };
                                                })(),
                                                lineno: 86
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(function() {
                                            var _i, _j, _len, _len1, _ref3, _ref4;
                                            if (err != null) {

                                            } else if ((_ref3 = _this.type) === T.binary_doc || _ref3 === T.canonical_text) {
                                                for (_i = 0, _len = data_packets.length; _i < _len; _i++) {
                                                    d = data_packets[_i];
                                                    d.push_sig(new packetsigs.Data({
                                                        sig: _this
                                                    }));
                                                }
                                            } else if ((_ref4 = _this.type) === T.subkey_binding) {
                                                for (_j = 0, _len1 = data_packets.length; _j < _len1; _j++) {
                                                    d = data_packets[_j];
                                                    d.push_sig(new SKB({
                                                        primary: _this.primary,
                                                        sig: _this,
                                                        direction: SKB.DOWN
                                                    }));
                                                }
                                            }
                                            return __iced_k();
                                        });
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err);
                                };
                            })(this));
                        };

                        return Signature_v2_or_v3;

                    })(Packet);

                    Signature_v2 = (function(_super) {
                        __extends(Signature_v2, _super);

                        function Signature_v2() {
                            return Signature_v2.__super__.constructor.apply(this, arguments);
                        }

                        return Signature_v2;

                    })(Signature_v2_or_v3);

                    Signature_v3 = (function(_super) {
                        __extends(Signature_v3, _super);

                        function Signature_v3() {
                            return Signature_v3.__super__.constructor.apply(this, arguments);
                        }

                        return Signature_v3;

                    })(Signature_v2_or_v3);

                    Signature = (function(_super) {
                        __extends(Signature, _super);

                        function Signature(_arg) {
                            this.key = _arg.key, this.hasher = _arg.hasher, this.key_id = _arg.key_id, this.sig_data = _arg.sig_data, this.public_key_class = _arg.public_key_class, this.signed_hash_value_hash = _arg.signed_hash_value_hash, this.hashed_subpackets = _arg.hashed_subpackets, this.time = _arg.time, this.sig = _arg.sig, this.type = _arg.type, this.unhashed_subpackets = _arg.unhashed_subpackets, this.version = _arg.version;
                            if (this.hasher == null) {
                                this.hasher = SHA512;
                            }
                            if (this.hashed_subpackets == null) {
                                this.hashed_subpackets = [];
                            }
                            if (this.unhashed_subpackets == null) {
                                this.unhashed_subpackets = [];
                            }
                            this.subpacket_index = this._make_subpacket_index();
                            this._framed_output = null;
                        }

                        Signature.prototype.get_key_id = function() {
                            var _ref3;
                            if (this.key_id) {
                                return this.key_id;
                            } else {
                                return (_ref3 = this.subpacket_index.all[S.issuer]) != null ? _ref3.id : void 0;
                            }
                        };

                        Signature.prototype._make_subpacket_index = function() {
                            var p, ret, _i, _j, _len, _len1, _ref3, _ref4;
                            ret = {
                                hashed: {},
                                unhashed: {},
                                all: {}
                            };
                            _ref3 = this.hashed_subpackets;
                            for (_i = 0, _len = _ref3.length; _i < _len; _i++) {
                                p = _ref3[_i];
                                ret.hashed[p.type] = p;
                                ret.all[p.type] = p;
                            }
                            _ref4 = this.unhashed_subpackets;
                            for (_j = 0, _len1 = _ref4.length; _j < _len1; _j++) {
                                p = _ref4[_j];
                                ret.unhashed[p.type] = p;
                                ret.all[p.type] = p;
                            }
                            return ret;
                        };

                        Signature.prototype.prepare_payload = function(data) {
                            var flatsp, hvalue, payload, prefix, s, trailer;
                            flatsp = Buffer.concat((function() {
                                var _i, _len, _ref3, _results;
                                _ref3 = this.hashed_subpackets;
                                _results = [];
                                for (_i = 0, _len = _ref3.length; _i < _len; _i++) {
                                    s = _ref3[_i];
                                    _results.push(s.to_buffer());
                                }
                                return _results;
                            }).call(this));
                            prefix = Buffer.concat([new Buffer([C.versions.signature.V4, this.type, this.key.type, this.hasher.type]), uint_to_buffer(16, flatsp.length), flatsp]);
                            trailer = Buffer.concat([new Buffer([C.versions.signature.V4, 0xff]), uint_to_buffer(32, prefix.length)]);
                            payload = Buffer.concat([data, prefix, trailer]);
                            hvalue = this.hasher(payload);
                            return {
                                prefix: prefix,
                                payload: payload,
                                hvalue: hvalue
                            };
                        };

                        Signature.prototype.write_unframed = function(data, cb) {
                            var esc, hvalue, payload, prefix, result2, results, s, sig, uhsp, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref3;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            esc = make_esc(cb, "write_unframed");
                            uhsp = Buffer.concat((function() {
                                var _i, _len, _ref3, _results;
                                _ref3 = this.unhashed_subpackets;
                                _results = [];
                                for (_i = 0, _len = _ref3.length; _i < _len; _i++) {
                                    s = _ref3[_i];
                                    _results.push(s.to_buffer());
                                }
                                return _results;
                            }).call(this));
                            _ref3 = this.prepare_payload(data), prefix = _ref3.prefix, payload = _ref3.payload, hvalue = _ref3.hvalue;
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/signature.iced",
                                        funcname: "Signature.write_unframed"
                                    });
                                    _this.key.pad_and_sign(payload, {
                                        hasher: _this.hasher
                                    }, esc(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return sig = arguments[0];
                                            };
                                        })(),
                                        lineno: 168
                                    })));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    result2 = Buffer.concat([uint_to_buffer(16, uhsp.length), uhsp, new Buffer([hvalue.readUInt8(0), hvalue.readUInt8(1)]), sig]);
                                    results = Buffer.concat([prefix, result2]);
                                    return cb(null, results);
                                };
                            })(this));
                        };

                        Signature.prototype.write = function(data, cb) {
                            var err, ret, unframed, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/signature.iced",
                                        funcname: "Signature.write"
                                    });
                                    _this.write_unframed(data, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                err = arguments[0];
                                                return unframed = arguments[1];
                                            };
                                        })(),
                                        lineno: 181
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    if (typeof err === "undefined" || err === null) {
                                        _this._framed_output = ret = _this.frame_packet(C.packet_tags.signature, unframed);
                                    }
                                    return cb(err, ret);
                                };
                            })(this));
                        };

                        Signature.prototype.get_framed_output = function() {
                            return this._framed_output || this.replay();
                        };

                        Signature.parse = function(slice) {
                            return (new Parser(slice)).parse();
                        };

                        Signature.prototype.extract_key = function(data_packets) {
                            var p, _i, _len, _results;
                            _results = [];
                            for (_i = 0, _len = data_packets.length; _i < _len; _i++) {
                                p = data_packets[_i];
                                if (p.key != null) {
                                    this.key = p.key;
                                    break;
                                } else {
                                    _results.push(void 0);
                                }
                            }
                            return _results;
                        };

                        Signature.prototype.verify = function(data_packets, cb, opts) {
                            var err, p, s, subkey, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/signature.iced",
                                        funcname: "Signature.verify"
                                    });
                                    _this._verify(data_packets, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return err = arguments[0];
                                            };
                                        })(),
                                        lineno: 210
                                    }), opts);
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    (function(__iced_k) {
                                        var _i, _len, _ref3, _results, _while;
                                        _ref3 = _this.unhashed_subpackets;
                                        _len = _ref3.length;
                                        _i = 0;
                                        _while = function(__iced_k) {
                                            var _break, _continue, _next;
                                            _break = __iced_k;
                                            _continue = function() {
                                                return iced.trampoline(function() {
                                                    ++_i;
                                                    return _while(__iced_k);
                                                });
                                            };
                                            _next = _continue;
                                            if (!(_i < _len)) {
                                                return _break();
                                            } else {
                                                p = _ref3[_i];
                                                if ((typeof err === "undefined" || err === null) && ((s = p.to_sig()) != null)) {
                                                    (function(__iced_k) {
                                                        if (s.type !== C.sig_types.primary_binding) {
                                                            return __iced_k(err = new Error("unknown subpacket signature type: " + s.type));
                                                        } else {
                                                            (function(__iced_k) {
                                                                if (data_packets.length !== 1) {
                                                                    return __iced_k(err = new Error("Needed 1 data packet for a primary_binding signature"));
                                                                } else {
                                                                    subkey = data_packets[0];
                                                                    s.primary = _this.primary;
                                                                    s.key = subkey.key;
                                                                    (function(__iced_k) {
                                                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                                            parent: ___iced_passed_deferral,
                                                                            filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/signature.iced",
                                                                            funcname: "Signature.verify"
                                                                        });
                                                                        s._verify([subkey], __iced_deferrals.defer({
                                                                            assign_fn: (function() {
                                                                                return function() {
                                                                                    return err = arguments[0];
                                                                                };
                                                                            })(),
                                                                            lineno: 220
                                                                        }), opts);
                                                                        __iced_deferrals._fulfill();
                                                                    })(__iced_k);
                                                                }
                                                            })(__iced_k);
                                                        }
                                                    })(_next);
                                                } else {
                                                    return _continue();
                                                }
                                            }
                                        };
                                        _while(__iced_k);
                                    })(function() {
                                        return cb(err);
                                    });
                                };
                            })(this));
                        };

                        Signature.prototype._verify = function(data_packets, cb, opts) {
                            var SKB, T, buffers, d, data, dp, err, fp, hvalue, key_expiration, n, packets, payload, ps, sig, sig_expiration, subkey, user_attribute, userid, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            err = null;
                            T = C.sig_types;
                            subkey = null;
                            this.data_packets = (function() {
                                switch (this.type) {
                                    case T.binary_doc:
                                    case T.canonical_text:
                                        return data_packets;
                                    case T.issuer:
                                    case T.persona:
                                    case T.casual:
                                    case T.positive:
                                    case T.certificate_revocation:
                                    case T.key_revocation:
                                        if ((n = data_packets.length) > 1) {
                                            err = new Error("Only expecting one (or no) UserID-style packet(s) in a self-sig (got " + n + ")");
                                            return [];
                                        } else {
                                            return [this.primary].concat(data_packets);
                                        }
                                        break;
                                    case T.subkey_binding:
                                    case T.primary_binding:
                                    case T.subkey_revocation:
                                        packets = [];
                                        if (data_packets.length !== 1) {
                                            err = new Error("Wrong number of data packets; expected only 1");
                                        } else if (this.primary == null) {
                                            err = new Error("Need a primary key for subkey signature");
                                        } else {
                                            subkey = data_packets[0];
                                            packets = [this.primary, subkey];
                                        }
                                        return packets;
                                    case T.direct:
                                        return [this.primary].concat(data_packets);
                                    default:
                                        err = new Error("cannot verify sigtype " + this.type);
                                        return [];
                                }
                            }).call(this);
                            (function(_this) {
                                return (function(__iced_k) {
                                    var _ref3;
                                    if (!((err != null) || (_this.is_third_party && _this.type === T.key_revocation))) {
                                        buffers = (function() {
                                            var _i, _len, _ref3, _results;
                                            _ref3 = this.data_packets;
                                            _results = [];
                                            for (_i = 0, _len = _ref3.length; _i < _len; _i++) {
                                                dp = _ref3[_i];
                                                _results.push(dp.to_signature_payload());
                                            }
                                            return _results;
                                        }).call(_this);
                                        data = Buffer.concat(buffers);
                                        _ref3 = _this.prepare_payload(data), payload = _ref3.payload, hvalue = _ref3.hvalue;
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/signature.iced",
                                                funcname: "Signature._verify"
                                            });
                                            _this.key.verify_unpad_and_check_hash({
                                                sig: _this.sig,
                                                hash: hvalue,
                                                hasher: _this.hasher
                                            }, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        return err = arguments[0];
                                                    };
                                                })(),
                                                lineno: 272
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(__iced_k);
                                    } else {
                                        return __iced_k();
                                    }
                                });
                            })(this)((function(_this) {
                                return function() {
                                    var _i, _len, _ref3, _ref4;
                                    if ((err == null) && (_this.key_manager != null)) {
                                        err = _this.key_manager.pgp_check_not_expired({
                                            subkey_material: _this.subkey_material,
                                            now: opts != null ? opts.now : void 0
                                        });
                                    }
                                    if (err == null) {
                                        opts || (opts = {});
                                        opts.subkey = subkey;
                                        _ref3 = _this._check_key_sig_expiration(opts), err = _ref3[0], key_expiration = _ref3[1], sig_expiration = _ref3[2];
                                        opts.subkey = null;
                                    }
                                    sig = _this;
                                    if (err == null) {
                                        SKB = packetsigs.SubkeyBinding;
                                        switch (_this.type) {
                                            case T.binary_doc:
                                            case T.canonical_text:
                                                _ref4 = _this.data_packets;
                                                for (_i = 0, _len = _ref4.length; _i < _len; _i++) {
                                                    d = _ref4[_i];
                                                    d.push_sig(new packetsigs.Data({
                                                        sig: sig
                                                    }));
                                                }
                                                break;
                                            case T.issuer:
                                            case T.persona:
                                            case T.casual:
                                            case T.positive:
                                                ps = null;
                                                if ((userid = _this.data_packets[1].to_userid()) != null) {
                                                    ps = new packetsigs.SelfSig({
                                                        type: _this.type,
                                                        userid: userid,
                                                        sig: sig
                                                    });
                                                    userid.push_sig(ps);
                                                } else if ((user_attribute = _this.data_packets[1].to_user_attribute()) != null) {
                                                    ps = new packetsigs.SelfSig({
                                                        type: _this.type,
                                                        user_attribute: user_attribute,
                                                        sig: sig,
                                                        key_expiration: key_expiration,
                                                        sig_expiration: sig_expiration
                                                    });
                                                    user_attribute.push_sig(ps);
                                                }
                                                if (ps) {
                                                    _this.primary.push_sig(ps);
                                                }
                                                break;
                                            case T.subkey_binding:
                                                subkey.push_sig(new SKB({
                                                    primary: _this.primary,
                                                    sig: sig,
                                                    direction: SKB.DOWN,
                                                    key_expiration: key_expiration,
                                                    sig_expiration: sig_expiration
                                                }));
                                                break;
                                            case T.primary_binding:
                                                subkey.push_sig(new SKB({
                                                    primary: _this.primary,
                                                    sig: sig,
                                                    direction: SKB.UP,
                                                    key_expiration: key_expiration,
                                                    sig_expiration: sig_expiration
                                                }));
                                                break;
                                            case T.subkey_revocation:
                                                subkey.mark_revoked(sig);
                                                break;
                                            case T.key_revocation:
                                                if (_this.issuer_matches_key(_this.primary)) {
                                                    _this.primary.mark_revoked(sig);
                                                } else {
                                                    _this.primary.add_designated_revocation(sig);
                                                }
                                                break;
                                            case T.direct:
                                                if (fp = _this.subpacket_index.hashed[S.revocation_key]) {
                                                    _this.primary.add_designee(fp);
                                                }
                                                break;
                                            case T.certificate_revocation:
                                                if ((userid = _this.data_packets[1].to_userid()) != null) {
                                                    userid.mark_revoked(sig);
                                                }
                                                break;
                                            default:
                                                err = new Error("Got unknown signature type=" + _this.type);
                                        }
                                    }
                                    return cb(err);
                                };
                            })(this));
                        };

                        Signature.prototype._third_party_verify = function(key, cb) {
                            var buffers, data, dp, err, hvalue, issuer, keyid, payload, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref3;
                            __iced_k = __iced_k_noop;
                            ___iced_passed_deferral = iced.findDeferral(arguments);
                            if (!bufeq_secure(issuer = this.get_issuer_key_id(), keyid = key.get_key_id())) {
                                return cb(new Error("Key id does not match: " + (issuer.toString('hex')) + " != " + (keyid.toString('hex'))));
                            }
                            buffers = (function() {
                                var _i, _len, _ref3, _results;
                                _ref3 = this.data_packets;
                                _results = [];
                                for (_i = 0, _len = _ref3.length; _i < _len; _i++) {
                                    dp = _ref3[_i];
                                    _results.push(dp.to_signature_payload());
                                }
                                return _results;
                            }).call(this);
                            data = Buffer.concat(buffers);
                            _ref3 = this.prepare_payload(data), payload = _ref3.payload, hvalue = _ref3.hvalue;
                            (function(_this) {
                                return (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/openpgp/packet/signature.iced",
                                        funcname: "Signature._third_party_verify"
                                    });
                                    key.key.verify_unpad_and_check_hash({
                                        sig: _this.sig,
                                        hash: hvalue,
                                        hasher: _this.hasher
                                    }, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return err = arguments[0];
                                            };
                                        })(),
                                        lineno: 348
                                    }));
                                    __iced_deferrals._fulfill();
                                });
                            })(this)((function(_this) {
                                return function() {
                                    return cb(err);
                                };
                            })(this));
                        };

                        Signature.prototype.is_signature = function() {
                            return true;
                        };

                        Signature.prototype.issuer_matches_key = function(key) {
                            var fp;
                            if ((fp = this.get_issuer_fingerprint()) != null) {
                                if (!bufeq_secure(fp, this.primary.get_fingerprint())) {
                                    return false;
                                }
                            }
                            return bufeq_secure(this.get_issuer_key_id(), this.primary.get_key_id());
                        };

                        Signature.prototype.when_generated = function() {
                            var _ref3;
                            return (_ref3 = this.subpacket_index.hashed[S.creation_time]) != null ? _ref3.time : void 0;
                        };

                        Signature.prototype.get_key_expires = function() {
                            var _ref3;
                            return (_ref3 = this.subpacket_index.hashed[S.key_expiration_time]) != null ? _ref3.time : void 0;
                        };

                        Signature.prototype.get_sig_expires = function() {
                            var _ref3;
                            return (_ref3 = this.subpacket_index.hashed[S.expiration_time]) != null ? _ref3.time : void 0;
                        };

                        Signature.prototype.time_primary_pair = function() {
                            var T, _ref3, _ref4;
                            T = C.sig_types;
                            if ((_ref3 = this.type) === T.issuer || _ref3 === T.persona || _ref3 === T.casual || _ref3 === T.positive) {
                                return [this.when_generated(), !!((_ref4 = this.subpacket_index.hashed[S.primary_user_id]) != null ? _ref4.flag : void 0)];
                            } else {
                                return null;
                            }
                        };

                        Signature.prototype._check_key_sig_expiration = function(opts) {
                            var T, err, key_creation, key_expiration, key_expiration_packet, n, now, sig_creation_packet, sig_expiration, sig_expiration_packet, _ref3;
                            err = null;
                            T = C.sig_types;
                            key_expiration = 0;
                            sig_expiration = 0;
                            if ((_ref3 = this.type) === T.issuer || _ref3 === T.persona || _ref3 === T.casual || _ref3 === T.positive || _ref3 === T.subkey_binding || _ref3 === T.primary_binding) {
                                key_creation = (opts.subkey || this.primary).timestamp;
                                key_expiration_packet = this.subpacket_index.hashed[S.key_expiration_time];
                                sig_creation_packet = this.subpacket_index.hashed[S.creation_time];
                                sig_expiration_packet = this.subpacket_index.hashed[S.sig_expiration_time];
                                now = (n = opts != null ? opts.now : void 0) != null ? n : unix_time();
                                if ((key_creation != null) && (key_expiration_packet != null ? key_expiration_packet.time : void 0)) {
                                    key_expiration = key_creation + key_expiration_packet.time;
                                }
                                if ((sig_creation_packet != null) && (sig_expiration_packet != null ? sig_expiration_packet.time : void 0)) {
                                    sig_expiration = sig_creation_packet.time + sig_expiration_packet.time;
                                }
                                if (key_expiration && !opts.time_travel && now > key_expiration) {
                                    err = new Error("Key expired " + (now - key_expiration) + "s ago");
                                }
                                if (sig_expiration && !opts.time_travel && now > sig_expiration) {
                                    err = new Error("Sig expired " + (now - key_expiration) + "s ago");
                                }
                            }
                            return [err, key_expiration, sig_expiration];
                        };

                        Signature.prototype.get_key_flags = function() {
                            var _ref3, _ref4, _ref5;
                            return ((_ref3 = this.subpacket_index) != null ? (_ref4 = _ref3.hashed) != null ? (_ref5 = _ref4[C.sig_subpacket.key_flags]) != null ? _ref5.all_flags() : void 0 : void 0 : void 0) || 0;
                        };

                        Signature.prototype.get_issuer_key_id = function() {
                            var _ref3, _ref4;
                            return (_ref3 = this.subpacket_index) != null ? (_ref4 = _ref3.all[C.sig_subpacket.issuer]) != null ? _ref4.id : void 0 : void 0;
                        };

                        Signature.prototype.get_issuer_fingerprint = function() {
                            var _ref3;
                            return (_ref3 = this.subpacket_index.all[S.issuer_fingerprint]) != null ? _ref3.fingerprint : void 0;
                        };

                        return Signature;

                    })(Packet);

                    SubPacket = (function() {
                        function SubPacket(type) {
                            this.type = type;
                            this.critical = false;
                            this.five_byte_len = false;
                        }

                        SubPacket.prototype.set_opts = function(d) {
                            var k, v;
                            for (k in d) {
                                v = d[k];
                                this[k] = v;
                            }
                            return true;
                        };

                        SubPacket.prototype.to_buffer = function() {
                            var inner;
                            inner = this._v_to_buffer();
                            return Buffer.concat([encode_length(inner.length + 1, this.five_byte_len), uint_to_buffer(8, this.type | (this.critical ? 0x80 : 0x00)), inner]);
                        };

                        SubPacket.prototype.to_sig = function() {
                            return null;
                        };

                        SubPacket.prototype.export_to_option = function() {
                            return null;
                        };

                        return SubPacket;

                    })();

                    Experimental = (function(_super) {
                        __extends(Experimental, _super);

                        function Experimental(buf, type) {
                            this.buf = buf;
                            this.type = type;
                        }

                        Experimental.parse = function(slice, type) {
                            return new Experimental(slice.consume_rest_to_buffer(), type);
                        };

                        Experimental.prototype._v_to_buffer = function() {
                            return this.buf;
                        };

                        return Experimental;

                    })(SubPacket);

                    Time = (function(_super) {
                        __extends(Time, _super);

                        function Time(type, time) {
                            this.time = time;
                            this.never_expires = this.time === 0;
                            Time.__super__.constructor.call(this, type);
                        }

                        Time.parse = function(slice, klass) {
                            return new klass(slice.read_uint32());
                        };

                        Time.prototype._v_to_buffer = function() {
                            return uint_to_buffer(32, this.time);
                        };

                        return Time;

                    })(SubPacket);

                    Preference = (function(_super) {
                        __extends(Preference, _super);

                        function Preference(type, v) {
                            var e, _i, _len, _ref3;
                            this.v = v;
                            Preference.__super__.constructor.call(this, type);
                            _ref3 = this.v;
                            for (_i = 0, _len = _ref3.length; _i < _len; _i++) {
                                e = _ref3[_i];
                                assert(e != null);
                            }
                        }

                        Preference.parse = function(slice, klass) {
                            var c, v;
                            v = (function() {
                                var _i, _len, _ref3, _results;
                                _ref3 = slice.consume_rest_to_buffer();
                                _results = [];
                                for (_i = 0, _len = _ref3.length; _i < _len; _i++) {
                                    c = _ref3[_i];
                                    _results.push(c);
                                }
                                return _results;
                            })();
                            return new klass(v);
                        };

                        Preference.prototype._v_to_buffer = function() {
                            var e;
                            return new Buffer((function() {
                                var _i, _len, _ref3, _results;
                                _ref3 = this.v;
                                _results = [];
                                for (_i = 0, _len = _ref3.length; _i < _len; _i++) {
                                    e = _ref3[_i];
                                    _results.push(e);
                                }
                                return _results;
                            }).call(this));
                        };

                        return Preference;

                    })(SubPacket);

                    CreationTime = (function(_super) {
                        __extends(CreationTime, _super);

                        function CreationTime(t) {
                            CreationTime.__super__.constructor.call(this, S.creation_time, t);
                        }

                        CreationTime.parse = function(slice) {
                            return Time.parse(slice, CreationTime);
                        };

                        return CreationTime;

                    })(Time);

                    ExpirationTime = (function(_super) {
                        __extends(ExpirationTime, _super);

                        function ExpirationTime(t) {
                            ExpirationTime.__super__.constructor.call(this, S.expiration_time, t);
                        }

                        ExpirationTime.parse = function(slice) {
                            return Time.parse(slice, ExpirationTime);
                        };

                        return ExpirationTime;

                    })(Time);

                    Exportable = (function(_super) {
                        __extends(Exportable, _super);

                        function Exportable(flag) {
                            this.flag = flag;
                            Exportable.__super__.constructor.call(this, S.exportable_certificate);
                        }

                        Exportable.parse = function(slice) {
                            return new Exportable(slice.read_uint8());
                        };

                        Exportable.prototype._v_to_buffer = function() {
                            return uint_to_buffer(8, this.flag);
                        };

                        return Exportable;

                    })(SubPacket);

                    Trust = (function(_super) {
                        __extends(Trust, _super);

                        function Trust(level, amount) {
                            this.level = level;
                            this.amount = amount;
                            Trust.__super__.constructor.call(this, S.trust_signature);
                        }

                        Trust.parse = function(slice) {
                            return new Trust(slice.read_uint8(), slice.read_uint8());
                        };

                        Trust.prototype._v_to_buffer = function() {
                            return Buffer.concat([uint_to_buffer(8, this.level), uint_to_buffer(8, this.amount)]);
                        };

                        return Trust;

                    })(SubPacket);

                    RegularExpression = (function(_super) {
                        __extends(RegularExpression, _super);

                        function RegularExpression(re) {
                            this.re = re;
                            RegularExpression.__super__.constructor.call(this, S.regular_expression);
                        }

                        RegularExpression.parse = function(slice) {
                            var ret;
                            ret = new RegularExpression(slice.consume_rest_to_buffer().toString('utf8'));
                            return ret;
                        };

                        RegularExpression.prototype._v_to_buffer = function() {
                            return new Buffer(this.re, 'utf8');
                        };

                        return RegularExpression;

                    })(SubPacket);

                    Revocable = (function(_super) {
                        __extends(Revocable, _super);

                        function Revocable(flag) {
                            this.flag = flag;
                            Revocable.__super__.constructor.call(this, S.revocable);
                        }

                        Revocable.parse = function(slice) {
                            return new Revocable(slice.read_uint8());
                        };

                        Revocable.prototype._v_to_buffer = function() {
                            return uint_to_buffer(8, this.flag);
                        };

                        return Revocable;

                    })(SubPacket);

                    KeyExpirationTime = (function(_super) {
                        __extends(KeyExpirationTime, _super);

                        function KeyExpirationTime(t) {
                            KeyExpirationTime.__super__.constructor.call(this, S.key_expiration_time, t);
                        }

                        KeyExpirationTime.parse = function(slice) {
                            return Time.parse(slice, KeyExpirationTime);
                        };

                        return KeyExpirationTime;

                    })(Time);

                    PreferredSymmetricAlgorithms = (function(_super) {
                        __extends(PreferredSymmetricAlgorithms, _super);

                        function PreferredSymmetricAlgorithms(v) {
                            PreferredSymmetricAlgorithms.__super__.constructor.call(this, S.preferred_symmetric_algorithms, v);
                        }

                        PreferredSymmetricAlgorithms.parse = function(slice) {
                            return Preference.parse(slice, PreferredSymmetricAlgorithms);
                        };

                        return PreferredSymmetricAlgorithms;

                    })(Preference);

                    RevocationKey = (function(_super) {
                        __extends(RevocationKey, _super);

                        function RevocationKey(key_class, alg, fingerprint) {
                            this.key_class = key_class;
                            this.alg = alg;
                            this.fingerprint = fingerprint;
                            RevocationKey.__super__.constructor.call(this, S.revocation_key);
                        }

                        RevocationKey.parse = function(slice) {
                            var fp, ka, kc;
                            kc = slice.read_uint8();
                            ka = slice.read_uint8();
                            fp = slice.read_buffer(SHA1.output_length);
                            return new RevocationKey(kc, ka, fp);
                        };

                        RevocationKey.prototype._v_to_buffer = function() {
                            return Buffer.concat([uint_to_buffer(8, this.key_class), uint_to_buffer(8, this.alg), new Buffer(this.fingerprint)]);
                        };

                        return RevocationKey;

                    })(SubPacket);

                    Issuer = (function(_super) {
                        __extends(Issuer, _super);

                        function Issuer(id) {
                            this.id = id;
                            Issuer.__super__.constructor.call(this, S.issuer);
                        }

                        Issuer.parse = function(slice) {
                            return new Issuer(slice.read_buffer(8));
                        };

                        Issuer.prototype._v_to_buffer = function() {
                            return new Buffer(this.id);
                        };

                        return Issuer;

                    })(SubPacket);

                    NotationData = (function(_super) {
                        __extends(NotationData, _super);

                        function NotationData(flags, name, value) {
                            this.flags = flags;
                            this.name = name;
                            this.value = value;
                            NotationData.__super__.constructor.call(this, S.notation_data);
                        }

                        NotationData.parse = function(slice) {
                            var flags, name, nl, value, vl;
                            flags = slice.read_uint32();
                            nl = slice.read_uint16();
                            vl = slice.read_uint16();
                            name = slice.read_buffer(nl);
                            value = slice.read_buffer(vl);
                            return new NotationData(flags, name, value);
                        };

                        NotationData.prototype._v_to_buffer = function() {
                            return Buffer.concat([uint_to_buffer(32, this.flags), uint_to_buffer(16, this.name.length), uint_to_buffer(16, this.value.length), new Buffer(this.name), new Buffer(this.value)]);
                        };

                        return NotationData;

                    })(SubPacket);

                    PreferredHashAlgorithms = (function(_super) {
                        __extends(PreferredHashAlgorithms, _super);

                        function PreferredHashAlgorithms(v) {
                            PreferredHashAlgorithms.__super__.constructor.call(this, S.preferred_hash_algorithms, v);
                        }

                        PreferredHashAlgorithms.parse = function(slice) {
                            return Preference.parse(slice, PreferredHashAlgorithms);
                        };

                        return PreferredHashAlgorithms;

                    })(Preference);

                    PreferredCompressionAlgorithms = (function(_super) {
                        __extends(PreferredCompressionAlgorithms, _super);

                        function PreferredCompressionAlgorithms(v) {
                            PreferredCompressionAlgorithms.__super__.constructor.call(this, S.preferred_compression_algorithms, v);
                        }

                        PreferredCompressionAlgorithms.parse = function(slice) {
                            return Preference.parse(slice, PreferredCompressionAlgorithms);
                        };

                        return PreferredCompressionAlgorithms;

                    })(Preference);

                    KeyServerPreferences = (function(_super) {
                        __extends(KeyServerPreferences, _super);

                        function KeyServerPreferences(v) {
                            KeyServerPreferences.__super__.constructor.call(this, S.key_server_preferences, v);
                        }

                        KeyServerPreferences.parse = function(slice) {
                            return Preference.parse(slice, KeyServerPreferences);
                        };

                        return KeyServerPreferences;

                    })(Preference);

                    Features = (function(_super) {
                        __extends(Features, _super);

                        function Features(v) {
                            Features.__super__.constructor.call(this, S.features, v);
                        }

                        Features.parse = function(slice) {
                            return Preference.parse(slice, Features);
                        };

                        return Features;

                    })(Preference);

                    PreferredKeyServer = (function(_super) {
                        __extends(PreferredKeyServer, _super);

                        function PreferredKeyServer(server) {
                            this.server = server;
                            PreferredKeyServer.__super__.constructor.call(this, S.preferred_key_server);
                        }

                        PreferredKeyServer.parse = function(slice) {
                            return new PreferredKeyServer(slice.consume_rest_to_buffer());
                        };

                        PreferredKeyServer.prototype._v_to_buffer = function() {
                            return this.server;
                        };

                        return PreferredKeyServer;

                    })(SubPacket);

                    PrimaryUserId = (function(_super) {
                        __extends(PrimaryUserId, _super);

                        function PrimaryUserId(flag) {
                            this.flag = flag;
                            PrimaryUserId.__super__.constructor.call(this, S.primary_user_id);
                        }

                        PrimaryUserId.parse = function(slice) {
                            return new PrimaryUserId(slice.read_uint8());
                        };

                        PrimaryUserId.prototype._v_to_buffer = function() {
                            return uint_to_buffer(8, this.flag);
                        };

                        return PrimaryUserId;

                    })(SubPacket);

                    PolicyURI = (function(_super) {
                        __extends(PolicyURI, _super);

                        function PolicyURI(flag) {
                            this.flag = flag;
                            PolicyURI.__super__.constructor.call(this, S.policy_uri);
                        }

                        PolicyURI.parse = function(slice) {
                            return new PolicyURI(slice.consume_rest_to_buffer());
                        };

                        PolicyURI.prototype._v_to_buffer = function() {
                            return this.flag;
                        };

                        return PolicyURI;

                    })(SubPacket);

                    KeyFlags = (function(_super) {
                        __extends(KeyFlags, _super);

                        function KeyFlags(v) {
                            KeyFlags.__super__.constructor.call(this, S.key_flags, v);
                        }

                        KeyFlags.parse = function(slice) {
                            return Preference.parse(slice, KeyFlags);
                        };

                        KeyFlags.prototype.all_flags = function() {
                            var e, ret, _i, _len, _ref3;
                            ret = 0;
                            _ref3 = this.v;
                            for (_i = 0, _len = _ref3.length; _i < _len; _i++) {
                                e = _ref3[_i];
                                ret |= e;
                            }
                            return ret;
                        };

                        return KeyFlags;

                    })(Preference);

                    SignersUserID = (function(_super) {
                        __extends(SignersUserID, _super);

                        function SignersUserID(uid) {
                            this.uid = uid;
                            SignersUserID.__super__.constructor.call(this, S.signers_user_id);
                        }

                        SignersUserID.parse = function(slice) {
                            return new SignersUserID(slice.consume_rest_to_buffer());
                        };

                        SignersUserID.prototype._v_to_buffer = function() {
                            return this.uid;
                        };

                        return SignersUserID;

                    })(SubPacket);

                    ReasonForRevocation = (function(_super) {
                        __extends(ReasonForRevocation, _super);

                        function ReasonForRevocation(flag, reason) {
                            this.flag = flag;
                            this.reason = reason;
                            ReasonForRevocation.__super__.constructor.call(this, S.reason_for_revocation);
                        }

                        ReasonForRevocation.parse = function(slice) {
                            var flag, reason;
                            flag = slice.read_uint8();
                            reason = slice.consume_rest_to_buffer();
                            return new ReasonForRevocation(flag, reason);
                        };

                        ReasonForRevocation.prototype._v_to_buffer = function() {
                            return Buffer.concat([uint_to_buffer(8, this.flag), this.reason]);
                        };

                        return ReasonForRevocation;

                    })(SubPacket);

                    SignatureTarget = (function(_super) {
                        __extends(SignatureTarget, _super);

                        function SignatureTarget(pub_key_alg, hasher, hval) {
                            this.pub_key_alg = pub_key_alg;
                            this.hasher = hasher;
                            this.hval = hval;
                            SignatureTarget.__super__.constructor.call(this, S.signature_target);
                        }

                        SignatureTarget.parse = function(slice) {
                            var hasher, hval, pka;
                            pka = slice.read_uint8();
                            hasher = alloc_or_throw(slice.read_uint8());
                            hval = slice.read_buffer(hasher.output_length);
                            return new SignatureTarget(pka, hasher, hval);
                        };

                        SignatureTarget.prototype._v_to_buffer = function() {
                            return Buffer.concat([uint_to_buffer(8, this.pub_key_alg), uint_to_buffer(8, this.hasher.type), this.hval]);
                        };

                        return SignatureTarget;

                    })(SubPacket);

                    EmbeddedSignature = (function(_super) {
                        __extends(EmbeddedSignature, _super);

                        function EmbeddedSignature(_arg) {
                            this.sig = _arg.sig, this.rawsig = _arg.rawsig;
                            EmbeddedSignature.__super__.constructor.call(this, S.embedded_signature);
                        }

                        EmbeddedSignature.prototype._v_to_buffer = function() {
                            return this.rawsig;
                        };

                        EmbeddedSignature.prototype.to_sig = function() {
                            return this.sig;
                        };

                        EmbeddedSignature.parse = function(slice) {
                            var rawsig, sig;
                            rawsig = slice.peek_rest_to_buffer();
                            sig = Signature.parse(slice);
                            return new EmbeddedSignature({
                                sig: sig,
                                rawsig: rawsig
                            });
                        };

                        return EmbeddedSignature;

                    })(SubPacket);

                    IssuerFingerprint = (function(_super) {
                        __extends(IssuerFingerprint, _super);

                        function IssuerFingerprint(n, fingerprint) {
                            this.n = n;
                            this.fingerprint = fingerprint;
                            IssuerFingerprint.__super__.constructor.call(this, S.issuer_fingerprint);
                        }

                        IssuerFingerprint.parse = function(slice) {
                            var fp, n;
                            n = slice.read_uint8();
                            fp = slice.consume_rest_to_buffer();
                            return new IssuerFingerprint(n, fp);
                        };

                        IssuerFingerprint.prototype._v_to_buffer = function() {
                            return Buffer.concat([uint_to_buffer(8, this.n), this.fingerprint]);
                        };

                        return IssuerFingerprint;

                    })(SubPacket);

                    exports.Signature = Signature;

                    Parser = (function() {
                        function Parser(slice) {
                            this.slice = slice;
                        }

                        Parser.prototype.parse_v2_or_v3 = function(v, klass) {
                            var o;
                            if (this.slice.read_uint8() !== 5) {
                                throw new error("Bad one-octet length");
                            }
                            o = {};
                            o.type = this.slice.read_uint8();
                            o.time = this.slice.read_uint32();
                            o.sig_data = this.slice.peek_rest_to_buffer();
                            o.key_id = this.slice.read_buffer(8);
                            o.public_key_class = asymmetric.get_class(this.slice.read_uint8());
                            o.hasher = alloc_or_throw(this.slice.read_uint8());
                            o.signed_hash_value_hash = this.slice.read_uint16();
                            o.sig = o.public_key_class.parse_sig(this.slice);
                            o.version = v;
                            return new klass(o);
                        };

                        Parser.prototype.parse_v4 = function() {
                            var end, hashed_subpacket_count, o, unhashed_subpacket_count;
                            o = {};
                            o.type = this.slice.read_uint8();
                            o.public_key_class = asymmetric.get_class(this.slice.read_uint8());
                            o.hasher = alloc_or_throw(this.slice.read_uint8());
                            hashed_subpacket_count = this.slice.read_uint16();
                            end = this.slice.i + hashed_subpacket_count;
                            o.sig_data = this.slice.peek_to_buffer(hashed_subpacket_count);
                            o.hashed_subpackets = ((function() {
                                var _results;
                                _results = [];
                                while (this.slice.i < end) {
                                    _results.push(this.parse_subpacket());
                                }
                                return _results;
                            }).call(this));
                            unhashed_subpacket_count = this.slice.read_uint16();
                            end = this.slice.i + unhashed_subpacket_count;
                            o.unhashed_subpackets = ((function() {
                                var _results;
                                _results = [];
                                while (this.slice.i < end) {
                                    _results.push(this.parse_subpacket());
                                }
                                return _results;
                            }).call(this));
                            o.signed_hash_value_hash = this.slice.read_uint16();
                            o.sig = o.public_key_class.parse_sig(this.slice);
                            o.version = 4;
                            return new Signature(o);
                        };

                        Parser.prototype.parse_subpacket = function() {
                            var critical, end, five_byte_len, klass, len, raw_type, ret, type, _ref3;
                            _ref3 = this.slice.read_v4_length(), len = _ref3[0], five_byte_len = _ref3[1];
                            raw_type = this.slice.read_uint8();
                            type = raw_type & 0x7f;
                            critical = !!(raw_type & 0x80);
                            end = this.slice.clamp(len - 1);
                            klass = (function() {
                                switch (type) {
                                    case S.creation_time:
                                        return CreationTime;
                                    case S.expiration_time:
                                        return ExpirationTime;
                                    case S.exportable_certificate:
                                        return Exportable;
                                    case S.trust_signature:
                                        return Trust;
                                    case S.regular_expression:
                                        return RegularExpression;
                                    case S.revocable:
                                        return Revocable;
                                    case S.key_expiration_time:
                                        return KeyExpirationTime;
                                    case S.preferred_symmetric_algorithms:
                                        return PreferredSymmetricAlgorithms;
                                    case S.revocation_key:
                                        return RevocationKey;
                                    case S.issuer:
                                        return Issuer;
                                    case S.notation_data:
                                        return NotationData;
                                    case S.preferred_hash_algorithms:
                                        return PreferredHashAlgorithms;
                                    case S.preferred_compression_algorithms:
                                        return PreferredCompressionAlgorithms;
                                    case S.key_server_preferences:
                                        return KeyServerPreferences;
                                    case S.preferred_key_server:
                                        return PreferredKeyServer;
                                    case S.primary_user_id:
                                        return PrimaryUserId;
                                    case S.policy_uri:
                                        return PolicyURI;
                                    case S.key_flags:
                                        return KeyFlags;
                                    case S.signers_user_id:
                                        return SignersUserID;
                                    case S.reason_for_revocation:
                                        return ReasonForRevocation;
                                    case S.features:
                                        return Features;
                                    case S.signature_target:
                                        return SignatureTarget;
                                    case S.embedded_signature:
                                        return EmbeddedSignature;
                                    case S.issuer_fingerprint:
                                        return IssuerFingerprint;
                                    default:
                                        if (type >= S.experimental_low && type <= S.experimental_high) {
                                            return Experimental;
                                        } else {
                                            throw new Error("Unknown signature subpacket: " + type);
                                        }
                                }
                            })();
                            ret = klass.parse(this.slice, type);
                            ret.set_opts({
                                critical: critical,
                                five_byte_len: five_byte_len
                            });
                            this.slice.unclamp(end);
                            return ret;
                        };

                        Parser.prototype.parse = function() {
                            var version;
                            version = this.slice.read_uint8();
                            switch (version) {
                                case C.versions.signature.V2:
                                    return this.parse_v2_or_v3(version, Signature_v2);
                                case C.versions.signature.V3:
                                    return this.parse_v2_or_v3(version, Signature_v3);
                                case C.versions.signature.V4:
                                    return this.parse_v4();
                                default:
                                    throw new Error("Unknown signature version: " + version);
                            }
                        };

                        return Parser;

                    })();

                    exports.CreationTime = CreationTime;

                    exports.KeyFlags = KeyFlags;

                    exports.KeyExpirationTime = KeyExpirationTime;

                    exports.PreferredSymmetricAlgorithms = PreferredSymmetricAlgorithms;

                    exports.PreferredHashAlgorithms = PreferredHashAlgorithms;

                    exports.PreferredCompressionAlgorithms = PreferredCompressionAlgorithms;

                    exports.Features = Features;

                    exports.KeyServerPreferences = KeyServerPreferences;

                    exports.Issuer = Issuer;

                    exports.EmbeddedSignature = EmbeddedSignature;

                    exports.PrimaryUserId = PrimaryUserId;

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../../asymmetric": 1,
            "../../const": 5,
            "../../hash": 16,
            "../../util": 72,
            "../buffer": 37,
            "../util": 62,
            "./base": 47,
            "./packetsigs": 53,
            "assert": 87,
            "buffer": 126,
            "iced-error": 179,
            "iced-runtime": 183,
            "util": 302
        }],
        56: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var AES, C, Packet, SHA1, SHA256, UserAttribute, bufferify, encrypt, native_rng, parse, triplesec, uint_to_buffer, _ref, _ref1,
                        __hasProp = {}.hasOwnProperty,
                        __extends = function(child, parent) {
                            for (var key in parent) {
                                if (__hasProp.call(parent, key)) child[key] = parent[key];
                            }

                            function ctor() {
                                this.constructor = child;
                            }
                            ctor.prototype = parent.prototype;
                            child.prototype = new ctor();
                            child.__super__ = parent.prototype;
                            return child;
                        };

                    C = require('../../const').openpgp;

                    triplesec = require('triplesec');

                    _ref = triplesec.hash, SHA1 = _ref.SHA1, SHA256 = _ref.SHA256;

                    AES = triplesec.ciphers.AES;

                    native_rng = triplesec.prng.native_rng;

                    _ref1 = require('../../util'), bufferify = _ref1.bufferify, uint_to_buffer = _ref1.uint_to_buffer;

                    encrypt = require('../cfb').encrypt;

                    Packet = require('./base').Packet;

                    parse = require('pgp-utils').userid.parse;

                    UserAttribute = (function(_super) {
                        __extends(UserAttribute, _super);

                        function UserAttribute(data) {
                            this.data = data;
                            UserAttribute.__super__.constructor.call(this);
                        }

                        UserAttribute.prototype.write = function() {
                            return this.frame_packet(C.packet_tags.user_attribute, this.data);
                        };

                        UserAttribute.parse = function(slice) {
                            return new UserAttribute(slice.consume_rest_to_buffer());
                        };

                        UserAttribute.prototype.to_user_attribute = function() {
                            return this;
                        };

                        UserAttribute.prototype.to_signature_payload = function() {
                            return Buffer.concat([new Buffer([C.signatures.user_attribute]), uint_to_buffer(32, this.data.length), this.data]);
                        };

                        return UserAttribute;

                    })(Packet);

                    exports.UserAttribute = UserAttribute;

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../../const": 5,
            "../../util": 72,
            "../cfb": 40,
            "./base": 47,
            "buffer": 126,
            "pgp-utils": 229,
            "triplesec": 282
        }],
        57: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var AES, C, Packet, SHA1, SHA256, UserID, bufferify, encrypt, native_rng, parse, triplesec, uint_to_buffer, _ref, _ref1,
                        __hasProp = {}.hasOwnProperty,
                        __extends = function(child, parent) {
                            for (var key in parent) {
                                if (__hasProp.call(parent, key)) child[key] = parent[key];
                            }

                            function ctor() {
                                this.constructor = child;
                            }
                            ctor.prototype = parent.prototype;
                            child.prototype = new ctor();
                            child.__super__ = parent.prototype;
                            return child;
                        };

                    C = require('../../const').openpgp;

                    triplesec = require('triplesec');

                    _ref = triplesec.hash, SHA1 = _ref.SHA1, SHA256 = _ref.SHA256;

                    AES = triplesec.ciphers.AES;

                    native_rng = triplesec.prng.native_rng;

                    _ref1 = require('../../util'), bufferify = _ref1.bufferify, uint_to_buffer = _ref1.uint_to_buffer;

                    encrypt = require('../cfb').encrypt;

                    Packet = require('./base').Packet;

                    parse = require('pgp-utils').userid.parse;

                    UserID = (function(_super) {
                        __extends(UserID, _super);

                        function UserID(userid, components) {
                            this.components = components != null ? components : null;
                            this.userid = bufferify(userid);
                            if (this.compontents == null) {
                                this._parse();
                            }
                            UserID.__super__.constructor.call(this);
                            this._time_primary_pair = null;
                            this.primary = false;
                            this.most_recent_sig = null;
                        }

                        UserID.prototype.utf8 = function() {
                            return this.userid.toString('utf8');
                        };

                        UserID.prototype.write = function() {
                            return this.frame_packet(C.packet_tags.userid, this.userid);
                        };

                        UserID.parse = function(slice) {
                            return new UserID(slice.consume_rest_to_buffer());
                        };

                        UserID.prototype.to_userid = function() {
                            return this;
                        };

                        UserID.prototype.cmp = function(b) {
                            var x, y;
                            x = this.utf8();
                            y = b.utf8();
                            if (x < y) {
                                return -1;
                            } else if (x === y) {
                                return 0;
                            } else {
                                return 1;
                            }
                        };

                        UserID.prototype.to_signature_payload = function() {
                            return Buffer.concat([new Buffer([C.signatures.userid]), uint_to_buffer(32, this.userid.length), this.userid]);
                        };

                        UserID.prototype._parse = function() {
                            var c;
                            if ((c = parse(this.utf8())) != null) {
                                return this.components = c;
                            }
                        };

                        UserID.prototype.get_username = function() {
                            var _ref2;
                            return (_ref2 = this.components) != null ? _ref2.username : void 0;
                        };

                        UserID.prototype.get_comment = function() {
                            var _ref2;
                            return (_ref2 = this.components) != null ? _ref2.comment : void 0;
                        };

                        UserID.prototype.get_email = function() {
                            var _ref2;
                            return (_ref2 = this.components) != null ? _ref2.email : void 0;
                        };

                        UserID.prototype.time_primary_pair = function() {
                            var max, p, pairs, ret, s, _i, _len;
                            if (this._time_primary_pair == null) {
                                pairs = (function() {
                                    var _i, _len, _ref2, _ref3, _results;
                                    _ref2 = this.get_psc().get_self_sigs();
                                    _results = [];
                                    for (_i = 0, _len = _ref2.length; _i < _len; _i++) {
                                        s = _ref2[_i];
                                        _results.push(s != null ? (_ref3 = s.sig) != null ? _ref3.time_primary_pair() : void 0 : void 0);
                                    }
                                    return _results;
                                }).call(this);
                                max = null;
                                ret = [null, null];
                                for (_i = 0, _len = pairs.length; _i < _len; _i++) {
                                    p = pairs[_i];
                                    if (!(p != null)) {
                                        continue;
                                    }
                                    if (p[0] && ((ret[0] == null) || (ret[0] < p[0]))) {
                                        ret[0] = p[0];
                                    }
                                    if (p[1] && ((ret[1] == null) || (ret[1] < p[0]))) {
                                        ret[1] = p[0];
                                    }
                                }
                                this._time_primary_pair = ret;
                                this.most_recent_sig = ret[0];
                            }
                            return this._time_primary_pair;
                        };

                        UserID.make = function(components) {
                            var c, comment, userid;
                            comment = (c = components.comment) != null ? "(" + c + ") " : "";
                            userid = "" + components.username + " " + comment + "<" + components.email + ">";
                            return new UserID(userid, components);
                        };

                        UserID.prototype.get_framed_signature_output = function() {
                            var _ref2, _ref3, _ref4;
                            return (_ref2 = this.get_psc()) != null ? (_ref3 = _ref2.get_self_sig()) != null ? (_ref4 = _ref3.sig) != null ? _ref4.get_framed_output() : void 0 : void 0 : void 0;
                        };

                        UserID.prototype.mark_revoked = function(sig) {
                            return this.revocation = sig;
                        };

                        UserID.prototype.is_revoked = function() {
                            return this.revocation != null;
                        };

                        return UserID;

                    })(Packet);

                    exports.UserID = UserID;

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../../const": 5,
            "../../util": 72,
            "../cfb": 40,
            "./base": 47,
            "buffer": 126,
            "pgp-utils": 229,
            "triplesec": 282
        }],
        58: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var C, Compressed, Generic, KeyMaterial, Literal, MessageParser, OnePassSignature, PKESK, PacketParser, SEIPD, Signature, SlicerBuffer, UserAttribute, UserID, inspect, parse, util, _ref;

                    util = require('../util');

                    SlicerBuffer = require('./buffer').SlicerBuffer;

                    C = require('../const').openpgp;

                    KeyMaterial = require('./packet/keymaterial').KeyMaterial;

                    Signature = require('./packet/signature').Signature;

                    _ref = require('./packet/sess'), SEIPD = _ref.SEIPD, PKESK = _ref.PKESK;

                    UserID = require('./packet/userid').UserID;

                    UserAttribute = require('./packet/user_attribute').UserAttribute;

                    Compressed = require('./packet/compressed').Compressed;

                    Generic = require('./packet/generic').Generic;

                    OnePassSignature = require('./packet/one_pass_sig').OnePassSignature;

                    Literal = require('./packet/literal').Literal;

                    inspect = require('util').inspect;

                    MessageParser = (function() {
                        function MessageParser(slice) {
                            this.slice = slice;
                        }

                        MessageParser.prototype.parse = function() {
                            var _results;
                            _results = [];
                            while (this.slice.rem()) {
                                _results.push(this.parse_packet());
                            }
                            return _results;
                        };

                        MessageParser.prototype.parse_packet = function() {
                            return (new PacketParser(this.slice)).parse();
                        };

                        return MessageParser;

                    })();

                    PacketParser = (function() {
                        function PacketParser(slice) {
                            this.slice = slice;
                            this.body = null;
                            this.real_packet_len = null;
                            this.tag = null;
                            this.len = null;
                            this.header_len = null;
                        }

                        PacketParser.prototype.parse_header = function() {
                            this.parse_tag_and_len();
                            this.header_len || (this.header_len = this.slice.offset());
                            this.body || (this.body = new SlicerBuffer(this.slice.read_buffer(this.len)));
                            this.real_packet_len || (this.real_packet_len = this.len);
                            return this.slice.unclamp();
                        };

                        PacketParser.prototype.parse = function() {
                            var ret;
                            this.parse_header();
                            ret = this.parse_body();
                            return ret;
                        };

                        PacketParser.prototype.parse_body = function() {
                            var packet, pt, raw, sb;
                            pt = C.packet_tags;
                            sb = this.body;
                            raw = sb.peek_rest_to_buffer();
                            packet = (function() {
                                switch (this.tag) {
                                    case pt.PKESK:
                                        return PKESK.parse(sb);
                                    case pt.one_pass_sig:
                                        return OnePassSignature.parse(sb);
                                    case pt.secret_key:
                                        return KeyMaterial.parse_private_key(sb, {
                                            subkey: false
                                        });
                                    case pt.secret_subkey:
                                        return KeyMaterial.parse_private_key(sb, {
                                            subkey: true
                                        });
                                    case pt.public_key:
                                        return KeyMaterial.parse_public_key(sb, {
                                            subkey: false
                                        });
                                    case pt.public_subkey:
                                        return KeyMaterial.parse_public_key(sb, {
                                            subkey: true
                                        });
                                    case pt.signature:
                                        return Signature.parse(sb);
                                    case pt.userid:
                                        return UserID.parse(sb);
                                    case pt.user_attribute:
                                        return UserAttribute.parse(sb);
                                    case pt.SEIPD:
                                        return SEIPD.parse(sb);
                                    case pt.literal:
                                        return Literal.parse(sb);
                                    case pt.compressed:
                                        return Compressed.parse(sb);
                                    default:
                                        return new Generic(this.tag, sb);
                                }
                            }).call(this);
                            packet.set({
                                tag: this.tag,
                                real_packet_len: this.real_packet_len,
                                header_len: this.header_len,
                                raw: raw
                            });
                            return packet;
                        };

                        PacketParser.prototype.parse_tag_and_len = function() {
                            var c;
                            if (this.slice.len() < 2 || ((c = this.slice.read_uint8()) & 0x80) === 0) {
                                throw new Error("This doesn't look like a binary PGP packet (c=" + c + ")");
                            }
                            if ((c & 0x40) === 0) {
                                return this.parse_tag_and_len_old(c);
                            } else {
                                return this.parse_tag_and_len_new(c);
                            }
                        };

                        PacketParser.prototype.parse_tag_and_len_old = function(c) {
                            this.tag = (c & 0x3f) >> 2;
                            return this.len = (function() {
                                switch (c & 0x03) {
                                    case 0:
                                        return this.slice.read_uint8();
                                    case 1:
                                        return this.slice.read_uint16();
                                    case 2:
                                        return this.slice.read_uint32();
                                    case 3:
                                        return this.slice.rem();
                                }
                            }).call(this);
                        };

                        PacketParser.prototype.parse_tag_and_len_new = function(c) {
                            var ret;
                            this.tag = c & 0x3f;
                            ret = this.parse_tag_len_new();
                            return ret;
                        };

                        PacketParser.prototype.parse_tag_len_new = function() {
                            var c, d, go, lastlen, packet_length, segments;
                            go = true;
                            segments = [];
                            this.len = 0;
                            lastlen = 0;
                            while (go) {
                                go = false;
                                c = this.slice.read_uint8();
                                lastlen = c < 192 ? c : c === 255 ? this.slice.read_uint32() : c < 224 ? (d = this.slice.read_uint8(), ((c - 192) << 8) + (d + 192)) : (this.header_len || (this.header_len = this.slice.offset()), packet_length = 1 << (c & 0x1f), segments.push(this.slice.read_buffer(packet_length)), go = true, packet_length);
                                this.len += lastlen;
                            }
                            if (segments.length) {
                                segments.push(this.slice.read_buffer(lastlen));
                                this.body = new SlicerBuffer(Buffer.concat(segments));
                                this.len = this.body.length;
                                return this.real_packet_len = this.slice.offset();
                            }
                        };

                        return PacketParser;

                    })();

                    exports.parse = parse = function(buf) {
                        return util.katch(function() {
                            return (new MessageParser(new SlicerBuffer(buf))).parse();
                        });
                    };

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../const": 5,
            "../util": 72,
            "./buffer": 37,
            "./packet/compressed": 48,
            "./packet/generic": 49,
            "./packet/keymaterial": 50,
            "./packet/literal": 51,
            "./packet/one_pass_sig": 52,
            "./packet/sess": 54,
            "./packet/signature": 55,
            "./packet/user_attribute": 56,
            "./packet/userid": 57,
            "buffer": 126,
            "util": 302
        }],
        59: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var C, KeyBlock, Message, OPS, Warnings, armor, athrow, bufeq_secure, do_message, hashmod, iced, import_key_pgp, katch, konst, make_esc, parse, unix_time, util, verify_clearsign, verify_detached, __iced_k, __iced_k_noop, _ref;

                iced = require('iced-runtime');
                __iced_k = __iced_k_noop = function() {};

                make_esc = require('iced-error').make_esc;

                OPS = require('../keyfetch').OPS;

                konst = require('../const');

                C = konst.openpgp;

                _ref = require('../util'), katch = _ref.katch, unix_time = _ref.unix_time, athrow = _ref.athrow, Warnings = _ref.Warnings, bufeq_secure = _ref.bufeq_secure;

                parse = require('./parser').parse;

                import_key_pgp = require('../symmetric').import_key_pgp;

                util = require('util');

                armor = require('./armor');

                hashmod = require('../hash');

                verify_clearsign = require('./clearsign').verify;

                verify_detached = require('./detachsign').verify;

                KeyBlock = (function() {
                    function KeyBlock(packets, opts) {
                        this.packets = packets;
                        this.verified_signatures = [];
                        this.subkeys = [];
                        this.primary = null;
                        this.userids = [];
                        this.user_attributes = [];
                        this.warnings = new Warnings();
                        this.opts = opts || {};
                        if (this.opts.strict == null) {
                            this.opts.strict = true;
                        }
                    }

                    KeyBlock.prototype.to_obj = function() {
                        return {
                            subkeys: this.subkeys,
                            primary: this.primary,
                            userids: this.userids
                        };
                    };

                    KeyBlock.prototype._extract_keys = function() {
                        var err, i, p, _i, _len, _ref1;
                        err = null;
                        if (!this.packets.length) {
                            err = new Error("No packets; cannot extract a key");
                        } else if (!(this.primary = this.packets[0]).is_primary()) {
                            err = new Error("First packet must be the primary key");
                        } else {
                            _ref1 = this.packets.slice(1);
                            for (i = _i = 0, _len = _ref1.length; _i < _len; i = ++_i) {
                                p = _ref1[i];
                                if (p.is_key_material() && (err == null)) {
                                    if (p.key.is_toxic()) {
                                        this.warnings.push("Ignoring toxic subkey (ElGamal Encrypt+Sign)");
                                    } else if (!p.is_primary()) {
                                        this.subkeys.push(p);
                                    } else if (bufeq_secure(p.get_fingerprint(), this.primary.get_fingerprint())) {
                                        p.set_duplicate_primary();
                                    } else {
                                        err = new Error("cannot have 2 primary keys");
                                    }
                                }
                            }
                        }
                        return err;
                    };

                    KeyBlock.prototype._check_keys = function() {
                        return this._check_primary() || this._check_subkeys();
                    };

                    KeyBlock.prototype._check_primary = function() {
                        var err;
                        return err = !this.primary.is_self_signed() ? new Error("no valid primary key self-signature or key(s) have expired") : (this.userids = this.primary.get_signed_userids()).length === 0 ? new Error("no valid Userid signed into key") : (this.user_attributes = this.primary.get_signed_user_attributes(), null);
                    };

                    KeyBlock.prototype._check_subkeys = function() {
                        var err, i, k, msg, subkeys, _i, _len;
                        subkeys = this.subkeys;
                        err = null;
                        this.subkeys = [];
                        for (i = _i = 0, _len = subkeys.length; _i < _len; i = ++_i) {
                            k = subkeys[i];
                            if (err == null) {
                                if (k.is_signed_subkey_of(this.primary, this.opts)) {
                                    this.subkeys.push(k);
                                } else {
                                    msg = "Subkey " + i + " was invalid; discarding";
                                    this.warnings.push(msg);
                                }
                            }
                        }
                        return err;
                    };

                    KeyBlock.prototype.process = function(cb) {
                        var err, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        err = this._extract_keys();
                        (function(_this) {
                            return (function(__iced_k) {
                                if (err == null) {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                            funcname: "KeyBlock.process"
                                        });
                                        _this._verify_sigs(__iced_deferrals.defer({
                                            assign_fn: (function() {
                                                return function() {
                                                    return err = arguments[0];
                                                };
                                            })(),
                                            lineno: 87
                                        }));
                                        __iced_deferrals._fulfill();
                                    })(__iced_k);
                                } else {
                                    return __iced_k();
                                }
                            });
                        })(this)((function(_this) {
                            return function() {
                                var _ref1;
                                if ((_ref1 = _this.opts) != null ? _ref1.no_check_keys : void 0) {
                                    if (err == null) {
                                        _this.userids = _this.primary.get_signed_userids();
                                    }
                                } else {
                                    if (err == null) {
                                        err = _this._check_keys();
                                    }
                                }
                                return cb(err);
                            };
                        })(this));
                    };

                    KeyBlock.prototype._get_issuer = function(i, packet, primary) {
                        var fp, iid;
                        if ((fp = packet.get_issuer_fingerprint()) != null) {
                            return [fp, bufeq_secure(fp, this.primary.get_fingerprint()), this.primary.get_fingerprint()];
                        }
                        if ((iid = packet.get_issuer_key_id()) != null) {
                            return [iid, bufeq_secure(iid, this.primary.get_key_id()), this.primary.get_key_id()];
                        }
                        this.warnings.push("Signature is missing an issuer (at packet=" + i + ")");
                        return [null, false];
                    };

                    KeyBlock.prototype._verify_sigs = function(cb) {
                        var err, expected_ours, i, issuer_id, matches_ours, msg, n_sigs, p, tmp, working_set, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        err = null;
                        working_set = [];
                        n_sigs = 0;
                        (function(_this) {
                            return (function(__iced_k) {
                                var _i, _len, _ref1, _results, _while;
                                _ref1 = _this.packets.slice(1);
                                _len = _ref1.length;
                                i = 0;
                                _while = function(__iced_k) {
                                    var _break, _continue, _next;
                                    _break = __iced_k;
                                    _continue = function() {
                                        return iced.trampoline(function() {
                                            ++i;
                                            return _while(__iced_k);
                                        });
                                    };
                                    _next = _continue;
                                    if (!(i < _len)) {
                                        return _break();
                                    } else {
                                        p = _ref1[i];
                                        if (err == null) {
                                            (function(__iced_k) {
                                                if (!p.is_signature()) {
                                                    if (n_sigs > 0) {
                                                        n_sigs = 0;
                                                        working_set = [];
                                                    }
                                                    if (!p.is_duplicate_primary()) {
                                                        working_set.push(p);
                                                    }
                                                    (function(__iced_k) {
                                                        _continue()
                                                    })(__iced_k);
                                                } else {
                                                    return __iced_k();
                                                }
                                            })(function() {
                                                var _ref2;
                                                n_sigs++;
                                                _ref2 = _this._get_issuer(i, p, _this.primary), issuer_id = _ref2[0], matches_ours = _ref2[1], expected_ours = _ref2[2];
                                                (function(__iced_k) {
                                                    if (issuer_id != null) {
                                                        (function(__iced_k) {
                                                            if (!(matches_ours || p.type === C.sig_types.key_revocation)) {
                                                                _this.warnings.push("Skipping signature by another issuer: " + (issuer_id != null ? issuer_id.toString('hex') : void 0) + " != " + (expected_ours != null ? expected_ours.toString('hex') : void 0));
                                                                (function(__iced_k) {
                                                                    _continue()
                                                                })(__iced_k);
                                                            } else {
                                                                return __iced_k();
                                                            }
                                                        })(function() {
                                                            p.key = _this.primary.key;
                                                            p.primary = _this.primary;
                                                            p.is_third_party = !matches_ours;
                                                            (function(__iced_k) {
                                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                                    parent: ___iced_passed_deferral,
                                                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                                                    funcname: "KeyBlock._verify_sigs"
                                                                });
                                                                p.verify(working_set, __iced_deferrals.defer({
                                                                    assign_fn: (function() {
                                                                        return function() {
                                                                            return tmp = arguments[0];
                                                                        };
                                                                    })(),
                                                                    lineno: 137
                                                                }), _this.opts);
                                                                __iced_deferrals._fulfill();
                                                            })(function() {
                                                                return __iced_k(typeof tmp !== "undefined" && tmp !== null ? (msg = "Signature failure in packet " + i + ": " + tmp.message + " (" + (issuer_id.toString('hex')) + ")", _this.warnings.push(msg)) : _this.verified_signatures.push(p));
                                                            });
                                                        });
                                                    } else {
                                                        return __iced_k();
                                                    }
                                                })(_next);
                                            });
                                        } else {
                                            return _continue();
                                        }
                                    }
                                };
                                _while(__iced_k);
                            });
                        })(this)((function(_this) {
                            return function() {
                                return cb(err);
                            };
                        })(this));
                    };

                    return KeyBlock;

                })();

                Message = (function() {
                    function Message(_arg) {
                        this.keyfetch = _arg.keyfetch, this.data_fn = _arg.data_fn, this.data = _arg.data, this.strict = _arg.strict, this.now = _arg.now;
                        this.literals = [];
                        this.enc_data_packet = null;
                        this.warnings = new Warnings();
                    }

                    Message.prototype._get_session_key = function(cb) {
                        var enc, err, esk_packets, fingerprint, index, key_ids, key_material, km, p, packet, pkcs5, privk, sesskey, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        key_ids = [];
                        esk_packets = [];
                        err = null;
                        pkcs5 = false;
                        key_ids = (function() {
                            var _results;
                            _results = [];
                            while (this.packets.length && (p = this.packets[0].to_esk_packet())) {
                                esk_packets.push(p);
                                this.packets.shift();
                                _results.push(p.get_key_id());
                            }
                            return _results;
                        }).call(this);
                        (function(_this) {
                            return (function(__iced_k) {
                                if (key_ids.length) {
                                    enc = true;
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                            funcname: "Message._get_session_key"
                                        });
                                        _this.keyfetch.fetch(key_ids, konst.ops.decrypt, __iced_deferrals.defer({
                                            assign_fn: (function() {
                                                return function() {
                                                    err = arguments[0];
                                                    km = arguments[1];
                                                    return index = arguments[2];
                                                };
                                            })(),
                                            lineno: 178
                                        }));
                                        __iced_deferrals._fulfill();
                                    })(function() {
                                        (function(__iced_k) {
                                            if (err == null) {
                                                packet = esk_packets[index];
                                                key_material = km.find_pgp_key_material(key_ids[index]);
                                                fingerprint = key_material.get_fingerprint();
                                                privk = key_material.key;
                                                (function(__iced_k) {
                                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                        parent: ___iced_passed_deferral,
                                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                                        funcname: "Message._get_session_key"
                                                    });
                                                    privk.decrypt_and_unpad(packet.ekey, {
                                                        fingerprint: fingerprint
                                                    }, __iced_deferrals.defer({
                                                        assign_fn: (function() {
                                                            return function() {
                                                                err = arguments[0];
                                                                sesskey = arguments[1];
                                                                return pkcs5 = arguments[2];
                                                            };
                                                        })(),
                                                        lineno: 184
                                                    }));
                                                    __iced_deferrals._fulfill();
                                                })(function() {
                                                    return __iced_k(err == null ? _this.encryption_subkey = key_material : void 0);
                                                });
                                            } else {
                                                return __iced_k();
                                            }
                                        })(__iced_k);
                                    });
                                } else {
                                    return __iced_k(enc = false);
                                }
                            });
                        })(this)((function(_this) {
                            return function() {
                                return cb(err, enc, sesskey, pkcs5);
                            };
                        })(this));
                    };

                    Message.prototype._find_encrypted_data = function(cb) {
                        var err, ret;
                        err = ret = null;
                        if (this.packets.length && (ret = this.packets[0].to_enc_data_packet())) {
                            this.packets.pop();
                        } else {
                            err = new Error("Could not find encrypted data packet");
                        }
                        return cb(err, ret);
                    };

                    Message.prototype._decrypt_with_session_key = function(sesskey, edat, pkcs5, cb) {
                        var cipher, err, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref1;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        _ref1 = katch(function() {
                            return import_key_pgp(sesskey, pkcs5);
                        }), err = _ref1[0], cipher = _ref1[1];
                        (function(_this) {
                            return (function(__iced_k) {
                                if (err == null) {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                            funcname: "Message._decrypt_with_session_key"
                                        });
                                        edat.decrypt({
                                            cipher: cipher
                                        }, __iced_deferrals.defer({
                                            assign_fn: (function() {
                                                return function() {
                                                    err = arguments[0];
                                                    return ret = arguments[1];
                                                };
                                            })(),
                                            lineno: 206
                                        }));
                                        __iced_deferrals._fulfill();
                                    })(__iced_k);
                                } else {
                                    return __iced_k();
                                }
                            });
                        })(this)((function(_this) {
                            return function() {
                                return cb(err, ret);
                            };
                        })(this));
                    };

                    Message.prototype._parse = function(raw, cb) {
                        var err, packets, _ref1;
                        _ref1 = parse(raw), err = _ref1[0], packets = _ref1[1];
                        return cb(err, packets);
                    };

                    Message.prototype._decrypt = function(cb) {
                        var edat, esc, is_enc, packets, pkcs5, plaintext, sesskey, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        esc = make_esc(cb, "Message::decrypt");
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                    funcname: "Message._decrypt"
                                });
                                _this._get_session_key(esc(__iced_deferrals.defer({
                                    assign_fn: (function() {
                                        return function() {
                                            is_enc = arguments[0];
                                            sesskey = arguments[1];
                                            return pkcs5 = arguments[2];
                                        };
                                    })(),
                                    lineno: 219
                                })));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                (function(__iced_k) {
                                    if (is_enc) {
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                                funcname: "Message._decrypt"
                                            });
                                            _this._find_encrypted_data(esc(__iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        return edat = arguments[0];
                                                    };
                                                })(),
                                                lineno: 221
                                            })));
                                            __iced_deferrals._fulfill();
                                        })(function() {
                                            (function(__iced_k) {
                                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                    parent: ___iced_passed_deferral,
                                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                                    funcname: "Message._decrypt"
                                                });
                                                _this._decrypt_with_session_key(sesskey, edat, pkcs5, esc(__iced_deferrals.defer({
                                                    assign_fn: (function() {
                                                        return function() {
                                                            return plaintext = arguments[0];
                                                        };
                                                    })(),
                                                    lineno: 222
                                                })));
                                                __iced_deferrals._fulfill();
                                            })(function() {
                                                (function(__iced_k) {
                                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                        parent: ___iced_passed_deferral,
                                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                                        funcname: "Message._decrypt"
                                                    });
                                                    _this._parse(plaintext, esc(__iced_deferrals.defer({
                                                        assign_fn: (function() {
                                                            return function() {
                                                                return packets = arguments[0];
                                                            };
                                                        })(),
                                                        lineno: 223
                                                    })));
                                                    __iced_deferrals._fulfill();
                                                })(function() {
                                                    return __iced_k(_this.packets = packets.concat(_this.packets));
                                                });
                                            });
                                        });
                                    } else {
                                        return __iced_k();
                                    }
                                })(function() {
                                    return cb(null);
                                });
                            };
                        })(this));
                    };

                    Message.prototype._inflate = function(cb) {
                        var esc, inflated, p, packets, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        packets = [];
                        esc = make_esc(cb, "Message::_inflate");
                        (function(_this) {
                            return (function(__iced_k) {
                                var _i, _len, _ref1, _results, _while;
                                _ref1 = _this.packets;
                                _len = _ref1.length;
                                _i = 0;
                                _while = function(__iced_k) {
                                    var _break, _continue, _next;
                                    _break = __iced_k;
                                    _continue = function() {
                                        return iced.trampoline(function() {
                                            ++_i;
                                            return _while(__iced_k);
                                        });
                                    };
                                    _next = _continue;
                                    if (!(_i < _len)) {
                                        return _break();
                                    } else {
                                        p = _ref1[_i];
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                                funcname: "Message._inflate"
                                            });
                                            p.inflate(esc(__iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        return inflated = arguments[0];
                                                    };
                                                })(),
                                                lineno: 233
                                            })));
                                            __iced_deferrals._fulfill();
                                        })(function() {
                                            (function(__iced_k) {
                                                if (typeof inflated !== "undefined" && inflated !== null) {
                                                    (function(__iced_k) {
                                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                            parent: ___iced_passed_deferral,
                                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                                            funcname: "Message._inflate"
                                                        });
                                                        _this._parse(inflated, esc(__iced_deferrals.defer({
                                                            assign_fn: (function() {
                                                                return function() {
                                                                    return p = arguments[0];
                                                                };
                                                            })(),
                                                            lineno: 235
                                                        })));
                                                        __iced_deferrals._fulfill();
                                                    })(function() {
                                                        return __iced_k(packets.push.apply(packets, p));
                                                    });
                                                } else {
                                                    return __iced_k(packets.push(p));
                                                }
                                            })(_next);
                                        });
                                    }
                                };
                                _while(__iced_k);
                            });
                        })(this)((function(_this) {
                            return function() {
                                _this.packets = packets;
                                return cb(null);
                            };
                        })(this));
                    };

                    Message.prototype._frame_signatures = function() {
                        var o, p, payload, ret, stack, _i, _j, _len, _len1, _ref1;
                        ret = [];
                        stack = [];
                        payload = [];
                        _ref1 = this.packets;
                        for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                            p = _ref1[_i];
                            if (p.tag === C.packet_tags.one_pass_sig) {
                                stack.push({
                                    open: p
                                });
                            } else if (!stack.length) {

                            } else if (p.tag === C.packet_tags.signature) {
                                o = stack.pop();
                                o.close = p;
                                ret.push(o);
                            } else {
                                payload.push(p);
                            }
                        }
                        for (_j = 0, _len1 = ret.length; _j < _len1; _j++) {
                            o = ret[_j];
                            o.payload = payload;
                        }
                        return ret;
                    };

                    Message.prototype._verify_sig = function(sig, cb) {
                        var a, b, err, i, key_material, km, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        err = null;
                        if (!bufeq_secure((a = sig.open.key_id), (b = sig.close.get_key_id()))) {
                            err = new Error("signature mismatch open v close: " + (a != null ? a.toString('hex') : void 0) + " != " + (b != null ? b.toString('hex') : void 0));
                        }
                        (function(_this) {
                            return (function(__iced_k) {
                                if (err == null) {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                            funcname: "Message._verify_sig"
                                        });
                                        _this.keyfetch.fetch([a], konst.ops.verify, __iced_deferrals.defer({
                                            assign_fn: (function() {
                                                return function() {
                                                    err = arguments[0];
                                                    km = arguments[1];
                                                    return i = arguments[2];
                                                };
                                            })(),
                                            lineno: 274
                                        }));
                                        __iced_deferrals._fulfill();
                                    })(function() {
                                        return __iced_k(err != null ? err = new Error("Can't find a key for " + (a.toString('hex')) + ": " + err.message) : void 0);
                                    });
                                } else {
                                    return __iced_k();
                                }
                            });
                        })(this)((function(_this) {
                            return function() {
                                (function(__iced_k) {
                                    if (err == null) {
                                        key_material = km.find_pgp_key_material(a);
                                        sig.close.key = key_material.key;
                                        sig.close.subkey_material = key_material;
                                        sig.close.key_manager = km;
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                                funcname: "Message._verify_sig"
                                            });
                                            sig.close.verify(sig.payload, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        return err = arguments[0];
                                                    };
                                                })(),
                                                lineno: 289
                                            }), {
                                                now: _this.now
                                            });
                                            __iced_deferrals._fulfill();
                                        })(__iced_k);
                                    } else {
                                        return __iced_k(!_this.strict ? (_this.warnings.push("Problem fetching key " + (a.toString('hex')) + ": " + (err.toString())), err = null) : void 0);
                                    }
                                })(function() {
                                    return cb(err);
                                });
                            };
                        })(this));
                    };

                    Message.prototype._verify = function(cb) {
                        var esc, sig, sigs, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        esc = make_esc(cb, "Message::_verify_sigs");
                        sigs = this._frame_signatures();
                        (function(_this) {
                            return (function(__iced_k) {
                                var _i, _len, _ref1, _results, _while;
                                _ref1 = sigs;
                                _len = _ref1.length;
                                _i = 0;
                                _while = function(__iced_k) {
                                    var _break, _continue, _next;
                                    _break = __iced_k;
                                    _continue = function() {
                                        return iced.trampoline(function() {
                                            ++_i;
                                            return _while(__iced_k);
                                        });
                                    };
                                    _next = _continue;
                                    if (!(_i < _len)) {
                                        return _break();
                                    } else {
                                        sig = _ref1[_i];
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                                funcname: "Message._verify"
                                            });
                                            _this._verify_sig(sig, esc(__iced_deferrals.defer({
                                                lineno: 303
                                            })));
                                            __iced_deferrals._fulfill();
                                        })(_next);
                                    }
                                };
                                _while(__iced_k);
                            });
                        })(this)((function(_this) {
                            return function() {
                                return cb(null);
                            };
                        })(this));
                    };

                    Message.prototype.collect_literals = function() {
                        var p, _i, _len, _ref1, _results;
                        _ref1 = this.packets;
                        _results = [];
                        for (_i = 0, _len = _ref1.length; _i < _len; _i++) {
                            p = _ref1[_i];
                            if (p.tag === C.packet_tags.literal) {
                                _results.push(p);
                            }
                        }
                        return _results;
                    };

                    Message.prototype._process_generic = function(_arg, cb) {
                        var esc, packets, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        packets = _arg.packets;
                        this.packets = packets;
                        esc = make_esc(cb, "Message:process");
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                    funcname: "Message._process_generic"
                                });
                                _this._decrypt(esc(__iced_deferrals.defer({
                                    lineno: 316
                                })));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                        funcname: "Message._process_generic"
                                    });
                                    _this._inflate(esc(__iced_deferrals.defer({
                                        lineno: 317
                                    })));
                                    __iced_deferrals._fulfill();
                                })(function() {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                            funcname: "Message._process_generic"
                                        });
                                        _this._verify(esc(__iced_deferrals.defer({
                                            lineno: 318
                                        })));
                                        __iced_deferrals._fulfill();
                                    })(function() {
                                        return cb(null, _this.collect_literals());
                                    });
                                });
                            };
                        })(this));
                    };

                    Message.prototype._verify_clearsign = function(_arg, cb) {
                        var clearsign, err, literal, packets, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        packets = _arg.packets, clearsign = _arg.clearsign;
                        (function(_this) {
                            return (function(__iced_k) {
                                if (clearsign == null) {
                                    return __iced_k(err = new Error("no clearsign data found"));
                                } else {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                            funcname: "Message._verify_clearsign"
                                        });
                                        verify_clearsign({
                                            packets: packets,
                                            clearsign: clearsign,
                                            keyfetch: _this.keyfetch,
                                            now: _this.now
                                        }, __iced_deferrals.defer({
                                            assign_fn: (function() {
                                                return function() {
                                                    err = arguments[0];
                                                    return literal = arguments[1];
                                                };
                                            })(),
                                            lineno: 327
                                        }));
                                        __iced_deferrals._fulfill();
                                    })(__iced_k);
                                }
                            });
                        })(this)((function(_this) {
                            return function() {
                                return cb(err, [literal]);
                            };
                        })(this));
                    };

                    Message.prototype.parse_and_inflate = function(body, cb) {
                        var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        esc = make_esc(cb, "Message::parse_and_inflate");
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                    funcname: "Message.parse_and_inflate"
                                });
                                _this._parse(body, esc(__iced_deferrals.defer({
                                    assign_fn: (function(__slot_1) {
                                        return function() {
                                            return __slot_1.packets = arguments[0];
                                        };
                                    })(_this),
                                    lineno: 334
                                })));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                        funcname: "Message.parse_and_inflate"
                                    });
                                    _this._inflate(esc(__iced_deferrals.defer({
                                        lineno: 335
                                    })));
                                    __iced_deferrals._fulfill();
                                })(function() {
                                    return cb(null, _this.collect_literals());
                                });
                            };
                        })(this));
                    };

                    Message.prototype.parse_and_process = function(msg, cb) {
                        var esc, literals, packets, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        esc = make_esc(cb, "Message::parse_and_process");
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                    funcname: "Message.parse_and_process"
                                });
                                _this._parse(msg.body, esc(__iced_deferrals.defer({
                                    assign_fn: (function() {
                                        return function() {
                                            return packets = arguments[0];
                                        };
                                    })(),
                                    lineno: 342
                                })));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                        funcname: "Message.parse_and_process"
                                    });
                                    _this._process({
                                        msg: msg,
                                        packets: packets
                                    }, esc(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return literals = arguments[0];
                                            };
                                        })(),
                                        lineno: 343
                                    })));
                                    __iced_deferrals._fulfill();
                                })(function() {
                                    return cb(null, literals);
                                });
                            };
                        })(this));
                    };

                    Message.prototype._verify_signature = function(_arg, cb) {
                        var err, literals, packets, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        packets = _arg.packets;
                        (function(_this) {
                            return (function(__iced_k) {
                                if (!((_this.data != null) || (_this.data_fn != null))) {
                                    return __iced_k(err = new Error("Cannot verify detached signature without data input"));
                                } else {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                            funcname: "Message._verify_signature"
                                        });
                                        verify_detached({
                                            packets: packets,
                                            data: _this.data,
                                            data_fn: _this.data_fn,
                                            keyfetch: _this.keyfetch,
                                            now: _this.now
                                        }, __iced_deferrals.defer({
                                            assign_fn: (function() {
                                                return function() {
                                                    err = arguments[0];
                                                    return literals = arguments[1];
                                                };
                                            })(),
                                            lineno: 352
                                        }));
                                        __iced_deferrals._fulfill();
                                    })(__iced_k);
                                }
                            });
                        })(this)((function(_this) {
                            return function() {
                                return cb(err, literals);
                            };
                        })(this));
                    };

                    Message.prototype._process = function(_arg, cb) {
                        var err, literals, msg, packets, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        msg = _arg.msg, packets = _arg.packets;
                        msg.type || (msg.type = C.message_types.generic);
                        (function(_this) {
                            return (function(__iced_k) {
                                switch (msg.type) {
                                    case C.message_types.generic:
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                                funcname: "Message._process"
                                            });
                                            _this._process_generic({
                                                packets: packets
                                            }, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        err = arguments[0];
                                                        return literals = arguments[1];
                                                    };
                                                })(),
                                                lineno: 361
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(__iced_k);
                                        break;
                                    case C.message_types.clearsign:
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                                funcname: "Message._process"
                                            });
                                            _this._verify_clearsign({
                                                packets: packets,
                                                clearsign: msg.clearsign
                                            }, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        err = arguments[0];
                                                        return literals = arguments[1];
                                                    };
                                                })(),
                                                lineno: 363
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(__iced_k);
                                        break;
                                    case C.message_types.signature:
                                        (function(__iced_k) {
                                            __iced_deferrals = new iced.Deferrals(__iced_k, {
                                                parent: ___iced_passed_deferral,
                                                filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced",
                                                funcname: "Message._process"
                                            });
                                            _this._verify_signature({
                                                packets: packets
                                            }, __iced_deferrals.defer({
                                                assign_fn: (function() {
                                                    return function() {
                                                        err = arguments[0];
                                                        return literals = arguments[1];
                                                    };
                                                })(),
                                                lineno: 365
                                            }));
                                            __iced_deferrals._fulfill();
                                        })(__iced_k);
                                        break;
                                    default:
                                        return __iced_k(err = new Error("Needed a 'generic', 'clearsign', or 'signature' PGP message, got " + msg.type));
                                }
                            });
                        })(this)((function(_this) {
                            return function() {
                                return cb(err, literals);
                            };
                        })(this));
                    };

                    return Message;

                })();

                exports.KeyBlock = KeyBlock;

                exports.Message = Message;

                exports.do_message = do_message = function(_arg, cb) {
                    var armored, data, data_fn, err, esk, keyfetch, literals, msg, msg_type, now, proc, raw, strict, warnings, ___iced_passed_deferral, __iced_deferrals, __iced_k, _ref1;
                    __iced_k = __iced_k_noop;
                    ___iced_passed_deferral = iced.findDeferral(arguments);
                    armored = _arg.armored, raw = _arg.raw, msg_type = _arg.msg_type, keyfetch = _arg.keyfetch, data_fn = _arg.data_fn, data = _arg.data, strict = _arg.strict, now = _arg.now;
                    literals = null;
                    err = msg = warnings = esk = null;
                    if (armored != null) {
                        _ref1 = armor.decode(armored), err = _ref1[0], msg = _ref1[1];
                    } else if (raw != null) {
                        msg_type || (msg_type = C.message_types.generic);
                        msg = {
                            body: raw,
                            type: msg_type
                        };
                    } else {
                        err = new Error("No input to do_message; need either 'armored' or 'raw' input");
                    }
                    (function(_this) {
                        return (function(__iced_k) {
                            if (err == null) {
                                if (strict == null) {
                                    strict = true;
                                }
                                proc = new Message({
                                    keyfetch: keyfetch,
                                    data_fn: data_fn,
                                    data: data,
                                    strict: strict,
                                    now: now
                                });
                                (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/home/zapu/kb_other/kbpgp/src/openpgp/processor.iced"
                                    });
                                    proc.parse_and_process(msg, __iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                err = arguments[0];
                                                return literals = arguments[1];
                                            };
                                        })(),
                                        lineno: 413
                                    }));
                                    __iced_deferrals._fulfill();
                                })(function() {
                                    warnings = proc.warnings;
                                    return __iced_k(esk = proc.encryption_subkey);
                                });
                            } else {
                                return __iced_k();
                            }
                        });
                    })(this)((function(_this) {
                        return function() {
                            return cb(err, literals, warnings, esk);
                        };
                    })(this));
                };

            }).call(this);

        }, {
            "../const": 5,
            "../hash": 16,
            "../keyfetch": 26,
            "../symmetric": 70,
            "../util": 72,
            "./armor": 35,
            "./clearsign": 41,
            "./detachsign": 42,
            "./parser": 58,
            "iced-error": 179,
            "iced-runtime": 183,
            "util": 302
        }],
        60: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var C, S2K, SHA256, SecretKeyMaterial, alloc, iterated_s2k, streamers, triplesec, _iterated_s2k_cache, _ref;

                    triplesec = require('triplesec');

                    C = require('../const').openpgp;

                    _ref = require('../hash'), alloc = _ref.alloc, SHA256 = _ref.SHA256, streamers = _ref.streamers;

                    S2K = (function() {
                        S2K.prototype._count = function(c, bias) {
                            return (16 + (c & 15)) << ((c >> 4) + bias);
                        };

                        function S2K() {
                            this.hash = SHA256;
                            this.streamer = streamers.SHA256();
                        }

                        S2K.prototype.set_hash_algorithm = function(which) {
                            if ((this.hash = alloc(which)) != null) {
                                return this.streamer = streamers[this.hash.algname]();
                            } else {
                                console.warn("No such hash: " + which + "; defaulting to SHA-256");
                                this.hash = SHA256;
                                return this.streamer = streamers.SHA256();
                            }
                        };

                        S2K.prototype.read = function(slice) {
                            var c;
                            this.type = slice.read_uint8();
                            switch (this.type) {
                                case C.s2k.plain:
                                    this.set_hash_algorithm(slice.read_uint8());
                                    break;
                                case C.s2k.salt:
                                    this.set_hash_algorithm(slice.read_uint8());
                                    this.salt = slice.read_buffer(8);
                                    break;
                                case C.s2k.salt_iter:
                                    this.set_hash_algorithm(slice.read_uint8());
                                    this.salt = slice.read_buffer(8);
                                    this.EXPBIAS = 6;
                                    c = slice.read_uint8();
                                    this.count = this._count(c, this.EXPBIAS);
                                    break;
                                case C.s2k.gnu:
                                    this.read_gnu_extensions(slice);
                                    break;
                                default:
                                    throw new Error("unknown s2k type! " + this.type);
                            }
                            return this;
                        };

                        S2K.prototype.read_gnu_extensions = function(slice) {
                            var buf, gnu_ext_type, id, version;
                            version = slice.read_uint8();
                            if ((id = (buf = slice.read_buffer(3)).toString('utf8')) === "GNU") {
                                gnu_ext_type = slice.read_uint8() + 1000;
                                switch (gnu_ext_type) {
                                    case 1001:
                                        return this.type = C.s2k.gnu_dummy;
                                    default:
                                        throw new Error("unknown s2k gnu protection mode: " + gnu_ext_type);
                                }
                            } else {
                                throw new Error("Malformed GNU-extension: " + ext);
                            }
                        };

                        S2K.prototype.write = function(passphrase, salt, c, keysize) {
                            var type;
                            this.type = type = 3;
                            this.salt = salt;
                            this.count = this._count(c, 6);
                            this.s2kLength = 10;
                            return this.produce_key(passphrase, keysize);
                        };

                        S2K.prototype.is_dummy = function() {
                            return this.type === C.s2k.gnu_dummy;
                        };

                        S2K.prototype.produce_key = function(passphrase, numBytes) {
                            var key, key2, prefix, ret, seed;
                            if (numBytes == null) {
                                numBytes = 16;
                            }
                            ret = (function() {
                                switch (this.type) {
                                    case C.s2k.plain:
                                        return this.hash(passphrase);
                                    case C.s2k.salt:
                                        return this.hash(Buffer.concat([this.salt, passphrase]));
                                    case C.s2k.salt_iter:
                                        seed = Buffer.concat([this.salt, passphrase]);
                                        key = iterated_s2k({
                                            alg: this.hash.algname,
                                            seed: seed,
                                            count: this.count
                                        });
                                        if ((numBytes != null) && (numBytes === 24 || numBytes === 32)) {
                                            prefix = new Buffer([0]);
                                            key2 = iterated_s2k({
                                                alg: this.hash.algname,
                                                seed: seed,
                                                count: this.count,
                                                prefix: prefix
                                            });
                                            return Buffer.concat([key, key2]);
                                        } else {
                                            return key;
                                        }
                                        break;
                                    default:
                                        return null;
                                }
                            }).call(this);
                            return ret.slice(0, numBytes);
                        };

                        return S2K;

                    })();

                    _iterated_s2k_cache = {};

                    iterated_s2k = function(_arg) {
                        var alg, bigbuf, count, i, k, n, prefix, rem, rembuf, ret, seed, streamer, tot, val;
                        alg = _arg.alg, seed = _arg.seed, count = _arg.count, prefix = _arg.prefix;
                        k = "" + alg + "-" + (seed.toString('base64')) + "-" + count;
                        if (prefix != null) {
                            k += "-" + (prefix.toString('base64'));
                        }
                        if ((val = _iterated_s2k_cache[k]) != null) {
                            return val;
                        }
                        streamer = streamers[alg]();
                        if (prefix != null) {
                            streamer.update(prefix);
                        }
                        bigbuf = Buffer.concat((function() {
                            var _i, _results;
                            _results = [];
                            for (i = _i = 0; _i < 4096; i = ++_i) {
                                _results.push(seed);
                            }
                            return _results;
                        })());
                        tot = 0;
                        while (tot + bigbuf.length <= count) {
                            streamer.update(bigbuf);
                            tot += bigbuf.length;
                        }
                        rem = count - tot;
                        n = Math.ceil(rem / seed.length);
                        rembuf = Buffer.concat((function() {
                            var _i, _results;
                            _results = [];
                            for (i = _i = 0; 0 <= n ? _i < n : _i > n; i = 0 <= n ? ++_i : --_i) {
                                _results.push(seed);
                            }
                            return _results;
                        })());
                        ret = streamer(rembuf.slice(0, rem));
                        _iterated_s2k_cache[k] = ret;
                        return ret;
                    };

                    SecretKeyMaterial = (function() {
                        function SecretKeyMaterial() {
                            this.s2k_convention = null;
                            this.s2k = null;
                            this.iv = null;
                            this.cipher = null;
                            this.payload = null;
                        }

                        SecretKeyMaterial.prototype.is_dummy = function() {
                            return (this.s2k != null) && this.s2k.is_dummy();
                        };

                        SecretKeyMaterial.prototype.has_private = function() {
                            return !this.is_dummy();
                        };

                        SecretKeyMaterial.prototype.is_locked = function() {
                            return (this.s2k_convention !== C.s2k_convention.none) && !(this.is_dummy());
                        };

                        return SecretKeyMaterial;

                    })();

                    exports.S2K = S2K;

                    exports.SecretKeyMaterial = SecretKeyMaterial;

                }).call(this);

            }).call(this, require("buffer").Buffer)
        }, {
            "../const": 5,
            "../hash": 16,
            "buffer": 126,
            "triplesec": 282
        }],
        61: [function(require, module, exports) {
            // Generated by IcedCoffeeScript 108.0.11
            (function() {
                var C, SignatureEngine, SignatureEngineInterface, burn, decode, decode_sig, get_sig_body, iced, make_esc, processor, __iced_k, __iced_k_noop,
                    __hasProp = {}.hasOwnProperty,
                    __extends = function(child, parent) {
                        for (var key in parent) {
                            if (__hasProp.call(parent, key)) child[key] = parent[key];
                        }

                        function ctor() {
                            this.constructor = child;
                        }
                        ctor.prototype = parent.prototype;
                        child.prototype = new ctor();
                        child.__super__ = parent.prototype;
                        return child;
                    };

                iced = require('iced-runtime');
                __iced_k = __iced_k_noop = function() {};

                make_esc = require('iced-error').make_esc;

                burn = require('./burner').burn;

                processor = require('./processor');

                decode = require('./armor').decode;

                C = require('../const');

                SignatureEngineInterface = require('../kmi').SignatureEngineInterface;

                exports.decode_sig = decode_sig = function(_arg) {
                    var armored, err, msg, mt, _ref;
                    armored = _arg.armored;
                    _ref = decode(armored), err = _ref[0], msg = _ref[1];
                    mt = C.openpgp.message_types;
                    if ((err == null) && (msg.type !== mt.generic)) {
                        err = new Error("wrong message type; expected a generic message; got " + msg.type);
                    }
                    return [err, msg];
                };

                exports.get_sig_body = get_sig_body = function(_arg) {
                    var armored, err, msg, res, _ref;
                    armored = _arg.armored;
                    res = null;
                    _ref = decode_sig({
                        armored: armored
                    }), err = _ref[0], msg = _ref[1];
                    if (err == null) {
                        res = msg.body;
                    }
                    return [err, res];
                };

                exports.SignatureEngine = SignatureEngine = (function(_super) {
                    __extends(SignatureEngine, _super);

                    function SignatureEngine(_arg) {
                        this.km = _arg.km;
                    }

                    SignatureEngine.prototype.get_km = function() {
                        return this.km;
                    };

                    SignatureEngine.prototype.box = function(msg, cb) {
                        var err, out, signing_key, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        out = {
                            type: "pgp"
                        };
                        (function(_this) {
                            return (function(__iced_k) {
                                if ((signing_key = _this.km.find_signing_pgp_key()) != null) {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/Users/max/src/keybase/kbpgp/src/openpgp/sigeng.iced",
                                            funcname: "SignatureEngine.box"
                                        });
                                        burn({
                                            msg: msg,
                                            signing_key: signing_key
                                        }, __iced_deferrals.defer({
                                            assign_fn: (function(__slot_1, __slot_2) {
                                                return function() {
                                                    err = arguments[0];
                                                    __slot_1.pgp = arguments[1];
                                                    return __slot_2.raw = arguments[2];
                                                };
                                            })(out, out),
                                            lineno: 37
                                        }));
                                        __iced_deferrals._fulfill();
                                    })(function() {
                                        return __iced_k(typeof err === "undefined" || err === null ? out.armored = out.pgp : void 0);
                                    });
                                } else {
                                    return __iced_k(err = new Error("No signing key found"));
                                }
                            });
                        })(this)((function(_this) {
                            return function() {
                                return cb(err, out);
                            };
                        })(this));
                    };

                    SignatureEngine.prototype.get_unverified_payload_from_raw_sig_body = function(_arg, cb) {
                        var body, err, esc, l, literals, m, n, payload, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        body = _arg.body;
                        esc = make_esc(cb, "get_payload_from_raw_sig_body");
                        payload = null;
                        m = new processor.Message({});
                        (function(_this) {
                            return (function(__iced_k) {
                                __iced_deferrals = new iced.Deferrals(__iced_k, {
                                    parent: ___iced_passed_deferral,
                                    filename: "/Users/max/src/keybase/kbpgp/src/openpgp/sigeng.iced",
                                    funcname: "SignatureEngine.get_unverified_payload_from_raw_sig_body"
                                });
                                m.parse_and_inflate(body, esc(__iced_deferrals.defer({
                                    assign_fn: (function() {
                                        return function() {
                                            return literals = arguments[0];
                                        };
                                    })(),
                                    lineno: 48
                                })));
                                __iced_deferrals._fulfill();
                            });
                        })(this)((function(_this) {
                            return function() {
                                if ((n = literals.length) !== 1 || ((l = literals[0]) == null)) {
                                    err = new Error("Got " + n + " literals; only wanted 1");
                                } else {
                                    payload = l.data;
                                }
                                return cb(err, payload);
                            };
                        })(this));
                    };

                    SignatureEngine.prototype.get_body = function(args, cb) {
                        var err, res, _ref;
                        _ref = get_sig_body(args), err = _ref[0], res = _ref[1];
                        return cb(err, res);
                    };

                    SignatureEngine.prototype.decode = function(armored, cb) {
                        var err, msg, _ref;
                        _ref = decode_sig({
                            armored: armored
                        }), err = _ref[0], msg = _ref[1];
                        return cb(err, msg);
                    };

                    SignatureEngine.prototype.unbox = function(msg, cb, opts) {
                        var eng, esc, literals, payload, ___iced_passed_deferral, __iced_deferrals, __iced_k;
                        __iced_k = __iced_k_noop;
                        ___iced_passed_deferral = iced.findDeferral(arguments);
                        if (opts == null) {
                            opts = {};
                        }
                        esc = make_esc(cb, "SignatureEngine::unbox");
                        (function(_this) {
                            return (function(__iced_k) {
                                if (typeof msg === 'string') {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/Users/max/src/keybase/kbpgp/src/openpgp/sigeng.iced",
                                            funcname: "SignatureEngine.unbox"
                                        });
                                        _this.decode(msg, esc(__iced_deferrals.defer({
                                            assign_fn: (function() {
                                                return function() {
                                                    return msg = arguments[0];
                                                };
                                            })(),
                                            lineno: 72
                                        })));
                                        __iced_deferrals._fulfill();
                                    })(__iced_k);
                                } else {
                                    return __iced_k();
                                }
                            });
                        })(this)((function(_this) {
                            return function() {
                                opts.keyfetch = _this.km;
                                opts.strict = true;
                                eng = new processor.Message(opts);
                                (function(__iced_k) {
                                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                                        parent: ___iced_passed_deferral,
                                        filename: "/Users/max/src/keybase/kbpgp/src/openpgp/sigeng.iced",
                                        funcname: "SignatureEngine.unbox"
                                    });
                                    eng.parse_and_process({
                                        body: msg.body
                                    }, esc(__iced_deferrals.defer({
                                        assign_fn: (function() {
                                            return function() {
                                                return literals = arguments[0];
                                            };
                                        })(),
                                        lineno: 76
                                    })));
                                    __iced_deferrals._fulfill();
                                })(function() {
                                    (function(__iced_k) {
                                        __iced_deferrals = new iced.Deferrals(__iced_k, {
                                            parent: ___iced_passed_deferral,
                                            filename: "/Users/max/src/keybase/kbpgp/src/openpgp/sigeng.iced",
                                            funcname: "SignatureEngine.unbox"
                                        });
                                        _this._check_result(literals, esc(__iced_deferrals.defer({
                                            assign_fn: (function() {
                                                return function() {
                                                    return payload = arguments[0];
                                                };
                                            })(),
                                            lineno: 77
                                        })));
                                        __iced_deferrals._fulfill();
                                    })(function() {
                                        return cb(null, payload, msg.body);
                                    });
                                });
                            };
                        })(this));
                    };

                    SignatureEngine.prototype._check_result = function(literals, cb) {
                        var b, err, l, n, payload, sw, _ref;
                        err = payload = null;
                        if ((n = literals.length) !== 1 || ((l = literals[0]) == null)) {
                            err = new Error("Expected only one pgp literal; got " + n);
                        } else if ((sw = (_ref = l.get_data_signer()) != null ? _ref.sig : void 0) == null) {
                            err = new Error("Expected a signature on the payload message");
                        } else if ((this.km.find_pgp_key((b = sw.get_key_id()))) == null) {
                            err = new Error("Failed sanity check; didn't have a key for '" + (b.toString('hex')) + "'");
                        } else {
                            payload = l.data;
                        }
                        return cb(err, payload);
                    };

                    return SignatureEngine;

                })(SignatureEngineInterface);

            }).call(this);

        }, {
            "../const": 5,
            "../kmi": 29,
            "./armor": 35,
            "./burner": 38,
            "./processor": 59,
            "iced-error": 179,
            "iced-runtime": 183
        }],
        62: [function(require, module, exports) {
            (function(Buffer) {
                // Generated by IcedCoffeeScript 108.0.11
                (function() {
                    var C, calc_checksum, encode_length, fit_to_size, ops_to_keyflags;

                    C = require('../const');

                    exports.make_time_packet = function(d) {
                        var b;
                        d || (d = Math.floor(Date.now() / 1000));
                        b = new Buffer(4);
                        b.writeUInt32BE(d, 0);
                        return b;
                    };

                    exports.calc_checksum = calc_checksum = function(text) {
                        var i, ret, _i, _ref;
                        ret = 0;
                        for (i = _i = 0, _ref = text.length; 0 <= _ref ? _i < _ref : _i > _ref; i = 0 <= _ref ? ++_i : --_i) {
                            ret = (ret + text.readUInt8(i)) % 65536;
                        }
                        return ret;
                    };

                    exports.encode_length = encode_length = function(l, five_byte) {
                        var ret;
                        if (five_byte == null) {
                            five_byte = false;
                        }
                        ret = null;
                        if (l >= 8384 || five_byte) {
                            ret = new Buffer(5);
                            ret.writeUInt8(0xff, 0);
                            ret.writeUInt32BE(l, 1);
                        } else if (l < 192) {
                            ret = new Buffer(1);
                            ret.writeUInt8(l, 0);
                        } else if (l >= 192 && l < 8384) {
                            ret = new Buffer(2);
                            ret.