// Tabs
function showTab(i){
  document.querySelectorAll('.tab').forEach((t,j)=>t.classList.toggle('active',i===j));
  document.querySelectorAll('.tab-content').forEach((c,j)=>c.classList.toggle('active',i===j));
}
function toggleLoader(id,show){document.getElementById(id).style.display=show?'inline-block':'none';}
function showToast(msg){const t=document.getElementById('toast'); t.innerText=msg; t.className='show'; setTimeout(()=>{t.className='';},2500);}
function copyToClipboard(id){const t=document.getElementById(id); t.select(); navigator.clipboard.writeText(t.value); showToast('Copied to clipboard!');}

// Generate Keys
async function generateKeys(){
  toggleLoader('keyLoader',true);
  document.getElementById('keyProgress').style.width='10%';
  try{
    const name=document.getElementById('name').value||'Anonymous';
    const email=document.getElementById('email').value||'anon@example.com';
    const pass=document.getElementById('password').value||'';
    const bits=parseInt(document.getElementById('keySize').value);

    const { privateKey, publicKey } = await openpgp.generateKey({
      type:'rsa',
      rsaBits: bits,
      userIDs: [{ name, email }],
      passphrase: pass
    });

    document.getElementById('publicKey').value = publicKey;
    document.getElementById('privateKey').value = privateKey;
    document.getElementById('keyProgress').style.width='100%';
    showToast('Keys generated!');
  } catch(e){ showToast('Error: '+e.message);}
  toggleLoader('keyLoader',false);
}

// Encrypt
async function encryptMessage(){
  toggleLoader('encryptLoader',true);
  try{
    const pub = await openpgp.readKey({ armoredKey:document.getElementById('encryptKey').value.trim() });
    const message = await openpgp.createMessage({ text: document.getElementById('plaintext').value });
    const encrypted = await openpgp.encrypt({ message, encryptionKeys: pub });
    document.getElementById('encrypted').value = encrypted;
    showToast('Message encrypted!');
  } catch(e){showToast('Error: '+e.message);}
  toggleLoader('encryptLoader',false);
}

// Decrypt
async function decryptMessage(){
  toggleLoader('decryptLoader',true);
  try{
    const priv = await openpgp.readPrivateKey({ armoredKey: document.getElementById('decryptKey').value.trim() });
    const pass = document.getElementById('decryptPassword').value||'';
    const decryptedKey = pass ? await openpgp.decryptKey({ privateKey: priv, passphrase: pass }) : priv;
    const message = await openpgp.readMessage({ armoredMessage: document.getElementById('ciphertext').value.trim() });
    const { data } = await openpgp.decrypt({ message, decryptionKeys: decryptedKey });
    document.getElementById('decrypted').value = data;
    showToast('Message decrypted!');
  } catch(e){showToast('Error: '+e.message);}
  toggleLoader('decryptLoader',false);
}

// Sign (Cleartext)
async function signMessage(){
  toggleLoader('signLoader',true);
  try{
    const priv = await openpgp.readPrivateKey({ armoredKey: document.getElementById('signKey').value.trim() });
    const pass = document.getElementById('signPassword').value||'';
    const decryptedKey = pass ? await openpgp.decryptKey({ privateKey: priv, passphrase: pass }) : priv;
    const cleartext = await openpgp.createCleartextMessage({ text: document.getElementById('signMessageText').value });
    const signed = await openpgp.sign({ message: cleartext, signingKeys: decryptedKey, config: { preferredHashAlgorithm: openpgp.enums.hash.sha256 } });
    document.getElementById('signedMessage').value = signed;
    showToast('Message signed (cleartext)!');
  } catch(e){showToast('Error: '+e.message);}
  toggleLoader('signLoader',false);
}

// Verify (Cleartext)
async function verifyMessage(){
  toggleLoader('verifyLoader',true);
  try{
    const pub = await openpgp.readKey({ armoredKey: document.getElementById('verifyKey').value.trim() });
    const cleartext = await openpgp.readCleartextMessage({ cleartextMessage: document.getElementById('verifyMessageText').value.trim() });
    const verification = await openpgp.verify({ message: cleartext, verificationKeys: pub });
    try { await verification.signatures[0].verified; document.getElementById('verifyResult').value = 'Signature is VALID ✅'; }
    catch(e){ document.getElementById('verifyResult').value = 'Signature is INVALID ❌'; }
    showToast('Verification complete!');
  } catch(e){ document.getElementById('verifyResult').value='Error: '+e.message; showToast('Error: '+e.message);}
  toggleLoader('verifyLoader',false);
}

