<?php
/**
 * Plugin Name: Dark Mode PGP Tool by Molly9
 * Description: PGP Tool plugin with Generate Keys, Encrypt/Decrypt, Sign/Verify (Cleartext) in dark mode. [wppgp_tool]
 * Version: 1.0
 * Author: Molly9 (https://ivan.cyou)
 */

if(!defined('ABSPATH')) exit;

// Enqueue scripts and styles
function wppgptool_enqueue_scripts() {
    wp_enqueue_style('wppgptool-css', plugin_dir_url(__FILE__) . 'css/pgp-tool.css');
    wp_enqueue_script('openpgpjs', 'https://cdn.jsdelivr.net/npm/openpgp@5/dist/openpgp.min.js', array(), null, true);
    wp_enqueue_script('wppgptool-js', plugin_dir_url(__FILE__) . 'js/pgp-tool.js', array('openpgpjs'), null, true);
}
add_action('wp_enqueue_scripts', 'wppgptool_enqueue_scripts');

// Shortcode to display PGP tool
function wppgptool_shortcode() {
    ob_start();
    ?>
    <div class="container">
    <h1>PGP Tool - Dark Mode</h1>
    <div class="tabs">
        <div class="tab active" onclick="showTab(0)">Generate Keys</div>
        <div class="tab" onclick="showTab(1)">Encrypt</div>
        <div class="tab" onclick="showTab(2)">Decrypt</div>
        <div class="tab" onclick="showTab(3)">Sign</div>
        <div class="tab" onclick="showTab(4)">Verify</div>
    </div>

    <!-- Generate Keys -->
    <div class="tab-content active">
        <h3>Generate PGP Keys</h3>
        <input type="text" id="name" placeholder="Name (optional)">
        <input type="email" id="email" placeholder="Email (optional)">
        <input type="password" id="password" placeholder="Password (optional)">
        <select id="keySize">
            <option value="2048">2048 bits</option>
            <option value="4096">4096 bits</option>
            <option value="8192">8192 bits</option>
        </select>
        <button onclick="generateKeys()">Generate Keys <span class="loader" id="keyLoader"></span></button>
        <div class="progress-container"><div id="keyProgress" class="progress-bar"></div></div>
        <textarea id="publicKey" placeholder="Public Key"></textarea>
        <button class="copy-btn" onclick="copyToClipboard('publicKey')">Copy Public Key</button>
        <textarea id="privateKey" placeholder="Private Key"></textarea>
        <button class="copy-btn" onclick="copyToClipboard('privateKey')">Copy Private Key</button>
    </div>

    <!-- Encrypt -->
    <div class="tab-content">
        <h3>Encrypt Message</h3>
        <textarea id="plaintext" placeholder="Enter message"></textarea>
        <textarea id="encryptKey" placeholder="Recipient's public key"></textarea>
        <button onclick="encryptMessage()">Encrypt <span class="loader" id="encryptLoader"></span></button>
        <textarea id="encrypted" placeholder="Encrypted message"></textarea>
        <button class="copy-btn" onclick="copyToClipboard('encrypted')">Copy Encrypted Message</button>
    </div>

    <!-- Decrypt -->
    <div class="tab-content">
        <h3>Decrypt Message</h3>
        <textarea id="decryptKey" placeholder="Your private key"></textarea>
        <input type="password" id="decryptPassword" placeholder="Password (if any)">
        <textarea id="ciphertext" placeholder="Paste encrypted message"></textarea>
        <button onclick="decryptMessage()">Decrypt <span class="loader" id="decryptLoader"></span></button>
        <textarea id="decrypted" placeholder="Decrypted message"></textarea>
        <button class="copy-btn" onclick="copyToClipboard('decrypted')">Copy Decrypted Message</button>
    </div>

    <!-- Sign -->
    <div class="tab-content">
        <h3>Sign Message (Cleartext)</h3>
        <textarea id="signKey" placeholder="Your private key"></textarea>
        <input type="password" id="signPassword" placeholder="Password (if any)">
        <textarea id="signMessageText" placeholder="Message to sign"></textarea>
        <button onclick="signMessage()">Sign <span class="loader" id="signLoader"></span></button>
        <textarea id="signedMessage" placeholder="Signed message"></textarea>
        <button class="copy-btn" onclick="copyToClipboard('signedMessage')">Copy Signed Message</button>
    </div>

    <!-- Verify -->
    <div class="tab-content">
        <h3>Verify Signed Message (Cleartext)</h3>
        <textarea id="verifyKey" placeholder="Sender's public key"></textarea>
        <textarea id="verifyMessageText" placeholder="Signed message"></textarea>
        <button onclick="verifyMessage()">Verify <span class="loader" id="verifyLoader"></span></button>
        <textarea id="verifyResult" placeholder="Verification result"></textarea>
        <button class="copy-btn" onclick="copyToClipboard('verifyResult')">Copy Verification Result</button>
    </div>
    </div>

    <div id="toast"></div>
    <?php
    return ob_get_clean();
}
add_shortcode('wppgp_tool','wppgptool_shortcode');

