importScripts('https://cdn.jsdelivr.net/npm/openpgp@5/dist/openpgp.min.js');

onmessage = async function(e){
    try{
        const {name,email,pass,bits} = e.data;
        const key = await openpgp.generateKey({
            type:'rsa',
            rsaBits: bits,
            userIDs:[{name,email}],
            passphrase: pass,
            format:'armored'
        });
        postMessage({publicKey:key.publicKey, privateKey:key.privateKey});
    } catch(err){
        postMessage({error:err.message});
    }
};

