<?php
/**
 * Plugin Name: Molly9 PGP Tools
 * Description: Dark-mode PGP alat za generiranje ključeva, enkripciju/dekripciju, potpisivanje i verifikaciju – sve klijentski, bez server-side obrade.
 * Version: 1.0.0
 * Author: Ivan / Molly9
 * Text Domain: m9-pgp-tools
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Enqueue CSS i JS
 */
function m9pgp_enqueue_assets() {
    $plugin_url = plugin_dir_url( __FILE__ );

    // Scoped dark CSS za plugin (ne dira globalni CSS)
    wp_enqueue_style(
        'm9pgp-tools-css',
        $plugin_url . 'css/m9-pgp-tools.css',
        array(),
        '1.0.0'
    );

    // OpenPGP.js v5 s CDN-a
    wp_enqueue_script(
        'openpgpjs',
        'https://cdn.jsdelivr.net/npm/openpgp@5/dist/openpgp.min.js',
        array(),
        null,
        true
    );

    // JS za UI i PGP funkcije
    wp_enqueue_script(
        'm9pgp-tools-js',
        $plugin_url . 'js/m9-pgp-tools.js',
        array( 'openpgpjs' ),
        '1.0.0',
        true
    );
}
add_action( 'wp_enqueue_scripts', 'm9pgp_enqueue_assets' );

/**
 * Shortcode output
 * [m9_pgp_tools]
 */
function m9pgp_render_shortcode() {
    ob_start();
    ?>

    <div class="m9pgp-tool">
        <h1>Molly9 PGP Tools</h1>

        <div class="m9pgp-tabs">
            <div class="m9pgp-tab m9pgp-tab-active" onclick="m9pgpShowTab(0)">Generate Keys</div>
            <div class="m9pgp-tab" onclick="m9pgpShowTab(1)">Encrypt</div>
            <div class="m9pgp-tab" onclick="m9pgpShowTab(2)">Decrypt</div>
            <div class="m9pgp-tab" onclick="m9pgpShowTab(3)">Sign</div>
            <div class="m9pgp-tab" onclick="m9pgpShowTab(4)">Verify</div>
        </div>

        <!-- Generate Keys -->
        <div class="m9pgp-tab-content m9pgp-tab-content-active">
            <h3>Generate PGP Keys</h3>
            <input type="text" id="m9pgp-name" placeholder="Name (optional)">
            <input type="email" id="m9pgp-email" placeholder="Email (optional)">
            <input type="password" id="m9pgp-password" placeholder="Password (optional)">
            <select id="m9pgp-key-size">
                <option value="2048">2048 bits</option>
                <option value="4096">4096 bits</option>
                <option value="8192">8192 bits</option>
            </select>
            <button type="button" onclick="m9pgpGenerateKeys()">
                Generate Keys
                <span class="m9pgp-loader" id="m9pgp-key-loader"></span>
            </button>

            <div class="m9pgp-progress-container">
                <div id="m9pgp-key-progress" class="m9pgp-progress-bar"></div>
            </div>

            <textarea id="m9pgp-public-key" placeholder="Public Key"></textarea>
            <button type="button" class="m9pgp-copy-btn" onclick="m9pgpCopyToClipboard('m9pgp-public-key')">
                Copy Public Key
            </button>

            <textarea id="m9pgp-private-key" placeholder="Private Key"></textarea>
            <button type="button" class="m9pgp-copy-btn" onclick="m9pgpCopyToClipboard('m9pgp-private-key')">
                Copy Private Key
            </button>
        </div>

        <!-- Encrypt -->
        <div class="m9pgp-tab-content">
            <h3>Encrypt Message</h3>
            <textarea id="m9pgp-encrypt-key" placeholder="Recipient public key"></textarea>
            <textarea id="m9pgp-encrypt-text" placeholder="Message to encrypt"></textarea>
            <button type="button" onclick="m9pgpEncryptMessage()">
                Encrypt
                <span class="m9pgp-loader" id="m9pgp-encrypt-loader"></span>
            </button>
            <textarea id="m9pgp-ciphertext" placeholder="Encrypted message"></textarea>
            <button type="button" class="m9pgp-copy-btn" onclick="m9pgpCopyToClipboard('m9pgp-ciphertext')">
                Copy Encrypted Message
            </button>
        </div>

        <!-- Decrypt -->
        <div class="m9pgp-tab-content">
            <h3>Decrypt Message</h3>
            <textarea id="m9pgp-decrypt-key" placeholder="Your private key"></textarea>
            <input type="password" id="m9pgp-decrypt-password" placeholder="Password (if any)">
            <textarea id="m9pgp-decrypt-ciphertext" placeholder="Paste encrypted message"></textarea>
            <button type="button" onclick="m9pgpDecryptMessage()">
                Decrypt
                <span class="m9pgp-loader" id="m9pgp-decrypt-loader"></span>
            </button>
            <textarea id="m9pgp-decrypted" placeholder="Decrypted message"></textarea>
            <button type="button" class="m9pgp-copy-btn" onclick="m9pgpCopyToClipboard('m9pgp-decrypted')">
                Copy Decrypted Message
            </button>
        </div>

        <!-- Sign (Cleartext) -->
        <div class="m9pgp-tab-content">
            <h3>Sign Message (Cleartext)</h3>
            <textarea id="m9pgp-sign-key" placeholder="Your private key"></textarea>
            <input type="password" id="m9pgp-sign-password" placeholder="Password (if any)">
            <textarea id="m9pgp-sign-text" placeholder="Message to sign"></textarea>
            <button type="button" onclick="m9pgpSignMessage()">
                Sign
                <span class="m9pgp-loader" id="m9pgp-sign-loader"></span>
            </button>
            <textarea id="m9pgp-signed-message" placeholder="Signed message (cleartext)"></textarea>
            <button type="button" class="m9pgp-copy-btn" onclick="m9pgpCopyToClipboard('m9pgp-signed-message')">
                Copy Signed Message
            </button>
        </div>

        <!-- Verify (Cleartext) -->
        <div class="m9pgp-tab-content">
            <h3>Verify Signed Message</h3>
            <textarea id="m9pgp-verify-key" placeholder="Sender public key"></textarea>
            <textarea id="m9pgp-verify-message" placeholder="Signed message (cleartext)"></textarea>
            <button type="button" onclick="m9pgpVerifyMessage()">
                Verify
                <span class="m9pgp-loader" id="m9pgp-verify-loader"></span>
            </button>
            <textarea id="m9pgp-verify-result" placeholder="Verification result"></textarea>
            <button type="button" class="m9pgp-copy-btn" onclick="m9pgpCopyToClipboard('m9pgp-verify-result')">
                Copy Verification Result
            </button>
        </div>

        <div class="m9pgp-toast" id="m9pgp-toast"></div>
    </div>

    <?php
    return ob_get_clean();
}
add_shortcode( 'm9_pgp_tools', 'm9pgp_render_shortcode' );

