<?php
/*
Plugin Name: PGP Tools
Plugin URI: https://
Description: Generates PGP Keys. Encrypts and decrypts text. Runs completely in the browser.
Version: 1.6
Author: pgptools
Author URI: https://
License: GPLv2
*/

add_action( 'wp_enqueue_scripts', 'pgp_tools_register_scripts' );
function pgp_tools_register_scripts(){
	wp_register_script( 'pgp_tools_openpgp_script', plugins_url( 'pgp-tools' ) . '/lib/openpgp.min.js' );
	wp_register_script( 'pgp_tools_jquery_validation_script', plugins_url( 'pgp-tools' ) . '/lib/jquery.validate.min.js' );
	wp_register_script( 'pgp_tools_script', plugins_url( 'pgp-tools' ) . '/pgp-tools.js' );
	wp_register_style( 'pgp_tools_style', plugins_url( 'pgp-tools' ) . '/css/pgp-tools.css' );
}

add_shortcode('pgp_tools', 'pgp_tools_insert');
function pgp_tools_insert() {
	wp_enqueue_script('jquery');
	wp_enqueue_script('pgp_tools_openpgp_script');
	wp_enqueue_script('pgp_tools_jquery_validation_script');
	wp_enqueue_script('pgp_tools_script');
	wp_enqueue_style('pgp_tools_style');
	load_plugin_textdomain( 'pgp-tools', false, basename( dirname( __FILE__ ) ) . '/i18n/' );
	$text_Generate_PGP_Keys = __('Generate PGP Keys', 'pgp-tools');
	$text_Your_Name = __('Your name:', 'pgp-tools');
	$text_Your_Email = __('Your e-mail address:', 'pgp-tools');
	$text_Required = __('required', 'pgp-tools');
	$text_Not_Required = __('not required', 'pgp-tools');
	$text_Choose_a_Password = __('Choose a password:', 'pgp-tools');
	$text_Need_Help_For_Password_First = __( 'Need help to choose a password?', 'pgp-tools' );
	$text_Need_Help_For_Password_Second = '<a href="https:///" target="_blank">' . __( 'Try a nice password generator.', 'pgp-tools' ) . '</a>';
	$text_Key_Size = __('Key Size:', 'pgp-tools');
	$text_Key_1024 = __('1024 bits - for testing purpose only', 'pgp-tools');
	$text_Key_2048 = __('2048 bits - recommended', 'pgp-tools');
	$text_Key_4096 = __('4096 bits - more secure', 'pgp-tools');
	$text_Your_Browser_May_Not_Respond = __('Your browser may not respond during key generation.', 'pgp-tools');
	$text_Public_Key = __('Public Key', 'pgp-tools');
	$text_Private_Key = __('Private Key', 'pgp-tools');
	$text_Encrypt_a_Message = __('Encrypt a Message', 'pgp-tools');
	$text_Your_Message = __('Your message:', 'pgp-tools');
	$text_Here_is_my_secret_message = __('Here is my secret message', 'pgp-tools');
	$text_Encrypt = __('Encrypt', 'pgp-tools');
	$text_Your_Public_Key = __('The public key to encrypt to:', 'pgp-tools');
	$text_Decrypt_a_Message = __('Decrypt a Message', 'pgp-tools');
	$text_Your_Password = __('Your password:', 'pgp-tools');
	$text_If_Applicable = __('if applicable', 'pgp-tools');
	$text_Your_Encrypted_Message = __('Your encrypted message:', 'pgp-tools');
	$text_Your_Private_Key = __('Your private key:', 'pgp-tools');
	$output = <<<EOF
<div>
	<div class="accordion" id="accordion-pgp-tools">
		<div class="accordion-group">
			<div class="accordion-heading pgp-tools-form1">
				<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion-pgp-tools" href="#collapseOne">$text_Generate_PGP_Keys</a>
			</div>
			<div id="collapseOne" class="accordion-body collapse in">
				<div class="accordion-inner">
					<div class="block">
						<form method="post" name="pgp_tools_form1" id="pgp_tools_form1">
							<label for="pgp_tools_username">$text_Your_Name&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style="font-style: italic;">$text_Required</span></label><br />
							<input type="text" name="pgp_tools_username" id="pgp_tools_username" />
							<br />
							<label for="pgp_tools_mail_address">$text_Your_Email&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style="font-style: italic;">$text_Not_Required</span></label><br />
							<input type="text" name="pgp_tools_mail_address" id="pgp_tools_mail_address" />
							<br />
							<label for="pgp_tools_key_password">$text_Choose_a_Password&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style="font-style: italic;">$text_Not_Required</span></label><br />
							<input type="password" name="pgp_tools_key_password" id="pgp_tools_key_password" />
							<div>$text_Need_Help_For_Password_First $text_Need_Help_For_Password_Second</div>
							<br />
							<label for="pgp_tools_key_length">$text_Key_Size</label><br />
							<select name="pgp_tools_key_length" id="pgp_tools_key_length">
								<option value="1024">$text_Key_1024</option>
								<option value="2048" selected="selected">$text_Key_2048</option>
								<option value="4096">$text_Key_4096</option>
							</select>
							<br />
							$text_Your_Browser_May_Not_Respond<br />
							<input type="button" class="btn btn-primary" value="$text_Generate_PGP_Keys" name="pgp_tools_form1_button" id="pgp_tools_form1_button" />
						</form>
					</div>
					<br />
					<div class="block">
						<label for="pgp_tools_pubgenkey">$text_Public_Key</label><br />
						<textarea id="pgp_tools_pubgenkey"></textarea>
						<br /><br />
						<label for="pgp_tools_privgenkey">$text_Private_Key</label><br />
						<textarea id="pgp_tools_privgenkey"></textarea>
					</div>
				</div>
			</div>
		</div>

		<div class="accordion-group">
			<div class="accordion-heading pgp-tools-form2">
				<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion-pgp-tools" href="#collapseTwo">$text_Encrypt_a_Message</a>
			</div>
			<div id="collapseTwo" class="accordion-body collapse">
				<div class="accordion-inner">
					<div class="block">
						<form method="post" name="pgp_tools_form2" id="pgp_tools_form2">
							<label for="pgp_tools_message_encrypt">$text_Your_Message</label><br />
							<textarea name="pgp_tools_message_encrypt" id="pgp_tools_message_encrypt">$text_Here_is_my_secret_message</textarea>
							<br />
							<input type="button" class="btn btn-primary" value="$text_Encrypt" name="pgp_tools_form2_button" id="pgp_tools_form2_button" />
							<br />&nbsp;<br />
							<label for="pgp_tools_pubkey">$text_Your_Public_Key</label><br />
							<textarea name="pgp_tools_pubkey" id="pgp_tools_pubkey"></textarea>
						</form>
					</div>
				</div>
			</div>
		</div>

		<div class="accordion-group">
			<div class="accordion-heading pgp-tools-form3">
				<a class="accordion-toggle" data-toggle="collapse" data-parent="#accordion-pgp-tools" href="#collapseThree">$text_Decrypt_a_Message</a>
			</div>
			<div id="collapseThree" class="accordion-body collapse">
				<div class="accordion-inner">
					<div class="block">
						<form method="post" name="pgp_tools_form3" id="pgp_tools_form3">
							<label for="pgp_tools_key_password_decrypt">$text_Your_Password&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style="font-style: italic;">$text_If_Applicable</span></label><br />
							<input type="password" name="pgp_tools_key_password_decrypt" id="pgp_tools_key_password_decrypt" /><br />
							<label for="pgp_tools_message_decrypt">$text_Your_Encrypted_Message</label><br />
							<textarea name="pgp_tools_message_decrypt" id="pgp_tools_message_decrypt"></textarea>
							<br />
							<input type="button" class="btn btn-primary" value="$text_Decrypt_a_Message" name="pgp_tools_form3_button" id="pgp_tools_form3_button" />
							<br />&nbsp;<br />
							<label for="pgp_tools_privkey">$text_Your_Private_Key</label><br />
							<textarea name="pgp_tools_privkey" id="pgp_tools_privkey"></textarea>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
EOF;
	return $output;
}
